/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.storage.oracle;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxySetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.DimensionAttributeOracle;
import oracle.dbtools.crest.model.design.storage.oracle.DimensionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;

public class LevelOracle
extends AbstractStorageObjectOracle {
    private String columns = "";
    private InlineList columnSet = null;
    private DimensionOracle dimension;
    private TableProxy levelTable;
    private String tableName;
    private String tableOwner;
    private transient String newName = "";
    public static final String TYPE_NAME = "Level";

    public LevelOracle(StorageDesign storageDesign) {
        this.setStorageDesign(storageDesign);
    }

    @Override
    public void showPropertyDialog() {
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getIDPrefix() {
        return "L";
    }

    public ArrayList getTables() {
        ArrayList<TableProxyOracle> tables = new ArrayList<TableProxyOracle>();
        ColumnProxySetOracle allColumns = (ColumnProxySetOracle)this.getStorageDesign().getColumnProxySet();
        for (int i = 0; i < this.getColumnSet().size(); ++i) {
            ColumnProxyOracle col = (ColumnProxyOracle)allColumns.getProxy((String)this.getColumnSet().elementAt(i));
            if (col == null || tables.contains(col.getTableProxy())) continue;
            tables.add(col.getTableProxy());
        }
        return tables;
    }

    private void addColumn(String columns) {
        if (!this.getColumnSet().contains(columns)) {
            this.getColumnSet().add(columns);
        }
    }

    public void recreateColumnSet(String columns) {
        this.getColumnSet().clear();
        StringTokenizer st = new StringTokenizer(columns, ",");
        while (st.hasMoreTokens()) {
            this.getColumnSet().add(st.nextToken().trim());
        }
    }

    public void setColumns(String columns) {
        if (this.getStorageDesign().isLoading()) {
            this.recreateColumnSet(columns);
        } else {
            this.addColumn(columns);
        }
        this.columns = this.getColumnSet().toString();
        this.fireDataFieldChange();
    }

    public String getColumns() {
        return this.columns;
    }

    public InlineList getColumnSet() {
        if (this.columnSet == null) {
            this.columnSet = new InlineList();
        }
        return this.columnSet;
    }

    public void clear() {
        this.getColumnSet().removeAllElements();
    }

    public DimensionOracle getDimension() {
        return this.dimension;
    }

    public void setDimension(DimensionOracle dimension) {
        if (this.dimension != dimension) {
            this.dimension = dimension;
            this.setPAC_Element(dimension);
            this.fireDataFieldChange();
        }
    }

    public TableProxy getLevelTable() {
        if (this.levelTable == null && this.getColumnSet().size() > 0) {
            ColumnProxySetOracle allColumns = (ColumnProxySetOracle)this.getStorageDesign().getColumnProxySet();
            for (int i = 0; i < this.getColumnSet().size(); ++i) {
                ColumnProxyOracle col = (ColumnProxyOracle)allColumns.getProxy((String)this.getColumnSet().elementAt(i));
                if (col == null || col.getTableProxy() == null) continue;
                this.levelTable = col.getTableProxy();
                break;
            }
        }
        return this.levelTable;
    }

    public void setLevelTable(TableProxy levelTable) {
        this.levelTable = levelTable;
    }

    public DimensionAttributeOracle getLevelAttribute() {
        for (DimensionAttributeOracle attr : this.getStorageDesignOracle().getDimensionAttributeSet()) {
            if (attr.getLevel() != this) continue;
            return attr;
        }
        return null;
    }

    public String getNewName() {
        return this.newName;
    }

    public void setNewName(String newName) {
        this.newName = newName;
    }

    @Override
    public boolean isTopLevelObject() {
        return false;
    }

    public String getTableName() {
        return this.tableName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public String getTableOwner() {
        return this.tableOwner;
    }

    public void setTableOwner(String userName) {
        this.tableOwner = userName;
    }

    public class InlineList
    extends Vector {
        @Override
        public String toString() {
            StringBuffer result = new StringBuffer();
            Iterator it = this.iterator();
            boolean b = false;
            while (it.hasNext()) {
                if (b) {
                    result.append(",");
                } else {
                    b = true;
                }
                String obj = (String)it.next();
                result.append(obj);
            }
            return result.toString();
        }
    }
}

