/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.relational;

import java.util.Iterator;
import oracle.dbtools.crest.model.ModelObjectSetListener;
import oracle.dbtools.crest.model.NameSpaceController;
import oracle.dbtools.crest.model.SetEvent;
import oracle.dbtools.crest.model.SetListener;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.relational.GlobalIndexSet;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.SchemaObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.util.GUID;

public class TableSet
extends DesignObjectSet
implements SetListener {
    public static final Object[] PROTOTYPE_ARRAY = new Table[0];
    private GlobalIndexSet globalIndexSet;

    public TableSet(DesignPart designPart) {
        super(designPart);
        this.requireSort = true;
        if (designPart != null) {
            this.setNameSpaceController(((RelationalDesign)designPart).getTablesAndViewsNameController());
        }
        this.getGlobalIndexSet();
    }

    @Override
    protected Object[] getProtoTypeArray() {
        return PROTOTYPE_ARRAY;
    }

    @Override
    protected String getDefaultNamePrefix() {
        return this.getPreference("default table name");
    }

    public Table createTable(String oldID) {
        Table table = new Table(this.getDesignPart());
        table.setBeingRecreated(false);
        this.initialize(table, oldID);
        return table;
    }

    public Table recreateTable(String oldID) {
        Table table = new Table(this.getDesignPart());
        table.setBeingRecreated(true);
        this.initialize(table, oldID);
        return table;
    }

    private void initialize(Table table, String oldID) {
        if (oldID == null || oldID.isEmpty()) {
            table.setObjectID(new GUID().toString());
        } else {
            table.setObjectID(oldID);
        }
        table.setDesign(this.getDesign());
        table.setParent(this);
        this.getDesign().addDesignObject(table);
        this.add(table);
    }

    @Override
    public Object getParent() {
        return this.getDesignPart();
    }

    @Override
    public void remove(DesignObject object) {
        object.setParent(null);
        super.remove(object);
    }

    @Override
    public void changed(DesignObjectSet set, SetEvent event) {
    }

    public GlobalIndexSet getGlobalIndexSet() {
        if (this.globalIndexSet == null) {
            this.globalIndexSet = new GlobalIndexSet(this);
            this.globalIndexSet.addSetListener((ModelObjectSetListener)((Object)this.getDesignPart()));
        }
        return this.globalIndexSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeAll() {
        clearAll = true;
        try {
            Object[] elements = this.toArray();
            for (int i = elements.length - 1; i >= 0; --i) {
                DesignObject obj = (DesignObject)elements[i];
                obj.remove();
            }
        }
        finally {
            clearAll = false;
        }
        super.removeAll();
    }

    @Override
    public Table getBySchemaAndName(String schema, String name) {
        if (schema != null && name != null) {
            Iterator it = this.iterator();
            while (it.hasNext()) {
                Table table = (Table)it.next();
                if (!schema.equalsIgnoreCase(table.getSchema()) || !name.equalsIgnoreCase(table.getName())) continue;
                return table;
            }
        }
        return null;
    }

    @Override
    public boolean changeName(String schema, String oldName, String newName, DesignObject object) {
        NameSpaceController nsc = this.getNameSpaceController();
        if (nsc != null) {
            String validName = nsc.getValidName(object, schema, newName);
            if (validName.equals(newName)) {
                nsc.updateNamesMap(schema, oldName, newName, object);
                String oldLongName = oldName;
                if (schema != null && !"".equals(schema)) {
                    oldLongName = schema + "." + oldName;
                }
                String newLongName = newName;
                if (schema != null && !"".equals(schema)) {
                    newLongName = schema + "." + newName;
                }
                this.doRenaming(oldLongName, newLongName, object);
                return true;
            }
            return false;
        }
        Object obj2 = this.names.get(newName.toUpperCase());
        if (obj2 == null || obj2 == object) {
            this.doRenaming(oldName, newName, object);
            return true;
        }
        return false;
    }

    @Override
    public boolean updateNamesMap(SchemaObject oldSchema, String oldName, SchemaObject newSchema, String newName, DesignObject object) {
        NameSpaceController nsc = this.getNameSpaceController();
        boolean res = false;
        if (nsc != null) {
            res = nsc.updateNamesMap(oldSchema, oldName, newSchema, newName, object);
            super.updateNamesMap(oldSchema, oldName, newSchema, newName, object);
            return res;
        }
        return super.updateNamesMap(oldSchema, oldName, newSchema, newName, object);
    }
}

