/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.datatypes;

import java.util.TreeMap;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.Task;
import oracle.dbtools.crest.model.design.ContainedObjectWithDomain;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.DTReference;
import oracle.dbtools.crest.model.design.datatypes.DataTypeObject;
import oracle.dbtools.crest.model.design.datatypes.DistinctType;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.v12c.StorageDesignOraclev12c;
import oracle.dbtools.crest.util.logging.Logger;

public class TypeElement
extends DesignObject
implements DataTypeObject {
    public static final String TYPE_NAME = "TypeElement";
    private StructuredType structuredType;
    private boolean isReference;
    private DesignObject type;
    private String typeID = "";
    private String size = "";
    private int precision;
    private int scale;
    private DTReference referenceRelation;
    protected ObjectChangeEvent sharedEvent = new ObjectChangeEvent("ChangeEvent");
    public static final String PARAM_SCALE = "scale";
    public static final String PARAM_PRECISION = "precision";
    public static final String PARAM_SIZE = "size";
    public static final int TYPE_NONE_COMPLEX = 0;
    public static final int TYPE_REFERENCE = 1;
    public static final int TYPE_STRUCT_COMPOSITION = 2;
    public static final int TYPE_COLLECTION_OF_REFS = 3;
    public static final int TYPE_COLLECTION_OF_EMBEDDED_STR = 4;
    public static final int TYPE_COLLECTION_OF_COLLECTION_TYPE = 5;
    public static final int TYPE_COLLECTION_OF_BASIC_TYPE = 6;
    private int datatypeDescriptor = 4;
    private boolean mandatory = false;
    private String referenceRelationID = null;
    private Domain domain;
    private String units;
    private String getterName;
    private String setterName;
    private String nativeDataType;
    private String typeObjLongName;

    public TypeElement(DesignPart designPart, StructuredType structuredType) {
        super(designPart);
        this.structuredType = structuredType;
    }

    public void setStructuredType(StructuredType structuredType) {
        this.structuredType = structuredType;
    }

    public StructuredType getStructuredType() {
        return this.structuredType;
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public boolean isDesignLevelAccessibleObject() {
        return true;
    }

    @Override
    public String getIDPrefix() {
        return TYPE_NAME;
    }

    @Override
    public boolean isReference() {
        return this.isReference;
    }

    @Override
    public void setReference(boolean isReference) {
        if (this.isReference != isReference) {
            this.isReference = isReference;
            this.fireChange(this.sharedEvent);
        }
    }

    @Override
    public void remove() {
        this.updateReference(null);
        if (this.structuredType != null) {
            this.structuredType.remove(this);
        }
        if (this.referenceRelation != null) {
            this.referenceRelation.setTypeElement(null);
            this.referenceRelation.remove();
            this.referenceRelation = null;
        }
        super.remove();
    }

    @Override
    public DesignObject getType() {
        if (!"".equalsIgnoreCase(this.typeID)) {
            this.type = this.getDesign().getDesignObject(this.typeID);
            if (this.type != null) {
                this.typeID = "";
                if (this.type instanceof Domain) {
                    this.domain = (Domain)this.type;
                }
            } else if (!this.getDesign().isLoading()) {
                this.type = this.getDesign().getDomainSet().getDefaultDomain();
                this.domain = (Domain)this.type;
                this.typeID = "";
                this.setDataTypeDescriptor();
            }
        } else if (this.type == null) {
            this.type = this.getDesign().getDomainSet().getDefaultDomain();
            this.domain = (Domain)this.type;
            this.setDataTypeDescriptor();
        }
        return this.type;
    }

    @Override
    public void setType(DesignObject type) {
        if (this.type != type) {
            this.type = type;
            if (type instanceof Domain) {
                this.domain = (Domain)type;
            }
            this.fireChange(this.sharedEvent);
        }
    }

    private void setDataTypeDescriptor() {
        this.getType();
        if (this.type == null) {
            this.datatypeDescriptor = 0;
        } else if (this.type instanceof StructuredType && this.isReference) {
            this.datatypeDescriptor = 1;
        } else if (this.type instanceof StructuredType && !this.isReference) {
            this.datatypeDescriptor = 2;
        } else if (this.type instanceof CollectionType) {
            TypeElement coltype = ((CollectionType)this.type).getElementType();
            this.datatypeDescriptor = coltype.getDatatypeDescriptor() == 1 ? 3 : (coltype.getDatatypeDescriptor() == 2 ? 4 : (coltype.getType() instanceof CollectionType ? 5 : 6));
        }
    }

    public void updateReference() {
        if (this.type instanceof StructuredType) {
            StructuredType newParent = (StructuredType)this.type;
            if (!this.getDesign().isLoading()) {
                this.updateReference(newParent);
            }
        } else if (this.type instanceof CollectionType) {
            DesignObject coltype = ((CollectionType)this.type).getElementType().getType();
            if (coltype instanceof StructuredType) {
                StructuredType newParent = (StructuredType)coltype;
                if (!this.getDesign().isLoading()) {
                    this.updateReference(newParent);
                }
            }
        } else {
            this.updateReference(null);
        }
        this.fireChange(ObjectChangeEvent.HIERARCHICAL_PARENT_CHANGED);
    }

    @Override
    public String getDataType() {
        return this.formatDataType();
    }

    public String getDataType(String rdbmsName) {
        String fSize = "";
        int fPrecision = 0;
        int fScale = 0;
        String dtName = "NONE";
        if (this.getType() != null) {
            if (this.getType() instanceof Domain) {
                Domain dom = (Domain)this.getType();
                LogicalDatatype logicalDatatype = dom.getLogicalDatatype();
                TreeMap<String, String> map = new TreeMap<String, String>();
                map.put(PARAM_SIZE, "" + dom.getSize());
                map.put(PARAM_PRECISION, "" + dom.getPrecision());
                map.put(PARAM_SCALE, "" + dom.getScale());
                dtName = logicalDatatype.createDataType(rdbmsName, map).toString();
            } else {
                if (this.getType() instanceof LogicalDatatype) {
                    fSize = this.size;
                    fPrecision = this.precision;
                    fScale = this.scale;
                    TreeMap<String, String> map = new TreeMap<String, String>();
                    map.put(PARAM_SIZE, "" + fSize);
                    if (this.getUnits() != null && this.getUnits().length() > 0) {
                        map.put(PARAM_SIZE, "" + fSize + " " + this.getUnits());
                    } else {
                        map.put(PARAM_SIZE, "" + fSize);
                    }
                    map.put(PARAM_PRECISION, "" + this.precision);
                    map.put(PARAM_SCALE, "" + this.scale);
                    dtName = ((LogicalDatatype)this.getType()).createDataType(rdbmsName, map).toString();
                    return dtName;
                }
                if (this.getType() instanceof DistinctType) {
                    DistinctType dt = (DistinctType)this.getType();
                    if (dt.getLogicalDataType() != null) {
                        fSize = dt.getSize();
                        fPrecision = dt.getPrecision();
                        fScale = dt.getScale();
                        TreeMap<String, String> map = new TreeMap<String, String>();
                        map.put(PARAM_SIZE, "" + fSize);
                        map.put(PARAM_PRECISION, "" + fPrecision);
                        map.put(PARAM_SCALE, "" + fScale);
                        dtName = dt.getLogicalDataType().createDataType(rdbmsName, map).toString();
                        return dtName;
                    }
                } else if (this.getType() instanceof StructuredType) {
                    dtName = this.isReference ? "REF " + this.getType().getName() : this.getType().getName();
                } else if (this.getType() instanceof CollectionType) {
                    dtName = this.getType().getName();
                }
            }
            StringBuffer logical = new StringBuffer(dtName);
            boolean needBracket = false;
            boolean needComma = false;
            if (fSize != null && !fSize.equals("") || fPrecision > 0 || fScale > 0) {
                needBracket = true;
            }
            if (needBracket) {
                logical.append('(');
            }
            if (fSize != null && !fSize.equals("")) {
                logical.append(fSize);
                needComma = true;
            }
            if (fPrecision > 0) {
                if (needComma) {
                    logical.append(", ");
                }
                logical.append(fPrecision);
                needComma = true;
            }
            if (fScale > 0) {
                if (needComma) {
                    logical.append(", ");
                }
                logical.append(fScale);
            }
            if (needBracket) {
                logical.append(')');
            }
            return logical.toString();
        }
        return "NONE";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getDataTypePresentationForHive() {
        String rdbmsName = StorageDesignOraclev12c.RDBMS_TYPE.getName();
        TreeMap<String, String> parameters = new TreeMap<String, String>();
        parameters.put(PARAM_SIZE, "" + this.size);
        parameters.put(PARAM_PRECISION, "" + String.valueOf(this.precision));
        parameters.put(PARAM_SCALE, "" + String.valueOf(this.scale));
        String type = "String";
        try {
            LogicalDatatype lt = null;
            if (this.getType() instanceof LogicalDatatype) {
                lt = (LogicalDatatype)this.getType();
            } else if (this.getType() instanceof DistinctType) {
                lt = ((DistinctType)this.getType()).getLogicalDataType();
            }
            if (this.getType() instanceof Domain) {
                if (this.getDomain() == null) {
                    return type;
                }
                lt = this.getDomain().getLogicalDatatype();
                type = lt.getDataTypeForHive(parameters);
                if (type != null) {
                    return type;
                }
                type = this.getDomain().getDataType(rdbmsName).toString();
                return lt.transformOracleTypeToHive(type);
            }
            if (this.getType() instanceof LogicalDatatype || this.getType() instanceof DistinctType) {
                if (lt == null) {
                    return type;
                }
                type = lt.getDataTypeForHive(parameters);
                if (type != null) {
                    return type;
                }
                type = ContainedObjectWithDomain.getDataTypeWithDefaults(lt, parameters, rdbmsName).toString();
                return lt.transformOracleTypeToHive(type);
            }
            if (this.getType() instanceof StructuredType) {
                return ((StructuredType)this.getType()).getDataTypePresentationForHive();
            }
            if (this.getType() instanceof CollectionType) {
                return ((CollectionType)this.getType()).getDataTypePresentationForHive();
            }
            if ("String".equalsIgnoreCase(type)) return type;
        }
        catch (Exception e) {
            Logger.error(e);
        }
        return type;
    }

    private String formatDataType() {
        String fSize = "";
        int fPrecision = 0;
        int fScale = 0;
        String dtName = "NONE";
        if (this.getType() != null) {
            if (this.getType() instanceof Domain) {
                dtName = this.getType().getName();
            } else if (this.getType() instanceof LogicalDatatype) {
                fSize = this.size;
                fPrecision = this.precision;
                fScale = this.scale;
                dtName = this.getType().getName();
            } else if (this.getType() instanceof DistinctType) {
                DistinctType dt = (DistinctType)this.getType();
                if (dt.getLogicalDataType() != null) {
                    fSize = dt.getSize();
                    fPrecision = dt.getPrecision();
                    fScale = dt.getScale();
                    dtName = dt.getLogicalDataType().getName();
                }
            } else if (this.getType() instanceof StructuredType) {
                dtName = this.isReference ? "REF " + this.getType().getName() : this.getType().getName();
            } else if (this.getType() instanceof CollectionType) {
                dtName = this.getType().getName();
            }
            StringBuffer logical = new StringBuffer(dtName);
            boolean needBracket = false;
            boolean needComma = false;
            if (fSize != null && !fSize.equals("") || fPrecision > 0 || fScale > 0) {
                needBracket = true;
            }
            if (needBracket) {
                logical.append(" (");
            }
            if (fSize != null && !fSize.equals("")) {
                logical.append(fSize);
                if (this.getUnits() != null && this.getUnits().length() > 0) {
                    logical.append(" " + this.getUnits());
                }
                needComma = true;
            }
            if (fPrecision > 0) {
                if (needComma) {
                    logical.append(", ");
                }
                logical.append(fPrecision);
                needComma = true;
            }
            if (fScale > 0) {
                if (needComma) {
                    logical.append(", ");
                }
                logical.append(fScale);
            }
            if (needBracket) {
                logical.append(')');
            }
            return logical.toString();
        }
        return "NONE";
    }

    @Override
    public int getPrecision() {
        return this.precision;
    }

    @Override
    public void setPrecision(int precision) {
        this.precision = precision;
    }

    @Override
    public int getScale() {
        return this.scale;
    }

    @Override
    public void setScale(int scale) {
        this.scale = scale;
    }

    @Override
    public String getSize() {
        return this.size;
    }

    @Override
    public void setSize(String size) {
        this.size = size;
    }

    @Override
    public void copy(DesignObject designObject) {
        super.copy(designObject);
        TypeElement typeElement = (TypeElement)designObject;
        typeElement.setMandatory(this.isMandatory());
        this.copyDataType(typeElement);
    }

    public void copyDataType(TypeElement typeElement) {
        typeElement.setType(this.getType());
        typeElement.setSize(this.getSize());
        typeElement.setPrecision(this.getPrecision());
        typeElement.setScale(this.getScale());
        typeElement.setUnits(this.getUnits());
        typeElement.setReference(this.isReference());
    }

    protected void updateReference(StructuredType newParent) {
        if (newParent == null) {
            if (this.referenceRelation != null) {
                this.referenceRelation.setTypeElement(null);
                this.referenceRelation.remove();
                this.referenceRelation = null;
            }
        } else {
            if (this.referenceRelation != null) {
                CollectionType ct;
                if (this.referenceRelation.getSourceDTObject() == this.type) {
                    this.referenceRelation.updatePresentation();
                    return;
                }
                if (this.type instanceof CollectionType && (ct = (CollectionType)this.type).getDataType() == this.referenceRelation.getSourceDTObject()) {
                    this.referenceRelation.updatePresentation();
                    return;
                }
                this.referenceRelation.setTypeElement(null);
                this.referenceRelation.remove();
            }
            this.referenceRelation = this.getDesign().getDataTypesDesign().createDTReference();
            if (this.referenceRelationID != null && !"".equals(this.referenceRelationID)) {
                this.referenceRelation.setObjectID(this.referenceRelationID);
            }
            this.referenceRelation.setTypeElement(this);
            this.referenceRelation.setSourceDTObject(newParent);
            this.referenceRelation.setTargetDTObject(this.structuredType);
            this.referenceRelation.updatePresentation();
        }
    }

    public DTReference getReferenceRelation() {
        return this.referenceRelation;
    }

    public void setReferenceRelation(DTReference referenceRelation) {
        this.referenceRelation = referenceRelation;
    }

    @Override
    public String getLongName() {
        return this.structuredType.getName().concat(".").concat(this.getName());
    }

    public void setTypeID(String typeID) {
        this.typeID = typeID;
    }

    public String getTypeID() {
        if (this.type != null) {
            return this.type.getObjectID();
        }
        return this.typeID;
    }

    public int getDatatypeDescriptor() {
        this.setDataTypeDescriptor();
        return this.datatypeDescriptor;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public void setMandatory(boolean mandatory) {
        this.mandatory = mandatory;
    }

    @Override
    public boolean isReadOnly() {
        if (this.getStructuredType() != null && this.getStructuredType().isReadOnly()) {
            return true;
        }
        return super.isReadOnly();
    }

    public String getReferenceRelationID() {
        if (this.referenceRelation != null) {
            return this.referenceRelation.getObjectID();
        }
        return this.referenceRelationID;
    }

    public void setReferenceRelationID(String id) {
        this.referenceRelationID = id;
        if (this.referenceRelationID != null && this.referenceRelation == null) {
            this.createReferenceRelation();
        }
        if (this.referenceRelationID != null && this.referenceRelation == null) {
            this.getDesignPart().addTask(new CreateReferenceRelationTask(this));
        }
    }

    public void updateReferenceNew() {
        if (this.type instanceof StructuredType) {
            StructuredType newParent = (StructuredType)this.type;
            this.updateReference(newParent);
        } else if (this.type instanceof CollectionType) {
            DesignObject coltype = ((CollectionType)this.type).getElementType().getType();
            if (coltype instanceof StructuredType) {
                StructuredType newParent = (StructuredType)coltype;
                this.updateReference(newParent);
            }
        } else {
            this.updateReference(null);
        }
        this.fireChange(ObjectChangeEvent.HIERARCHICAL_PARENT_CHANGED);
    }

    private void createReferenceRelation() {
        if (this.getType() != null) {
            this.updateReferenceNew();
        }
    }

    public Domain getDomain() {
        return this.domain;
    }

    public String getUnits() {
        return this.units;
    }

    public void setUnits(String units) {
        this.units = units;
    }

    public String getGetterName() {
        return this.getterName;
    }

    public void setGetterName(String getterName) {
        this.getterName = getterName;
    }

    public String getSetterName() {
        return this.setterName;
    }

    public void setSetterName(String setterName) {
        this.setterName = setterName;
    }

    public String getNativeDataType() {
        RDBMSType rdbmsType;
        if ((this.nativeDataType == null || this.nativeDataType.isEmpty()) && (rdbmsType = this.getSelectedRDBMSType()) != null) {
            this.nativeDataType = this.getDataType(rdbmsType.getName());
        }
        return this.nativeDataType;
    }

    public void setNativeDataType(String nativeDataType) {
        this.nativeDataType = nativeDataType;
    }

    public String getTypeObjLongName() {
        DesignObject type = this.getType();
        if (type instanceof StructuredType || type instanceof CollectionType) {
            RelationalObjectProxy typeProxy;
            StorageDesign sd = this.getDesign().getRelationalDesign().getStorageDesign();
            if (sd != null && (typeProxy = sd.getProxy(type)) != null) {
                return typeProxy.getLongName();
            }
            return type.getName();
        }
        return this.typeObjLongName;
    }

    public void setTypeObjLongName(String longName) {
        this.typeObjLongName = longName;
    }

    public class CreateReferenceRelationTask
    implements Task {
        private static final String TASK_NAME = "create ReferenceRelation task";
        TypeElement te;

        CreateReferenceRelationTask(TypeElement typeElement) {
            this.te = typeElement;
        }

        @Override
        public boolean execute() {
            this.te.createReferenceRelation();
            return this.te.referenceRelation != null;
        }

        public String toString() {
            return TASK_NAME;
        }
    }
}

