/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.datatypes;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.model.IDGenerator;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.ObjectListener;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectCollection;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.datatypes.AbstractDTObject;
import oracle.dbtools.crest.model.design.datatypes.DTInheritance;
import oracle.dbtools.crest.model.design.datatypes.DataTypesDesign;
import oracle.dbtools.crest.model.design.datatypes.Datatype;
import oracle.dbtools.crest.model.design.datatypes.Method;
import oracle.dbtools.crest.model.design.datatypes.MethodSet;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.datatypes.TypeElementSet;
import oracle.dbtools.crest.util.logging.Logger;

public class StructuredType
extends AbstractDTObject
implements ObjectListener,
Datatype {
    private boolean _final;
    private DTInheritance inheritanceRelation;
    private boolean instantiable;
    private String parentTypeID;
    private int maxLengthAsString = 0;
    private DesignObjectCollection methods = new DesignObjectCollection();
    private DesignObjectCollection elements = new DesignObjectCollection();
    private StructuredType parentType;
    private String parentTypeName = "";
    public static String MAP = "MAP";
    public static String STRUCT = "STRUCT";
    public static String UNIONTYPE = "UNIONTYPE";
    public static String[] HIVE_TYPE_CHOICES = new String[]{"", MAP, UNIONTYPE};
    private String hiveType = "";
    private IDGenerator localIDGenerator;
    private IDGenerator methodIDGenerator;
    private Map localIDs = new TreeMap();
    private Map methodIDs = new TreeMap();
    protected ObjectChangeEvent sharedEvent = new ObjectChangeEvent("ChangeEvent");
    private static final Logger LOGGER = new Logger(StructuredType.class);
    public static final String TYPE_NAME = "StructuredType";

    public StructuredType(DesignPart designPart) {
        super(designPart);
    }

    public boolean isFinal() {
        return this._final;
    }

    public void setFinal(boolean _final) {
        this._final = _final;
    }

    public DTInheritance getInheritanceRelation() {
        return this.inheritanceRelation;
    }

    public void setInheritanceRelation(DTInheritance inheritanceRelation) {
        this.inheritanceRelation = inheritanceRelation;
    }

    public boolean isInstantiable() {
        return this.instantiable;
    }

    public void setInstantiable(boolean instantiable) {
        this.instantiable = instantiable;
    }

    public String getParentTypeID() {
        return this.parentTypeID;
    }

    public void setParentTypeID(String parentTypeID) {
        this.parentTypeID = parentTypeID;
    }

    public String getHiveType() {
        return this.hiveType;
    }

    public void setHiveType(String hiveType) {
        this.hiveType = hiveType;
    }

    public int getMaxLengthAsString() {
        return this.maxLengthAsString;
    }

    public void setMaxLengthAsString(int maxLengthAsString) {
        this.maxLengthAsString = maxLengthAsString;
    }

    public TypeElement createTypeElement() {
        return this.createTypeElement("");
    }

    public Method createMethod() {
        return this.createMethod(null);
    }

    public TypeElement createTypeElement(String typeName) {
        TypeElement typeElem = new TypeElement(this.getDesignPart(), this);
        typeElem.setName(typeName);
        typeElem.setDesign(this.getDesign());
        typeElem.setParent(this);
        this.add(typeElem);
        return typeElem;
    }

    public Method createMethod(String methodName) {
        Method method = new Method(this.getDesignPart(), this);
        method.setName(methodName);
        method.setDesign(this.getDesign());
        method.setParent(this);
        this.addMethod(method);
        return method;
    }

    public void addMethod(Method method) {
        if (method == null || this.isReadOnly()) {
            return;
        }
        if (this.containsMethod(method)) {
            return;
        }
        if (!this.getMethodClass().isAssignableFrom(method.getClass())) {
            LOGGER.error("Class: " + method.getClass());
            LOGGER.error("Expected: " + this.getContainedClass());
            throw new RuntimeException("Wrong class added to container.");
        }
        this.assignMethodID(method);
        this.methods.add(method);
        this.getMethodSet().add(method);
        method.setStructuredType(this);
        method.setParent(this.methods);
        method.addObjectListener(this);
        this.sharedEvent.setAffected(method);
        this.fireChange(this.sharedEvent);
    }

    public TypeElementSet getTypeElementSet() {
        return ((DataTypesDesign)this.getDesignPart()).getTypeElementSet();
    }

    public MethodSet getMethodSet() {
        return ((DataTypesDesign)this.getDesignPart()).getMethodSet();
    }

    public void add(TypeElement object) {
        if (object == null || this.isReadOnly()) {
            return;
        }
        if (this.contains(object)) {
            return;
        }
        if (this.getContainedClass().isAssignableFrom(object.getClass())) {
            String newName;
            if (!this.getDesign().isLoading() && !(newName = this.validateElementName(object.getName(), 0)).equalsIgnoreCase(object.getName())) {
                object.setName(newName);
            }
        } else {
            LOGGER.error("Class: " + object.getClass());
            LOGGER.error("Expected: " + this.getContainedClass());
            throw new RuntimeException("Wrong class added to container.");
        }
        this.assignLocalID(object);
        object.setParent(this.elements);
        this.elements.add(object);
        object.setStructuredType(this);
        this.getTypeElementSet().add(object);
        object.addObjectListener(this);
        ObjectChangeEvent event = new ObjectChangeEvent(ObjectChangeEvent.ELEMENT_ADDED.getDescription());
        event.setAffected(object);
        this.fireChange(event);
    }

    public boolean contains(TypeElement element) {
        return this.elements.contains(element);
    }

    public boolean containsMethod(Method method) {
        return this.methods.contains(method);
    }

    public Class getContainedClass() {
        return TypeElement.class;
    }

    public Class getMethodClass() {
        return Method.class;
    }

    protected void assignLocalID(ModelIDObject object) {
        String id = object.getObjectID();
        if (id == null) {
            while (this.localIDs.containsKey(id = this.getLocalIDGenerator().createNewID())) {
            }
            this.localIDs.put(id, object);
            object.setObjectID(id);
        } else {
            this.localIDs.put(id, object);
        }
    }

    protected void assignMethodID(ModelIDObject object) {
        String id = object.getObjectID();
        if (id == null) {
            while (this.methodIDs.containsKey(id = this.getMethodIDGenerator().createNewID())) {
            }
            this.methodIDs.put(id, object);
            object.setObjectID(id);
        } else {
            this.methodIDs.put(id, object);
        }
    }

    public IDGenerator getLocalIDGenerator() {
        if (this.localIDGenerator == null) {
            this.localIDGenerator = new IDGenerator();
            this.localIDGenerator.initializeWith(10000L, 3000000L);
        }
        return this.localIDGenerator;
    }

    public IDGenerator getMethodIDGenerator() {
        if (this.methodIDGenerator == null) {
            this.methodIDGenerator = new IDGenerator();
            this.methodIDGenerator.initializeWith(10000L, 3000000L);
        }
        return this.methodIDGenerator;
    }

    public List getAttributesList() {
        if (this.elements.size() > 0) {
            ArrayList list = new ArrayList();
            this.elements.addAllElementsTo(list);
            return list;
        }
        return Collections.EMPTY_LIST;
    }

    public int getAttributesCount() {
        return this.elements.size();
    }

    public List getMethodsList() {
        if (this.methods.size() > 0) {
            ArrayList list = new ArrayList();
            this.methods.addAllElementsTo(list);
            return list;
        }
        return Collections.EMPTY_LIST;
    }

    public TypeElement getElementByID(String localID) {
        if (localID == null) {
            return null;
        }
        Iterator it = this.elements.iterator();
        while (it.hasNext()) {
            TypeElement co = (TypeElement)it.next();
            if (!localID.equals(co.getObjectID())) continue;
            it = null;
            return co;
        }
        it = null;
        return null;
    }

    public Method getMethodByID(String localID) {
        if (localID == null) {
            return null;
        }
        Iterator it = this.methods.iterator();
        while (it.hasNext()) {
            Method co = (Method)it.next();
            if (!localID.equals(co.getObjectID())) continue;
            it = null;
            return co;
        }
        it = null;
        return null;
    }

    @Override
    public int getByteSize() {
        return 0;
    }

    @Override
    public String getSize() {
        return null;
    }

    public TypeElement[] getElements() {
        return this.toElementObjectArray(this.elements.getElementsList());
    }

    public Method[] getMethods() {
        return this.toMethodObjectArray(this.methods.getElementsList());
    }

    public TypeElement[] toElementObjectArray(Collection collection) {
        return (TypeElement[])collection.toArray((Object[])Array.newInstance(this.getContainedClass(), 0));
    }

    public Method[] toMethodObjectArray(Collection collection) {
        return (Method[])collection.toArray((Object[])Array.newInstance(this.getMethodClass(), 0));
    }

    public String getDataTypePresentationForHive() {
        String type = "String";
        TypeElement[] elems = this.getElements();
        if (elems.length > 0) {
            if (MAP.equals(this.getHiveType())) {
                if (elems.length > 1) {
                    type = "MAP<" + elems[0].getDataTypePresentationForHive() + "," + elems[1].getDataTypePresentationForHive() + ">";
                    return type;
                }
            } else {
                if (UNIONTYPE.equals(this.getHiveType())) {
                    type = "UNIONTYPE<";
                    for (int i = 0; i < elems.length; ++i) {
                        TypeElement te = elems[i];
                        if (i > 0) {
                            type = type + ",";
                        }
                        type = type + te.getDataTypePresentationForHive();
                    }
                    type = type + ">";
                    return type;
                }
                type = "STRUCT<";
                for (int i = 0; i < elems.length; ++i) {
                    TypeElement te = elems[i];
                    if (i > 0) {
                        type = type + ",";
                    }
                    type = type + te.getName();
                    type = type + ":" + te.getDataTypePresentationForHive();
                }
                type = type + ">";
                return type;
            }
        }
        return type;
    }

    public void remove(TypeElement object) {
        if (object != null && this.isWriteable()) {
            this.getTypeElementSet().remove(object);
            this.elements.remove(object);
            object.setStructuredType(null);
            this.localIDs.remove(object.getObjectID());
            object.removeObjectListener(this);
            object.setParent(null);
            this.fireChange(ObjectChangeEvent.ELEMENT_REMOVED);
        }
    }

    public TypeElement[] removeAll() {
        TypeElement[] elms = this.getElements();
        for (int i = 0; i < elms.length; ++i) {
            this.remove(elms[i]);
        }
        return elms;
    }

    public StructuredType getParentType() {
        if (this.parentType == null && !"".equalsIgnoreCase(this.parentTypeID)) {
            this.parentType = (StructuredType)this.getDesign().getDesignObject(this.parentTypeID);
            this.parentTypeID = "";
        }
        return this.parentType;
    }

    public void setParentType(StructuredType parentType) {
        this.setParentType(parentType, false);
    }

    public void setParentType(StructuredType parentType, boolean showMessage) {
        if (this.parentType != parentType) {
            if (parentType != null) {
                StructuredType newParent = parentType;
                this.parentType = parentType;
                if (!this.getDesign().isLoading()) {
                    this.updateInheritance(newParent);
                    if (parentType != null) {
                        this.refreshChildElementsNames();
                    }
                }
                this.fireChange(ObjectChangeEvent.HIERARCHICAL_PARENT_CHANGED);
            } else {
                StructuredType newParent = parentType;
                this.parentType = parentType;
                if (!this.getDesign().isLoading()) {
                    this.updateInheritance(newParent);
                }
                this.fireChange(ObjectChangeEvent.HIERARCHICAL_PARENT_CHANGED);
            }
        }
    }

    public String getParentTypeName() {
        StructuredType parentType = this.getParentType();
        if (parentType != null) {
            return parentType.getName();
        }
        return this.parentTypeName;
    }

    public void setParentTypeName(String name) {
        this.parentTypeName = name;
        StructuredType parentType = null;
        if (name != null && !name.isEmpty()) {
            parentType = (StructuredType)this.getDesign().getDataTypesDesign().getStructuredTypeSet().getByName(name);
        }
        this.setParentType(parentType);
    }

    protected void refreshChildElementsNames() {
        TypeElement[] elms = this.getElements();
        for (int i = 0; i < elms.length; ++i) {
            TypeElement te = elms[i];
            te.setName(this.validateElementName(te.getName(), 0));
        }
        Iterator it = ((DataTypesDesign)this.getDesignPart()).getStructuredTypeSet().iterator();
        while (it.hasNext()) {
            StructuredType st = (StructuredType)it.next();
            if (st.getParentType() != this) continue;
            st.refreshChildElementsNames();
        }
    }

    public boolean isParentOf(StructuredType child) {
        if (child == this) {
            return true;
        }
        for (StructuredType st = child.getParentType(); st != null; st = st.getParentType()) {
            if (st != this) continue;
            return true;
        }
        return false;
    }

    private String validateElementName(String name, int idx) {
        String newName = name;
        for (TypeElement element : this.getParentAndChildElements()) {
            if (!element.getName().equalsIgnoreCase(newName)) continue;
            String suffix = "_".concat(String.valueOf(idx));
            if (newName.endsWith(suffix)) {
                newName = newName.substring(0, newName.lastIndexOf(suffix));
            }
            newName = newName.concat("_").concat(String.valueOf(++idx));
            newName = this.validateElementName(newName, idx);
            break;
        }
        return newName;
    }

    public List getChildElements() {
        ArrayList<TypeElement> list = new ArrayList<TypeElement>();
        Iterator it = ((DataTypesDesign)this.getDesignPart()).getStructuredTypeSet().iterator();
        while (it.hasNext()) {
            StructuredType st = (StructuredType)it.next();
            if (st.getParentType() != this) continue;
            TypeElement[] elems = st.getElements();
            for (int i = 0; i < elems.length; ++i) {
                list.add(elems[i]);
            }
            list.addAll(st.getChildElements());
        }
        return list;
    }

    public List getParentElements() {
        ArrayList<TypeElement> list = new ArrayList<TypeElement>();
        for (StructuredType st = this.getParentType(); st != null; st = st.getParentType()) {
            for (int i = 0; i < st.getElements().length; ++i) {
                list.add(st.getElements()[i]);
            }
        }
        return list;
    }

    public List getParentAndChildElements() {
        ArrayList list = new ArrayList();
        list.addAll(this.getParentElements());
        list.addAll(this.getChildElements());
        return list;
    }

    protected void updateInheritance(StructuredType newParent) {
        if (newParent == null) {
            if (this.inheritanceRelation != null) {
                this.inheritanceRelation.remove();
                this.inheritanceRelation = null;
            }
        } else {
            if (this.inheritanceRelation != null) {
                if (this.inheritanceRelation.getSourceDTObject() == this.parentType) {
                    return;
                }
                this.inheritanceRelation.remove();
            }
            this.inheritanceRelation = this.getDesign().getDataTypesDesign().createDTInheritance();
            this.inheritanceRelation.setSourceDTObject(newParent);
            this.inheritanceRelation.setTargetDTObject(this);
        }
    }

    @Override
    public void changed(DesignObject object, ObjectChangeEvent event) {
        if (event == ObjectChangeEvent.OBJECT_REMOVED) {
            if (event.getAffected() instanceof TypeElement) {
                this.remove((TypeElement)event.getAffected());
            } else if (event.getAffected() instanceof Method) {
                this.removeMethod((Method)event.getAffected());
            }
        } else {
            this.fireChange(event);
        }
    }

    public void removeMethod(Method object) {
        if (object != null && this.isWriteable()) {
            this.getMethodSet().remove(object);
            this.methods.remove(object);
            object.setStructuredType(null);
            this.methodIDs.remove(object.getObjectID());
            object.removeObjectListener(this);
            object.setParent(null);
            this.sharedEvent.setAffected(object);
            this.fireChange(this.sharedEvent);
        }
    }

    public List getAllElements() {
        ArrayList list = new ArrayList();
        if (this.getParentType() != null) {
            this.getParentType().addParentElements(list);
        }
        this.elements.addAllElementsTo(list);
        return list;
    }

    private void addParentElements(List list) {
        if (this.getParentType() != null) {
            this.getParentType().addParentElements(list);
        }
        this.elements.addAllElementsTo(list);
    }

    public Method[] removeAllMethods() {
        Method[] mtds = this.getMethods();
        for (int i = 0; i < mtds.length; ++i) {
            this.removeMethod(mtds[i]);
        }
        return mtds;
    }

    public Method getMethodByNameAndNumber(String name, int number) {
        if (name != null) {
            for (Method method : this.methods) {
                if (!name.equalsIgnoreCase(method.getName()) || number != method.getNumber()) continue;
                return method;
            }
        }
        return null;
    }

    public List getAllSubTypes() {
        ArrayList<StructuredType> list = new ArrayList<StructuredType>();
        Iterator it = this.getDesignObjectSet().iterator();
        while (it.hasNext()) {
            StructuredType st = (StructuredType)it.next();
            if (st.getParentType() != this) continue;
            list.add(st);
            list.addAll(st.getSubTypes());
        }
        return list;
    }

    private List getSubTypes() {
        ArrayList<StructuredType> list = new ArrayList<StructuredType>();
        Iterator it = this.getDesignObjectSet().iterator();
        while (it.hasNext()) {
            StructuredType st = (StructuredType)it.next();
            if (st.getParentType() != this) continue;
            list.add(st);
        }
        return list;
    }

    @Override
    public String getObjectTypeName() {
        return TYPE_NAME;
    }

    @Override
    public String getStorageName() {
        try {
            return new File(this.getDesignPart().getStoragePath(), "structuredtype/" + this.getObjectID() + ".xml").getCanonicalPath();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public boolean moveElementToIndex(DesignObject object, int index) {
        if (this.elements.getIndexOf(object) == index) {
            return true;
        }
        boolean result = this.elements.moveElementToIndex(object, index);
        this.sharedEvent.setAffected(object);
        this.fireChange(this.sharedEvent);
        return result;
    }

    public boolean moveMethodToIndex(DesignObject object, int index) {
        if (this.methods.getIndexOf(object) == index) {
            return true;
        }
        boolean result = this.methods.moveElementToIndex(object, index);
        this.sharedEvent.setAffected(object);
        this.fireChange(this.sharedEvent);
        return result;
    }

    public int getIndexOf(TypeElement object) {
        return this.elements.getIndexOf(object);
    }
}

