/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.ddl.oracle.v10g;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import oracle.dbtools.crest.exports.ddl.oracle.v10g.SSBTableOraclev10g;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.PropertyNames;
import oracle.dbtools.crest.model.design.compare.CompareModelToModel;
import oracle.dbtools.crest.model.design.compare.CompareObjectSelection;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.PropertyHolder;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBListPartitionOracle;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.v10g.AbstractCSSBOraclev10g;
import oracle.dbtools.crest.model.design.compare.storage.StoragePropertiesComparator;
import oracle.dbtools.crest.model.design.compare.storage.oracle.TableComparatorOracle;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.relational.SpatialColumnDefObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.oracle.IndexProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SupplementalLogGroup;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableProxyOraclev10g;
import oracle.dbtools.crest.util.options.Settings;

public class CSSBAlterTableOraclev10g
extends AbstractCSSBOraclev10g {
    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        CompareObjectSelection listPartitionsNode;
        int listPartitionsIndex;
        CompareObjectSelection sourceObj = (CompareObjectSelection)object;
        Table table = (Table)sourceObj.getObject();
        Design design = table.getDesign();
        RDBMSSite site = table.getSelectedRDBMSSite();
        this.storageDesign = (StorageDesignOraclev10g)design.getStorageDesign(site, table);
        TableProxyOraclev10g tableProxy = (TableProxyOraclev10g)this.storageDesign.getTableProxySet().getProxy(table.getObjectID());
        boolean createProp = false;
        boolean moveProp = false;
        boolean moveStorageProp = false;
        if (sourceObj.isModified()) {
            StoragePropertiesComparator pc;
            PropertyHolder ph;
            boolean alterProp = false;
            ArrayList<String> propList = new ArrayList<String>();
            Settings settings = sourceObj.getObject().getDesign().getSettings();
            for (EngPropertyHolder ph2 : sourceObj.getPropertiesComparator().getPropertiesList()) {
                if (!ph2.isSelected()) continue;
                if (ph2.getName().equals(PropertiesComparator.COMMENT_IN_RDBMS) && settings.isGenerateCommentsInRDBMS()) {
                    if (ph2.getLeftValue() != null && !ph2.getLeftValue().isEmpty() || sourceObj.isModified() && sourceObj.getStatus() != 2) {
                        this.appendCommentOn(oldbuffer, tableProxy, prettyPrint, false, CSSBAlterTableOraclev10g.isMaterializedQueryTable(sourceObj.getCorrespondentObjectSelection()));
                    }
                } else if (ph2.getName().equals(PropertiesComparator.SPATIAL_TABLE) && Boolean.parseBoolean(ph2.getLeftValue())) {
                    for (SpatialColumnDefObject spObjects : table.getSpatialDefinitions()) {
                        if (spObjects.getSpatialColumn() == null && !spObjects.isFunction()) continue;
                        this.appendRegisterSpatialTable(oldbuffer, table, spObjects, prettyPrint);
                    }
                }
                if (!ph2.getName().equalsIgnoreCase(PropertyNames.ROW_ARCHIVAL)) continue;
                propList.add("ROW ARCHIVAL");
                alterProp = true;
            }
            for (EngPropertyHolder ph2 : sourceObj.getPropertiesComparator().getStoragePropertiesList()) {
                if (!ph2.isSelected()) continue;
                String propName = ph2.getName();
                if (settings.isIncludeStorageInDDL()) {
                    if (propName.equalsIgnoreCase(PropertyNames.PCT_FREE) && settings.isIncludePctFreeInDDL()) {
                        propList.add("PCTFREE");
                        alterProp = true;
                    } else if (propName.equalsIgnoreCase(PropertyNames.PCT_USED) && settings.isIncludePctUsedInDDL()) {
                        propList.add("PCTUSED");
                        alterProp = true;
                    } else if (propName.equalsIgnoreCase(PropertyNames.INIT_TRANS) && settings.isIncludeInitransInDDL()) {
                        propList.add("INITRANS");
                        alterProp = true;
                    } else if (propName.equalsIgnoreCase(PropertyNames.SC_BUFFER_POOL) && settings.isIncludeBufferPoolInDDL()) {
                        propList.add("BUFFER_POOL");
                        alterProp = true;
                    } else if (propName.equalsIgnoreCase(PropertyNames.SC_INITIAL_EXTENT) && settings.isIncludeInitialExtentInDDL() || propName.equalsIgnoreCase(PropertyNames.SC_NEXT_EXTENT) && settings.isIncludeNextExtentInDDL() || propName.equalsIgnoreCase(PropertyNames.SC_MIN_EXTENTS) && settings.isIncludeMinExtentsInDDL() || propName.equalsIgnoreCase(PropertyNames.SC_MAX_EXTENTS) && settings.isIncludeMaxExtentsInDDL() || propName.equalsIgnoreCase(PropertyNames.SC_PCT_INCREASE) && settings.isIncludePctIncreaseInDDL() || propName.equalsIgnoreCase(PropertyNames.SC_FREE_LISTS) && settings.isIncludeFreeListsInDDL() || propName.equalsIgnoreCase(PropertyNames.SC_FREE_LISTS_GRPS) && settings.isIncludeFreeListGroupsInDDL()) {
                        moveStorageProp = true;
                    }
                }
                if (!propName.equalsIgnoreCase(PropertyNames.TABLESPACE) || !settings.isIncludeTablespaceInDDL() || tableProxy.getTableSpace() == null) continue;
                moveProp = true;
            }
            if (settings.isIncludeLoggingInDDL() && (ph = (PropertyHolder)(pc = sourceObj.getPropertiesComparator().getPhysicalPropertiesComparator()).getPropertyHolderByName(TableComparatorOracle.LOGGING)) != null && ph.isModified() && ph.isSelected() && !ph.isFiltered()) {
                alterProp = true;
                propList.add("LOGGING");
            }
            if (alterProp) {
                String logging;
                CSSBAlterTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                this.appendBeforeAlterScript(oldbuffer, prettyPrint, (ContainerObject)tableProxy.getObject());
                CSSBAlterTableOraclev10g.appendStringWithSpace(oldbuffer, "ALTER");
                CSSBAlterTableOraclev10g.appendStringWithSpace(oldbuffer, "TABLE");
                CSSBAlterTableOraclev10g.appendStringWithSpace(oldbuffer, CSSBAlterTableOraclev10g.getFormattedTableName(sourceObj, this.storageDesign));
                if (this.storageDesign.getDesign().getSettings().isIncludeLoggingInDDL() && (propList == null || propList.contains("LOGGING")) && !"".equals(logging = tableProxy.getLogging())) {
                    CSSBAlterTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 2);
                    if (logging.equalsIgnoreCase("NO")) {
                        CSSBAlterTableOraclev10g.appendStringWithSpace(oldbuffer, "NOLOGGING");
                    } else {
                        CSSBAlterTableOraclev10g.appendStringWithSpace(oldbuffer, "LOGGING");
                    }
                }
                this.appendSegment(oldbuffer, tableProxy.getSegment(), prettyPrint, tableProxy.getTableSpace(), tableProxy.getLogging(), propList);
                if (propList.contains("ROW ARCHIVAL")) {
                    CSSBAlterTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 2);
                    if (!table.isRowArchival()) {
                        CSSBAlterTableOraclev10g.appendStringWithSpace(oldbuffer, "NO");
                    }
                    CSSBAlterTableOraclev10g.appendStringWithSpace(oldbuffer, "ROW ARCHIVAL");
                }
                CSSBAlterTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                CSSBAlterTableOraclev10g.appendLineFinisher(oldbuffer, prettyPrint);
                this.appendAfterAlterScript(oldbuffer, prettyPrint, (ContainerObject)tableProxy.getObject());
                this.getStatus().incrementAlterTable();
            }
            if (createProp) {
                CSSBAlterTableOraclev10g.appendStringWithSpace(oldbuffer, "-- Table " + table.getName() + " some storage properties are not modified");
                CSSBAlterTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                CSSBAlterTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
            }
            if (moveProp || moveStorageProp) {
                CSSBAlterTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                CSSBAlterTableOraclev10g.appendStringWithSpace(oldbuffer, "ALTER");
                CSSBAlterTableOraclev10g.appendStringWithSpace(oldbuffer, "TABLE");
                CSSBAlterTableOraclev10g.appendStringWithSpace(oldbuffer, CSSBAlterTableOraclev10g.getFormattedTableName(sourceObj, this.storageDesign));
                CSSBAlterTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 1);
                CSSBAlterTableOraclev10g.appendStringWithSpace(oldbuffer, "MOVE");
                if (moveProp) {
                    CSSBAlterTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 1);
                    CSSBAlterTableOraclev10g.appendStringWithSpace(oldbuffer, "TABLESPACE");
                    CSSBAlterTableOraclev10g.appendStringWithSpace(oldbuffer, this.storageDesign.getFormatedName(tableProxy.getTableSpace()));
                }
                if (moveStorageProp) {
                    CSSBAlterTableOraclev10g.addStorage(oldbuffer, tableProxy.getSegment(), prettyPrint, tableProxy.getTableSpace(), tableProxy.getLogging(), null, this.storageDesign);
                }
                CSSBAlterTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                CSSBAlterTableOraclev10g.appendLineFinisher(oldbuffer, prettyPrint);
                this.getStatus().incrementAlterTable();
                this.addRebuildIndexes(oldbuffer, tableProxy, prettyPrint);
            }
        }
        if ((listPartitionsIndex = sourceObj.getChildIndex(CompareModelToModel.LIST_PARTITIONS)) > -1 && !createProp && (listPartitionsNode = (CompareObjectSelection)sourceObj.getChild(listPartitionsIndex)).hasChildsWithChangeStatus()) {
            CSSBListPartitionOracle cssbListPartitionOracle = new CSSBListPartitionOracle();
            cssbListPartitionOracle.updateListPartitions(oldbuffer, sourceObj, listPartitionsNode, this.storageDesign, prettyPrint);
        }
        this.processPhysicalproperties(oldbuffer, object, prettyPrint);
    }

    public static boolean isMaterializedQueryTable(ModelIdObjectSelection sel) {
        ModelIDObject mo = sel.getObject();
        if (mo instanceof Table) {
            String sql = ((Table)mo).getUserDefinedSQL();
            return sql != null && !sql.isEmpty() || ((Table)mo).isMaterializedQueryTable();
        }
        if (mo instanceof TableProxyOracle) {
            return ((TableProxyOracle)mo).getSnapshot() != null;
        }
        return false;
    }

    private void addRebuildIndexes(StringBuffer oldbuffer, TableProxyOracle tp, boolean prettyPrint) {
        StorageDesignOracle sd = (StorageDesignOracle)tp.getStorageDesign();
        for (IndexProxyOracle ip : tp.getIndexes()) {
            String name = sd.getFormatedLongNameDDL(ip);
            CSSBAlterTableOraclev10g.appendStringWithSpace(oldbuffer, "ALTER");
            CSSBAlterTableOraclev10g.appendStringWithSpace(oldbuffer, "INDEX");
            CSSBAlterTableOraclev10g.appendStringWithSpace(oldbuffer, name);
            CSSBAlterTableOraclev10g.appendStringWithSpace(oldbuffer, "REBUILD");
            CSSBAlterTableOraclev10g.appendLineFinisher(oldbuffer, prettyPrint);
        }
    }

    public static void addStorage(StringBuffer buffer, SegmentOracle segment, boolean prettyPrint, TableSpaceOracle tableSpace, String logging, List propList, StorageDesignOracle storageDesign) {
        Settings settings = storageDesign.getDesign().getSettings();
        if (settings.isIncludeStorageInDDL()) {
            CSSBAlterTableOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            CSSBAlterTableOraclev10g.appendStringWithSpace(buffer, "STORAGE");
            CSSBAlterTableOraclev10g.appendStringWithSpace(buffer, '(');
            CSSBAlterTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            boolean props = false;
            if (segment.getSCInitialExtent() > 0L && settings.isIncludeInitialExtentInDDL() && (propList == null || propList.contains("INITIAL"))) {
                CSSBAlterTableOraclev10g.appendStringWithSpace(buffer, "INITIAL");
                CSSBAlterTableOraclev10g.appendStringWithSpace(buffer, segment.getSCInitialExtent());
                CSSBAlterTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                props = true;
            }
            if (segment.getSCNextExtent() > 0L && settings.isIncludeNextExtentInDDL() && (propList == null || propList.contains("NEXT"))) {
                CSSBAlterTableOraclev10g.appendStringWithSpace(buffer, "NEXT");
                CSSBAlterTableOraclev10g.appendStringWithSpace(buffer, segment.getSCNextExtent());
                CSSBAlterTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                props = true;
            }
            if (settings.isIncludePctIncreaseInDDL() && (propList == null || propList.contains("PCTINCREASE"))) {
                CSSBAlterTableOraclev10g.appendStringWithSpace(buffer, "PCTINCREASE");
                CSSBAlterTableOraclev10g.appendStringWithSpace(buffer, segment.getSCPctIncrease());
                CSSBAlterTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                props = true;
            }
            if (settings.isIncludeMinExtentsInDDL() && (propList == null || propList.contains("MINEXTENTS"))) {
                CSSBAlterTableOraclev10g.appendStringWithSpace(buffer, "MINEXTENTS");
                CSSBAlterTableOraclev10g.appendStringWithSpace(buffer, segment.getSCMinExtents());
                CSSBAlterTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                props = true;
            }
            if (settings.isIncludeMaxExtentsInDDL() && (propList == null || propList.contains("MAXEXTENTS"))) {
                CSSBAlterTableOraclev10g.appendStringWithSpace(buffer, "MAXEXTENTS");
                CSSBAlterTableOraclev10g.appendStringWithSpace(buffer, segment.getSCMaxExtents());
                CSSBAlterTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                props = true;
            }
            if (settings.isIncludeFreeListsInDDL() && (propList == null || propList.contains("FREELISTS"))) {
                CSSBAlterTableOraclev10g.appendStringWithSpace(buffer, "FREELISTS");
                CSSBAlterTableOraclev10g.appendStringWithSpace(buffer, segment.getSCFreeLists());
                CSSBAlterTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                props = true;
            }
            if (settings.isIncludeFreeListGroupsInDDL() && (propList == null || propList.contains("FREELISTGROUPS"))) {
                CSSBAlterTableOraclev10g.appendStringWithSpace(buffer, "FREELIST");
                CSSBAlterTableOraclev10g.appendStringWithSpace(buffer, "GROUPS");
                CSSBAlterTableOraclev10g.appendStringWithSpace(buffer, segment.getSCFreelistGroups());
                CSSBAlterTableOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                props = true;
            }
            CSSBAlterTableOraclev10g.appendStringWithSpace(buffer, ')');
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return ((CompareObjectSelection)object).getObject() instanceof Table;
    }

    void processPhysicalproperties(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        CompareObjectSelection sourceObj = (CompareObjectSelection)object;
        if (sourceObj.isModified()) {
            Table table = (Table)sourceObj.getObject();
            Design design = table.getDesign();
            RDBMSSite site = table.getSelectedRDBMSSite();
            this.storageDesign = (StorageDesignOraclev10g)design.getStorageDesign(site, table);
            TableProxyOraclev10g stp = (TableProxyOraclev10g)this.storageDesign.getTableProxySet().getProxy(table.getObjectID());
            StoragePropertiesComparator pc = sourceObj.getPropertiesComparator().getPhysicalPropertiesComparator();
            PropertyHolder ph = (PropertyHolder)pc.getPropertyHolderByName(TableComparatorOracle.SUPPLEMENTAL_GROUPS);
            TableProxyOraclev10g ttp = null;
            if (pc instanceof TableComparatorOracle) {
                ttp = (TableProxyOraclev10g)((TableComparatorOracle)pc).getTargetTableProxy();
            }
            if (ph.isSelected() && ttp != null) {
                CSSBAlterTableOraclev10g.processLogGroups(oldbuffer, sourceObj, stp, ttp, prettyPrint);
            }
            if ((ph = (PropertyHolder)pc.getPropertyHolderByName(TableComparatorOracle.SUPPLEMENTAL_ID_KEYS)).isSelected() && ttp != null) {
                CSSBAlterTableOraclev10g.processLogIdKeys(oldbuffer, sourceObj, stp, ttp, prettyPrint);
            }
            this.addExternalTable(oldbuffer, sourceObj, stp, prettyPrint);
        }
    }

    public void addExternalTable(StringBuffer oldbuffer, CompareObjectSelection obj, TableProxyOraclev10g stp, boolean prettyPrint) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (EngPropertyHolder ph : obj.getPropertiesComparator().getPhysicalPropertiesList()) {
            if (!ph.isSelected()) continue;
            if (ph.getName().equals(TableComparatorOracle.ACCESS_PARAMS)) {
                map.put(TableComparatorOracle.ACCESS_PARAMS, ph.getLeftValue());
                continue;
            }
            if (ph.getName().equals(TableComparatorOracle.DEFAULT_DIR)) {
                map.put(TableComparatorOracle.DEFAULT_DIR, ph.getLeftValue());
                continue;
            }
            if (ph.getName().equals(TableComparatorOracle.REJECT_LIMIT)) {
                map.put(TableComparatorOracle.REJECT_LIMIT, ph.getLeftValue());
                continue;
            }
            if (ph.getName().equals(TableComparatorOracle.OPAQUE_FORMAT_SPEC)) {
                map.put(TableComparatorOracle.OPAQUE_FORMAT_SPEC, ph.getLeftValue());
                continue;
            }
            if (ph.getName().equals(TableComparatorOracle.LOCATIONS)) {
                map.put(TableComparatorOracle.LOCATIONS, ph.getLeftValue());
                continue;
            }
            if (ph.getName().equals(TableComparatorOracle.PROJECT_COLUMN)) {
                map.put(TableComparatorOracle.PROJECT_COLUMN, ph.getLeftValue());
                continue;
            }
            if (!ph.getName().equals(TableComparatorOracle.CLOB_SUBQUERY)) continue;
            map.put(TableComparatorOracle.CLOB_SUBQUERY, ph.getLeftValue());
        }
        if (!map.isEmpty()) {
            String pr;
            String clob;
            String opac;
            String tname = CSSBAlterTableOraclev10g.getFormattedTableName(obj, this.storageDesign);
            CSSBAlterTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
            CSSBAlterTableOraclev10g.appendStringWithSpace(oldbuffer, "ALTER");
            CSSBAlterTableOraclev10g.appendStringWithSpace(oldbuffer, "TABLE");
            CSSBAlterTableOraclev10g.appendStringWithSpace(oldbuffer, CSSBAlterTableOraclev10g.getFormattedTableName(obj, this.storageDesign));
            CSSBAlterTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 1);
            boolean newline = false;
            if (map.get(TableComparatorOracle.ACCESS_PARAMS) != null) {
                opac = stp.getOpaqueFormatSpec();
                if (opac != null && !opac.isEmpty()) {
                    CSSBAlterTableOraclev10g.appendStringWithSpace(oldbuffer, "ACCESS");
                    CSSBAlterTableOraclev10g.appendStringWithSpace(oldbuffer, "PARAMETERS");
                    CSSBAlterTableOraclev10g.appendStringWithSpace(oldbuffer, '(');
                    CSSBAlterTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 1);
                    CSSBAlterTableOraclev10g.appendStringWithSpace(oldbuffer, opac.trim());
                    CSSBAlterTableOraclev10g.appendStringWithSpace(oldbuffer, ')');
                    newline = true;
                } else {
                    String clob2 = stp.getClobSubquery();
                    if (clob2 != null && !clob2.isEmpty()) {
                        CSSBAlterTableOraclev10g.appendStringWithSpace(oldbuffer, "ACCESS");
                        CSSBAlterTableOraclev10g.appendStringWithSpace(oldbuffer, "PARAMETERS");
                        CSSBAlterTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 1);
                        CSSBAlterTableOraclev10g.appendStringWithSpace(oldbuffer, clob2.trim());
                        newline = true;
                    }
                }
            } else if (map.get(TableComparatorOracle.OPAQUE_FORMAT_SPEC) != null) {
                opac = stp.getOpaqueFormatSpec();
                if (opac != null && !opac.isEmpty()) {
                    CSSBAlterTableOraclev10g.appendStringWithSpace(oldbuffer, "ACCESS");
                    CSSBAlterTableOraclev10g.appendStringWithSpace(oldbuffer, "PARAMETERS");
                    CSSBAlterTableOraclev10g.appendStringWithSpace(oldbuffer, '(');
                    CSSBAlterTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 1);
                    CSSBAlterTableOraclev10g.appendStringWithSpace(oldbuffer, opac.trim());
                    CSSBAlterTableOraclev10g.appendStringWithSpace(oldbuffer, ')');
                    newline = true;
                }
            } else if (map.get(TableComparatorOracle.CLOB_SUBQUERY) != null && (clob = stp.getClobSubquery()) != null && !clob.isEmpty()) {
                CSSBAlterTableOraclev10g.appendStringWithSpace(oldbuffer, "ACCESS");
                CSSBAlterTableOraclev10g.appendStringWithSpace(oldbuffer, "PARAMETERS");
                CSSBAlterTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 1);
                CSSBAlterTableOraclev10g.appendStringWithSpace(oldbuffer, clob.trim());
                newline = true;
            }
            if (newline) {
                CSSBAlterTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 1);
                newline = false;
            }
            if (map.get(TableComparatorOracle.DEFAULT_DIR) != null) {
                CSSBAlterTableOraclev10g.appendStringWithSpace(oldbuffer, "DEFAULT");
                CSSBAlterTableOraclev10g.appendStringWithSpace(oldbuffer, "DIRECTORY");
                CSSBAlterTableOraclev10g.appendStringWithSpace(oldbuffer, stp.getDefaultDirName());
                newline = true;
            }
            if (newline) {
                CSSBAlterTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 1);
                newline = false;
            }
            if (map.get(TableComparatorOracle.REJECT_LIMIT) != null) {
                CSSBAlterTableOraclev10g.appendStringWithSpace(oldbuffer, "REJECT");
                CSSBAlterTableOraclev10g.appendStringWithSpace(oldbuffer, "LIMIT");
                CSSBAlterTableOraclev10g.appendStringWithSpace(oldbuffer, stp.getRejectLimit());
                newline = true;
            }
            if (newline) {
                CSSBAlterTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 1);
                newline = false;
            }
            if (map.get(TableComparatorOracle.PROJECT_COLUMN) != null && (TableProxyOracle.ALL.equalsIgnoreCase(pr = stp.getProjectColumn()) || TableProxyOracle.REFERENCED.equalsIgnoreCase(pr))) {
                CSSBAlterTableOraclev10g.appendStringWithSpace(oldbuffer, "PROJECT COLUMN");
                CSSBAlterTableOraclev10g.appendStringWithSpace(oldbuffer, pr);
                newline = true;
            }
            if (newline) {
                CSSBAlterTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 1);
                newline = false;
            }
            if (map.get(TableComparatorOracle.LOCATIONS) != null) {
                SSBTableOraclev10g.appendLocations(oldbuffer, stp, prettyPrint, newline);
                newline = false;
            }
            CSSBAlterTableOraclev10g.appendLineFinisher(oldbuffer, prettyPrint);
        }
    }

    public static void processLogIdKeys(StringBuffer oldbuffer, CompareObjectSelection sourceObj, TableProxyOraclev10g stp, TableProxyOraclev10g ttp, boolean prettyPrint) {
        CSSBAlterTableOraclev10g.processLogIdKeys(oldbuffer, sourceObj, stp, ttp, prettyPrint, true);
    }

    public static void processLogIdKeys(StringBuffer oldbuffer, CompareObjectSelection sourceObj, TableProxyOraclev10g stp, TableProxyOraclev10g ttp, boolean prettyPrint, boolean includDrop) {
        boolean tf;
        String keys = "";
        String dkeys = "";
        boolean sf = stp.getSupplementalLogPK();
        if (sf != (tf = ttp.getSupplementalLogPK())) {
            if (tf) {
                dkeys = "PRIMARY KEY";
            }
            if (sf) {
                keys = "PRIMARY KEY";
            }
        }
        if ((sf = stp.getSupplementalLogUK()) != (tf = ttp.getSupplementalLogUK())) {
            if (tf) {
                dkeys = dkeys.isEmpty() ? "UNIQUE" : dkeys + ',' + "UNIQUE";
            }
            if (sf) {
                keys = keys.isEmpty() ? "UNIQUE" : keys + ',' + "UNIQUE";
            }
        }
        if ((sf = stp.getSupplementalLogFK()) != (tf = ttp.getSupplementalLogFK())) {
            if (tf) {
                dkeys = dkeys.isEmpty() ? "FOREIGN KEY" : dkeys + ',' + "FOREIGN KEY";
            }
            if (sf) {
                keys = keys.isEmpty() ? "FOREIGN KEY" : keys + ',' + "FOREIGN KEY";
            }
        }
        if ((sf = stp.getSupplementalLogALL()) != (tf = ttp.getSupplementalLogALL())) {
            if (tf) {
                dkeys = dkeys.isEmpty() ? "ALL" : dkeys + ',' + "ALL";
            }
            if (sf) {
                keys = keys.isEmpty() ? "ALL" : keys + ',' + "ALL";
            }
        }
        if (!dkeys.isEmpty() && includDrop) {
            CSSBAlterTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
            CSSBAlterTableOraclev10g.appendStringWithSpace(oldbuffer, "ALTER TABLE " + CSSBAlterTableOraclev10g.getFormattedTableName(sourceObj, stp.getStorageDesign()) + " DROP SUPPLEMENTAL LOG DATA (");
            CSSBAlterTableOraclev10g.appendStringWithSpace(oldbuffer, dkeys);
            CSSBAlterTableOraclev10g.appendStringWithSpace(oldbuffer, ") COLUMNS");
            CSSBAlterTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
            CSSBAlterTableOraclev10g.appendLineFinisher(oldbuffer, prettyPrint);
        }
        if (!keys.isEmpty()) {
            CSSBAlterTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
            CSSBAlterTableOraclev10g.appendStringWithSpace(oldbuffer, "ALTER TABLE " + CSSBAlterTableOraclev10g.getFormattedTableName(sourceObj, stp.getStorageDesign()) + " ADD SUPPLEMENTAL LOG DATA (");
            CSSBAlterTableOraclev10g.appendStringWithSpace(oldbuffer, keys);
            CSSBAlterTableOraclev10g.appendStringWithSpace(oldbuffer, ") COLUMNS");
            CSSBAlterTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
            CSSBAlterTableOraclev10g.appendLineFinisher(oldbuffer, prettyPrint);
        }
    }

    public static void processLogGroups(StringBuffer oldbuffer, CompareObjectSelection sourceObj, TableProxyOraclev10g stp, TableProxyOraclev10g ttp, boolean prettyPrint) {
        CSSBAlterTableOraclev10g.processLogGroups(oldbuffer, sourceObj, stp, ttp, prettyPrint, true);
    }

    public static void processLogGroups(StringBuffer oldbuffer, CompareObjectSelection sourceObj, TableProxyOraclev10g stp, TableProxyOraclev10g ttp, boolean prettyPrint, boolean includDrop) {
        ArrayList<SupplementalLogGroup> drop = new ArrayList<SupplementalLogGroup>();
        ArrayList<SupplementalLogGroup> create = new ArrayList<SupplementalLogGroup>();
        List<SupplementalLogGroup> slogs = stp.getLoggingGroups();
        List<SupplementalLogGroup> tlogs = ttp.getLoggingGroups();
        ArrayList<SupplementalLogGroup> tcopy = new ArrayList<SupplementalLogGroup>(tlogs);
        for (SupplementalLogGroup sg : slogs) {
            SupplementalLogGroup gr = SupplementalLogGroup.getByName(tlogs, sg.getName());
            if (gr == null) {
                create.add(sg);
                continue;
            }
            if (gr.equivelentTo(sg)) {
                tcopy.remove(gr);
                continue;
            }
            create.add(sg);
            drop.add(sg);
            tcopy.remove(gr);
        }
        if (includDrop) {
            drop.addAll(tcopy);
            for (SupplementalLogGroup sg : drop) {
                CSSBAlterTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                CSSBAlterTableOraclev10g.appendStringWithSpace(oldbuffer, "ALTER");
                CSSBAlterTableOraclev10g.appendStringWithSpace(oldbuffer, "TABLE");
                CSSBAlterTableOraclev10g.appendStringWithSpace(oldbuffer, CSSBAlterTableOraclev10g.getFormattedTableName(sourceObj, stp.getStorageDesign()));
                CSSBAlterTableOraclev10g.appendStringWithSpace(oldbuffer, "DROP SUPPLEMENTAL LOG GROUP");
                CSSBAlterTableOraclev10g.appendStringWithSpace(oldbuffer, stp.getStorageDesign().getFormatedName(sg.getName()));
                CSSBAlterTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                CSSBAlterTableOraclev10g.appendLineFinisher(oldbuffer, prettyPrint);
            }
        }
        for (SupplementalLogGroup sg : create) {
            CSSBAlterTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
            CSSBAlterTableOraclev10g.appendStringWithSpace(oldbuffer, "ALTER");
            CSSBAlterTableOraclev10g.appendStringWithSpace(oldbuffer, "TABLE");
            CSSBAlterTableOraclev10g.appendStringWithSpace(oldbuffer, CSSBAlterTableOraclev10g.getFormattedTableName(sourceObj, stp.getStorageDesign()));
            CSSBAlterTableOraclev10g.appendStringWithSpace(oldbuffer, "ADD SUPPLEMENTAL LOG GROUP");
            CSSBAlterTableOraclev10g.appendStringWithSpace(oldbuffer, stp.getStorageDesign().getFormatedName(sg.getName()));
            CSSBAlterTableOraclev10g.appendStringWithSpace(oldbuffer, sg.getColumnsDDLPresentation());
            if (TableProxyOraclev10g.ALWAYS.equals(sg.getCondition())) {
                CSSBAlterTableOraclev10g.appendStringWithSpace(oldbuffer, TableProxyOraclev10g.ALWAYS);
            }
            CSSBAlterTableOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
            CSSBAlterTableOraclev10g.appendLineFinisher(oldbuffer, prettyPrint);
        }
    }
}

