/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.ddl.oracle.v10g;

import java.util.Iterator;
import oracle.dbtools.crest.exports.ddl.oracle.SSBAutoIncrementColumnOracle;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.compare.ddl.AbstractCSSBOracle;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.v10g.CSSBCreateTableOraclev10g;
import oracle.dbtools.crest.model.design.constraint.CheckConstraint;
import oracle.dbtools.crest.model.design.constraint.ConstraintEnumeration;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.datatypes.Datatype;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.SpatialColumnDefObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StructuredTypeProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableCheckConstraintOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.ColumnProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.TableProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.ColumnProxyOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v12c.ColumnProxyOraclev12c;
import oracle.dbtools.crest.model.design.storage.oracle.v12c.StorageDesignOraclev12c;

public abstract class AbstractCSSBOraclev10g
extends AbstractCSSBOracle {
    private DesignObject sType;
    protected StorageDesignOracle storageDesign;
    protected SSBAutoIncrementColumnOracle ssbAutoIncCol = null;
    private boolean hasIdentityOptions;

    protected void appendRowDependency(StringBuffer buffer, TableProxyOracle tableProxy, boolean prettyPrint) {
        if ("YES".equalsIgnoreCase(tableProxy.getRowDependency())) {
            AbstractCSSBOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "ROWDEPENDENCIES");
        } else if (this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL()) {
            AbstractCSSBOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "NOROWDEPENDENCIES");
        }
    }

    protected void appendRowMovement(StringBuffer buffer, TableProxyOracle tableProxy, boolean prettyPrint) {
        if (!"INDEX".equalsIgnoreCase(tableProxy.getOrganization()) || "YES".equalsIgnoreCase(tableProxy.getPartitioned())) {
            if ("ENABLE".equalsIgnoreCase(tableProxy.getParttitionedRowMovement())) {
                AbstractCSSBOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "ENABLE");
                AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "ROW MOVEMENT");
            } else if (this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL()) {
                AbstractCSSBOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "DISABLE");
                AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "ROW MOVEMENT");
            }
        }
    }

    protected void appendXMLTypeColumnProps(StringBuffer buffer, ColumnProxyOraclev10g columnProxy, boolean prettyPrint) {
        Column column = columnProxy.getColumn();
        if (column.isReference() && column.getUse() == 3) {
            return;
        }
        boolean storeAsBinaryXml = false;
        String allowAnySchema = "";
        String allowNonSchema = "";
        AbstractCSSBOraclev10g.appendNewLine(buffer, prettyPrint, 1);
        AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "XMLTYPE");
        AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "COLUMN");
        AbstractCSSBOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columnProxy));
        AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "STORE AS");
        if (columnProxy.getStoreAs().equalsIgnoreCase("OBJECT RELATIONAL")) {
            AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "OBJECT RELATIONAL");
        } else {
            if (columnProxy instanceof ColumnProxyOraclev11g) {
                if (((ColumnProxyOraclev11g)columnProxy).getLobStorageType().equalsIgnoreCase("SECUREFILE")) {
                    AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "SECUREFILE");
                } else if (((ColumnProxyOraclev11g)columnProxy).getLobStorageType().equalsIgnoreCase("BASICFILE")) {
                    AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "BASICFILE");
                }
                allowAnySchema = ((ColumnProxyOraclev11g)columnProxy).getAllowAnySchema();
                allowNonSchema = ((ColumnProxyOraclev11g)columnProxy).getAllowNonSchema();
                storeAsBinaryXml = columnProxy.getStoreAs().equalsIgnoreCase("BINARY XML");
            }
            if (storeAsBinaryXml) {
                AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "BINARY XML");
            } else {
                AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "CLOB");
            }
            String lobSegmentName = columnProxy.getLobSegmentName();
            if (lobSegmentName != null && lobSegmentName.length() > 0) {
                AbstractCSSBOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(lobSegmentName));
            }
            AbstractCSSBOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            AbstractCSSBOraclev10g.appendStringWithSpace(buffer, '(');
            AbstractCSSBOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            if (columnProxy.getTablespace() != null && this.storageDesign.getDesign().getSettings().isIncludeTablespaceInDDL()) {
                AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "TABLESPACE");
                AbstractCSSBOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columnProxy.getTablespace()));
                AbstractCSSBOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            }
            if (this.storageDesign.getDesign().getSettings().isIncludeStorageInDDL()) {
                AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "STORAGE");
                AbstractCSSBOraclev10g.appendStringWithSpace(buffer, '(');
                AbstractCSSBOraclev10g.appendNewLine(buffer, prettyPrint, 3);
                boolean props = false;
                if (columnProxy.getSCInitialExtent() > 0L && this.storageDesign.getDesign().getSettings().isIncludeInitialExtentInDDL()) {
                    AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "INITIAL");
                    AbstractCSSBOraclev10g.appendStringWithSpace(buffer, columnProxy.getSCInitialExtent());
                    AbstractCSSBOraclev10g.appendNewLine(buffer, prettyPrint, 3);
                    props = true;
                }
                if (columnProxy.getSCNextExtent() > 0L && this.storageDesign.getDesign().getSettings().isIncludeNextExtentInDDL()) {
                    AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "NEXT");
                    AbstractCSSBOraclev10g.appendStringWithSpace(buffer, columnProxy.getSCNextExtent());
                    AbstractCSSBOraclev10g.appendNewLine(buffer, prettyPrint, 3);
                    props = true;
                }
                if (this.storageDesign.getDesign().getSettings().isIncludePctIncreaseInDDL()) {
                    AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "PCTINCREASE");
                    AbstractCSSBOraclev10g.appendStringWithSpace(buffer, columnProxy.getSCPctIncrease());
                    AbstractCSSBOraclev10g.appendNewLine(buffer, prettyPrint, 3);
                    props = true;
                }
                if (this.storageDesign.getDesign().getSettings().isIncludeMinExtentsInDDL()) {
                    AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "MINEXTENTS");
                    AbstractCSSBOraclev10g.appendStringWithSpace(buffer, columnProxy.getSCMinExtents());
                    AbstractCSSBOraclev10g.appendNewLine(buffer, prettyPrint, 3);
                    props = true;
                }
                if (this.storageDesign.getDesign().getSettings().isIncludeMaxExtentsInDDL()) {
                    AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "MAXEXTENTS");
                    AbstractCSSBOraclev10g.appendStringWithSpace(buffer, columnProxy.getSCMaxExtents());
                    AbstractCSSBOraclev10g.appendNewLine(buffer, prettyPrint, 3);
                    props = true;
                }
                if (this.storageDesign.getDesign().getSettings().isIncludeFreeListsInDDL()) {
                    AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "FREELISTS");
                    AbstractCSSBOraclev10g.appendStringWithSpace(buffer, columnProxy.getSCFreeLists());
                    AbstractCSSBOraclev10g.appendNewLine(buffer, prettyPrint, 3);
                    props = true;
                }
                if (this.storageDesign.getDesign().getSettings().isIncludeFreeListGroupsInDDL() && columnProxy.getSCFreelistGroups() > 1) {
                    AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "FREELIST");
                    AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "GROUPS");
                    AbstractCSSBOraclev10g.appendStringWithSpace(buffer, columnProxy.getSCFreelistGroups());
                    AbstractCSSBOraclev10g.appendNewLine(buffer, prettyPrint, 3);
                    props = true;
                }
                if (this.storageDesign.getDesign().getSettings().isIncludeBufferPoolInDDL()) {
                    AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "BUFFER_POOL");
                    AbstractCSSBOraclev10g.appendStringWithSpace(buffer, columnProxy.getSCBufferPool());
                    AbstractCSSBOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                    props = true;
                }
                if (props) {
                    AbstractCSSBOraclev10g.appendStringWithSpace(buffer, ')');
                } else {
                    buffer = buffer.replace(buffer.lastIndexOf("STORAGE ("), buffer.length(), "");
                }
                AbstractCSSBOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            }
            if (columnProxy.getChunk() > 0) {
                AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "CHUNK");
                AbstractCSSBOraclev10g.appendStringWithSpace(buffer, columnProxy.getChunk());
                AbstractCSSBOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            }
            if (columnProxy.getOldVersions().equalsIgnoreCase("RETENTION")) {
                AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "RETENTION");
            } else {
                AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "PCTVERSION");
                AbstractCSSBOraclev10g.appendStringWithSpace(buffer, columnProxy.getPCTVersion());
            }
            if (columnProxy.getFreepools() > 0 && columnProxy.getSCFreelistGroups() <= 1) {
                AbstractCSSBOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "FREEPOOLS");
                AbstractCSSBOraclev10g.appendStringWithSpace(buffer, columnProxy.getFreepools());
            }
            AbstractCSSBOraclev10g.appendStorageInRow(buffer, columnProxy.getTableProxy(), columnProxy.getStorageInRow(), prettyPrint);
            AbstractCSSBOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            AbstractCSSBOraclev10g.appendStringWithSpace(buffer, columnProxy.getCache());
            if (this.storageDesign.getDesign().getSettings().isIncludeLoggingInDDL() && (!"CACHE".equalsIgnoreCase(columnProxy.getCache()) || this.storageDesign instanceof StorageDesignOraclev12c)) {
                String logging = columnProxy.getLogging();
                if (logging.equalsIgnoreCase("YES")) {
                    AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "LOGGING");
                } else if (logging.equalsIgnoreCase("NO")) {
                    AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "NOLOGGING");
                } else if (logging.equalsIgnoreCase("FILESYSTEM_LIKE_LOGGING") && AbstractCSSBOraclev10g.isSecureFile(((ColumnProxyOraclev11g)columnProxy).getLobStorageType(), this.storageDesign)) {
                    AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "FILESYSTEM_LIKE_LOGGING");
                }
            }
            AbstractCSSBOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            AbstractCSSBOraclev10g.appendStringWithSpace(buffer, ')');
        }
        this.appendXMLSchemaSpec(buffer, columnProxy.getXmlSchemaUrl(), columnProxy.getXmlSchemaElement(), storeAsBinaryXml, allowAnySchema, allowNonSchema, prettyPrint);
    }

    protected static boolean isSecureFile(String lobStorageType, StorageDesignOracle storageDesign) {
        if (storageDesign instanceof StorageDesignOraclev12c) {
            return !lobStorageType.equalsIgnoreCase("BASICFILE");
        }
        return lobStorageType.equalsIgnoreCase("SECUREFILE");
    }

    protected static void appendStorageInRow(StringBuffer buffer, TableProxyOracle tableProxy, String enableDisable, boolean prettyPrint) {
        if ("ENABLE".equalsIgnoreCase(enableDisable)) {
            if (!"INDEX".equals(tableProxy.getOrganization())) {
                AbstractCSSBOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "ENABLE");
                AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "STORAGE IN ROW");
            }
        } else {
            AbstractCSSBOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "DISABLE");
            AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "STORAGE IN ROW");
        }
    }

    protected void appendXMLSchemaSpec(StringBuffer buffer, String xmlSchemaUrl, String xmlSchemaElement, boolean storeAsBinaryXml, String allowAnySchema, String allowNonSchema, boolean prettyPrint) {
        if (xmlSchemaElement != null && xmlSchemaElement.length() > 0) {
            AbstractCSSBOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            if (xmlSchemaUrl != null && xmlSchemaUrl.length() > 0) {
                buffer.append("XMLSCHEMA").append(' ').append('\"').append(xmlSchemaUrl).append('\"');
                AbstractCSSBOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            }
            buffer.append("ELEMENT").append(' ').append('\"').append(xmlSchemaElement).append('\"').append(' ');
        }
        if (storeAsBinaryXml) {
            if (allowAnySchema.equals("YES")) {
                AbstractCSSBOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "ALLOW");
                AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "ANYSCHEMA");
            }
            if (allowNonSchema.equals("YES")) {
                AbstractCSSBOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "ALLOW");
                AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "NONSCHEMA");
            } else if (allowNonSchema.equals("NO")) {
                AbstractCSSBOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "DISALLOW");
                AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "NONSCHEMA");
            }
        }
    }

    protected void appendVarrayColumnProp(StringBuffer buffer, ColumnProxyOraclev10g columnProxy, boolean prettyPrint) {
        if (this.hasVarrayClause(columnProxy)) {
            AbstractCSSBOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "VARRAY");
            AbstractCSSBOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columnProxy));
            this.appendSubstitutableColumnClause(buffer, columnProxy, prettyPrint, false);
            if (!columnProxy.getLobSegname().equals("")) {
                AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "STORE AS");
                if (columnProxy instanceof ColumnProxyOraclev11g) {
                    if (((ColumnProxyOraclev11g)columnProxy).getLobStorageType().equalsIgnoreCase("SECUREFILE")) {
                        AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "SECUREFILE");
                    } else if (((ColumnProxyOraclev11g)columnProxy).getLobStorageType().equalsIgnoreCase("BASICFILE")) {
                        AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "BASICFILE");
                    }
                }
                AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "LOB");
                AbstractCSSBOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columnProxy.getLobSegname()));
            }
        }
    }

    protected void appendObjectTypeColProperties(StringBuffer buffer, Table table, TableProxyOraclev10g tableProxy, boolean prettyPrint) {
        if (table.isBST() && tableProxy != null) {
            boolean first = true;
            Column[] cols = (Column[])table.getElements();
            for (int i = 0; i < cols.length; ++i) {
                Column column = cols[i];
                ColumnProxyOraclev10g columnProxy = (ColumnProxyOraclev10g)tableProxy.getColumnProxy(column.getObjectID());
                if (!this.shouldGenerateObjectPropDefinition(column, columnProxy)) continue;
                if (first) {
                    AbstractCSSBOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    AbstractCSSBOraclev10g.appendStringWithSpace(buffer, '(');
                    first = false;
                } else {
                    this.appendComma(buffer);
                }
                AbstractCSSBOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                AbstractCSSBOraclev10g.appendString(buffer, ' ');
                AbstractCSSBOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columnProxy));
                this.appendColumnOptions(buffer, tableProxy, column, columnProxy, prettyPrint);
                this.appendInlineRefConstraint(buffer, column, columnProxy, prettyPrint);
                CSSBCreateTableOraclev10g.appendColumnConstraints(buffer, column, columnProxy, prettyPrint);
            }
            boolean nestedColNotNullChecksRequired = false;
            for (Column nestedColumn : table.getNestedElements()) {
                if (!nestedColumn.isMandatory()) continue;
                nestedColNotNullChecksRequired = true;
            }
            if (nestedColNotNullChecksRequired) {
                if (first) {
                    AbstractCSSBOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    AbstractCSSBOraclev10g.appendStringWithSpace(buffer, '(');
                }
                first = this.appendNestedColumnNotNullChecks(buffer, table, tableProxy, prettyPrint, first);
            }
            boolean TableChecksRequired = false;
            for (TableCheckConstraintOracle constraint : tableProxy.getTableCheckConstraints()) {
                if (!constraint.getTableConstraint().isGenerateInDDL()) continue;
                String rule = constraint.getTableConstraint().getRule();
                String cname = constraint.getName().toUpperCase();
                if (cname.startsWith("SYS_") || cname.startsWith("NULL SET GENERATED_")) {
                    cname = "";
                }
                if (!"".equals(cname) || "".equals(rule)) continue;
                TableChecksRequired = true;
            }
            if (TableChecksRequired) {
                if (first) {
                    AbstractCSSBOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    AbstractCSSBOraclev10g.appendStringWithSpace(buffer, '(');
                }
                first = this.appendTableConstraintsDefinition(buffer, tableProxy, prettyPrint, first);
            }
            if (table.getOidPKColumns().size() > 0) {
                if (first) {
                    AbstractCSSBOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    AbstractCSSBOraclev10g.appendStringWithSpace(buffer, '(');
                    first = false;
                } else {
                    this.appendComma(buffer);
                }
                this.appendPK_ObjectType(buffer, table, tableProxy, prettyPrint);
            }
            if (!first) {
                AbstractCSSBOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                AbstractCSSBOraclev10g.appendStringWithSpace(buffer, ')');
            }
        }
    }

    private boolean shouldGenerateObjectPropDefinition(Column column, ColumnProxyOraclev10g columnProxy) {
        if (column.isOid()) {
            return false;
        }
        if (!column.getNullsAllowed()) {
            return true;
        }
        String defaultValue = columnProxy.getDefaultValue();
        if (defaultValue != null && !"".equalsIgnoreCase(defaultValue)) {
            return true;
        }
        if (column.isAutoIncrementColumn() && columnProxy.getDDLTypeForAutoIncCol().equals("DEFAULT_CLAUSE")) {
            return true;
        }
        if (column.isReference() && "YES".equalsIgnoreCase(columnProxy.getWithRowId())) {
            return true;
        }
        if (!column.getAVTs().isEmpty()) {
            return true;
        }
        ConstraintEnumeration valueList = column.getValueList();
        if (valueList != null && !valueList.isEmpty()) {
            return true;
        }
        CheckConstraint check = column.getCheck();
        return check != null;
    }

    private void appendPK_ObjectType(StringBuffer buffer, Table table, TableProxyOracle tableProxy, boolean prettyPrint) {
        KeyObject pk = table.getPK();
        if (pk != null) {
            StorageDesignOracle storageDesign = (StorageDesignOracle)tableProxy.getStorageDesign();
            ModelIDObject keyObject = storageDesign.getPKProxySet().getProxy(pk.getObjectID());
            if (keyObject == null) {
                keyObject = pk;
            }
            AbstractCSSBOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            if (!keyObject.getName().startsWith("SYS_")) {
                AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "CONSTRAINT");
                AbstractCSSBOraclev10g.appendStringWithSpace(buffer, storageDesign.getFormatedName(keyObject));
            }
            AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "PRIMARY KEY");
            AbstractCSSBOraclev10g.appendStringWithSpace(buffer, '(');
            boolean first = true;
            for (Column column : table.getOidPKColumns()) {
                ColumnProxyOraclev10g columnProxy = (ColumnProxyOraclev10g)tableProxy.getColumnProxy(column.getObjectID());
                if (first) {
                    first = false;
                } else {
                    AbstractCSSBOraclev10g.appendStringWithSpace(buffer, ',');
                }
                AbstractCSSBOraclev10g.appendStringWithSpace(buffer, storageDesign.getFormatedName(columnProxy));
            }
            AbstractCSSBOraclev10g.appendStringWithSpace(buffer, ')');
        }
    }

    protected void appendDatatype(StringBuffer buffer, String datatype, ColumnProxyOraclev10g columnProxy, boolean prettyPrint) {
        AbstractCSSBOraclev10g.appendStringWithSpace(buffer, datatype);
        if (datatype.equalsIgnoreCase("unknown")) {
            AbstractCSSBOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "--  ERROR: Datatype UNKNOWN is not allowed");
            AbstractCSSBOraclev10g.appendNewLine(buffer, prettyPrint, 5);
            this.getStatus().incrementErrors();
        } else if (datatype.equals("VARCHAR2") || datatype.equals("NVARCHAR2") || datatype.equals("RAW")) {
            AbstractCSSBOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "--  ERROR: " + datatype + " size not specified");
            AbstractCSSBOraclev10g.appendNewLine(buffer, prettyPrint, 5);
            this.getStatus().incrementErrors();
        } else if (datatype.equals("CHAR") || datatype.equals("NCHAR")) {
            AbstractCSSBOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "--  WARNING: CHAR size not specified");
            AbstractCSSBOraclev10g.appendNewLine(buffer, prettyPrint, 5);
            this.getStatus().incrementWarnings();
        }
    }

    protected void appendInlineRefConstraint(StringBuffer buffer, Column column, ColumnProxyOraclev10g columnProxy, boolean prettyPrint) {
        this.appendWithRowid(buffer, column, columnProxy, prettyPrint);
    }

    private void appendWithRowid(StringBuffer buffer, Column column, ColumnProxyOraclev10g columnProxy, boolean prettyPrint) {
        if (column.isReference() && "YES".equalsIgnoreCase(columnProxy.getWithRowId())) {
            AbstractCSSBOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "WITH");
            AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "ROWID");
        }
    }

    protected void appendColumnOptions(StringBuffer buffer, TableProxyOraclev10g tableProxy, Column column, ColumnProxyOraclev10g columnProxy, boolean prettyPrint) {
        this.appendWithDefaultDefinition(buffer, columnProxy);
        if (!column.getNullsAllowed()) {
            this.appendNotNullDefinition(buffer, columnProxy, prettyPrint);
        } else if (this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL()) {
            AbstractCSSBOraclev10g.appendString(buffer, ' ');
            AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "NULL");
        }
    }

    protected void appendAutoIncrementSequence(StringBuffer buffer, Column column, boolean prettyPrint) {
        if (this.ssbAutoIncCol == null) {
            this.ssbAutoIncCol = new SSBAutoIncrementColumnOracle(this.storageDesign);
            this.ssbAutoIncCol.setDDLGenerator(this.getDDLGenerator());
        }
        this.ssbAutoIncCol.appendAutoIncrementSequenceAndTrigger(buffer, column, prettyPrint, false);
    }

    protected void appendInvisible(StringBuffer buffer, ColumnProxyOracle columnProxy) {
        if (columnProxy instanceof ColumnProxyOraclev12c && ((ColumnProxyOraclev12c)columnProxy).getInvisible().equalsIgnoreCase("YES")) {
            AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "INVISIBLE");
        }
    }

    protected void appendEncrypt(StringBuffer buffer, ColumnProxyOraclev11g columnProxy, boolean prettyPrint) {
        if (columnProxy.getEncrypt().equalsIgnoreCase("YES") && this.storageDesign.getDesign().getSettings().isIncludeStorageInDDL() && this.storageDesign.getDesign().getSettings().isIncludeEncryptionInDDL()) {
            String useSalt;
            String integrityAlgorithm;
            AbstractCSSBOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            AbstractCSSBOraclev10g.appendString(buffer, ' ');
            AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "ENCRYPT");
            String encryptionAlgorithm = columnProxy.getEncryptionAlgorithm();
            if (encryptionAlgorithm.length() > 0) {
                AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "USING");
                AbstractCSSBOraclev10g.appendStringWithSpace(buffer, '\'' + encryptionAlgorithm + '\'');
            }
            if ((integrityAlgorithm = columnProxy.getIntegrityAlgorithm()).length() > 0) {
                AbstractCSSBOraclev10g.appendStringWithSpace(buffer, '\'' + integrityAlgorithm + '\'');
            }
            if ((useSalt = columnProxy.getUseSalt()).equalsIgnoreCase("YES")) {
                AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "SALT");
            } else if (useSalt.equalsIgnoreCase("NO")) {
                AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "NO");
                AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "SALT");
            }
        }
    }

    protected void appendWithDefaultDefinition(StringBuffer buffer, ColumnProxyOraclev10g columnProxy) {
        String dt;
        Column column = columnProxy.getColumn();
        if (column.isIdentityColumn() && !column.getTable().isBST() && columnProxy.getDDLTypeForAutoIncCol().equalsIgnoreCase("IDENTITY_CLAUSE") && (dt = column.getDatatypeString(this.storageDesign.getRDBMSType().getName())).toUpperCase().indexOf("CHAR") == -1) {
            AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "GENERATED");
            if (column.isAutoIncrementGenerateAlways()) {
                AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "ALWAYS");
            } else {
                AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "BY");
                AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "DEFAULT");
                if (((ColumnProxyOraclev12c)columnProxy).getDefaultOnNull().equalsIgnoreCase("YES")) {
                    AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "ON");
                    AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "NULL");
                }
            }
            AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "AS");
            AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "IDENTITY");
            this.appendIdentityOptions(buffer, column);
            return;
        }
        String defaultValue = columnProxy.getDefaultValue();
        if (column.isAutoIncrementColumn() && columnProxy.getDDLTypeForAutoIncCol().equalsIgnoreCase("DEFAULT_CLAUSE")) {
            if (this.ssbAutoIncCol == null) {
                this.ssbAutoIncCol = new SSBAutoIncrementColumnOracle(this.storageDesign);
            }
            defaultValue = this.ssbAutoIncCol.generateSequenceName(null, column, false) + ".NEXTVAL";
        }
        if (defaultValue != null && !"".equalsIgnoreCase(defaultValue)) {
            AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "DEFAULT");
            if (columnProxy instanceof ColumnProxyOraclev12c && ((ColumnProxyOraclev12c)columnProxy).getDefaultOnNull().equalsIgnoreCase("YES")) {
                AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "ON");
                AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "NULL");
            }
            String dt2 = column.getDatatypeString(this.storageDesign.getRDBMSType().getName());
            String df = this.addQuotesToDefault(dt2, defaultValue);
            AbstractCSSBOraclev10g.appendStringWithSpace(buffer, df);
        }
    }

    protected void appendIdentityOptions(StringBuffer buffer, Column column) {
        Integer incrementBy;
        this.hasIdentityOptions = false;
        boolean includeDefaultSettings = this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL();
        if (!"".equals(column.getAutoIncrementStartWith())) {
            this.startIdentityOption(buffer);
            AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "START");
            AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "WITH");
            AbstractCSSBOraclev10g.appendStringWithSpace(buffer, column.getAutoIncrementStartWith());
        }
        if ((incrementBy = column.getAutoIncrementIncrementBy()) != null && (incrementBy < 0 || incrementBy > 1)) {
            this.startIdentityOption(buffer);
            AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "INCREMENT");
            AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "BY");
            this.appendStringWithSpace(buffer, incrementBy);
        } else if (includeDefaultSettings) {
            this.startIdentityOption(buffer);
            AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "INCREMENT");
            AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "BY");
            AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "1");
        }
        String maxValue = column.getAutoIncrementMaxValue();
        if (maxValue != null && !maxValue.equals("")) {
            this.startIdentityOption(buffer);
            AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "MAXVALUE");
            AbstractCSSBOraclev10g.appendStringWithSpace(buffer, maxValue);
        } else if (includeDefaultSettings) {
            this.startIdentityOption(buffer);
            AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "NOMAXVALUE");
        }
        String minValue = column.getAutoIncrementMinValue();
        if (minValue != null && !minValue.equals("")) {
            this.startIdentityOption(buffer);
            AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "MINVALUE");
            AbstractCSSBOraclev10g.appendStringWithSpace(buffer, minValue);
        } else if (includeDefaultSettings) {
            this.startIdentityOption(buffer);
            AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "NOMINVALUE");
        }
        if (column.isAutoIncrementCycle()) {
            this.startIdentityOption(buffer);
            AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "CYCLE");
        } else if (includeDefaultSettings) {
            this.startIdentityOption(buffer);
            AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "NOCYCLE");
        }
        Integer cacheInteger = column.getAutoIncrementCache();
        if (column.isAutoIncrementDisableCache()) {
            this.startIdentityOption(buffer);
            AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "NOCACHE");
        } else if (cacheInteger != null && cacheInteger > 0) {
            this.startIdentityOption(buffer);
            AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "CACHE");
            this.appendStringWithSpace(buffer, cacheInteger);
        } else if (includeDefaultSettings) {
            this.startIdentityOption(buffer);
            AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "CACHE");
            AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "20");
        }
        if (column.isAutoIncrementOrder()) {
            this.startIdentityOption(buffer);
            AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "ORDER");
        } else if (includeDefaultSettings) {
            this.startIdentityOption(buffer);
            AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "NOORDER");
        }
        if (this.hasIdentityOptions) {
            AbstractCSSBOraclev10g.appendStringWithSpace(buffer, ')');
        }
    }

    private void startIdentityOption(StringBuffer buffer) {
        if (!this.hasIdentityOptions) {
            buffer.append(NEWLINE).append("    ").append("    ");
            AbstractCSSBOraclev10g.appendStringWithSpace(buffer, '(');
            this.hasIdentityOptions = true;
        }
    }

    protected boolean appendTableConstraintsDefinition(StringBuffer buffer, TableProxyOracle tableProxy, boolean prettyPrint, boolean first) {
        if (tableProxy != null) {
            for (TableCheckConstraintOracle constraint : tableProxy.getTableCheckConstraints()) {
                TableLevelConstraint tlc = constraint.getTableConstraint();
                if (!tlc.shouldBeMerge() || !tlc.isGenerateInDDL()) continue;
                String rule = constraint.getTableConstraint().getRule();
                String cname = constraint.getName().toUpperCase();
                if (cname.startsWith("SYS_") || cname.startsWith("NULL SET GENERATED_")) {
                    cname = "";
                }
                if (!"".equals(cname) || "".equals(rule)) continue;
                if (first) {
                    first = false;
                } else {
                    this.appendComma(buffer);
                }
                AbstractCSSBOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                AbstractCSSBOraclev10g.appendString(buffer, ' ');
                AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "CHECK");
                AbstractCSSBOraclev10g.appendString(buffer, '(');
                AbstractCSSBOraclev10g.appendString(buffer, rule);
                AbstractCSSBOraclev10g.appendString(buffer, ')');
                this.appendTableConstraintState(buffer, constraint, prettyPrint);
            }
        }
        return first;
    }

    protected void appendTableConstraintState(StringBuffer buffer, TableCheckConstraintOracle constraint, boolean prettyPrint) {
        if (!"NO".equalsIgnoreCase(constraint.getDeferrable())) {
            AbstractCSSBOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "DEFERRABLE");
            if ("DEFERRED".equalsIgnoreCase(constraint.getInitially())) {
                AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "INITIALLY");
                AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "DEFERRED");
            } else if (this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL()) {
                AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "INITIALLY");
                AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "IMMEDIATE");
            }
        } else if (this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL()) {
            AbstractCSSBOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "NOT");
            AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "DEFERRABLE");
        }
        if (this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL()) {
            AbstractCSSBOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            if ("YES".equalsIgnoreCase(constraint.getEnable())) {
                AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "ENABLE");
            } else {
                AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "DISABLE");
            }
            if ("YES".equalsIgnoreCase(constraint.getValidate())) {
                AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "VALIDATE");
            } else {
                AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "NOVALIDATE");
            }
        } else {
            if ("NO".equalsIgnoreCase(constraint.getEnable())) {
                AbstractCSSBOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "DISABLE");
                if ("YES".equalsIgnoreCase(constraint.getValidate())) {
                    AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "VALIDATE");
                }
            }
            if ("NO".equalsIgnoreCase(constraint.getValidate())) {
                AbstractCSSBOraclev10g.appendNewLine(buffer, prettyPrint, 2);
                AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "NOVALIDATE");
            }
        }
        if (constraint.getExceptionsTable() != null) {
            AbstractCSSBOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "EXCEPTIONS");
            AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "INTO");
            AbstractCSSBOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(constraint.getExceptionsTable()));
        }
    }

    protected void appendNotNullDefinition(StringBuffer buffer, ColumnProxyOraclev10g columnProxy, boolean prettyPrint) {
        String nncName = null;
        if (!columnProxy.getDesign().getSettings().notNullShortFormGeneration()) {
            String string = nncName = columnProxy.isNotNullConstraintNameChanged() ? columnProxy.getNncName() : columnProxy.getColumn().getNotNullConstraintName();
            if (nncName != null && nncName.startsWith("SYS_")) {
                nncName = null;
            }
        }
        if (!"NO".equalsIgnoreCase(columnProxy.getNncDeferrable()) || !"YES".equalsIgnoreCase(columnProxy.getNncEnable()) || !"YES".equalsIgnoreCase(columnProxy.getNncValidate()) || nncName != null && !"".equals(nncName)) {
            AbstractCSSBOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            AbstractCSSBOraclev10g.appendString(buffer, ' ');
            if (nncName != null && !"".equals(nncName)) {
                nncName = this.storageDesign.getFormatedName(nncName);
                AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "CONSTRAINT");
                AbstractCSSBOraclev10g.appendStringWithSpace(buffer, nncName);
            }
            AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "NOT NULL");
            this.appendNotNullConstraintState(buffer, columnProxy);
        } else {
            AbstractCSSBOraclev10g.appendString(buffer, ' ');
            AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "NOT NULL");
        }
    }

    protected boolean appendNestedColumnNotNullChecks(StringBuffer buffer, Table table, TableProxyOraclev10g tableProxy, boolean prettyPrint, boolean first) {
        for (Column nestedColumn : table.getNestedElements()) {
            String nncName;
            ColumnProxyOraclev10g columnProxy;
            if (!nestedColumn.isMandatory() || (columnProxy = (ColumnProxyOraclev10g)tableProxy.getColumnProxy(nestedColumn.getObjectID())) == null) continue;
            if (first) {
                first = false;
            } else {
                this.appendComma(buffer);
            }
            AbstractCSSBOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            AbstractCSSBOraclev10g.appendString(buffer, ' ');
            String string = nncName = columnProxy.isNotNullConstraintNameChanged() ? columnProxy.getNncName() : nestedColumn.getNotNullConstraintName();
            if (nncName != null && !nncName.isEmpty() && !nncName.startsWith("SYS_")) {
                AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "CONSTRAINT");
                AbstractCSSBOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(nncName));
            }
            AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "CHECK");
            AbstractCSSBOraclev10g.appendStringWithSpace(buffer, '(');
            AbstractCSSBOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columnProxy));
            AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "IS");
            AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "NOT NULL");
            AbstractCSSBOraclev10g.appendStringWithSpace(buffer, ')');
            this.appendNotNullConstraintState(buffer, columnProxy);
        }
        return first;
    }

    private void appendNotNullConstraintState(StringBuffer buffer, ColumnProxyOracle columnProxy) {
        if (!"NO".equalsIgnoreCase(columnProxy.getNncDeferrable())) {
            AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "DEFERRABLE");
            if ("DEFERRED".equalsIgnoreCase(columnProxy.getNncInitially())) {
                AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "INITIALLY");
                AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "DEFERRED");
            } else if (this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL()) {
                AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "INITIALLY");
                AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "IMMEDIATE");
            }
        } else if (this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL()) {
            AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "NOT");
            AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "DEFERRABLE");
        }
        if (this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL()) {
            if ("YES".equalsIgnoreCase(columnProxy.getNncEnable())) {
                AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "ENABLE");
            } else {
                AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "DISABLE");
            }
            if ("YES".equalsIgnoreCase(columnProxy.getNncValidate())) {
                AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "VALIDATE");
            } else {
                AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "NOVALIDATE");
            }
        } else {
            if (!"YES".equalsIgnoreCase(columnProxy.getNncEnable())) {
                AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "DISABLE");
                if ("YES".equalsIgnoreCase(columnProxy.getNncValidate())) {
                    AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "VALIDATE");
                }
            }
            if (!"YES".equalsIgnoreCase(columnProxy.getNncValidate())) {
                AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "NOVALIDATE");
            }
        }
    }

    protected void appendNestedTableColumnProp(StringBuffer buffer, ColumnProxyOraclev10g columnProxy, boolean prettyPrint) {
        AbstractCSSBOraclev10g.appendNewLine(buffer, prettyPrint, 1);
        AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "NESTED");
        AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "TABLE");
        AbstractCSSBOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columnProxy));
        this.appendSubstitutableColumnClause(buffer, columnProxy, prettyPrint, false);
        String storageTableName = columnProxy.getNtStorageTable();
        if (storageTableName.trim().isEmpty()) {
            AbstractCSSBOraclev10g.appendNewLine(buffer, prettyPrint, 0);
            AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "--  WARNING: Using column name as default storage_table name for nested column " + columnProxy.getName());
            this.getStatus().incrementWarnings();
            storageTableName = columnProxy.getName();
        }
        AbstractCSSBOraclev10g.appendNewLine(buffer, prettyPrint, 2);
        AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "STORE AS");
        AbstractCSSBOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(storageTableName));
        if (!columnProxy.getAdditionalNTS().equals("")) {
            AbstractCSSBOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            AbstractCSSBOraclev10g.appendStringWithSpace(buffer, '(');
            AbstractCSSBOraclev10g.appendStringWithSpace(buffer, columnProxy.getAdditionalNTS());
            AbstractCSSBOraclev10g.appendStringWithSpace(buffer, ')');
        }
        if (!columnProxy.getNtReturn().equals("")) {
            AbstractCSSBOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "RETURN");
            AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "AS");
            AbstractCSSBOraclev10g.appendStringWithSpace(buffer, columnProxy.getNtReturn());
        }
    }

    protected void appendSubstitutableColumnClause(StringBuffer buffer, ColumnProxyOraclev10g columnProxy, boolean prettyPrint, boolean columnClause) {
        Column column = columnProxy.getColumn();
        Table table = (Table)column.getContainerWithKeyObject();
        if (table.isBST() && !table.isSubstitutable()) {
            return;
        }
        if (!column.isReference()) {
            if (column.isAllowSubtypeSubstitution()) {
                if (columnClause && (column.isRestrictedTypeSubstitution() && column.getPermittedSubTypes().size() == 1 || columnProxy.getSubtitutable().equals("ONLY FOR TYPE"))) {
                    AbstractCSSBOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "COLUMN");
                    AbstractCSSBOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columnProxy));
                    AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "IS");
                    AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "OF");
                    AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "TYPE");
                    AbstractCSSBOraclev10g.appendStringWithSpace(buffer, '(');
                    AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "ONLY");
                    if (column.isRestrictedTypeSubstitution() && column.getPermittedSubTypes().size() == 1) {
                        StructuredType st = (StructuredType)column.getPermittedSubTypes().get(0);
                        StructuredTypeProxyOracle stp = (StructuredTypeProxyOracle)this.storageDesign.getStructuredTypeProxySet().getObjectGeneratedBy(st);
                        if (stp != null) {
                            AbstractCSSBOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(stp));
                        } else {
                            AbstractCSSBOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(st));
                        }
                    } else {
                        AbstractCSSBOraclev10g.appendStringWithSpace(buffer, columnProxy.getElementType());
                    }
                    AbstractCSSBOraclev10g.appendStringWithSpace(buffer, ')');
                } else if (columnProxy.getSubtitutable().equals("YES") || columnProxy.getSubtitutable().equals("NO")) {
                    if (columnClause) {
                        AbstractCSSBOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                        AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "COLUMN");
                        AbstractCSSBOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columnProxy));
                    }
                    if (columnProxy.getSubtitutable().equals("NO")) {
                        AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "NOT");
                    }
                    AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "SUBSTITUTABLE");
                    AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "AT");
                    AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "ALL");
                    AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "LEVELS");
                } else if (this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL()) {
                    if (columnClause) {
                        AbstractCSSBOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                        AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "COLUMN");
                        AbstractCSSBOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columnProxy));
                    }
                    AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "SUBSTITUTABLE");
                    AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "AT");
                    AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "ALL");
                    AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "LEVELS");
                }
            } else {
                if (columnClause) {
                    AbstractCSSBOraclev10g.appendNewLine(buffer, prettyPrint, 1);
                    AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "COLUMN");
                    AbstractCSSBOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columnProxy));
                }
                AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "NOT");
                AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "SUBSTITUTABLE");
                AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "AT");
                AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "ALL");
                AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "LEVELS");
            }
        }
    }

    private boolean hasVarrayClause(ColumnProxyOraclev10g columnProxy) {
        return !columnProxy.getSubtitutable().equals("") || !columnProxy.getLobSegname().equals("");
    }

    protected void appendRegisterSpatialTable(StringBuffer oldbuffer, Table table, SpatialColumnDefObject spObjects, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        String advancedComment = "";
        AbstractCSSBOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
        AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "INSERT");
        AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "INTO");
        AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "USER_SDO_GEOM_METADATA");
        advancedComment = buffer.toString();
        this.appendSpatialColumnDefinition(buffer, table, spObjects, prettyPrint);
        this.appendFunctionDefinition(buffer, table, spObjects, prettyPrint);
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        AbstractCSSBOraclev10g.appendNewLine(buffer, prettyPrint, 0);
        AbstractCSSBOraclev10g.appendLineFinisher(buffer, prettyPrint);
        AbstractCSSBOraclev10g.appendNewLine(buffer, prettyPrint, 0);
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
    }

    private void appendFunctionDefinition(StringBuffer buffer, Table table, SpatialColumnDefObject spObjects, boolean prettyPrint) {
        if (spObjects.isFunction()) {
            AbstractCSSBOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            AbstractCSSBOraclev10g.appendString(buffer, "VALUES");
            AbstractCSSBOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            AbstractCSSBOraclev10g.appendStringWithSpace(buffer, '(');
            AbstractCSSBOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            AbstractCSSBOraclev10g.appendString(buffer, '\'');
            AbstractCSSBOraclev10g.appendString(buffer, this.storageDesign.getFormatedName(table));
            AbstractCSSBOraclev10g.appendString(buffer, '\'');
            AbstractCSSBOraclev10g.appendString(buffer, ',');
            AbstractCSSBOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            AbstractCSSBOraclev10g.appendString(buffer, '\'');
            AbstractCSSBOraclev10g.appendString(buffer, spObjects.getFuncExpression());
            AbstractCSSBOraclev10g.appendString(buffer, '\'');
            AbstractCSSBOraclev10g.appendString(buffer, ',');
            AbstractCSSBOraclev10g.appendSpace(buffer);
            this.appendTableDimensional(buffer, spObjects, prettyPrint);
            AbstractCSSBOraclev10g.appendStringWithSpace(buffer, ',');
            AbstractCSSBOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            if (spObjects.getSystemID() == null || spObjects.getSystemID().trim().equals("")) {
                AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "NULL");
            } else {
                AbstractCSSBOraclev10g.appendStringWithSpace(buffer, spObjects.getSystemID());
            }
            AbstractCSSBOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            AbstractCSSBOraclev10g.appendString(buffer, ')');
        }
    }

    private void appendSpatialColumnDefinition(StringBuffer buffer, Table table, SpatialColumnDefObject spObjects, boolean prettyPrint) {
        if (spObjects.getSpatialColumn() != null) {
            AbstractCSSBOraclev10g.appendStringWithSpace(buffer, '(');
            AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "TABLE_NAME");
            AbstractCSSBOraclev10g.appendStringWithSpace(buffer, ',');
            AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "COLUMN_NAME");
            AbstractCSSBOraclev10g.appendStringWithSpace(buffer, ',');
            AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "DIMINFO");
            AbstractCSSBOraclev10g.appendStringWithSpace(buffer, ',');
            AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "SRID");
            AbstractCSSBOraclev10g.appendStringWithSpace(buffer, ')');
            AbstractCSSBOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "VALUES");
            AbstractCSSBOraclev10g.appendStringWithSpace(buffer, '(');
            AbstractCSSBOraclev10g.appendString(buffer, '\'');
            AbstractCSSBOraclev10g.appendString(buffer, this.storageDesign.getFormatedName(table));
            AbstractCSSBOraclev10g.appendString(buffer, '\'');
            AbstractCSSBOraclev10g.appendStringWithSpace(buffer, ',');
            AbstractCSSBOraclev10g.appendString(buffer, '\'');
            Datatype colType = spObjects.getSpatialColumn().getDataType();
            String columnName = this.storageDesign.getFormatedName(spObjects.getSpatialColumn());
            if (colType instanceof StructuredType) {
                if (this.sType == null) {
                    this.sType = table.getDesign().getDataTypesDesign().getStructuredTypeSet().getByName("SDO_GEOMETRY");
                }
                StructuredType st = (StructuredType)colType;
                for (TypeElement te : st.getAllElements()) {
                    if (te.getType() != this.sType) continue;
                    columnName = columnName.concat(".").concat(this.storageDesign.getFormatedName(te));
                    break;
                }
            }
            AbstractCSSBOraclev10g.appendString(buffer, columnName);
            AbstractCSSBOraclev10g.appendStringWithSpace(buffer, '\'');
            AbstractCSSBOraclev10g.appendStringWithSpace(buffer, ',');
            this.appendTableDimensional(buffer, spObjects, prettyPrint);
            AbstractCSSBOraclev10g.appendStringWithSpace(buffer, ',');
            AbstractCSSBOraclev10g.appendNewLine(buffer, prettyPrint, 2);
            if (spObjects.getSystemID() == null || spObjects.getSystemID().trim().equals("")) {
                AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "NULL");
            } else {
                AbstractCSSBOraclev10g.appendStringWithSpace(buffer, spObjects.getSystemID());
            }
            AbstractCSSBOraclev10g.appendNewLine(buffer, prettyPrint, 1);
            AbstractCSSBOraclev10g.appendStringWithSpace(buffer, ')');
        }
    }

    private void appendTableDimensional(StringBuffer buffer, SpatialColumnDefObject spObjects, boolean prettyPrint) {
        AbstractCSSBOraclev10g.appendNewLine(buffer, prettyPrint, 2);
        AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "MDSYS.SDO_DIM_ARRAY");
        AbstractCSSBOraclev10g.appendStringWithSpace(buffer, '(');
        Iterator it = spObjects.getTableDimensions().iterator();
        while (it.hasNext()) {
            SpatialColumnDefObject.TableDimension td = (SpatialColumnDefObject.TableDimension)it.next();
            AbstractCSSBOraclev10g.appendNewLine(buffer, prettyPrint, 3);
            AbstractCSSBOraclev10g.appendStringWithSpace(buffer, "MDSYS.SDO_DIM_ELEMENT");
            AbstractCSSBOraclev10g.appendString(buffer, '(');
            AbstractCSSBOraclev10g.appendString(buffer, '\'');
            AbstractCSSBOraclev10g.appendString(buffer, this.storageDesign.getFormatedName(td.getName()));
            AbstractCSSBOraclev10g.appendString(buffer, '\'');
            AbstractCSSBOraclev10g.appendString(buffer, ',');
            AbstractCSSBOraclev10g.appendString(buffer, td.getLowBoundary());
            AbstractCSSBOraclev10g.appendString(buffer, ',');
            AbstractCSSBOraclev10g.appendString(buffer, td.getUpperBoundary());
            AbstractCSSBOraclev10g.appendString(buffer, ',');
            AbstractCSSBOraclev10g.appendString(buffer, td.getTolerance());
            AbstractCSSBOraclev10g.appendString(buffer, ')');
            if (!it.hasNext()) continue;
            AbstractCSSBOraclev10g.appendString(buffer, ',');
        }
        AbstractCSSBOraclev10g.appendNewLine(buffer, prettyPrint, 2);
        AbstractCSSBOraclev10g.appendString(buffer, ')');
    }
}

