/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.ddl.oracle;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import oracle.dbtools.crest.exports.ddl.SQLStatementBuilder;
import oracle.dbtools.crest.exports.ddl.oracle.SSBAutoIncrementColumnOracle;
import oracle.dbtools.crest.exports.ddl.oracle.v9i.SSBCreateBitmapJoinIndexOraclev9i;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.compare.ColumnComparator;
import oracle.dbtools.crest.model.design.compare.CompareObjectSelection;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.TableComparator;
import oracle.dbtools.crest.model.design.compare.TableSelection;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.AbstractCSSBOraclev9i;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBArcConstraintOracle;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBIndex;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.CSSBTriggerOracle;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.v10g.CSSBCreateRenameTableOraclev10g;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraint;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.Datatype;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.SpatialColumnDefObject;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.oracle.AbstractStorageObjectOracle;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.HashPartitionSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.IndexProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LobStorageOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PartitionSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StructuredTypeProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableCheckConstraintOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ClusterOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ColumnProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.HashPartitionLobItemOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.HashPartitionLobItemSetOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.HashPartitionOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.IndexGlobalPartitionOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.IndexGlobalPartitionSetOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.IndexGlobalPartitionsListOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ListPartitionOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ListStorageTemplatePartitionOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.LobStorageOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.PKProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.PartitionListOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.PartitionOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.PermissionsOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.SegmentOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TableProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.UniqueOraclev9i;

public class CSSBCreateRenameTable
extends AbstractCSSBOraclev9i {
    private CSSBIndex cssbIndex = new CSSBIndex();
    private CSSBArcConstraintOracle cssbArcConstraintOracle = null;
    private TableProxyOraclev9i tableProxy = null;
    private boolean isRenamed = false;
    private TableSelection tableObj;
    private TableSelection targetObject;
    private SSBCreateBitmapJoinIndexOraclev9i ssbBJIndex = null;
    private SSBAutoIncrementColumnOracle ssbAutoIncCol = null;
    private CSSBTriggerOracle cssbTriggerOracle = null;
    private String directoryName;

    @Override
    public boolean canHandle(Object object) {
        return ((CompareObjectSelection)object).canBeCreate() && ((CompareObjectSelection)object).getObject() instanceof Table;
    }

    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        String advancedComment = "";
        Table table = null;
        this.tableObj = (TableSelection)object;
        if (object == null) {
            return;
        }
        if (!(this.tableObj.getObject() instanceof Table)) {
            return;
        }
        table = (Table)this.tableObj.getObject();
        Design design = table.getDesign();
        RDBMSSite site = table.getSelectedRDBMSSite();
        this.storageDesign = (StorageDesignOracle)design.getStorageDesign(site, table);
        this.tableProxy = (TableProxyOraclev9i)this.storageDesign.getTableProxySet().getProxy(table.getObjectID());
        this.targetObject = (TableSelection)this.tableObj.getCorrespondentNode();
        if (table.getTypeSubstitution() == null) {
            if (this.tableProxy != null && this.tableProxy.isCommentChanged()) {
                this.appendComment(oldbuffer, this.tableProxy);
            } else {
                this.appendComment(oldbuffer, table);
            }
            if (this.tableProxy != null && this.tableProxy.getName().length() > this.tableProxy.getMaxNameLength()) {
                CSSBCreateRenameTable.appendNewLine(oldbuffer, prettyPrint, 0);
                CSSBCreateRenameTable.appendStringWithSpace(oldbuffer, "--  ERROR: Table name length exceeds maximum allowed length(" + this.tableProxy.getMaxNameLength() + ")");
                CSSBCreateRenameTable.appendNewLine(oldbuffer, prettyPrint, 0);
                this.getStatus().incrementErrors();
            }
            this.appendBeforeCreateScript(oldbuffer, prettyPrint, table);
            List columnList = this.tableObj.getObjectsForRestore(0);
            CSSBCreateRenameTable.appendStringWithSpace(buffer, "CREATE");
            if (this.tableProxy == null) {
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "TABLE");
                CSSBCreateRenameTable.appendStringWithSpace(buffer, CSSBCreateRenameTable.getFormattedTableName(this.tableObj, this.storageDesign));
                advancedComment = buffer.toString();
                this.appendElementList(buffer, this.tableObj, prettyPrint, columnList);
                this.appendOid(buffer, table, null, prettyPrint);
            } else {
                if ("YES".equalsIgnoreCase(this.tableProxy.getTemporary())) {
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, "GLOBAL");
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, "TEMPORARY");
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, "TABLE");
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, CSSBCreateRenameTable.getFormattedTableName(this.tableObj, this.storageDesign));
                    advancedComment = buffer.toString();
                    this.appendElementList(buffer, this.tableObj, prettyPrint, columnList);
                    CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, "ON");
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, "COMMIT");
                    if ("YES".equalsIgnoreCase(this.tableProxy.getTempPreserveRows())) {
                        CSSBCreateRenameTable.appendStringWithSpace(buffer, "PRESERVE ROWS");
                    } else {
                        CSSBCreateRenameTable.appendStringWithSpace(buffer, "DELETE ROWS");
                    }
                    this.appendOid(buffer, table, null, prettyPrint);
                    if ("YES".equalsIgnoreCase(this.tableProxy.getCache())) {
                        CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
                        CSSBCreateRenameTable.appendStringWithSpace(buffer, "CACHE");
                    } else if (this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL()) {
                        CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
                        CSSBCreateRenameTable.appendStringWithSpace(buffer, "NOCACHE");
                    }
                } else {
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, "TABLE");
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, CSSBCreateRenameTable.getFormattedTableName(this.tableObj, this.storageDesign));
                    advancedComment = buffer.toString();
                    this.appendElementList(buffer, this.tableObj, prettyPrint, columnList);
                    this.appendOid(buffer, table, this.tableProxy, prettyPrint);
                    this.appendCluster(buffer, this.tableProxy, prettyPrint);
                    this.appendColumnProperties(buffer, table, this.tableProxy, prettyPrint);
                    this.appendPartitionList(buffer, this.tableProxy, prettyPrint);
                    if (this.tableProxy.getCluster() == null && !"INDEX".equals(this.tableProxy.getOrganization())) {
                        if ("YES".equalsIgnoreCase(this.tableProxy.getCache())) {
                            CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
                            CSSBCreateRenameTable.appendStringWithSpace(buffer, "CACHE");
                        } else if (this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL()) {
                            CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
                            CSSBCreateRenameTable.appendStringWithSpace(buffer, "NOCACHE");
                        }
                    }
                    if ("YES".equalsIgnoreCase(this.tableProxy.getMonitoring())) {
                        CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
                        CSSBCreateRenameTable.appendStringWithSpace(buffer, "MONITORING");
                    }
                    if ("YES".equalsIgnoreCase(this.tableProxy.getParallel())) {
                        CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
                        CSSBCreateRenameTable.appendStringWithSpace(buffer, "PARALLEL");
                        if (!"".equals(this.tableProxy.getDegree())) {
                            CSSBCreateRenameTable.appendStringWithSpace(buffer, this.tableProxy.getDegree());
                        }
                    } else if (this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL()) {
                        CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
                        CSSBCreateRenameTable.appendStringWithSpace(buffer, "NOPARALLEL");
                    }
                }
                this.appendRowDependency(buffer, this.tableProxy, prettyPrint);
            }
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 0);
            CSSBCreateRenameTable.appendLineFinisher(buffer, prettyPrint);
            CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 0);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            this.getStatus().incrementCreateTable();
            this.appendAfterCreateScript(oldbuffer, prettyPrint, table);
            this.appendColumnCheckConstraints(oldbuffer, prettyPrint);
            this.appendTableLevelCheckConstraints(oldbuffer, this.tableObj, prettyPrint);
            int arcsIndex = this.tableObj.getChildIndex(ModelIdObjectSelection.ARCS);
            if (arcsIndex > -1) {
                for (CompareObjectSelection arcSel : this.tableObj.getChildObjects(arcsIndex)) {
                    if (arcSel.canBeCreate() && !arcSel.isSelected() || arcSel.canBeDrop() && arcSel.isSelected()) continue;
                    if (this.cssbArcConstraintOracle == null) {
                        this.cssbArcConstraintOracle = new CSSBArcConstraintOracle();
                    }
                    this.cssbArcConstraintOracle.appendArcConstraint(oldbuffer, arcSel, prettyPrint);
                }
            }
            if (table.getDesign().getDesign().getSettings().isGenerateCommentsInRDBMS()) {
                this.appendTableCommentOn(oldbuffer, this.tableObj, this.tableProxy, this.storageDesign, prettyPrint);
            }
            if (this.tableProxy != null) {
                this.appendAutoIncTriggers(oldbuffer, this.tableProxy, prettyPrint);
            }
            if (this.targetObject.getScriptExecuteOption().equals(TableSelection.STOP_AFTER_RECREATE)) {
                this.appendScriptExecution(oldbuffer, this.storageDesign.getFormatedName(this.targetObject.getName()));
            }
            if (this.isRenamed() && !TableSelection.NONE.equals(this.targetObject.getBackupOption()) && !TableSelection.NONE.equals(this.targetObject.getRestoreOption())) {
                String ext_name;
                if (TableSelection.BACKUP_RENAME.equals(this.targetObject.getBackupOption())) {
                    this.insertIntoTable(oldbuffer, this.tableProxy, this.tableObj, "", prettyPrint);
                } else if (TableSelection.BACKUP_UNLOAD.equals(this.targetObject.getBackupOption())) {
                    ext_name = "EXT_" + this.tableProxy.getName();
                    if (ext_name.length() > 30) {
                        ext_name = ext_name.substring(0, 30);
                    }
                    ext_name = this.storageDesign.getFormatedName(ext_name);
                    this.createExtDirectory(oldbuffer, this.tableObj, prettyPrint);
                    this.createExtTable(oldbuffer, ext_name, this.tableObj, this.targetObject.getName(), prettyPrint);
                    this.insertIntoTable(oldbuffer, this.tableProxy, this.tableObj, ext_name, prettyPrint);
                    this.dropExtTable(oldbuffer, ext_name, prettyPrint);
                    this.dropExtDir(oldbuffer, prettyPrint);
                } else if (TableSelection.BACKUP_UNLOAD_PARTITION.equals(this.targetObject.getBackupOption())) {
                    ext_name = "EXT_" + this.tableProxy.getName();
                    if (ext_name.length() > 30) {
                        ext_name = ext_name.substring(0, 30);
                    }
                    ext_name = this.storageDesign.getFormatedName(ext_name);
                    this.createExtDirectory(oldbuffer, this.tableObj, prettyPrint);
                    TableComparator comp = (TableComparator)this.targetObject.getPropertiesComparator();
                    TableProxyOracle targetProxy = (TableProxyOracle)comp.getTargetTableProxy();
                    for (PartitionOracle partition : targetProxy.getPartitions()) {
                        String fileName = this.storageDesign.getFormatedName(this.targetObject.getName() + "_" + partition.getName());
                        this.createExtTable(oldbuffer, ext_name, this.tableObj, fileName, prettyPrint);
                        this.insertIntoTable(oldbuffer, this.tableProxy, this.tableObj, ext_name, prettyPrint);
                        this.dropExtTable(oldbuffer, ext_name, prettyPrint);
                    }
                    this.dropExtDir(oldbuffer, prettyPrint);
                }
            }
            if (this.tableProxy != null) {
                this.appendIndexes(oldbuffer, this.tableProxy, this.tableObj, prettyPrint);
                this.appendBitmapJoinIndexes(oldbuffer, this.tableProxy, prettyPrint);
                this.appendTriggers(oldbuffer, prettyPrint);
                this.appendPermissions(oldbuffer, this.tableProxy, prettyPrint);
            }
            CSSBCreateRenameTable.appendNewLine(oldbuffer, prettyPrint, 0);
            CSSBCreateRenameTable.appendNewLine(oldbuffer, prettyPrint, 0);
            if (table.isSpatialTable()) {
                for (SpatialColumnDefObject spObjects : table.getSpatialDefinitions()) {
                    if (spObjects.getSpatialColumn() == null && !spObjects.isFunction()) continue;
                    this.appendRegisterSpatialTable(buffer, table, spObjects, prettyPrint);
                }
            }
        } else {
            CSSBCreateRenameTable.appendStringWithSpace(oldbuffer, "-- table " + table.getName() + ": is a part of type substitution hierarchy");
            CSSBCreateRenameTable.appendNewLine(oldbuffer, prettyPrint, 0);
        }
        this.tableProxy = null;
    }

    private void insertIntoTable(StringBuffer oldbuffer, TableProxyOraclev9i tableProxy, CompareObjectSelection object, String extTable, boolean prettyPrint) {
        TableComparator tableComp = (TableComparator)object.getPropertiesComparator();
        TableProxyOracle targetTableProxy = (TableProxyOracle)tableComp.getTargetTableProxy();
        StringBuffer buffer = new StringBuffer();
        String advancedComment = "";
        CSSBCreateRenameTable.appendNewLine(oldbuffer, prettyPrint, 0);
        CSSBCreateRenameTable.appendStringWithSpace(buffer, "INSERT");
        CSSBCreateRenameTable.appendStringWithSpace(buffer, "INTO");
        CSSBCreateRenameTable.appendStringWithSpace(buffer, CSSBCreateRenameTable.getFormattedTableName(this.tableObj, this.storageDesign));
        advancedComment = buffer.toString();
        CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
        CSSBCreateRenameTable.appendString(buffer, '(');
        ArrayList<CompareObjectSelection> appendedColumn = new ArrayList<CompareObjectSelection>();
        boolean first = true;
        CompareObjectSelection columns = (CompareObjectSelection)object.getChild(0);
        if (!columns.isLeaf()) {
            for (int i = 0; i < columns.getNumberOfChildren(); ++i) {
                CompareObjectSelection column = (CompareObjectSelection)columns.getChild(i);
                if (column.canBeCreate() || column.canBeDrop() && column.isSelected()) continue;
                if (first) {
                    first = false;
                } else {
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, ',');
                }
                CSSBCreateRenameTable.appendStringWithSpace(buffer, this.getFormattedColumnName(column));
                appendedColumn.add(column);
            }
        }
        CSSBCreateRenameTable.appendString(buffer, ')');
        CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 0);
        CSSBCreateRenameTable.appendStringWithSpace(buffer, "SELECT");
        if (this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL()) {
            CSSBCreateRenameTable.appendStringWithSpace(buffer, "ALL");
        }
        CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
        first = true;
        for (CompareObjectSelection columnNode : appendedColumn) {
            ColumnComparator comp;
            ModelIDObject columnOrProxy;
            String dataTypeConversion = columnNode.getDataTypeConversion();
            if ("".equals(dataTypeConversion) && columnNode.getCorrespondentNode() != null) {
                dataTypeConversion = columnNode.getCorrespondentNode().getDataTypeConversion();
            }
            if ((columnOrProxy = (comp = (ColumnComparator)columnNode.getPropertiesComparator()).getTargetColumnProxy()) == null) {
                columnOrProxy = comp.getTargetColumn();
            }
            String columnName = ((ModelObject)columnOrProxy).getName();
            if (this.isNotEmpty(dataTypeConversion) && Token.hasString(dataTypeConversion.toUpperCase(), columnName.toUpperCase())) {
                columnName = dataTypeConversion;
            } else {
                String ndata_type;
                columnName = this.storageDesign.getFormatedName(columnOrProxy);
                if (!TableSelection.BACKUP_RENAME.equals(this.targetObject.getBackupOption()) && (ndata_type = columnNode.getChoosedPropertyValue(PropertiesComparator.DATA_TYPE)).equalsIgnoreCase("BFILE")) {
                    columnName = "nvl2(" + columnName + ", bfilename(substr(" + columnName + ", 1, instr(" + columnName + ", ',') -1), substr(" + columnName + ", instr(" + columnName + ", ',') +2)), '')";
                }
            }
            if (first) {
                first = false;
            } else {
                CSSBCreateRenameTable.appendStringWithSpace(buffer, ',');
            }
            CSSBCreateRenameTable.appendStringWithSpace(buffer, columnName);
        }
        CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 0);
        CSSBCreateRenameTable.appendStringWithSpace(buffer, "FROM");
        CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
        if ("".equals(extTable)) {
            ModelIDObject user;
            String name = "bcp_" + targetTableProxy.getName();
            if (name.length() > 30) {
                name = name.substring(0, 30);
            }
            if (this.storageDesign.getDesign().getSettings().isIncludeSchemaInDDL() && (user = targetTableProxy.getSchemaImplementingObject()) != null) {
                CSSBCreateRenameTable.appendString(buffer, this.storageDesign.getFormatedName(user) + '.');
            }
            CSSBCreateRenameTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(name));
        } else {
            CSSBCreateRenameTable.appendStringWithSpace(buffer, extTable);
        }
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 0);
        CSSBCreateRenameTable.appendLineFinisher(buffer, prettyPrint);
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
    }

    private void appendColumnProperties(StringBuffer buffer, Table table, TableProxyOraclev9i tableProxy, boolean prettyPrint) {
        Column[] cols = (Column[])table.getElements();
        for (int i = 0; i < cols.length; ++i) {
            Column column = cols[i];
            ColumnProxyOraclev9i columnProxy = (ColumnProxyOraclev9i)tableProxy.getColumnProxy(column.getObjectID());
            Datatype datatype = columnProxy.getDataType();
            if (datatype.toString().equals("XMLTYPE")) {
                this.appendXMLTypeColumnProps(buffer, columnProxy, prettyPrint);
                continue;
            }
            if (datatype instanceof CollectionType) {
                CollectionType cdatatype = (CollectionType)datatype;
                if (cdatatype.isArrayType()) {
                    this.appendVarrayColumnProp(buffer, columnProxy, prettyPrint);
                    continue;
                }
                this.appendNestedTableColumnProp(buffer, columnProxy, prettyPrint);
                continue;
            }
            if (!(datatype instanceof StructuredType)) continue;
            this.appendSubstitutableColumnClause(buffer, columnProxy, prettyPrint, true);
        }
    }

    private void appendOid(StringBuffer buffer, Table table, TableProxyOracle tableProxy, boolean prettyPrint) {
        if (table.isRoot()) {
            if (table.isOidIsPK() && table.getOidPKColumns().size() > 0) {
                CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "OBJECT");
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "IDENTIFIER");
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "IS");
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "PRIMARY KEY");
            }
            if (!(tableProxy == null || tableProxy.getOidIndexSegment() == null && "".equalsIgnoreCase(tableProxy.getOidIndexName()))) {
                CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "OIDINDEX");
                if (!"".equalsIgnoreCase(tableProxy.getOidIndexName())) {
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tableProxy.getOidIndexName()));
                }
                if (tableProxy.getOidIndexSegment() != null) {
                    CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, '(');
                    this.appendSegment(buffer, (SegmentOraclev9i)tableProxy.getOidIndexSegment(), false, prettyPrint, null, "");
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, ')');
                }
            }
        }
    }

    private void appendElementList(StringBuffer buffer, CompareObjectSelection object, boolean prettyPrint, List restoreColumns) {
        TableComparator tableComp = (TableComparator)object.getPropertiesComparator();
        Table sourceTable = tableComp.getSourceTable();
        TableProxyOraclev9i sourceProxy = (TableProxyOraclev9i)tableComp.getSourceTableProxy();
        TableProxyOraclev9i targetProxy = (TableProxyOraclev9i)tableComp.getTargetTableProxy();
        List columns = object.getChildObjects(0);
        Column column = null;
        ColumnProxyOraclev9i columnProxy = null;
        CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
        if (sourceTable.getBasedOnStructuredType() != null) {
            StructuredTypeProxyOracle typeProxy;
            StructuredType type;
            ModelIDObject typeOrProxy = type = sourceTable.getBasedOnStructuredType();
            CSSBCreateRenameTable.appendStringWithSpace(buffer, "OF");
            if (sourceProxy != null && (typeProxy = (StructuredTypeProxyOracle)sourceProxy.getStorageDesign().getProxy(type)) != null) {
                if (typeProxy.getOwner() != null && this.storageDesign.getDesign().getSettings().isIncludeSchemaInDDL()) {
                    CSSBCreateRenameTable.appendString(buffer, this.storageDesign.getFormatedName(typeProxy.getOwner()));
                    CSSBCreateRenameTable.appendString(buffer, '.');
                }
                typeOrProxy = typeProxy;
            }
            CSSBCreateRenameTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(typeOrProxy));
            String typeName = ((ModelObject)typeOrProxy).getName();
            if (typeName.equalsIgnoreCase("XMLTYPE")) {
                this.appendObjectTypeColProperties(buffer, sourceTable, sourceProxy, prettyPrint);
                if (sourceProxy != null) {
                    CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, "XMLTYPE");
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, "STORE AS");
                    if (sourceProxy.getStoreAs().equalsIgnoreCase("OBJECT RELATIONAL")) {
                        CSSBCreateRenameTable.appendStringWithSpace(buffer, "OBJECT RELATIONAL");
                    } else {
                        CSSBCreateRenameTable.appendStringWithSpace(buffer, "CLOB");
                        String lobSegmentName = sourceProxy.getLobSegmentName();
                        if (lobSegmentName != null && lobSegmentName.length() > 0) {
                            CSSBCreateRenameTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(lobSegmentName));
                        }
                        CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
                        CSSBCreateRenameTable.appendStringWithSpace(buffer, '(');
                        CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 2);
                        if (sourceProxy.getXmlTypeTableSpace() != null && this.storageDesign.getDesign().getSettings().isIncludeTablespaceInDDL()) {
                            CSSBCreateRenameTable.appendStringWithSpace(buffer, "TABLESPACE");
                            CSSBCreateRenameTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(sourceProxy.getXmlTypeTableSpace()));
                            CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 2);
                        }
                        if (sourceProxy.getChunk() > 0) {
                            CSSBCreateRenameTable.appendStringWithSpace(buffer, "CHUNK");
                            CSSBCreateRenameTable.appendStringWithSpace(buffer, sourceProxy.getChunk());
                            CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 2);
                        }
                        if (sourceProxy.getOldVersions().equalsIgnoreCase("RETENTION")) {
                            CSSBCreateRenameTable.appendStringWithSpace(buffer, "RETENTION");
                        } else {
                            CSSBCreateRenameTable.appendStringWithSpace(buffer, "PCTVERSION");
                            CSSBCreateRenameTable.appendStringWithSpace(buffer, sourceProxy.getPCTVersion());
                        }
                        if (sourceProxy.getFreepools() > 0) {
                            CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 2);
                            CSSBCreateRenameTable.appendStringWithSpace(buffer, "FREEPOOLS");
                            CSSBCreateRenameTable.appendStringWithSpace(buffer, sourceProxy.getFreepools());
                        } else if (this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL()) {
                            CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 2);
                            CSSBCreateRenameTable.appendStringWithSpace(buffer, "FREEPOOLS");
                            CSSBCreateRenameTable.appendStringWithSpace(buffer, "1");
                        }
                        this.appendStorageInRow(buffer, sourceProxy, sourceProxy.getStorageInRow(), prettyPrint);
                        CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 2);
                        CSSBCreateRenameTable.appendStringWithSpace(buffer, sourceProxy.getXmlTypeCache());
                        if (!"CACHE".equalsIgnoreCase(sourceProxy.getXmlTypeCache()) && this.storageDesign.getDesign().getSettings().isIncludeLoggingInDDL()) {
                            if ("YES".equalsIgnoreCase(sourceProxy.getXmlTypeLogging())) {
                                CSSBCreateRenameTable.appendStringWithSpace(buffer, "LOGGING");
                            } else if ("NO".equalsIgnoreCase(sourceProxy.getXmlTypeLogging())) {
                                CSSBCreateRenameTable.appendStringWithSpace(buffer, "NOLOGGING");
                            }
                        }
                        CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
                        CSSBCreateRenameTable.appendStringWithSpace(buffer, ')');
                    }
                    this.appendXMLSchemaSpec(buffer, sourceProxy.getXmlSchemaUrl(), sourceProxy.getXmlSchemaElement(), prettyPrint);
                }
            } else {
                if (!sourceTable.isSubstitutable()) {
                    CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, "NOT");
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, "SUBSTITUTABLE");
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, "AT");
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, "ALL");
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, "LEVELS");
                } else if (this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL()) {
                    CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, "SUBSTITUTABLE");
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, "AT");
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, "ALL");
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, "LEVELS");
                }
                this.appendObjectTypeColProperties(buffer, sourceTable, sourceProxy, prettyPrint);
            }
        } else if (columns.size() <= 0) {
            CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateRenameTable.appendStringWithSpace(buffer, "-- No Columns");
            CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
        } else {
            boolean first = true;
            boolean merge = true;
            Iterator it = columns.iterator();
            while (it.hasNext()) {
                boolean targetSelected = false;
                CompareObjectSelection obj = (CompareObjectSelection)it.next();
                columnProxy = null;
                column = (Column)obj.getObject();
                merge = obj.isSelected();
                if (column == null || !merge) {
                    column = (Column)obj.getCorrespondentNode().getObject();
                    if (column == null) continue;
                    targetSelected = true;
                    columnProxy = (ColumnProxyOraclev9i)targetProxy.getColumnProxy(column.getObjectID());
                } else {
                    columnProxy = (ColumnProxyOraclev9i)sourceProxy.getColumnProxy(column.getObjectID());
                }
                if (!merge && !this.isRenamed() || column.isOid() || obj.canBeCreate() && !obj.isSelected() || obj.canBeDrop() && obj.isSelected()) continue;
                if (first) {
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, '(');
                    first = false;
                } else {
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, ',');
                }
                CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
                String formattedColName = targetSelected ? this.storageDesign.getFormatedName(columnProxy) : CSSBCreateRenameTable.getFormattedSelectedName(obj, this.storageDesign);
                int colNameLength = formattedColName.length();
                if (formattedColName.startsWith("\"")) {
                    colNameLength -= 2;
                }
                if (colNameLength > columnProxy.getMaxNameLength()) {
                    CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 0);
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, "--  ERROR: Column name length exceeds maximum allowed length(" + columnProxy.getMaxNameLength() + ")");
                    CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 0);
                    this.getStatus().incrementErrors();
                }
                if (columnProxy.isCommentChanged() && !"".equalsIgnoreCase(columnProxy.getComment())) {
                    this.appendComment(buffer, columnProxy);
                } else if (!"".equalsIgnoreCase(columnProxy.getObject().getComment())) {
                    this.appendComment(buffer, columnProxy.getObject());
                }
                CSSBCreateRenameTable.appendString(buffer, ' ');
                CSSBCreateRenameTable.appendStringWithSpace(buffer, formattedColName);
                if (column.getContainer().getBasedOnStructuredType() == null) {
                    String d_type = targetSelected && columnProxy != null ? column.getDatatypeString(columnProxy.getStorageDesign().getRDBMSType().getName()) : obj.getChoosedPropertyValue(PropertiesComparator.DATA_TYPE);
                    if ((d_type.equals("CHAR") || d_type.equals("NCHAR")) && this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL()) {
                        d_type = d_type + " (1)";
                    } else if (d_type.equals("UROWID") && this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL()) {
                        d_type = d_type + " (4000)";
                    }
                    buffer.append(d_type).append(' ');
                }
                if (sourceProxy == null && targetProxy == null) continue;
                this.appendColumnOptions(buffer, column, columnProxy, prettyPrint, obj, merge);
                this.appendInlineRefConstraint(buffer, column, columnProxy, prettyPrint);
                if (!this.storageDesign.getDesign().getSettings().isGenerateInlineColumnCC()) continue;
                CSSBCreateRenameTableOraclev10g.appendColumnConstraints(buffer, column, columnProxy, prettyPrint, obj);
            }
            this.appendSupplementalLoggings(buffer, sourceProxy, prettyPrint);
            CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateRenameTable.appendStringWithSpace(buffer, ')');
        }
    }

    private boolean hasNoMergeColumns(ContainedObject[] objects) {
        if (this.isRenamed()) {
            return false;
        }
        int count = 0;
        for (int i = 0; i < objects.length; ++i) {
            Column col = (Column)objects[i];
            if (col.shouldBeMerge()) continue;
            ++count;
        }
        return objects.length == count;
    }

    private void appendColumnOptions(StringBuffer buffer, Column column, ColumnProxyOraclev9i columnProxy, boolean prettyPrint, CompareObjectSelection obj, boolean merge) {
        this.appendWithDefaultDefinition(buffer, columnProxy, obj, merge);
        String mandatory = obj.getChoosedPropertyValue(PropertiesComparator.MANDATORY);
        boolean nn = Boolean.valueOf(mandatory);
        if (nn) {
            ColumnComparator comp = (ColumnComparator)obj.getPropertiesComparator();
            ColumnProxy targetColumnProxy = comp.getTargetColumnProxy();
            if (!column.getNullsAllowed()) {
                this.appendNotNullDefinition(buffer, columnProxy, prettyPrint);
            } else if (targetColumnProxy != null) {
                this.appendNotNullDefinition(buffer, (ColumnProxyOraclev9i)targetColumnProxy, prettyPrint);
            } else if (this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL()) {
                CSSBCreateRenameTable.appendString(buffer, ' ');
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "NULL");
            }
        }
    }

    private void appendWithDefaultDefinition(StringBuffer buffer, ColumnProxyOraclev9i columnProxy, CompareObjectSelection object, boolean merge) {
        String defaultValue = merge ? object.getChoosedPropertyValue(PropertiesComparator.DEFAULT_VALUE) : columnProxy.getDefaultValue();
        if (defaultValue != null && !"".equalsIgnoreCase(defaultValue)) {
            CSSBCreateRenameTable.appendStringWithSpace(buffer, "DEFAULT");
            String dt = object.getChoosedPropertyValue(PropertiesComparator.DATA_TYPE);
            String df = this.addQuotesToDefault(dt, defaultValue);
            CSSBCreateRenameTable.appendStringWithSpace(buffer, df);
        }
    }

    private PKProxyOraclev9i getPKProxy(TableProxyOraclev9i tableProxy) {
        KeyObject pk = ((Table)tableProxy.getObject()).getPK();
        if (pk != null) {
            return (PKProxyOraclev9i)((StorageDesignOraclev9i)tableProxy.getStorageDesign()).getPKProxySet().getProxy(pk.getObjectID());
        }
        return null;
    }

    private void appendIndexes(StringBuffer oldbuffer, CompareObjectSelection table, boolean prettyPrint) {
        List chIndexes = table.getChildObjects(1);
        for (CompareObjectSelection index : chIndexes) {
            StringBuffer columnList;
            Index theIndex;
            if (index.canBeCreate() && !index.isSelected()) continue;
            if (index.isModified() && !index.isSelected()) {
                theIndex = (Index)index.getCorrespondentNode().getObject();
                if (theIndex == null) continue;
                columnList = this.getColumnsForRestore(table.getCorrespondentNode(), theIndex, prettyPrint, true);
                this.cssbIndex.setRenamed(this.isRenamed());
                this.cssbIndex.setRestoredColumns(columnList);
                this.cssbIndex.setRestoredExpression(theIndex.getIndexExpression());
                this.cssbIndex.setTableName(CSSBCreateRenameTable.getFormattedTableName(this.tableObj, this.storageDesign));
                this.cssbIndex.doAppend(oldbuffer, theIndex, prettyPrint);
                continue;
            }
            theIndex = (Index)index.getObject();
            if (theIndex == null) continue;
            columnList = this.getColumnsForRestore(table, theIndex, prettyPrint, true);
            this.cssbIndex.setRenamed(this.isRenamed());
            this.cssbIndex.setRestoredColumns(columnList);
            this.cssbIndex.setRestoredExpression(index.getChoosedPropertyValue(PropertiesComparator.INDEX_FUNCTION_EXPRESSION));
            this.cssbIndex.setTableName(CSSBCreateRenameTable.getFormattedTableName(this.tableObj, this.storageDesign));
            this.cssbIndex.doAppend(oldbuffer, theIndex, prettyPrint);
        }
    }

    private void appendPKAndUK(StringBuffer oldbuffer, CompareObjectSelection table, boolean prettyPrint) {
        TableComparator comp = (TableComparator)table.getPropertiesComparator();
        TableProxyOraclev9i sourceTableProxy = (TableProxyOraclev9i)comp.getSourceTableProxy();
        TableProxyOraclev9i targetTableProxy = (TableProxyOraclev9i)comp.getTargetTableProxy();
        List chIndexes = table.getChildObjects(2);
        for (CompareObjectSelection index : chIndexes) {
            UniqueOraclev9i unique;
            StringBuffer columnList;
            Index theIndex;
            if (index.canBeCreate() && !index.isSelected()) continue;
            Index index2 = theIndex = index.isSelected() || !index.isModified() ? (Index)index.getObject() : (Index)index.getCorrespondentNode().getObject();
            if (theIndex != null && theIndex.isOidKey()) continue;
            if (index.getChoosedPropertyValue(PropertiesComparator.INDEX_STATUS).equals("Primary Constraint")) {
                Table sourceTable = comp.getSourceTable();
                if (sourceTable != null && sourceTable.getBasedOnStructuredType() != null) continue;
                if ((Index)index.getObject() == null) {
                    if (index.isSelected() || !this.isNotEmpty((columnList = this.getColumnsForRestore(table.getCorrespondentNode(), (Index)index.getCorrespondentNode().getObject(), prettyPrint, false)).toString())) continue;
                    this.appendRestorePKDefinition(oldbuffer, targetTableProxy, prettyPrint, columnList, index.getCorrespondentNode());
                    continue;
                }
                if (((Index)index.getObject()).isPK() && (index.isSelected() || !index.isModified())) {
                    columnList = this.getColumnsForRestore(table, (Index)index.getObject(), prettyPrint, false);
                    if (!this.isNotEmpty(columnList.toString())) continue;
                    this.appendPKDefinition(oldbuffer, sourceTableProxy, (Index)index.getObject(), columnList, prettyPrint);
                    continue;
                }
                columnList = this.getColumnsForRestore(table.getCorrespondentNode(), (Index)index.getCorrespondentNode().getObject(), prettyPrint, false);
                if (!this.isNotEmpty(columnList.toString())) continue;
                this.appendPKDefinition(oldbuffer, targetTableProxy, (Index)index.getCorrespondentNode().getObject(), columnList, prettyPrint);
                continue;
            }
            CompareObjectSelection targetObj = index.getCorrespondentNode();
            if ((Index)index.getObject() == null) {
                if (index.isSelected()) continue;
                if (((Index)targetObj.getObject()).isUnique()) {
                    columnList = this.getColumnsForRestore(table.getCorrespondentNode(), (Index)index.getCorrespondentNode().getObject(), prettyPrint, false);
                    if (!this.isNotEmpty(columnList.toString())) continue;
                    unique = (UniqueOraclev9i)targetTableProxy.getUniqueKeys().getObjectByID(targetObj.getObject().getObjectID());
                    this.appendUniqueDefinition(oldbuffer, targetTableProxy, unique, prettyPrint, columnList);
                    continue;
                }
                columnList = this.getColumnsForRestore(table.getCorrespondentNode(), (Index)targetObj.getObject(), prettyPrint, true);
                if (!this.isNotEmpty(columnList.toString()) || !this.cssbIndex.canHandle(targetObj.getObject())) continue;
                this.cssbIndex.setRenamed(this.isRenamed());
                this.cssbIndex.setRestoredColumns(columnList);
                this.cssbIndex.setTableName(CSSBCreateRenameTable.getFormattedTableName(this.tableObj, this.storageDesign));
                this.cssbIndex.doAppend(oldbuffer, targetObj.getObject(), prettyPrint);
                continue;
            }
            if (((Index)index.getObject()).isUnique() && (index.isSelected() || !index.isModified())) {
                columnList = this.getColumnsForRestore(table, (Index)index.getObject(), prettyPrint, false);
                if (!this.isNotEmpty(columnList.toString())) continue;
                unique = (UniqueOraclev9i)sourceTableProxy.getUniqueKeys().getObjectByID(index.getObject().getObjectID());
                this.appendUniqueDefinition(oldbuffer, sourceTableProxy, unique, prettyPrint, columnList);
                continue;
            }
            if (((Index)index.getCorrespondentNode().getObject()).isUnique()) {
                columnList = this.getColumnsForRestore(table.getCorrespondentNode(), (Index)index.getCorrespondentNode().getObject(), prettyPrint, false);
                if (!this.isNotEmpty(columnList.toString())) continue;
                UniqueOraclev9i uniqie = (UniqueOraclev9i)targetTableProxy.getUniqueKeys().getObjectByID(targetObj.getObject().getObjectID());
                this.appendUniqueDefinition(oldbuffer, targetTableProxy, uniqie, prettyPrint, columnList);
                continue;
            }
            columnList = this.getColumnsForRestore(table, (Index)index.getObject(), prettyPrint, true);
            if (!this.isNotEmpty(columnList.toString()) || !this.cssbIndex.canHandle(index.getObject())) continue;
            this.cssbIndex.setRenamed(this.isRenamed());
            this.cssbIndex.setRestoredColumns(columnList);
            this.cssbIndex.setTableName(CSSBCreateRenameTable.getFormattedTableName(this.tableObj, this.storageDesign));
            this.cssbIndex.doAppend(oldbuffer, index.getObject(), prettyPrint);
        }
    }

    private void appendPKDefinition(StringBuffer oldbuffer, TableProxyOraclev9i tableProxy, Index index, StringBuffer columnList, boolean prettyPrint) {
        Index pkInd;
        PKProxyOraclev9i pk;
        StringBuffer buffer = new StringBuffer();
        String advancedComment = "";
        if (tableProxy != null && (pk = this.getPKProxy(tableProxy)) != null && pk.getObject() == index && ((pkInd = pk.getIndex()).shouldBeMerge() || this.isRenamed()) && !this.hasNoMergeColumns(pkInd.getElements()) && !"".equalsIgnoreCase(pk.getColumns())) {
            CSSBCreateRenameTable.appendNewLine(oldbuffer, prettyPrint, 0);
            if (pk.isCommentChanged() && !"".equalsIgnoreCase(pk.getComment())) {
                this.appendComment(oldbuffer, pk);
            } else if (!"".equalsIgnoreCase(pk.getObject().getComment())) {
                this.appendComment(oldbuffer, pk.getObject());
            }
            String pkName = pk.getName();
            if (pkName.length() > tableProxy.getMaxNameLength()) {
                CSSBCreateRenameTable.appendNewLine(oldbuffer, prettyPrint, 0);
                CSSBCreateRenameTable.appendStringWithSpace(oldbuffer, "--  ERROR: PK name length exceeds maximum allowed length(" + tableProxy.getMaxNameLength() + ")");
                CSSBCreateRenameTable.appendNewLine(oldbuffer, prettyPrint, 0);
                this.getStatus().incrementErrors();
            }
            CSSBCreateRenameTable.appendStringWithSpace(buffer, "ALTER");
            CSSBCreateRenameTable.appendStringWithSpace(buffer, "TABLE");
            CSSBCreateRenameTable.appendStringWithSpace(buffer, CSSBCreateRenameTable.getFormattedTableName(this.tableObj, this.storageDesign));
            CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateRenameTable.appendStringWithSpace(buffer, "ADD");
            if (!pkName.startsWith("SYS_")) {
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "CONSTRAINT");
                CSSBCreateRenameTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(pk));
            }
            advancedComment = buffer.toString();
            CSSBCreateRenameTable.appendStringWithSpace(buffer, "PRIMARY KEY");
            CSSBCreateRenameTable.appendStringWithSpace(buffer, '(');
            if (!"".equals(pkInd.getIndexExpression())) {
                CSSBCreateRenameTable.appendStringWithSpace(buffer, pkInd.getIndexExpression());
            } else {
                this.appendStringWithSpace(buffer, columnList);
            }
            CSSBCreateRenameTable.appendStringWithSpace(buffer, ')');
            if (!"NO".equalsIgnoreCase(pk.getDeferrable())) {
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "DEFERRABLE");
                if ("DEFERRED".equalsIgnoreCase(pk.getInitially())) {
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, "INITIALLY");
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, "DEFERRED");
                } else if (this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL()) {
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, "INITIALLY");
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, "IMMEDIATE");
                }
            } else if (this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL()) {
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "NOT");
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "DEFERRABLE");
            }
            if (!"NO".equalsIgnoreCase(pk.getUsingIndex())) {
                this.appendUsingIndex(buffer, pk, prettyPrint);
            }
            if (this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL()) {
                if ("YES".equalsIgnoreCase(pk.getEnable())) {
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, "ENABLE");
                } else {
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, "DISABLE");
                }
                if ("YES".equalsIgnoreCase(pk.getValidate())) {
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, "VALIDATE");
                } else {
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, "NOVALIDATE");
                }
            } else {
                if (!"YES".equalsIgnoreCase(pk.getEnable())) {
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, "DISABLE");
                    if ("YES".equalsIgnoreCase(pk.getValidate())) {
                        CSSBCreateRenameTable.appendStringWithSpace(buffer, "VALIDATE");
                    }
                }
                if (!"YES".equalsIgnoreCase(pk.getValidate())) {
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, "NOVALIDATE");
                }
            }
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            CSSBCreateRenameTable.appendLineFinisher(buffer, prettyPrint);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            this.getStatus().incrementAlterTable();
            if (pk.getRely().equals("YES")) {
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "ALTER");
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "TABLE");
                CSSBCreateRenameTable.appendStringWithSpace(buffer, CSSBCreateRenameTable.getFormattedTableName(this.tableObj, this.storageDesign));
                CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "MODIFY");
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "CONSTRAINT");
                CSSBCreateRenameTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(pk));
                advancedComment = buffer.toString();
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "RELY");
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 0);
                CSSBCreateRenameTable.appendLineFinisher(buffer, prettyPrint);
                CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 0);
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                this.getStatus().incrementAlterTable();
            }
            if (pk.getExceptionsTable() != null && "YES".equalsIgnoreCase(pk.getEnable())) {
                CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "ALTER");
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "TABLE");
                CSSBCreateRenameTable.appendStringWithSpace(buffer, CSSBCreateRenameTable.getFormattedTableName(this.tableObj, this.storageDesign));
                advancedComment = buffer.toString();
                CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "MODIFY");
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "CONSTRAINT");
                CSSBCreateRenameTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(pk));
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "ENABLE EXCEPTIONS INTO");
                CSSBCreateRenameTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(pk.getExceptionsTable()));
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 0);
                CSSBCreateRenameTable.appendLineFinisher(buffer, prettyPrint);
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                this.getStatus().incrementAlterTable();
            }
        }
    }

    private void appendRestorePKDefinition(StringBuffer oldbuffer, TableProxyOraclev9i tableProxy, boolean prettyPrint, StringBuffer restoreColumns, CompareObjectSelection indexObj) {
        Index pkInd;
        PKProxyOraclev9i pk;
        StringBuffer buffer = new StringBuffer();
        String advancedComment = "";
        if (tableProxy != null && (pk = this.getPKProxy(tableProxy)) != null && ((pkInd = pk.getIndex()).shouldBeMerge() || this.isRenamed()) && this.isNotEmpty(restoreColumns.toString()) && !"".equalsIgnoreCase(pk.getColumns())) {
            CSSBCreateRenameTable.appendNewLine(oldbuffer, prettyPrint, 0);
            if (pk.isCommentChanged() && !"".equalsIgnoreCase(pk.getComment())) {
                this.appendComment(oldbuffer, pk);
            } else if (!"".equalsIgnoreCase(pk.getObject().getComment())) {
                this.appendComment(oldbuffer, pk.getObject());
            }
            CSSBCreateRenameTable.appendStringWithSpace(buffer, "ALTER");
            CSSBCreateRenameTable.appendStringWithSpace(buffer, "TABLE");
            CSSBCreateRenameTable.appendStringWithSpace(buffer, CSSBCreateRenameTable.getFormattedTableName(this.tableObj, this.storageDesign));
            CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateRenameTable.appendStringWithSpace(buffer, "ADD");
            if (!pk.getName().startsWith("SYS_")) {
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "CONSTRAINT");
                CSSBCreateRenameTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(pk));
            }
            advancedComment = buffer.toString();
            CSSBCreateRenameTable.appendStringWithSpace(buffer, "PRIMARY KEY");
            CSSBCreateRenameTable.appendStringWithSpace(buffer, '(');
            this.appendStringWithSpace(buffer, restoreColumns);
            CSSBCreateRenameTable.appendStringWithSpace(buffer, ')');
            if (!"NO".equalsIgnoreCase(pk.getDeferrable())) {
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "DEFERRABLE");
                if ("DEFERRED".equalsIgnoreCase(pk.getInitially())) {
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, "INITIALLY");
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, "DEFERRED");
                } else if (this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL()) {
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, "INITIALLY");
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, "IMMEDIATE");
                }
            } else if (this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL()) {
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "NOT");
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "DEFERRABLE");
            }
            if (!"NO".equalsIgnoreCase(pk.getUsingIndex())) {
                this.appendUsingIndex(buffer, pk, prettyPrint);
            }
            if (this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL()) {
                if ("YES".equalsIgnoreCase(pk.getEnable())) {
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, "ENABLE");
                } else {
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, "DISABLE");
                }
                if ("YES".equalsIgnoreCase(pk.getValidate())) {
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, "VALIDATE");
                } else {
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, "NOVALIDATE");
                }
            } else {
                if (!"YES".equalsIgnoreCase(pk.getEnable())) {
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, "DISABLE");
                    if ("YES".equalsIgnoreCase(pk.getValidate())) {
                        CSSBCreateRenameTable.appendStringWithSpace(buffer, "VALIDATE");
                    }
                }
                if (!"YES".equalsIgnoreCase(pk.getValidate())) {
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, "NOVALIDATE");
                }
            }
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 0);
            CSSBCreateRenameTable.appendLineFinisher(buffer, prettyPrint);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            this.getStatus().incrementAlterTable();
            if (pk.getRely().equals("YES")) {
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "ALTER");
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "TABLE");
                CSSBCreateRenameTable.appendStringWithSpace(buffer, CSSBCreateRenameTable.getFormattedTableName(this.tableObj, this.storageDesign));
                CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "MODIFY");
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "CONSTRAINT");
                CSSBCreateRenameTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(pk));
                advancedComment = buffer.toString();
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "RELY");
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 0);
                CSSBCreateRenameTable.appendLineFinisher(buffer, prettyPrint);
                CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 0);
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                this.getStatus().incrementAlterTable();
            }
            if (pk.getExceptionsTable() != null && "YES".equalsIgnoreCase(pk.getEnable())) {
                CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "ALTER");
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "TABLE");
                CSSBCreateRenameTable.appendStringWithSpace(buffer, CSSBCreateRenameTable.getFormattedTableName(this.tableObj, this.storageDesign));
                advancedComment = buffer.toString();
                CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "MODIFY");
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "CONSTRAINT");
                CSSBCreateRenameTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(pk));
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "ENABLE EXCEPTIONS INTO");
                CSSBCreateRenameTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(pk.getExceptionsTable()));
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 0);
                CSSBCreateRenameTable.appendLineFinisher(buffer, prettyPrint);
                this.appendToBuffer(oldbuffer, buffer, advancedComment);
                this.getStatus().incrementAlterTable();
            }
        }
    }

    private void appendSupplementalLoggings(StringBuffer buffer, TableProxyOraclev9i tableProxy, boolean prettyPrint) {
        if (tableProxy != null && !"".equalsIgnoreCase(tableProxy.getSuplementalLogGroupName())) {
            this.appendComma(buffer);
            CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateRenameTable.appendStringWithSpace(buffer, "SUPPLEMENTAL");
            CSSBCreateRenameTable.appendStringWithSpace(buffer, "LOG");
            CSSBCreateRenameTable.appendStringWithSpace(buffer, "GROUP");
            CSSBCreateRenameTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tableProxy.getSuplementalLogGroupName()));
            CSSBCreateRenameTable.appendStringWithSpace(buffer, '(');
            CSSBCreateRenameTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(tableProxy.getSuplementalLogColumns()));
            CSSBCreateRenameTable.appendStringWithSpace(buffer, ')');
            if (tableProxy.getSuplementalLogConditions().equalsIgnoreCase("ALWAYS")) {
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "ALWAYS");
            }
        }
    }

    @Override
    protected boolean appendTableConstraintsDefinition(StringBuffer buffer, TableProxyOracle tableProxy, boolean prettyPrint, boolean first) {
        return first;
    }

    private void appendUsingIndex(StringBuffer buffer, PKProxyOraclev9i pkProxy, boolean prettyPrint) {
        CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
        CSSBCreateRenameTable.appendStringWithSpace(buffer, "USING INDEX");
        IndexProxyOracle exIndex = pkProxy.getExistingIndex();
        if ("BY INDEX NAME".equalsIgnoreCase(pkProxy.getUsingIndex()) && pkProxy.getExistingIndex() != null) {
            Index existInd = exIndex.getIndex();
            if (!existInd.isRemoved() && existInd.canSupportConstraint(pkProxy.getIndex(), true)) {
                CSSBCreateRenameTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(pkProxy.getExistingIndex()));
            }
        } else if ("BY CREATE INDEX STATEMENT".equalsIgnoreCase(pkProxy.getUsingIndex())) {
            CSSBCreateRenameTable.appendStringWithSpace(buffer, '(');
            CSSBCreateRenameTable.appendStringWithSpace(buffer, pkProxy.getCreateIndexStatement());
            CSSBCreateRenameTable.appendStringWithSpace(buffer, ')');
        } else {
            TableProxyOracle tableProxy = (TableProxyOracle)pkProxy.getTableProxy();
            boolean temporaryTable = tableProxy.getTemporary().equals("YES");
            if (!temporaryTable) {
                if ("LOCAL PARTITIONED".equalsIgnoreCase(pkProxy.getUsingIndex())) {
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, "LOCAL");
                } else if ("GLOBAL PARTITIONED".equalsIgnoreCase(pkProxy.getUsingIndex())) {
                    this.appendGlobalIndex(buffer, pkProxy, prettyPrint);
                }
                if (pkProxy.getIndexSegment() != null) {
                    this.appendSegment(buffer, (SegmentOraclev9i)pkProxy.getIndexSegment(), false, prettyPrint, pkProxy.getTableSpace(), pkProxy.getLogging());
                } else {
                    if (pkProxy.getTableSpace() != null && this.storageDesign.getDesign().getSettings().isIncludeTablespaceInDDL()) {
                        CSSBCreateRenameTable.appendStringWithSpace(buffer, "TABLESPACE");
                        CSSBCreateRenameTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(pkProxy.getTableSpace()));
                        CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
                    }
                    if (this.storageDesign.isOpen() && this.storageDesign.getDesign().getSettings().isIncludeLoggingInDDL()) {
                        if ("YES".equalsIgnoreCase(pkProxy.getLogging())) {
                            CSSBCreateRenameTable.appendStringWithSpace(buffer, "LOGGING");
                            CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
                        } else if ("NO".equalsIgnoreCase(pkProxy.getLogging())) {
                            CSSBCreateRenameTable.appendStringWithSpace(buffer, "NOLOGGING");
                            CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
                        }
                    }
                }
            }
            if (pkProxy.getIndexSort().equalsIgnoreCase("NO")) {
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "NOSORT");
                CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
            } else if (pkProxy.getIndexSort().equalsIgnoreCase("REVERSE")) {
                if (this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL()) {
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, "SORT");
                }
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "REVERSE");
                CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
            } else if (this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL()) {
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "SORT");
                CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
            }
            if (pkProxy.getComputeStatistics().equalsIgnoreCase("YES")) {
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "COMPUTE STATISTICS");
            }
        }
    }

    private void appendUniqueUsingIndex(StringBuffer buffer, UniqueOraclev9i unique, boolean prettyPrint) {
        CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
        CSSBCreateRenameTable.appendStringWithSpace(buffer, "USING INDEX");
        IndexProxyOracle exIndex = unique.getExistingIndex();
        if ("BY INDEX NAME".equalsIgnoreCase(unique.getUsingIndex()) && unique.getExistingIndex() != null) {
            Index existInd = exIndex.getIndex();
            if (!existInd.isRemoved() && existInd.canSupportConstraint(unique.getIndex(), true)) {
                CSSBCreateRenameTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(unique.getExistingIndex()));
            }
        } else if ("BY CREATE INDEX STATEMENT".equalsIgnoreCase(unique.getUsingIndex())) {
            CSSBCreateRenameTable.appendStringWithSpace(buffer, '(');
            CSSBCreateRenameTable.appendStringWithSpace(buffer, unique.getCreateIndexStatement());
            CSSBCreateRenameTable.appendStringWithSpace(buffer, ')');
        } else {
            TableProxyOracle tableProxy = (TableProxyOracle)unique.getTableProxy();
            boolean temporaryTable = tableProxy.getTemporary().equals("YES");
            if (!temporaryTable) {
                if ("LOCAL PARTITIONED".equalsIgnoreCase(unique.getUsingIndex())) {
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, "LOCAL");
                } else if (unique.getUsingIndex().equalsIgnoreCase("GLOBAL PARTITIONED")) {
                    this.appendUniqueGlobalIndex(buffer, unique, prettyPrint);
                }
                if (unique.getIndexSegment() != null) {
                    this.appendSegment(buffer, (SegmentOraclev9i)unique.getIndexSegment(), false, prettyPrint, unique.getTableSpace(), unique.getLogging());
                } else {
                    if (unique.getTableSpace() != null && this.storageDesign.getDesign().getSettings().isIncludeTablespaceInDDL()) {
                        CSSBCreateRenameTable.appendStringWithSpace(buffer, "TABLESPACE");
                        CSSBCreateRenameTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(unique.getTableSpace()));
                        CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
                    }
                    if (this.storageDesign.getDesign().getSettings().isIncludeLoggingInDDL()) {
                        if ("YES".equalsIgnoreCase(unique.getLogging())) {
                            CSSBCreateRenameTable.appendStringWithSpace(buffer, "LOGGING");
                            CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
                        } else if ("NO".equalsIgnoreCase(unique.getLogging())) {
                            CSSBCreateRenameTable.appendStringWithSpace(buffer, "NOLOGGING");
                            CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
                        }
                    }
                }
            }
            if (unique.getIndexSort().equalsIgnoreCase("NO")) {
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "NOSORT");
                CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
            } else if (unique.getIndexSort().equalsIgnoreCase("REVERSE")) {
                if (this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL()) {
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, "SORT");
                }
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "REVERSE");
                CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
            } else if (this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL()) {
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "SORT");
                CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
            }
            if (unique.getComputeStatistics().equalsIgnoreCase("YES")) {
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "COMPUTE STATISTICS");
            }
        }
    }

    private void appendUniqueGlobalIndex(StringBuffer buffer, UniqueOraclev9i unique, boolean prettyPrint) {
        if (unique.getUsingIndexGlobalPL() != null) {
            CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateRenameTable.appendStringWithSpace(buffer, "GLOBAL");
            CSSBCreateRenameTable.appendStringWithSpace(buffer, "PARTITION");
            CSSBCreateRenameTable.appendStringWithSpace(buffer, "BY");
            CSSBCreateRenameTable.appendStringWithSpace(buffer, "RANGE");
            CSSBCreateRenameTable.appendStringWithSpace(buffer, '(');
            CSSBCreateRenameTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(unique.getUsingIndexGlobalPL().getGlobalPartColumns()));
            CSSBCreateRenameTable.appendStringWithSpace(buffer, ')');
            this.appendGlobalPartitions(buffer, (IndexGlobalPartitionsListOraclev9i)unique.getUsingIndexGlobalPL(), prettyPrint);
        }
    }

    private void appendGlobalIndex(StringBuffer buffer, PKProxyOraclev9i pkProxy, boolean prettyPrint) {
        if (pkProxy.getIndexGlobalPL() != null) {
            CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateRenameTable.appendStringWithSpace(buffer, "GLOBAL");
            CSSBCreateRenameTable.appendStringWithSpace(buffer, "PARTITION");
            CSSBCreateRenameTable.appendStringWithSpace(buffer, "BY");
            CSSBCreateRenameTable.appendStringWithSpace(buffer, "RANGE");
            CSSBCreateRenameTable.appendStringWithSpace(buffer, '(');
            CSSBCreateRenameTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(pkProxy.getIndexGlobalPL().getGlobalPartColumns()));
            CSSBCreateRenameTable.appendStringWithSpace(buffer, ')');
            this.appendGlobalPartitions(buffer, (IndexGlobalPartitionsListOraclev9i)pkProxy.getIndexGlobalPL(), prettyPrint);
        }
    }

    private void appendGlobalPartitions(StringBuffer buffer, IndexGlobalPartitionsListOraclev9i globalPartitionList, boolean prettyPrint) {
        IndexGlobalPartitionSetOraclev9i globalPartitionSet = (IndexGlobalPartitionSetOraclev9i)((StorageDesignOraclev9i)globalPartitionList.getStorageDesign()).getIndexGlobalPartitionSet();
        Object[] globalPartitionsList = globalPartitionSet.toArray();
        Arrays.sort(globalPartitionsList, new GlobalPossitionComparator());
        ArrayList<Object> sortedList = new ArrayList<Object>();
        for (int i = 0; i < globalPartitionsList.length; ++i) {
            sortedList.add(globalPartitionsList[i]);
        }
        Iterator setIt = sortedList.iterator();
        boolean first = true;
        while (setIt.hasNext()) {
            IndexGlobalPartitionOraclev9i globalPartition = (IndexGlobalPartitionOraclev9i)setIt.next();
            if (globalPartition.getIndexGlobalPartList() == null || !globalPartition.getIndexGlobalPartList().toString().equalsIgnoreCase(globalPartitionList.toString())) continue;
            if (first) {
                CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateRenameTable.appendStringWithSpace(buffer, '(');
                CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
                first = false;
            } else {
                CSSBCreateRenameTable.appendStringWithSpace(buffer, ',');
                CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
            }
            CSSBCreateRenameTable.appendStringWithSpace(buffer, "PARTITION");
            if (!globalPartition.getName().toUpperCase().startsWith("SYS_")) {
                CSSBCreateRenameTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(globalPartition));
            }
            CSSBCreateRenameTable.appendStringWithSpace(buffer, "VALUES LESS THAN");
            CSSBCreateRenameTable.appendStringWithSpace(buffer, '(');
            CSSBCreateRenameTable.appendStringWithSpace(buffer, globalPartition.getValueList());
            CSSBCreateRenameTable.appendStringWithSpace(buffer, ')');
            if (globalPartition.getSegment() != null) {
                this.appendSegment(buffer, (SegmentOraclev9i)globalPartition.getSegment(), false, prettyPrint, globalPartition.getTableSpace(), globalPartition.getLogging());
                continue;
            }
            if (globalPartition.getTableSpace() != null && this.storageDesign.getDesign().getSettings().isIncludeTablespaceInDDL()) {
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "TABLESPACE");
                CSSBCreateRenameTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(globalPartition.getTableSpace()));
            }
            if (!this.storageDesign.isOpen() || !this.storageDesign.getDesign().getSettings().isIncludeLoggingInDDL()) continue;
            if ("YES".equalsIgnoreCase(globalPartition.getLogging())) {
                CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 2);
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "LOGGING");
                continue;
            }
            if (!"NO".equalsIgnoreCase(globalPartition.getLogging())) continue;
            CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 2);
            CSSBCreateRenameTable.appendStringWithSpace(buffer, "NOLOGGING");
        }
        if (!first) {
            CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateRenameTable.appendStringWithSpace(buffer, ')');
        }
    }

    private void appendPartitionList(StringBuffer buffer, TableProxyOraclev9i tableProxy, boolean prettyPrint) {
        PartitionListOraclev9i partitionList = (PartitionListOraclev9i)tableProxy.getPartitionList();
        if (partitionList != null) {
            String partitionType = partitionList.getPartitionType();
            CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
            if ("RANGE".equalsIgnoreCase(partitionType)) {
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "PARTITION");
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "BY");
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "RANGE");
                CSSBCreateRenameTable.appendStringWithSpace(buffer, '(');
                CSSBCreateRenameTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(partitionList.getColumnIDs()));
                CSSBCreateRenameTable.appendStringWithSpace(buffer, ')');
                this.appendPartitions(buffer, partitionList, false, prettyPrint);
            } else if ("COMPOSITE BY HASH".equalsIgnoreCase(partitionType)) {
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "PARTITION");
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "BY");
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "RANGE");
                CSSBCreateRenameTable.appendStringWithSpace(buffer, '(');
                CSSBCreateRenameTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(partitionList.getColumnIDs()));
                CSSBCreateRenameTable.appendStringWithSpace(buffer, ')');
                CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "SUBPARTITION");
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "BY");
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "HASH");
                CSSBCreateRenameTable.appendStringWithSpace(buffer, '(');
                CSSBCreateRenameTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(partitionList.getSubPartitionsColumnIDs()));
                CSSBCreateRenameTable.appendStringWithSpace(buffer, ')');
                if ("NO".equals(partitionList.getUseSubpartStorageTemplate())) {
                    if (partitionList.getSubPartitionsQuantity() > 1 || !"".equals(partitionList.getSubPartitionsTableSpaces())) {
                        CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
                        CSSBCreateRenameTable.appendStringWithSpace(buffer, "SUBPARTITIONS");
                        CSSBCreateRenameTable.appendStringWithSpace(buffer, partitionList.getSubPartitionsQuantity());
                        if (!"".equals(partitionList.getSubPartitionsTableSpaces())) {
                            CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
                            CSSBCreateRenameTable.appendStringWithSpace(buffer, "STORE IN");
                            CSSBCreateRenameTable.appendStringWithSpace(buffer, '(');
                            CSSBCreateRenameTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedTablespaceNamesFromIDs(partitionList.getSubPartitionsTableSpaces()));
                            CSSBCreateRenameTable.appendStringWithSpace(buffer, ')');
                        }
                    } else if (this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL()) {
                        CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
                        CSSBCreateRenameTable.appendStringWithSpace(buffer, "SUBPARTITIONS");
                        CSSBCreateRenameTable.appendStringWithSpace(buffer, "1");
                    }
                } else {
                    this.appendHashSubPartitionTemplates(buffer, tableProxy, prettyPrint);
                }
                this.appendPartitions(buffer, partitionList, true, prettyPrint);
            } else if ("COMPOSITE BY LIST".equalsIgnoreCase(partitionType)) {
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "PARTITION");
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "BY");
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "RANGE");
                CSSBCreateRenameTable.appendStringWithSpace(buffer, '(');
                CSSBCreateRenameTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(partitionList.getColumnIDs()));
                CSSBCreateRenameTable.appendStringWithSpace(buffer, ')');
                CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "SUBPARTITION");
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "BY");
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "LIST");
                CSSBCreateRenameTable.appendStringWithSpace(buffer, '(');
                CSSBCreateRenameTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(partitionList.getSubPartitionsColumnIDs()));
                CSSBCreateRenameTable.appendStringWithSpace(buffer, ')');
                this.appendListSubPartitionTemplates(buffer, tableProxy, prettyPrint);
                this.appendPartitions(buffer, partitionList, true, prettyPrint);
            } else if ("HASH BY QUANTITY".equalsIgnoreCase(partitionType)) {
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "PARTITION");
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "BY");
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "HASH");
                CSSBCreateRenameTable.appendStringWithSpace(buffer, '(');
                CSSBCreateRenameTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(partitionList.getColumnIDs()));
                CSSBCreateRenameTable.appendStringWithSpace(buffer, ')');
                CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "PARTITIONS");
                CSSBCreateRenameTable.appendStringWithSpace(buffer, partitionList.getHashPQuantity());
                if (!"".equals(partitionList.getHashPTableSpaces())) {
                    CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, "STORE IN");
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, '(');
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedTablespaceNamesFromIDs(partitionList.getHashPTableSpaces()));
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, ')');
                }
                if (!"".equals(partitionList.getIOTOverflowHashPTS())) {
                    CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, "OVERFLOW");
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, "STORE IN");
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, '(');
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedTablespaceNamesFromIDs(partitionList.getIOTOverflowHashPTS()));
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, ')');
                }
            } else if ("HASH BY LIST OF PARTITIONS".equalsIgnoreCase(partitionType)) {
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "PARTITION");
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "BY");
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "HASH");
                CSSBCreateRenameTable.appendStringWithSpace(buffer, '(');
                CSSBCreateRenameTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(partitionList.getColumnIDs()));
                CSSBCreateRenameTable.appendStringWithSpace(buffer, ')');
                this.appendHashPartitions(buffer, tableProxy, prettyPrint);
            } else if ("LIST".equalsIgnoreCase(partitionType)) {
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "PARTITION");
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "BY");
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "LIST");
                CSSBCreateRenameTable.appendStringWithSpace(buffer, '(');
                CSSBCreateRenameTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(partitionList.getColumnIDs()));
                CSSBCreateRenameTable.appendStringWithSpace(buffer, ')');
                this.appendListPartitions(buffer, tableProxy, prettyPrint);
            }
        }
    }

    private void appendListSubPartitionTemplates(StringBuffer buffer, TableProxyOraclev9i tableProxy, boolean prettyPrint) {
        StorageObjectCollection templates = tableProxy.getListStorageTemplates();
        if (templates.size() > 0) {
            CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateRenameTable.appendStringWithSpace(buffer, "SUBPARTITION");
            CSSBCreateRenameTable.appendStringWithSpace(buffer, "TEMPLATE");
            CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateRenameTable.appendStringWithSpace(buffer, '(');
            for (int i = 0; i < templates.size(); ++i) {
                ListStorageTemplatePartitionOraclev9i temp = (ListStorageTemplatePartitionOraclev9i)templates.getElement(i);
                if (i > 0) {
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, ',');
                }
                CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 2);
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "SUBPARTITION");
                if (!temp.getName().toUpperCase().startsWith("SYS_")) {
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(temp));
                }
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "VALUES");
                CSSBCreateRenameTable.appendStringWithSpace(buffer, '(');
                if (!"".equalsIgnoreCase(temp.getValueList())) {
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, temp.getValueList());
                } else {
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, "DEFAULT");
                }
                CSSBCreateRenameTable.appendStringWithSpace(buffer, ')');
                this.appendPartStorage(buffer, temp, prettyPrint);
            }
            CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateRenameTable.appendStringWithSpace(buffer, ')');
        }
    }

    private void appendHashSubPartitionTemplates(StringBuffer buffer, TableProxyOraclev9i tableProxy, boolean prettyPrint) {
        if (tableProxy.getListStorageTemplates().size() > 0) {
            CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateRenameTable.appendStringWithSpace(buffer, "SUBPARTITION");
            CSSBCreateRenameTable.appendStringWithSpace(buffer, "TEMPLATE");
            Iterator setIt = tableProxy.getListStorageTemplates().iterator();
            boolean first = true;
            while (setIt.hasNext()) {
                HashPartitionOraclev9i partition = (HashPartitionOraclev9i)setIt.next();
                if (first) {
                    CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, '(');
                    first = false;
                } else {
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, ',');
                }
                CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "SUBPARTITION");
                if (!partition.getName().toUpperCase().startsWith("SYS_")) {
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(partition));
                }
                this.appendPartStorage(buffer, partition, prettyPrint);
            }
            if (!first) {
                CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateRenameTable.appendStringWithSpace(buffer, ')');
            }
        }
    }

    private void appendPartStorage(StringBuffer buffer, AbstractStorageObjectOracle template, boolean prettyPrint) {
        TableSpaceOracle tableSpace = null;
        TableSpaceOracle overflowTableSpace = null;
        StorageObjectCollection lobs = null;
        AbstractStorageObjectOracle owningPartition = null;
        if (template instanceof HashPartitionOraclev9i) {
            tableSpace = ((HashPartitionOraclev9i)template).getTableSpace();
            overflowTableSpace = ((HashPartitionOraclev9i)template).getIotOverflowTablespace();
            lobs = ((HashPartitionOraclev9i)template).getLobs();
            owningPartition = ((HashPartitionOraclev9i)template).getSubPartitionOf();
        } else if (template instanceof ListStorageTemplatePartitionOraclev9i) {
            tableSpace = ((ListStorageTemplatePartitionOraclev9i)template).getTablespace();
            lobs = ((ListStorageTemplatePartitionOraclev9i)template).getLobs();
            owningPartition = ((ListStorageTemplatePartitionOraclev9i)template).getSubPartitionOf();
        }
        if (this.storageDesign.getDesign().getSettings().isIncludeTablespaceInDDL()) {
            if (tableSpace != null) {
                CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 2);
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "TABLESPACE");
                CSSBCreateRenameTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tableSpace));
            }
            if (overflowTableSpace != null) {
                CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 2);
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "OVERFLOW");
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "TABLESPACE");
                CSSBCreateRenameTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(overflowTableSpace));
            }
        }
        if (lobs != null) {
            for (Object storageObject : lobs) {
                HashPartitionLobItemOraclev9i lobItem;
                if (storageObject instanceof LobStorageOraclev9i) {
                    LobStorageOraclev9i lobStorage = (LobStorageOraclev9i)storageObject;
                    if (lobStorage.getTableSpace() == null && lobStorage.getLobSegmentName().trim().equals("")) continue;
                    CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 2);
                    this.appendLobPartitioningStorage(buffer, lobStorage, lobStorage.getColumn(), lobStorage.getLobSegmentName(), lobStorage.getTableSpace(), prettyPrint);
                    continue;
                }
                if (!(storageObject instanceof HashPartitionLobItemOraclev9i) || (lobItem = (HashPartitionLobItemOraclev9i)storageObject).getTableSpace() == null) continue;
                CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 2);
                String lobSegName = lobItem.getName();
                if (owningPartition != null && (lobSegName.startsWith("SYS_LOB") || lobSegName.startsWith(lobItem.getIDPrefix()))) {
                    lobSegName = "";
                }
                this.appendLobPartitioningStorage(buffer, lobItem, lobItem.getLobColumn(), lobSegName, lobItem.getTableSpace(), prettyPrint);
            }
        }
    }

    private void appendListPartitions(StringBuffer buffer, TableProxyOraclev9i tableProxy, boolean prettyPrint) {
        Iterator it = tableProxy.getPartitions().iterator();
        boolean first = true;
        while (it.hasNext()) {
            Table table;
            ListPartitionOraclev9i partition = (ListPartitionOraclev9i)it.next();
            if (first) {
                CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateRenameTable.appendStringWithSpace(buffer, '(');
                CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
                first = false;
            } else {
                CSSBCreateRenameTable.appendStringWithSpace(buffer, ',');
                CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
            }
            CSSBCreateRenameTable.appendStringWithSpace(buffer, "PARTITION");
            if (!partition.getName().toUpperCase().startsWith("SYS_")) {
                CSSBCreateRenameTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(partition));
            }
            CSSBCreateRenameTable.appendStringWithSpace(buffer, "VALUES");
            CSSBCreateRenameTable.appendStringWithSpace(buffer, '(');
            if (!"".equalsIgnoreCase(partition.getColumns())) {
                CSSBCreateRenameTable.appendStringWithSpace(buffer, partition.getColumns());
            } else {
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "DEFAULT");
            }
            CSSBCreateRenameTable.appendStringWithSpace(buffer, ')');
            if (partition.getSegment() != null) {
                this.appendSegment(buffer, (SegmentOraclev9i)partition.getSegment(), true, prettyPrint, partition.getTablespace(), partition.getLogging());
            }
            if (partition.getDataSegmentCompression().equalsIgnoreCase("NO")) {
                CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "NOCOMPRESS");
            } else if (partition.getDataSegmentCompression().equalsIgnoreCase("YES")) {
                CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "COMPRESS");
            } else if (this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL()) {
                CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "NOCOMPRESS");
            }
            if (partition.getSegment() == null) {
                if (partition.getTablespace() != null && this.storageDesign.getDesign().getSettings().isIncludeTablespaceInDDL()) {
                    CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, "TABLESPACE");
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(partition.getTablespace()));
                }
                if (this.storageDesign.isOpen() && this.storageDesign.getDesign().getSettings().isIncludeLoggingInDDL()) {
                    if (partition.getLogging().equalsIgnoreCase("YES")) {
                        CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
                        CSSBCreateRenameTable.appendStringWithSpace(buffer, "LOGGING");
                    } else if (partition.getLogging().equalsIgnoreCase("NO")) {
                        CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
                        CSSBCreateRenameTable.appendStringWithSpace(buffer, "NOLOGGING");
                    }
                }
            }
            if ((table = (Table)this.tableObj.getObject()).isSpatialTable()) continue;
            for (LobStorageOracle lob : partition.getLobStorages()) {
                this.appendLobStorage(buffer, (LobStorageOraclev9i)lob, prettyPrint);
            }
        }
        if (!first) {
            CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateRenameTable.appendStringWithSpace(buffer, ')');
        }
    }

    private void appendPartitions(StringBuffer buffer, PartitionListOraclev9i partitionList, boolean composite, boolean prettyPrint) {
        PartitionSetOracle partitionSet = ((StorageDesignOraclev9i)partitionList.getStorageDesign()).getPartitionSet();
        Object[] partitionsList = partitionSet.toArray();
        Arrays.sort(partitionsList, new PossitionComparator());
        ArrayList<Object> sortedList = new ArrayList<Object>();
        for (int i = 0; i < partitionsList.length; ++i) {
            sortedList.add(partitionsList[i]);
        }
        Iterator setIt = sortedList.iterator();
        boolean first = true;
        while (setIt.hasNext()) {
            PartitionOracle partition = (PartitionOracle)setIt.next();
            if (partition.getPartitionList() == null || partition.getPartitionList() != partitionList) continue;
            if (first) {
                CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateRenameTable.appendStringWithSpace(buffer, '(');
                CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
                first = false;
            } else {
                CSSBCreateRenameTable.appendStringWithSpace(buffer, ',');
                CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
            }
            CSSBCreateRenameTable.appendStringWithSpace(buffer, "PARTITION");
            if (!partition.getName().toUpperCase().startsWith("SYS_")) {
                CSSBCreateRenameTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(partition));
            }
            CSSBCreateRenameTable.appendStringWithSpace(buffer, "VALUES LESS THAN");
            CSSBCreateRenameTable.appendStringWithSpace(buffer, '(');
            CSSBCreateRenameTable.appendStringWithSpace(buffer, partition.getValueList());
            CSSBCreateRenameTable.appendStringWithSpace(buffer, ')');
            if (partition.getSegment() != null) {
                this.appendSegment(buffer, (SegmentOraclev9i)partition.getSegment(), true, prettyPrint, partition.getTableSpace(), partition.getLogging());
            } else if (partition.getIOTOverflowSegment() != null) {
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "OVERFLOW");
                this.appendSegment(buffer, (SegmentOraclev9i)partition.getIOTOverflowSegment(), true, prettyPrint, partition.getTableSpace(), partition.getLogging());
            } else {
                if (partition.getTableSpace() != null && this.storageDesign.getDesign().getSettings().isIncludeTablespaceInDDL()) {
                    CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 2);
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, "TABLESPACE");
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(partition.getTableSpace()));
                }
                if (this.storageDesign.getDesign().getSettings().isIncludeLoggingInDDL()) {
                    if (partition.getLogging().equalsIgnoreCase("NO")) {
                        CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 2);
                        CSSBCreateRenameTable.appendStringWithSpace(buffer, "NOLOGGING");
                    } else if (partition.getLogging().equalsIgnoreCase("YES")) {
                        CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 2);
                        CSSBCreateRenameTable.appendStringWithSpace(buffer, "LOGGING");
                    }
                }
            }
            Table table = (Table)this.tableObj.getObject();
            if (!table.isSpatialTable()) {
                for (LobStorageOracle lob : partition.getLobs()) {
                    this.appendLobStorage(buffer, (LobStorageOraclev9i)lob, prettyPrint);
                }
            }
            if (!composite || this.appendHashSubPartitions(buffer, (PartitionOraclev9i)partition, partitionList, prettyPrint)) continue;
            if (partition.getSubPartitionsQuantity() > 0) {
                CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "SUBPARTITIONS");
                CSSBCreateRenameTable.appendStringWithSpace(buffer, partition.getSubPartitionsQuantity());
                if ("".equalsIgnoreCase(partition.getSubPartitionsTableSpaces())) continue;
                CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "STORE IN");
                CSSBCreateRenameTable.appendStringWithSpace(buffer, '(');
                CSSBCreateRenameTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedTablespaceNamesFromIDs(partition.getSubPartitionsTableSpaces()));
                CSSBCreateRenameTable.appendStringWithSpace(buffer, ')');
                continue;
            }
            if (partition.getListPartitions().size() <= 0) continue;
            boolean firstListPart = true;
            Iterator listPartitions = partition.getListPartitions().iterator();
            CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateRenameTable.appendStringWithSpace(buffer, '(');
            while (listPartitions.hasNext()) {
                ListStorageTemplatePartitionOraclev9i listPartition = (ListStorageTemplatePartitionOraclev9i)listPartitions.next();
                if (!firstListPart) {
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, ',');
                } else {
                    firstListPart = false;
                }
                CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 2);
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "SUBPARTITION");
                if (!listPartition.getName().toUpperCase().startsWith("SYS_")) {
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(listPartition));
                }
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "VALUES");
                CSSBCreateRenameTable.appendStringWithSpace(buffer, '(');
                CSSBCreateRenameTable.appendStringWithSpace(buffer, listPartition.getValueList());
                CSSBCreateRenameTable.appendStringWithSpace(buffer, ')');
                this.appendPartStorage(buffer, listPartition, prettyPrint);
            }
            CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateRenameTable.appendStringWithSpace(buffer, ')');
        }
        if (!first) {
            CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateRenameTable.appendStringWithSpace(buffer, ')');
        }
    }

    private boolean appendHashSubPartitions(StringBuffer buffer, PartitionOraclev9i partition, PartitionListOraclev9i partitionList, boolean prettyPrint) {
        boolean result = false;
        if (partitionList.getUseSubpartStorageTemplate().equalsIgnoreCase("NO")) {
            HashPartitionSetOracle hashPartitionSet = ((StorageDesignOracle)partition.getStorageDesign()).getHashPartitionSet();
            Iterator setIt = hashPartitionSet.iterator();
            boolean first = true;
            while (setIt.hasNext()) {
                HashPartitionOraclev9i hashPartition = (HashPartitionOraclev9i)setIt.next();
                if (hashPartition.getSubPartitionOf() != partition) continue;
                if (first) {
                    CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, '(');
                    first = false;
                    result = true;
                } else {
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, ',');
                    CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
                }
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "SUBPARTITION");
                if (!hashPartition.getName().toUpperCase().startsWith("SYS_")) {
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(hashPartition));
                }
                this.appendPartStorage(buffer, hashPartition, prettyPrint);
            }
            if (!first) {
                CSSBCreateRenameTable.appendStringWithSpace(buffer, ')');
            }
        }
        return result;
    }

    private boolean appendHashPartitions(StringBuffer buffer, TableProxyOraclev9i tableProxy, boolean prettyPrint) {
        boolean result = false;
        Iterator it = tableProxy.getPartitions().iterator();
        boolean first = true;
        while (it.hasNext()) {
            HashPartitionOraclev9i hashPartition = (HashPartitionOraclev9i)it.next();
            if (first) {
                CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateRenameTable.appendStringWithSpace(buffer, '(');
                CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
                first = false;
                result = true;
            } else {
                CSSBCreateRenameTable.appendStringWithSpace(buffer, ',');
                CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
            }
            CSSBCreateRenameTable.appendStringWithSpace(buffer, "PARTITION");
            if (!hashPartition.getName().toUpperCase().startsWith("SYS_")) {
                CSSBCreateRenameTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(hashPartition));
            }
            if (hashPartition.getTableSpace() != null && this.storageDesign.getDesign().getSettings().isIncludeTablespaceInDDL()) {
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "TABLESPACE");
                CSSBCreateRenameTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(hashPartition.getTableSpace()));
            }
            this.appendHashPLobItems(buffer, hashPartition, prettyPrint);
        }
        if (!first) {
            CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateRenameTable.appendStringWithSpace(buffer, ')');
        }
        return result;
    }

    private void appendHashPLobItems(StringBuffer buffer, HashPartitionOraclev9i hashPartition, boolean prettyPrint) {
        HashPartitionLobItemSetOraclev9i hashPLobItemSet = (HashPartitionLobItemSetOraclev9i)((StorageDesignOraclev9i)hashPartition.getStorageDesign()).getHashPartitionLobItemSet();
        for (HashPartitionLobItemOraclev9i hashPLobItem : hashPLobItemSet) {
            if (hashPLobItem.getHashPartition() == null || !hashPLobItem.getHashPartition().toString().equalsIgnoreCase(hashPartition.toString())) continue;
            CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 2);
            this.appendLobPartitioningStorage(buffer, hashPLobItem, hashPLobItem.getLobColumn(), "", hashPLobItem.getTableSpace(), prettyPrint);
        }
    }

    private void appendLobPartitioningStorage(StringBuffer buffer, StorageObject lobObject, Object column, String lobSegName, TableSpaceOracle tableSpace, boolean prettyPrint) {
        CSSBCreateRenameTable.appendStringWithSpace(buffer, "LOB");
        CSSBCreateRenameTable.appendStringWithSpace(buffer, '(');
        if (column instanceof ColumnProxy) {
            CSSBCreateRenameTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedName((ColumnProxy)column));
        } else {
            String columnName = "";
            if (column != null) {
                columnName = column.toString();
            }
            if (columnName.length() > 0) {
                CSSBCreateRenameTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(columnName));
            } else {
                CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 0);
                buffer.append("--  ERROR: Lob ");
                buffer.append(lobObject.getName());
                buffer.append(" has no Column specified");
                this.getStatus().incrementErrors();
            }
        }
        CSSBCreateRenameTable.appendStringWithSpace(buffer, ')');
        CSSBCreateRenameTable.appendStringWithSpace(buffer, "STORE AS");
        if (!lobSegName.equalsIgnoreCase("")) {
            CSSBCreateRenameTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(lobSegName));
        } else if (tableSpace == null) {
            CSSBCreateRenameTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(lobObject));
        }
        if (tableSpace != null && this.storageDesign.getDesign().getSettings().isIncludeTablespaceInDDL()) {
            CSSBCreateRenameTable.appendStringWithSpace(buffer, '(');
            CSSBCreateRenameTable.appendStringWithSpace(buffer, "TABLESPACE");
            CSSBCreateRenameTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tableSpace));
            CSSBCreateRenameTable.appendStringWithSpace(buffer, ')');
        }
    }

    private void appendLobStorage(StringBuffer buffer, LobStorageOraclev9i lobStorage, boolean prettyPrint) {
        if (lobStorage != null) {
            CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateRenameTable.appendStringWithSpace(buffer, "LOB");
            CSSBCreateRenameTable.appendStringWithSpace(buffer, '(');
            CSSBCreateRenameTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(lobStorage.getColumn()));
            CSSBCreateRenameTable.appendStringWithSpace(buffer, ')');
            CSSBCreateRenameTable.appendStringWithSpace(buffer, "STORE AS");
            CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateRenameTable.appendStringWithSpace(buffer, '(');
            CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 2);
            if (lobStorage.getTableSpace() != null && this.storageDesign.getDesign().getSettings().isIncludeTablespaceInDDL()) {
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "TABLESPACE");
                CSSBCreateRenameTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(lobStorage.getTableSpace()));
                CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 2);
            }
            if (this.storageDesign.getDesign().getSettings().isIncludeStorageInDDL()) {
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "STORAGE");
                CSSBCreateRenameTable.appendStringWithSpace(buffer, '(');
                CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 3);
                boolean props = false;
                if (lobStorage.getSCInitialExtent() > 0L && this.storageDesign.getDesign().getSettings().isIncludeInitialExtentInDDL()) {
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, "INITIAL");
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, lobStorage.getSCInitialExtent());
                    CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 3);
                    props = true;
                }
                if (lobStorage.getSCNextExtent() > 0L && this.storageDesign.getDesign().getSettings().isIncludeNextExtentInDDL()) {
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, "NEXT");
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, lobStorage.getSCNextExtent());
                    CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 3);
                    props = true;
                }
                if (this.storageDesign.getDesign().getSettings().isIncludePctIncreaseInDDL()) {
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, "PCTINCREASE");
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, lobStorage.getSCPctIncrease());
                    CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 3);
                    props = true;
                }
                if (this.storageDesign.getDesign().getSettings().isIncludeMinExtentsInDDL()) {
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, "MINEXTENTS");
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, lobStorage.getSCMinExtents());
                    CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 3);
                    props = true;
                }
                if (this.storageDesign.getDesign().getSettings().isIncludeMaxExtentsInDDL()) {
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, "MAXEXTENTS");
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, lobStorage.getSCMaxExtents());
                    CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 3);
                    props = true;
                }
                if (this.storageDesign.getDesign().getSettings().isIncludeFreeListsInDDL()) {
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, "FREELISTS");
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, lobStorage.getSCFreeLists());
                    props = true;
                }
                if (this.storageDesign.getDesign().getSettings().isIncludeFreeListGroupsInDDL() && lobStorage.getSCFreelistGroups() > 1) {
                    CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 3);
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, "FREELIST");
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, "GROUPS");
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, lobStorage.getSCFreelistGroups());
                    props = true;
                }
                if (this.storageDesign.getDesign().getSettings().isIncludeBufferPoolInDDL()) {
                    CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 3);
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, "BUFFER_POOL");
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, lobStorage.getSCBufferPool());
                    props = true;
                }
                if (props) {
                    CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 2);
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, ')');
                    CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 2);
                } else {
                    buffer = buffer.replace(buffer.lastIndexOf("STORAGE ("), buffer.length(), "");
                }
            }
            if (lobStorage.getChunk() > 0) {
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "CHUNK");
                CSSBCreateRenameTable.appendStringWithSpace(buffer, lobStorage.getChunk());
                CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 2);
            }
            if (lobStorage.getOldVersions().equalsIgnoreCase("RETENTION")) {
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "RETENTION");
            } else {
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "PCTVERSION");
                CSSBCreateRenameTable.appendStringWithSpace(buffer, lobStorage.getPCTVersion());
            }
            if (lobStorage.getFreepools() > 0 && lobStorage.getSCFreelistGroups() <= 1) {
                CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 2);
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "FREEPOOLS");
                CSSBCreateRenameTable.appendStringWithSpace(buffer, lobStorage.getFreepools());
            }
            this.appendStorageInRow(buffer, this.tableProxy, lobStorage.getStorageInRow(), prettyPrint);
            CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 2);
            CSSBCreateRenameTable.appendStringWithSpace(buffer, lobStorage.getCache());
            if (!"CACHE".equalsIgnoreCase(lobStorage.getCache()) && this.storageDesign.getDesign().getSettings().isIncludeLoggingInDDL()) {
                if ("YES".equalsIgnoreCase(lobStorage.getLogging())) {
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, "LOGGING");
                } else if ("NO".equalsIgnoreCase(lobStorage.getLogging())) {
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, "NOLOGGING");
                }
            }
            CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateRenameTable.appendStringWithSpace(buffer, ')');
        }
    }

    private void appendSegment(StringBuffer buffer, SegmentOraclev9i segment, boolean pctUsed, boolean prettyPrint, TableSpaceOracle tableSpace, String logging) {
        if (segment != null) {
            if (this.storageDesign.getDesign().getSettings().isIncludeStorageInDDL()) {
                if (this.storageDesign.getDesign().getSettings().isIncludePctFreeInDDL()) {
                    CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 2);
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, "PCTFREE");
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, segment.getPCTFree());
                }
                if (pctUsed && this.storageDesign.getDesign().getSettings().isIncludePctUsedInDDL()) {
                    CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 2);
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, "PCTUSED");
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, segment.getPCTUsed());
                }
                if (this.storageDesign.getDesign().getSettings().isIncludeInitransInDDL()) {
                    if (segment.getInitrans() > 1) {
                        CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 2);
                        CSSBCreateRenameTable.appendStringWithSpace(buffer, "INITRANS");
                        CSSBCreateRenameTable.appendStringWithSpace(buffer, segment.getInitrans());
                    } else if (this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL()) {
                        CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 2);
                        CSSBCreateRenameTable.appendStringWithSpace(buffer, "INITRANS");
                        CSSBCreateRenameTable.appendStringWithSpace(buffer, "1");
                    }
                    if (segment.getMaxTrans() > 1) {
                        CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 2);
                        CSSBCreateRenameTable.appendStringWithSpace(buffer, "MAXTRANS");
                        CSSBCreateRenameTable.appendStringWithSpace(buffer, segment.getMaxTrans());
                    } else if (this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL()) {
                        CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 2);
                        CSSBCreateRenameTable.appendStringWithSpace(buffer, "MAXTRANS");
                        CSSBCreateRenameTable.appendStringWithSpace(buffer, "255");
                    }
                }
            }
            if (this.storageDesign.getDesign().getSettings().isIncludeTablespaceInDDL()) {
                if (tableSpace != null) {
                    CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 2);
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, "TABLESPACE");
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tableSpace));
                } else if (segment.getTableSpace() != null) {
                    CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 2);
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, "TABLESPACE");
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(segment.getTableSpace()));
                }
            }
            if (this.storageDesign.getDesign().getSettings().isIncludeLoggingInDDL() && !"".equals(logging)) {
                CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 2);
                if (logging.equalsIgnoreCase("NO")) {
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, "NOLOGGING");
                } else {
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, "LOGGING");
                }
            }
            if (this.storageDesign.getDesign().getSettings().isIncludeStorageInDDL()) {
                CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 2);
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "STORAGE");
                CSSBCreateRenameTable.appendStringWithSpace(buffer, '(');
                CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 2);
                boolean props = false;
                if (segment.getSCInitialExtent() > 0L && this.storageDesign.getDesign().getSettings().isIncludeInitialExtentInDDL()) {
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, "INITIAL");
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, segment.getSCInitialExtent());
                    CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 2);
                    props = true;
                }
                if (segment.getSCNextExtent() > 0L && this.storageDesign.getDesign().getSettings().isIncludeNextExtentInDDL()) {
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, "NEXT");
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, segment.getSCNextExtent());
                    CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 2);
                    props = true;
                }
                if (this.storageDesign.getDesign().getSettings().isIncludePctIncreaseInDDL()) {
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, "PCTINCREASE");
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, segment.getSCPctIncrease());
                    CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 2);
                    props = true;
                }
                if (this.storageDesign.getDesign().getSettings().isIncludeMinExtentsInDDL()) {
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, "MINEXTENTS");
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, segment.getSCMinExtents());
                    CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 2);
                    props = true;
                }
                if (this.storageDesign.getDesign().getSettings().isIncludeMaxExtentsInDDL()) {
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, "MAXEXTENTS");
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, segment.getSCMaxExtents());
                    CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 2);
                    props = true;
                }
                if (this.storageDesign.getDesign().getSettings().isIncludeFreeListsInDDL()) {
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, "FREELISTS");
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, segment.getSCFreeLists());
                    CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 2);
                    props = true;
                }
                if (this.storageDesign.getDesign().getSettings().isIncludeFreeListGroupsInDDL()) {
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, "FREELIST");
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, "GROUPS");
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, segment.getSCFreelistGroups());
                    CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 2);
                    props = true;
                }
                if (this.storageDesign.getDesign().getSettings().isIncludeBufferPoolInDDL()) {
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, "BUFFER_POOL");
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, segment.getSCBufferPool());
                    CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
                    props = true;
                }
                if (props) {
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, ')');
                } else {
                    buffer = buffer.replace(buffer.lastIndexOf("STORAGE ("), buffer.length(), "");
                }
            }
        }
    }

    private void appendTableSpace(StringBuffer buffer, TableProxyOraclev9i tableProxy, boolean prettyPrint) {
        TableSpaceOracle tableSpace;
        if (this.storageDesign.getDesign().getSettings().isIncludeTablespaceInDDL() && (tableSpace = tableProxy.getTableSpace()) != null && !"[NONE]".equalsIgnoreCase(tableSpace.getName())) {
            CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateRenameTable.appendStringWithSpace(buffer, "TABLESPACE");
            CSSBCreateRenameTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(tableSpace));
        }
    }

    private void appendOrganization(StringBuffer buffer, TableProxyOraclev9i tableProxy, boolean prettyPrint) {
        boolean indexOrg = "INDEX".equalsIgnoreCase(tableProxy.getOrganization());
        if (indexOrg) {
            CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateRenameTable.appendStringWithSpace(buffer, "ORGANIZATION");
            CSSBCreateRenameTable.appendStringWithSpace(buffer, "INDEX");
        } else if (this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL() && !((Table)tableProxy.getObject()).isBST()) {
            CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateRenameTable.appendStringWithSpace(buffer, "ORGANIZATION");
            CSSBCreateRenameTable.appendStringWithSpace(buffer, "HEAP");
        }
        if (tableProxy.getSegment() == null) {
            this.appendTableSpace(buffer, tableProxy, prettyPrint);
            if (this.storageDesign.getDesign().getSettings().isIncludeLoggingInDDL()) {
                if ("YES".equalsIgnoreCase(tableProxy.getLogging())) {
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, "LOGGING");
                } else if ("NO".equalsIgnoreCase(tableProxy.getLogging())) {
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, "NOLOGGING");
                }
            }
        } else {
            this.appendSegment(buffer, (SegmentOraclev9i)tableProxy.getSegment(), !indexOrg, prettyPrint, tableProxy.getTableSpace(), tableProxy.getLogging());
        }
        if (indexOrg) {
            if (tableProxy.getIOTMappingTable().equalsIgnoreCase("YES")) {
                CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "MAPPING TABLE");
            }
            if (tableProxy.getIotPctThreshold() > 0) {
                CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "PCTTHRESHOLD");
                CSSBCreateRenameTable.appendStringWithSpace(buffer, tableProxy.getIotPctThreshold());
            } else if (this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL()) {
                CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "PCTTHRESHOLD");
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "50");
            }
            if (tableProxy.getIotCompress() > 0) {
                CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "COMPRESS");
                CSSBCreateRenameTable.appendStringWithSpace(buffer, tableProxy.getIotCompress());
            } else if (this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL()) {
                CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "NOCOMPRESS");
            }
            TableSpaceOracle overflowTableSpace = tableProxy.getIotOverflowTablespace();
            String overflowLogging = tableProxy.getIotOverflowLogging();
            SegmentOraclev9i overflowSegment = (SegmentOraclev9i)tableProxy.getIotOverflowSegment();
            ColumnProxy includingColumn = tableProxy.getIotIncluding();
            if (overflowTableSpace != null || !overflowLogging.equals("") || overflowSegment != null || includingColumn != null) {
                CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
                if (includingColumn != null) {
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, "INCLUDING");
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(includingColumn));
                    CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
                }
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "OVERFLOW");
                if (overflowTableSpace == null) {
                    overflowTableSpace = tableProxy.getTableSpace();
                }
                if (overflowLogging.equals("")) {
                    overflowLogging = tableProxy.getLogging();
                }
                if (overflowSegment != null) {
                    this.appendSegment(buffer, overflowSegment, true, prettyPrint, overflowTableSpace, overflowLogging);
                } else {
                    if (overflowTableSpace != null && this.storageDesign.getDesign().getSettings().isIncludeTablespaceInDDL()) {
                        CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
                        CSSBCreateRenameTable.appendStringWithSpace(buffer, "TABLESPACE");
                        CSSBCreateRenameTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(overflowTableSpace));
                    }
                    if (this.storageDesign.isOpen() && this.storageDesign.getDesign().getSettings().isIncludeLoggingInDDL()) {
                        if ("NO".equalsIgnoreCase(overflowLogging)) {
                            CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
                            CSSBCreateRenameTable.appendStringWithSpace(buffer, "NOLOGGING");
                        } else if ("YES".equalsIgnoreCase(overflowLogging)) {
                            CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
                            CSSBCreateRenameTable.appendStringWithSpace(buffer, "LOGGING");
                        }
                    }
                }
            }
        } else if (tableProxy.getDataSegmentCompression().equalsIgnoreCase("YES")) {
            CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateRenameTable.appendStringWithSpace(buffer, "COMPRESS");
        } else if (this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL()) {
            CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateRenameTable.appendStringWithSpace(buffer, "NOCOMPRESS");
        }
        if ("YES".equalsIgnoreCase(tableProxy.getPartitioned())) {
            CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
            if ("ENABLE".equalsIgnoreCase(tableProxy.getParttitionedRowMovement())) {
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "ENABLE");
            } else {
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "DISABLE");
            }
            CSSBCreateRenameTable.appendStringWithSpace(buffer, "ROW MOVEMENT");
        }
    }

    private void appendCluster(StringBuffer buffer, TableProxyOraclev9i tableProxy, boolean prettyPrint) {
        ClusterOraclev9i cluster = (ClusterOraclev9i)tableProxy.getCluster();
        if (cluster != null) {
            CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateRenameTable.appendStringWithSpace(buffer, "CLUSTER");
            CSSBCreateRenameTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(cluster));
            if (!"".equalsIgnoreCase(tableProxy.getClusterColumns())) {
                CSSBCreateRenameTable.appendStringWithSpace(buffer, '(');
                CSSBCreateRenameTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedColumnNamesFromIDs(tableProxy.getClusterColumns()));
                CSSBCreateRenameTable.appendStringWithSpace(buffer, ')');
            }
        } else {
            this.appendOrganization(buffer, tableProxy, prettyPrint);
            Table table = (Table)this.tableObj.getObject();
            if (!table.isSpatialTable()) {
                for (int i = 0; i < tableProxy.getLobStorages().size(); ++i) {
                    this.appendLobStorage(buffer, (LobStorageOraclev9i)tableProxy.getLobStorages().getElement(i), prettyPrint);
                }
            }
        }
    }

    private void appendUniqueDefinition(StringBuffer oldbuffer, TableProxyOracle tableProxy, UniqueOraclev9i unique, boolean prettyPrint, StringBuffer columnList) {
        StringBuffer buffer = new StringBuffer();
        String advancedComment = "";
        CSSBCreateRenameTable.appendNewLine(oldbuffer, prettyPrint, 0);
        if (unique.isCommentChanged() && !"".equalsIgnoreCase(unique.getComment())) {
            this.appendComment(oldbuffer, unique);
        } else if (!"".equalsIgnoreCase(unique.getObject().getComment())) {
            this.appendComment(oldbuffer, unique.getObject());
        }
        String uniqueName = unique.getName();
        if (uniqueName.length() > tableProxy.getMaxNameLength()) {
            CSSBCreateRenameTable.appendNewLine(oldbuffer, prettyPrint, 0);
            CSSBCreateRenameTable.appendStringWithSpace(oldbuffer, "--  ERROR: UK name length exceeds maximum allowed length(" + tableProxy.getMaxNameLength() + ")");
            CSSBCreateRenameTable.appendNewLine(oldbuffer, prettyPrint, 0);
            this.getStatus().incrementErrors();
        }
        CSSBCreateRenameTable.appendStringWithSpace(buffer, "ALTER");
        CSSBCreateRenameTable.appendStringWithSpace(buffer, "TABLE");
        CSSBCreateRenameTable.appendStringWithSpace(buffer, CSSBCreateRenameTable.getFormattedTableName(this.tableObj, this.storageDesign));
        CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
        CSSBCreateRenameTable.appendStringWithSpace(buffer, "ADD");
        if (!uniqueName.startsWith("SYS_")) {
            CSSBCreateRenameTable.appendStringWithSpace(buffer, "CONSTRAINT");
            CSSBCreateRenameTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(unique));
        }
        CSSBCreateRenameTable.appendStringWithSpace(buffer, "UNIQUE");
        advancedComment = buffer.toString();
        CSSBCreateRenameTable.appendStringWithSpace(buffer, '(');
        this.appendString(buffer, columnList);
        CSSBCreateRenameTable.appendStringWithSpace(buffer, ')');
        if (!"NO".equalsIgnoreCase(unique.getDeferrable())) {
            CSSBCreateRenameTable.appendStringWithSpace(buffer, "DEFERRABLE");
            if ("DEFERRED".equalsIgnoreCase(unique.getInitially())) {
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "INITIALLY");
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "DEFERRED");
            } else if (this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL()) {
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "INITIALLY");
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "IMMEDIATE");
            }
        } else if (this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL()) {
            CSSBCreateRenameTable.appendStringWithSpace(buffer, "NOT");
            CSSBCreateRenameTable.appendStringWithSpace(buffer, "DEFERRABLE");
        }
        if (!"NO".equalsIgnoreCase(unique.getUsingIndex())) {
            this.appendUniqueUsingIndex(buffer, unique, prettyPrint);
        }
        if (this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL()) {
            if ("YES".equalsIgnoreCase(unique.getEnable())) {
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "ENABLE");
            } else {
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "DISABLE");
            }
            if ("YES".equalsIgnoreCase(unique.getValidate())) {
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "VALIDATE");
            } else {
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "NOVALIDATE");
            }
        } else {
            if (!"YES".equalsIgnoreCase(unique.getEnable())) {
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "DISABLE");
                if ("YES".equalsIgnoreCase(unique.getValidate())) {
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, "VALIDATE");
                }
            }
            if (!"YES".equalsIgnoreCase(unique.getValidate())) {
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "NOVALIDATE");
            }
        }
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        CSSBCreateRenameTable.appendLineFinisher(buffer, prettyPrint);
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        this.getStatus().incrementAlterTable();
        if (unique.getRely().equals("YES")) {
            CSSBCreateRenameTable.appendStringWithSpace(buffer, "ALTER");
            CSSBCreateRenameTable.appendStringWithSpace(buffer, "TABLE");
            CSSBCreateRenameTable.appendStringWithSpace(buffer, CSSBCreateRenameTable.getFormattedTableName(this.tableObj, this.storageDesign));
            CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateRenameTable.appendStringWithSpace(buffer, "MODIFY");
            CSSBCreateRenameTable.appendStringWithSpace(buffer, "CONSTRAINT");
            CSSBCreateRenameTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(unique));
            advancedComment = buffer.toString();
            CSSBCreateRenameTable.appendStringWithSpace(buffer, "RELY");
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 0);
            CSSBCreateRenameTable.appendLineFinisher(buffer, prettyPrint);
            CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 0);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            this.getStatus().incrementAlterTable();
        }
        if (unique.getExceptionsTable() != null && "YES".equalsIgnoreCase(unique.getEnable())) {
            CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateRenameTable.appendStringWithSpace(buffer, "ALTER");
            CSSBCreateRenameTable.appendStringWithSpace(buffer, "TABLE");
            CSSBCreateRenameTable.appendStringWithSpace(buffer, CSSBCreateRenameTable.getFormattedTableName(this.tableObj, this.storageDesign));
            advancedComment = buffer.toString();
            CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateRenameTable.appendStringWithSpace(buffer, "MODIFY");
            CSSBCreateRenameTable.appendStringWithSpace(buffer, "CONSTRAINT");
            CSSBCreateRenameTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(unique));
            CSSBCreateRenameTable.appendStringWithSpace(buffer, "ENABLE EXCEPTIONS INTO");
            CSSBCreateRenameTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedLongNameDDL(unique.getExceptionsTable()));
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 0);
            CSSBCreateRenameTable.appendLineFinisher(buffer, prettyPrint);
            this.appendToBuffer(oldbuffer, buffer, advancedComment);
            this.getStatus().incrementAlterTable();
        }
    }

    private void appendPermissions(StringBuffer oldbuffer, TableProxyOracle tableProxy, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        String advancedComments = "";
        PermissionsSetOracle permissionsSet = ((StorageDesignOracle)tableProxy.getStorageDesign()).getPermissionsSet();
        for (PermissionsOraclev9i permissions : permissionsSet) {
            if (permissions.getTable() != null && permissions.getTable().equals(tableProxy)) {
                if (!permissions.getPrivileges().equalsIgnoreCase("")) {
                    CSSBCreateRenameTable.appendNewLine(oldbuffer, prettyPrint, 0);
                    CSSBCreateRenameTable.appendNewLine(oldbuffer, prettyPrint, 0);
                    this.appendComment(oldbuffer, permissions);
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, "GRANT");
                    this.appendPrivileges(buffer, permissions);
                    this.appendObject(buffer, permissions, prettyPrint);
                    this.appendTo(buffer, permissions, this.storageDesign);
                    this.appendHierrarchyOption(buffer, permissions, prettyPrint);
                    advancedComments = "GRANT ON " + this.getPermissionsON(permissions) + " TO " + this.getPermissionsTO(permissions);
                    this.appendToBuffer(oldbuffer, buffer, advancedComments);
                    CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 0);
                    buffer.append(';');
                    CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 0);
                    this.appendToBuffer(oldbuffer, buffer, advancedComments);
                }
                if (!permissions.getPrivilegesWithGrantOption().equalsIgnoreCase("")) {
                    CSSBCreateRenameTable.appendNewLine(oldbuffer, prettyPrint, 0);
                    CSSBCreateRenameTable.appendNewLine(oldbuffer, prettyPrint, 0);
                    this.appendComment(oldbuffer, permissions);
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, "GRANT");
                    this.appendPrivilegesWithGrantOption(buffer, permissions);
                    this.appendObject(buffer, permissions, prettyPrint);
                    this.appendTo(buffer, permissions, this.storageDesign);
                    this.appendGrantOption(buffer, permissions);
                    this.appendHierrarchyOption(buffer, permissions, prettyPrint);
                    advancedComments = "GRANT ON " + this.getPermissionsON(permissions) + " TO " + this.getPermissionsTO(permissions);
                    this.appendToBuffer(oldbuffer, buffer, advancedComments);
                    CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 0);
                    buffer.append(';');
                    CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 0);
                    this.appendToBuffer(oldbuffer, buffer, advancedComments);
                }
            }
            if (permissions.getColumnsTable() == null || !permissions.getColumnsTable().equals(tableProxy)) continue;
            for (int i = 0; i < 2; ++i) {
                List<String> colEntries = i == 0 ? permissions.getColumnEntries() : permissions.getColumnWithGrantOptionEntries();
                block2: for (String colEntry : colEntries) {
                    int commaIndex = colEntry.indexOf(44);
                    if (commaIndex <= -1) continue;
                    String colName = colEntry.substring(0, commaIndex).trim();
                    String colPriv = colEntry.substring(commaIndex + 1).trim();
                    if (colName.length() <= 0 || colPriv.length() <= 0) continue;
                    List columns = this.tableObj.getChildObjects(0);
                    for (CompareObjectSelection columnSel : columns) {
                        ModelIDObject column = columnSel.getObject();
                        if (column == null || !column.getName().equals(colName)) continue;
                        if (columnSel.canBeCreate() && !columnSel.isSelected()) continue block2;
                        CSSBCreateRenameTable.appendNewLine(oldbuffer, prettyPrint, 0);
                        CSSBCreateRenameTable.appendNewLine(oldbuffer, prettyPrint, 0);
                        CSSBCreateRenameTable.appendStringWithSpace(buffer, "GRANT");
                        CSSBCreateRenameTable.appendStringWithSpace(buffer, colPriv);
                        CSSBCreateRenameTable.appendStringWithSpace(buffer, '(');
                        CSSBCreateRenameTable.appendStringWithSpace(buffer, CSSBCreateRenameTable.getFormattedSelectedName(columnSel, this.storageDesign));
                        CSSBCreateRenameTable.appendStringWithSpace(buffer, ')');
                        this.appendObject(buffer, permissions, prettyPrint);
                        this.appendTo(buffer, permissions, this.storageDesign);
                        if (i > 0) {
                            this.appendGrantOption(buffer, permissions);
                        }
                        advancedComments = buffer.toString();
                        this.appendToBuffer(oldbuffer, buffer, advancedComments);
                        CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 0);
                        buffer.append(';');
                        CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 0);
                        this.appendToBuffer(oldbuffer, buffer, advancedComments);
                        continue block2;
                    }
                }
            }
        }
    }

    private String getPermissionsTO(PermissionsOraclev9i permissions) {
        if (permissions.getUser() != null) {
            return permissions.getUser().getName();
        }
        if (permissions.getRole() != null) {
            return permissions.getRole().getName();
        }
        return "";
    }

    private String getPermissionsON(PermissionsOraclev9i permissions) {
        if (permissions.getTable() != null) {
            return permissions.getTable().getLongNameDDL();
        }
        if (permissions.getColumnsTable() != null) {
            return permissions.getColumnsTable().getLongNameDDL();
        }
        return "";
    }

    private void appendPrivileges(StringBuffer buffer, PermissionsOraclev9i permissions) {
        buffer.append(permissions.getPrivileges());
    }

    private void appendPrivilegesWithGrantOption(StringBuffer buffer, PermissionsOraclev9i permissions) {
        buffer.append(permissions.getPrivilegesWithGrantOption());
    }

    private void appendObject(StringBuffer buffer, PermissionsOraclev9i permissions, boolean prettyPrint) {
        if (permissions.getTable() != null || permissions.getColumnsTable() != null) {
            CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateRenameTable.appendStringWithSpace(buffer, "ON");
            CSSBCreateRenameTable.appendStringWithSpace(buffer, CSSBCreateRenameTable.getFormattedTableName(this.tableObj, this.storageDesign));
        }
    }

    private void appendGrantOption(StringBuffer buffer, PermissionsOraclev9i permissions) {
        if (permissions.getRole() == null) {
            CSSBCreateRenameTable.appendStringWithSpace(buffer, "WITH GRANT OPTION");
        }
    }

    private void appendHierrarchyOption(StringBuffer buffer, PermissionsOraclev9i permissions, boolean prettyPrint) {
        if ("YES".equalsIgnoreCase(permissions.getHierarchyOption())) {
            CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateRenameTable.appendStringWithSpace(buffer, "WITH HIERARCHY OPTION");
        }
    }

    private void appendIndexes(StringBuffer oldbuffer, TableProxyOracle tableProxy, CompareObjectSelection engObject, boolean prettyPrint) {
        this.appendIndexes(oldbuffer, engObject, prettyPrint);
        this.appendPKAndUK(oldbuffer, engObject, prettyPrint);
    }

    private void appendTableLevelCheckConstraints(StringBuffer oldbuffer, TableSelection tableSel, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        List tableConstraints = tableSel.getChildObjects(4);
        for (CompareObjectSelection constraintObj : tableConstraints) {
            TableCheckConstraintOracle constraint;
            String rule;
            TableLevelConstraint tlc;
            TableProxyOracle tableProxy;
            TableComparator tableComp = (TableComparator)tableSel.getPropertiesComparator();
            if (!constraintObj.isSelected()) {
                constraintObj = constraintObj.getCorrespondentNode();
                tableProxy = (TableProxyOracle)tableComp.getTargetTableProxy();
            } else {
                tableProxy = (TableProxyOracle)tableComp.getSourceTableProxy();
            }
            if ((tlc = (TableLevelConstraint)constraintObj.getObject()) == null || tableProxy == null || !tlc.isGenerateInDDL() || "".equals(rule = tlc.getRule()) || (constraint = tableProxy.getTableConstraint(tlc)) == null) continue;
            String cname = constraint.getName().toUpperCase();
            if (cname.startsWith("SYS_") || cname.startsWith("NULL SET GENERATED_")) {
                cname = "";
            }
            CSSBCreateRenameTable.appendNewLine(oldbuffer, prettyPrint, 0);
            CSSBCreateRenameTable.appendNewLine(oldbuffer, prettyPrint, 0);
            if (cname.length() > constraint.getMaxNameLength()) {
                CSSBCreateRenameTable.appendNewLine(oldbuffer, prettyPrint, 0);
                CSSBCreateRenameTable.appendStringWithSpace(oldbuffer, "--  ERROR: Table constraint name length exceeds maximum allowed length(" + constraint.getMaxNameLength() + ")");
                CSSBCreateRenameTable.appendNewLine(oldbuffer, prettyPrint, 0);
                this.getStatus().incrementErrors();
            }
            String formatedConstraintName = this.storageDesign.getFormatedName(constraint);
            String formattedLongName = CSSBCreateRenameTable.getFormattedTableName(this.tableObj, this.storageDesign);
            CSSBCreateRenameTable.appendStringWithSpace(buffer, "ALTER");
            CSSBCreateRenameTable.appendStringWithSpace(buffer, "TABLE");
            CSSBCreateRenameTable.appendStringWithSpace(buffer, formattedLongName);
            CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
            CSSBCreateRenameTable.appendStringWithSpace(buffer, "ADD");
            if (!"".equals(cname)) {
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "CONSTRAINT");
                CSSBCreateRenameTable.appendStringWithSpace(buffer, formatedConstraintName);
                CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
            }
            CSSBCreateRenameTable.appendStringWithSpace(buffer, "CHECK");
            CSSBCreateRenameTable.appendString(buffer, '(');
            CSSBCreateRenameTable.appendString(buffer, constraint.getTableConstraint().getRule());
            CSSBCreateRenameTable.appendString(buffer, ')');
            this.appendTableConstraintState(buffer, constraint, prettyPrint);
            String advancedComments = "Alter Table " + formattedLongName + " Add Constraint " + formatedConstraintName;
            this.appendToBuffer(oldbuffer, buffer, advancedComments);
            CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 0);
            buffer.append(';');
            CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 0);
            this.appendToBuffer(oldbuffer, buffer, "");
            this.getStatus().incrementAlterTable();
        }
    }

    private void appendColumnCheckConstraints(StringBuffer oldbuffer, boolean prettyPrint) {
        if (!this.storageDesign.getDesign().getSettings().isGenerateInlineColumnCC()) {
            TableComparator tableComp = (TableComparator)this.tableObj.getPropertiesComparator();
            TableProxyOraclev9i sourceTableProxy = (TableProxyOraclev9i)tableComp.getSourceTableProxy();
            TableProxyOraclev9i targetTableProxy = (TableProxyOraclev9i)tableComp.getTargetTableProxy();
            List columns = this.tableObj.getChildObjects(0);
            for (CompareObjectSelection columnSelection : columns) {
                if (columnSelection.canBeCreate() && !columnSelection.isSelected() || columnSelection.canBeDrop() && columnSelection.isSelected()) continue;
                Column column = (Column)columnSelection.getObject();
                ColumnProxyOraclev9i columnProxy = null;
                boolean targetSelected = false;
                if (column == null || !columnSelection.isSelected()) {
                    column = (Column)columnSelection.getCorrespondentNode().getObject();
                    if (column == null) continue;
                    targetSelected = true;
                    columnProxy = (ColumnProxyOraclev9i)targetTableProxy.getColumnProxy(column.getObjectID());
                } else {
                    columnProxy = (ColumnProxyOraclev9i)sourceTableProxy.getColumnProxy(column.getObjectID());
                }
                StringBuffer tempBuffer = new StringBuffer();
                CSSBCreateRenameTableOraclev10g.appendColumnConstraints(tempBuffer, column, columnProxy, prettyPrint, columnSelection);
                if (tempBuffer.length() <= 0) continue;
                StringBuffer buffer = new StringBuffer();
                String formattedLongName = CSSBCreateRenameTable.getFormattedTableName(this.tableObj, this.storageDesign);
                CSSBCreateRenameTable.appendNewLine(oldbuffer, prettyPrint, 0);
                CSSBCreateRenameTable.appendNewLine(oldbuffer, prettyPrint, 0);
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "ALTER");
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "TABLE");
                CSSBCreateRenameTable.appendStringWithSpace(buffer, formattedLongName);
                CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateRenameTable.appendStringWithSpace(buffer, "ADD");
                this.appendString(buffer, tempBuffer);
                String advancedComments = "Alter Table " + formattedLongName + " Add Constraint";
                this.appendToBuffer(oldbuffer, buffer, advancedComments);
                CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 0);
                buffer.append(';');
                CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 0);
                this.appendToBuffer(oldbuffer, buffer, "");
                this.getStatus().incrementAlterTable();
            }
        }
    }

    private StringBuffer getColumnsForRestore(CompareObjectSelection engObject, Index index, boolean prettyPrint, boolean getColumnSortOrder) {
        StringBuffer columnList = new StringBuffer();
        boolean notFirst = false;
        List sourceColumns = engObject.getChildObjects(0);
        block0: for (Column indexCol : index.getElementsCollection()) {
            for (CompareObjectSelection tableCol : sourceColumns) {
                ModelIDObject column = tableCol.getObject();
                if (column == null || !column.equals(indexCol)) continue;
                if (tableCol.canBeCreate() && !tableCol.isSelected() || tableCol.canBeDrop() && tableCol.getCorrespondentNode().isSelected()) continue block0;
                if (notFirst) {
                    columnList.append(',');
                    CSSBCreateRenameTable.appendNewLine(columnList, prettyPrint, 1);
                    columnList.append(' ');
                }
                String formattedColumnName = tableCol.isSelected() ? CSSBCreateRenameTable.getFormattedSelectedName(tableCol, this.storageDesign) : this.storageDesign.getFormatedName(tableCol.getCorrespondentNode().getObject());
                CSSBCreateRenameTable.appendStringWithSpace(columnList, formattedColumnName);
                if (getColumnSortOrder) {
                    CSSBCreateRenameTable.appendStringWithSpace(columnList, index.getColumnSortOrder(tableCol.getObject()));
                }
                notFirst = true;
                continue block0;
            }
        }
        return columnList;
    }

    public boolean isRenamed() {
        return this.isRenamed;
    }

    public void setRenamed(boolean isRenamed) {
        this.isRenamed = isRenamed;
    }

    private String getFormattedColumnName(CompareObjectSelection columnSelection) {
        if (!columnSelection.isSelected()) {
            StorageDesign targetStorageDesign;
            Design targetDesign;
            Column targetColumn;
            ColumnComparator comp = (ColumnComparator)columnSelection.getPropertiesComparator();
            ColumnProxy targetColumnProxy = comp.getTargetColumnProxy();
            if (targetColumnProxy == null && (targetColumn = comp.getTargetColumn()) != null && (targetDesign = targetColumn.getDesign()) != null && (targetStorageDesign = targetDesign.getStorageDesign(targetDesign.getSelectedRDBMSSite())) != null) {
                targetColumnProxy = (ColumnProxyOracle)targetStorageDesign.getColumnProxySet().getObjectByID(targetColumn.getObjectID());
            }
            if (targetColumnProxy != null) {
                return this.storageDesign.getFormatedName(targetColumnProxy);
            }
        }
        return CSSBCreateRenameTable.getFormattedSelectedName(columnSelection, this.storageDesign);
    }

    private void createExtDirectory(StringBuffer oldbuffer, TableSelection object, boolean prettyPrint) {
        Design design;
        StringBuffer buffer = new StringBuffer();
        Table table = null;
        TableProxyOracle tableProxy = null;
        if (object == null) {
            return;
        }
        if (object.getObject() instanceof Table) {
            table = (Table)object.getObject();
            design = table.getDesign();
            RDBMSSite site = design.getSelectedRDBMSSite();
            this.storageDesign = (StorageDesignOracle)design.getStorageDesign(site, table);
            tableProxy = (TableProxyOraclev9i)this.storageDesign.getTableProxySet().getProxy(table.getObjectID());
        } else if (object.getObject() instanceof TableProxyOracle) {
            tableProxy = (TableProxyOracle)object.getObject();
            table = (Table)tableProxy.getObject();
            design = table.getDesign();
            this.storageDesign = (StorageDesignOraclev9i)design.getStorageDesign(design.getSelectedRDBMSSite(), table);
        } else {
            return;
        }
        TableSelection other = (TableSelection)object.getCorrespondentNode();
        String unloadDir = other.getUnloadDirectory();
        if ("".equals(unloadDir)) {
            unloadDir = other.getObject().getDesign().getUnloadDirectory();
        }
        CSSBCreateRenameTable.appendNewLine(oldbuffer, prettyPrint, 0);
        CSSBCreateRenameTable.appendNewLine(oldbuffer, prettyPrint, 0);
        CSSBCreateRenameTable.appendStringWithSpace(buffer, "CREATE OR REPLACE DIRECTORY");
        this.directoryName = table.getName() + "_dir";
        if (this.directoryName.length() > 30) {
            this.directoryName = table.getName();
        }
        CSSBCreateRenameTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(this.directoryName));
        CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
        CSSBCreateRenameTable.appendStringWithSpace(buffer, "AS");
        CSSBCreateRenameTable.appendStringWithSpace(buffer, "'" + unloadDir + "'");
        this.appendToBuffer(oldbuffer, buffer, buffer.toString());
        CSSBCreateRenameTable.appendNewLine(oldbuffer, prettyPrint, 0);
        CSSBCreateRenameTable.appendLineFinisher(buffer, prettyPrint);
    }

    private void createExtTable(StringBuffer oldbuffer, String extTableName, TableSelection object, String fileName, boolean prettyPrint) {
        Design design;
        StringBuffer buffer = new StringBuffer();
        Table table = null;
        TableProxyOracle tableProxy = null;
        if (object == null) {
            return;
        }
        if (object.getObject() instanceof Table) {
            table = (Table)object.getObject();
            design = table.getDesign();
            RDBMSSite site = design.getSelectedRDBMSSite();
            this.storageDesign = (StorageDesignOracle)design.getStorageDesign(site, table);
            tableProxy = (TableProxyOraclev9i)this.storageDesign.getTableProxySet().getProxy(table.getObjectID());
        } else if (object.getObject() instanceof TableProxyOracle) {
            tableProxy = (TableProxyOracle)object.getObject();
            table = (Table)tableProxy.getObject();
            design = table.getDesign();
            this.storageDesign = (StorageDesignOraclev9i)design.getStorageDesign(design.getSelectedRDBMSSite(), table);
        }
        CSSBCreateRenameTable.appendStringWithSpace(buffer, "CREATE");
        CSSBCreateRenameTable.appendStringWithSpace(buffer, "TABLE");
        CSSBCreateRenameTable.appendStringWithSpace(buffer, extTableName);
        String advancedcomment = buffer.toString();
        this.appendElementListExt(buffer, tableProxy, object, prettyPrint);
        CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
        CSSBCreateRenameTable.appendStringWithSpace(buffer, "ORGANIZATION");
        CSSBCreateRenameTable.appendString(buffer, "EXTERNAL");
        CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
        CSSBCreateRenameTable.appendString(buffer, '(');
        CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 2);
        CSSBCreateRenameTable.appendString(buffer, "TYPE oracle_loader");
        CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 2);
        CSSBCreateRenameTable.appendString(buffer, "DEFAULT DIRECTORY " + this.storageDesign.getFormatedName(this.directoryName));
        CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 2);
        CSSBCreateRenameTable.appendString(buffer, "ACCESS PARAMETERS");
        CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 2);
        CSSBCreateRenameTable.appendString(buffer, '(');
        CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 3);
        CSSBCreateRenameTable.appendString(buffer, "RECORDS DELIMITED BY '|@*|\\r\\n'");
        CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 3);
        CSSBCreateRenameTable.appendString(buffer, "FIELDS TERMINATED BY '|' OPTIONALLY ENCLOSED BY '\"' NOTRIM");
        this.addColumnsAndTransforms(buffer, tableProxy, object);
        CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 2);
        CSSBCreateRenameTable.appendString(buffer, ')');
        CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 2);
        CSSBCreateRenameTable.appendString(buffer, "LOCATION");
        CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 2);
        CSSBCreateRenameTable.appendString(buffer, '(');
        CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 3);
        CSSBCreateRenameTable.appendString(buffer, "'" + fileName + ".txt'");
        CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 2);
        CSSBCreateRenameTable.appendString(buffer, ')');
        CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
        CSSBCreateRenameTable.appendString(buffer, ") REJECT LIMIT 0");
        this.appendToBuffer(oldbuffer, buffer, advancedcomment);
        CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 0);
        CSSBCreateRenameTable.appendLineFinisher(buffer, prettyPrint);
        this.appendToBuffer(oldbuffer, buffer, buffer.toString());
        this.getStatus().incrementCreateTable();
    }

    private void dropExtTable(StringBuffer oldbuffer, String tableName, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        CSSBCreateRenameTable.appendNewLine(oldbuffer, prettyPrint, 0);
        CSSBCreateRenameTable.appendNewLine(oldbuffer, prettyPrint, 0);
        CSSBCreateRenameTable.appendStringWithSpace(buffer, "DROP TABLE");
        CSSBCreateRenameTable.appendStringWithSpace(buffer, tableName);
        this.appendToBuffer(oldbuffer, buffer, buffer.toString());
        CSSBCreateRenameTable.appendLineFinisher(buffer, prettyPrint);
        this.appendToBuffer(oldbuffer, buffer, buffer.toString());
        this.getStatus().incrementDropTable();
    }

    private void dropExtDir(StringBuffer oldbuffer, boolean prettyPrint) {
        StringBuffer buffer = new StringBuffer();
        CSSBCreateRenameTable.appendNewLine(oldbuffer, prettyPrint, 0);
        CSSBCreateRenameTable.appendNewLine(oldbuffer, prettyPrint, 0);
        CSSBCreateRenameTable.appendStringWithSpace(buffer, "DROP DIRECTORY");
        CSSBCreateRenameTable.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(this.directoryName));
        this.appendToBuffer(oldbuffer, buffer, buffer.toString());
        CSSBCreateRenameTable.appendLineFinisher(buffer, prettyPrint);
        this.appendToBuffer(oldbuffer, buffer, buffer.toString());
    }

    private void appendElementListExt(StringBuffer buffer, TableProxyOracle tableProxy, TableSelection object, boolean prettyPrint) {
        List columns = object.getChildObjects(0);
        if (columns.size() > 0) {
            boolean first = true;
            for (CompareObjectSelection column : columns) {
                String dataType;
                if (column.canBeCreate() || column.canBeDrop() && column.isSelected()) continue;
                CompareObjectSelection targetColumn = column.getCorrespondentNode();
                if (first) {
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, '(');
                    first = false;
                } else {
                    CSSBCreateRenameTable.appendStringWithSpace(buffer, ',');
                }
                CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateRenameTable.appendString(buffer, ' ');
                CSSBCreateRenameTable.appendStringWithSpace(buffer, CSSBCreateRenameTable.getFormattedSelectedName(column, this.storageDesign));
                Column col = (Column)targetColumn.getObject();
                if (col == null) {
                    dataType = targetColumn.getChoosedPropertyValue(PropertiesComparator.DATA_TYPE);
                } else {
                    dataType = col.getDatatypeString(tableProxy.getStorageDesign().getRDBMSType().getName());
                    if ((dataType.equals("CHAR") || dataType.equals("NCHAR")) && this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL()) {
                        dataType = dataType + " (1)";
                    } else if (dataType.equals("UROWID") && this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL()) {
                        dataType = dataType + " (4000)";
                    }
                }
                if (dataType.equalsIgnoreCase("BFILE")) {
                    dataType = "VARCHAR2 (255 BYTE)";
                }
                CSSBCreateRenameTable.appendStringWithSpace(buffer, dataType);
            }
            if (!first) {
                CSSBCreateRenameTable.appendNewLine(buffer, prettyPrint, 1);
                CSSBCreateRenameTable.appendStringWithSpace(buffer, ')');
            }
        }
    }

    private void appendBitmapJoinIndexes(StringBuffer oldbuffer, TableProxyOraclev9i sourceProxy, boolean prettyPrint) {
        for (Object object : sourceProxy.getBjIndexes()) {
            if (this.ssbBJIndex == null) {
                this.ssbBJIndex = new SSBCreateBitmapJoinIndexOraclev9i();
            }
            if (!this.ssbBJIndex.canHandle(object)) continue;
            this.ssbBJIndex.doAppendBJIndex(oldbuffer, object, prettyPrint);
        }
    }

    private void appendAutoIncTriggers(StringBuffer oldbuffer, TableProxyOraclev9i sourceProxy, boolean prettyPrint) {
        Table table = (Table)sourceProxy.getObject();
        for (Column column : table.getElementsCollection()) {
            if (!column.isAutoIncrementColumn()) continue;
            if (this.ssbAutoIncCol == null) {
                this.ssbAutoIncCol = new SSBAutoIncrementColumnOracle(this.storageDesign);
            }
            this.ssbAutoIncCol.appendAutoIncrementSequenceAndTrigger(oldbuffer, column, prettyPrint);
        }
    }

    private void appendTriggers(StringBuffer oldbuffer, boolean prettyPrint) {
        int triggersIndex = this.tableObj.getChildIndex(ModelIdObjectSelection.TRIGGERS);
        if (triggersIndex > -1) {
            Iterator trgIt = this.tableObj.getChildObjects(triggersIndex).iterator();
            while (trgIt.hasNext()) {
                if (this.cssbTriggerOracle == null) {
                    this.cssbTriggerOracle = new CSSBTriggerOracle();
                }
                CompareObjectSelection chobj = (CompareObjectSelection)trgIt.next();
                this.cssbTriggerOracle.forceAppendTrigger(oldbuffer, chobj, prettyPrint);
            }
        }
    }

    private String newline() {
        return SQLStatementBuilder.NEWLINE;
    }

    public String newTab() {
        return "    ";
    }

    public static String getColumnAndTypePresentation(String name, String type, Design design) {
        String u_type = type.toUpperCase();
        if (u_type.indexOf("CHAR") > -1) {
            String betweenBrackets = Token.getValBetweenBrackets(u_type);
            if (betweenBrackets.length() > 0) {
                return name + " CHAR (" + Token.getFirstToken(betweenBrackets) + ')';
            }
            if ((u_type.equals("CHAR") || u_type.equals("NCHAR")) && design.getDesign().getSettings().isIncludeDefaultSettingsInDDL()) {
                return name + " CHAR (1" + ')';
            }
        } else {
            if (u_type.indexOf("DATE") > -1) {
                return name + " CHAR DATE_FORMAT DATE MASK '" + design.getEngDateFormat() + "'";
            }
            if (u_type.indexOf("TIMESTAMP") > -1) {
                if (u_type.indexOf("ZONE") == -1) {
                    return name + " CHAR DATE_FORMAT TIMESTAMP MASK '" + design.getEngTimestampFormat() + "'";
                }
                if (u_type.indexOf("LOCAL") == -1) {
                    return name + " CHAR DATE_FORMAT TIMESTAMP WITH TIMEZONE MASK '" + design.getEngTimestampWTZFormat() + "'";
                }
                return name + " CHAR DATE_FORMAT TIMESTAMP WITH LOCAL TIMEZONE MASK '" + design.getEngTimestampFormat() + "'";
            }
        }
        return name;
    }

    private void addColumnsAndTransforms(StringBuffer buffer, TableProxy tableproxy, TableSelection object) {
        List columns = object.getChildObjects(0);
        Design design = tableproxy.getDesign();
        if (columns.size() > 0) {
            boolean first = true;
            for (CompareObjectSelection column : columns) {
                if (column.canBeCreate() || column.canBeDrop() && column.isSelected()) continue;
                CompareObjectSelection targetColumn = column.getCorrespondentNode();
                String name = CSSBCreateRenameTable.getFormattedSelectedName(column, this.storageDesign);
                if (!name.startsWith("\"")) {
                    name = '\"' + name.toUpperCase() + '\"';
                }
                String ndata_type = "";
                Column col = (Column)targetColumn.getObject();
                if (col != null) {
                    ndata_type = col.getDatatypeString(tableproxy.getStorageDesign().getRDBMSType().getName());
                    if ((ndata_type.equals("CHAR") || ndata_type.equals("NCHAR")) && this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL()) {
                        ndata_type = ndata_type + " (1)";
                    } else if (ndata_type.equals("UROWID") && this.storageDesign.getDesign().getSettings().isIncludeDefaultSettingsInDDL()) {
                        ndata_type = ndata_type + " (4000)";
                    }
                }
                if (first) {
                    buffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab());
                    buffer.append('(');
                    first = false;
                } else {
                    buffer.append(',');
                }
                buffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab()).append(this.newTab());
                buffer.append(CSSBCreateRenameTable.getColumnAndTypePresentation(name, ndata_type, design));
            }
            if (!first) {
                buffer.append(this.newline()).append(this.newTab()).append(this.newTab()).append(this.newTab());
                buffer.append(')');
            }
        }
    }

    static class PossitionComparator
    implements Comparator {
        PossitionComparator() {
        }

        public int compare(Object one, Object two) {
            if (((PartitionOraclev9i)one).getPosition() > ((PartitionOraclev9i)two).getPosition()) {
                return 1;
            }
            if (((PartitionOraclev9i)one).getPosition() < ((PartitionOraclev9i)two).getPosition()) {
                return -1;
            }
            return 0;
        }
    }

    static class GlobalPossitionComparator
    implements Comparator {
        GlobalPossitionComparator() {
        }

        public int compare(Object one, Object two) {
            if (((IndexGlobalPartitionOraclev9i)one).getPosition() > ((IndexGlobalPartitionOraclev9i)two).getPosition()) {
                return 1;
            }
            if (((IndexGlobalPartitionOraclev9i)one).getPosition() < ((IndexGlobalPartitionOraclev9i)two).getPosition()) {
                return -1;
            }
            return 0;
        }
    }
}

