/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.design.compare.ddl.oracle;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.model.design.PropertyNames;
import oracle.dbtools.crest.model.design.compare.CompareObjectSelection;
import oracle.dbtools.crest.model.design.compare.PropertiesComparator;
import oracle.dbtools.crest.model.design.compare.PropertyHolder;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.AbstractCSSBOraclev9i;
import oracle.dbtools.crest.model.design.compare.ddl.oracle.v10g.CSSBAlterTableOraclev10g;
import oracle.dbtools.crest.model.design.compare.storage.oracle.MViewLogComparator;
import oracle.dbtools.crest.model.design.compare.storage.oracle.TableComparatorOracle;
import oracle.dbtools.crest.model.design.engineering.EngPropertyHolder;
import oracle.dbtools.crest.model.design.storage.oracle.MaterializedViewLogOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.util.options.Settings;

public class CSSBAlterMViewLog
extends AbstractCSSBOraclev9i {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        CompareObjectSelection sourceObj = (CompareObjectSelection)object;
        MaterializedViewLogOracle smvlog = (MaterializedViewLogOracle)sourceObj.getObject();
        MaterializedViewLogOracle tmvlog = (MaterializedViewLogOracle)sourceObj.getCorrespondentNode().getObject();
        TableProxyOracle tp = smvlog.getTableProxy();
        if (tmvlog != null) {
            tp = tmvlog.getTableProxy();
        }
        MViewLogComparator comp = (MViewLogComparator)sourceObj.getPropertiesComparator();
        this.storageDesign = smvlog.getStorageDesignOracle();
        if (sourceObj.isModified()) {
            PropertiesComparator pc;
            PropertyHolder ph;
            String propName;
            ArrayList<String> propList = new ArrayList<String>();
            boolean alterProp = false;
            boolean moveProp = false;
            boolean createProp = false;
            boolean moveStorageProp = false;
            Settings settings = smvlog.getDesign().getSettings();
            for (EngPropertyHolder ph2 : sourceObj.getPropertiesComparator().getPropertiesList()) {
                if (!ph2.isSelected()) continue;
                propName = ph2.getName();
                if (settings.isIncludeStorageInDDL() && (propName.equalsIgnoreCase(PropertyNames.SC_INITIAL_EXTENT) && settings.isIncludeInitialExtentInDDL() || propName.equalsIgnoreCase(PropertyNames.SC_NEXT_EXTENT) && settings.isIncludeNextExtentInDDL() || propName.equalsIgnoreCase(PropertyNames.SC_MIN_EXTENTS) && settings.isIncludeMinExtentsInDDL() || propName.equalsIgnoreCase(PropertyNames.SC_PCT_INCREASE) && settings.isIncludePctIncreaseInDDL() || propName.equalsIgnoreCase(PropertyNames.SC_FREE_LISTS) && settings.isIncludeFreeListsInDDL() || propName.equalsIgnoreCase(PropertyNames.SC_FREE_LISTS_GRPS) && settings.isIncludeFreeListGroupsInDDL() || propName.equalsIgnoreCase(PropertyNames.SC_BUFFER_POOL) && settings.isIncludeBufferPoolInDDL())) {
                    moveStorageProp = true;
                }
                if (!propName.equalsIgnoreCase(PropertyNames.TABLESPACE) || !settings.isIncludeTablespaceInDDL()) continue;
                moveProp = true;
            }
            for (EngPropertyHolder ph2 : sourceObj.getPropertiesComparator().getPropertiesList()) {
                if (!ph2.isSelected()) continue;
                propName = ph2.getName();
                if (!settings.isIncludeStorageInDDL()) continue;
                if (propName.equalsIgnoreCase(PropertyNames.PCT_FREE) && settings.isIncludePctFreeInDDL()) {
                    propList.add("PCTFREE");
                    alterProp = true;
                    continue;
                }
                if (propName.equalsIgnoreCase(PropertyNames.PCT_USED) && settings.isIncludePctUsedInDDL() || !propName.equalsIgnoreCase(PropertyNames.INIT_TRANS) || !settings.isIncludeInitransInDDL()) continue;
                propList.add("INITRANS");
                alterProp = true;
            }
            if (settings.isIncludePhysicalPropertiesInCompare() && settings.isIncludeLoggingInDDL() && (ph = (PropertyHolder)(pc = sourceObj.getPropertiesComparator()).getPropertyHolderByName(TableComparatorOracle.LOGGING)) != null && ph.isModified() && ph.isSelected() && !ph.isFiltered()) {
                alterProp = true;
                propList.add("LOGGING");
            }
            String audit = CSSBAlterMViewLog.getAddedLogItems(smvlog, tmvlog, comp);
            if (alterProp || !audit.isEmpty()) {
                String logging;
                CSSBAlterMViewLog.appendNewLine(oldbuffer, prettyPrint, 0);
                CSSBAlterMViewLog.appendStringWithSpace(oldbuffer, "ALTER");
                CSSBAlterMViewLog.appendStringWithSpace(oldbuffer, "MATERIALIZED VIEW LOG");
                if (!audit.isEmpty()) {
                    CSSBAlterMViewLog.appendStringWithSpace(oldbuffer, "FORCE");
                }
                CSSBAlterMViewLog.appendStringWithSpace(oldbuffer, "ON");
                CSSBAlterMViewLog.appendStringWithSpace(oldbuffer, this.storageDesign.getFormatedLongNameDDL(smvlog));
                if (this.storageDesign.getDesign().getSettings().isIncludeLoggingInDDL() && (propList == null || propList.contains("LOGGING")) && !"".equals(logging = smvlog.getLogging())) {
                    CSSBAlterMViewLog.appendNewLine(oldbuffer, prettyPrint, 2);
                    if (logging.equalsIgnoreCase("NO")) {
                        CSSBAlterMViewLog.appendStringWithSpace(oldbuffer, "NOLOGGING");
                    } else {
                        CSSBAlterMViewLog.appendStringWithSpace(oldbuffer, "LOGGING");
                    }
                }
                this.appendPhysProperties(oldbuffer, smvlog.getPercentFree(), smvlog.getPercentUsed(), smvlog.getInitrans(), null, prettyPrint, propList, smvlog.getDesign().getSettings());
                if (!audit.isEmpty()) {
                    CSSBAlterMViewLog.appendNewLine(oldbuffer, prettyPrint, 1);
                    CSSBAlterMViewLog.appendStringWithSpace(oldbuffer, "ADD");
                    CSSBAlterMViewLog.appendStringWithSpace(oldbuffer, audit);
                }
                CSSBAlterMViewLog.appendNewLine(oldbuffer, prettyPrint, 0);
                CSSBAlterMViewLog.appendLineFinisher(oldbuffer, prettyPrint);
                this.getStatus().incrementAlterTable();
            }
            if (moveProp || moveStorageProp) {
                CSSBAlterMViewLog.appendNewLine(oldbuffer, prettyPrint, 0);
                CSSBAlterMViewLog.appendStringWithSpace(oldbuffer, "ALTER");
                CSSBAlterMViewLog.appendStringWithSpace(oldbuffer, "MATERIALIZED VIEW LOG");
                CSSBAlterMViewLog.appendStringWithSpace(oldbuffer, "ON");
                CSSBAlterMViewLog.appendStringWithSpace(oldbuffer, this.storageDesign.getFormatedLongNameDDL(tmvlog));
                CSSBAlterMViewLog.appendNewLine(oldbuffer, prettyPrint, 1);
                CSSBAlterMViewLog.appendStringWithSpace(oldbuffer, "MOVE");
                if (moveProp) {
                    CSSBAlterMViewLog.appendNewLine(oldbuffer, prettyPrint, 1);
                    CSSBAlterMViewLog.appendStringWithSpace(oldbuffer, "TABLESPACE");
                    CSSBAlterMViewLog.appendStringWithSpace(oldbuffer, this.storageDesign.getFormatedLongNameDDL(smvlog.getTablespace()));
                }
                if (moveStorageProp) {
                    if (smvlog.getSegment() != null) {
                        CSSBAlterTableOraclev10g.addStorage(oldbuffer, smvlog.getSegment(), prettyPrint, smvlog.getTablespace(), smvlog.getLogging(), null, this.storageDesign);
                    } else {
                        CSSBAlterMViewLog.addStorage(oldbuffer, smvlog, prettyPrint, smvlog.getTablespace(), smvlog.getLogging(), null, this.storageDesign);
                    }
                }
                CSSBAlterMViewLog.appendNewLine(oldbuffer, prettyPrint, 0);
                CSSBAlterMViewLog.appendLineFinisher(oldbuffer, prettyPrint);
                this.getStatus().incrementAlterTable();
            }
            if (!createProp) return;
        }
        if (sourceObj.hasChildsWithChangeStatus()) return;
    }

    public static void addStorage(StringBuffer buffer, MaterializedViewLogOracle mvlog, boolean prettyPrint, TableSpaceOracle tableSpace, String logging, List propList, StorageDesignOracle storageDesign) {
        Settings s = storageDesign.getDesign().getSettings();
        if (s.isIncludeStorageInDDL()) {
            CSSBAlterMViewLog.appendNewLine(buffer, prettyPrint, 1);
            CSSBAlterMViewLog.appendStringWithSpace(buffer, "STORAGE");
            CSSBAlterMViewLog.appendStringWithSpace(buffer, '(');
            CSSBAlterMViewLog.appendNewLine(buffer, prettyPrint, 2);
            boolean props = false;
            if (!mvlog.getInitialExtent().isEmpty() && s.isIncludeInitialExtentInDDL() && (propList == null || propList.contains("INITIAL"))) {
                CSSBAlterMViewLog.appendStringWithSpace(buffer, "INITIAL");
                CSSBAlterMViewLog.appendStringWithSpace(buffer, mvlog.getInitialExtent());
                CSSBAlterMViewLog.appendNewLine(buffer, prettyPrint, 2);
                props = true;
            }
            if (!mvlog.getNextExtent().isEmpty() && s.isIncludeNextExtentInDDL() && (propList == null || propList.contains("NEXT"))) {
                CSSBAlterMViewLog.appendStringWithSpace(buffer, "NEXT");
                CSSBAlterMViewLog.appendStringWithSpace(buffer, mvlog.getNextExtent());
                CSSBAlterMViewLog.appendNewLine(buffer, prettyPrint, 2);
                props = true;
            }
            if (s.isIncludePctIncreaseInDDL() && (propList == null || propList.contains("PCTINCREASE"))) {
                CSSBAlterMViewLog.appendStringWithSpace(buffer, "PCTINCREASE");
                CSSBAlterMViewLog.appendStringWithSpace(buffer, mvlog.getPercentIncrease());
                CSSBAlterMViewLog.appendNewLine(buffer, prettyPrint, 2);
                props = true;
            }
            if (s.isIncludeMinExtentsInDDL() && (propList == null || propList.contains("MINEXTENTS"))) {
                CSSBAlterMViewLog.appendStringWithSpace(buffer, "MINEXTENTS");
                CSSBAlterMViewLog.appendStringWithSpace(buffer, mvlog.getMinExtent());
                CSSBAlterMViewLog.appendNewLine(buffer, prettyPrint, 2);
                props = true;
            }
            if (s.isIncludeFreeListsInDDL() && (propList == null || propList.contains("FREELISTS"))) {
                CSSBAlterMViewLog.appendStringWithSpace(buffer, "FREELISTS");
                CSSBAlterMViewLog.appendStringWithSpace(buffer, mvlog.getFreelists());
                CSSBAlterMViewLog.appendNewLine(buffer, prettyPrint, 2);
                props = true;
            }
            if (s.isIncludeFreeListGroupsInDDL() && (propList == null || propList.contains("FREELISTGROUPS"))) {
                CSSBAlterMViewLog.appendStringWithSpace(buffer, "FREELIST");
                CSSBAlterMViewLog.appendStringWithSpace(buffer, "GROUPS");
                CSSBAlterMViewLog.appendStringWithSpace(buffer, mvlog.getFreelistGroups());
                CSSBAlterMViewLog.appendNewLine(buffer, prettyPrint, 2);
                props = true;
            }
            if (storageDesign.getDesign().getSettings().isIncludeBufferPoolInDDL() && (propList == null || propList.contains("BUFFER_POOL"))) {
                CSSBAlterMViewLog.appendStringWithSpace(buffer, "BUFFER_POOL");
                CSSBAlterMViewLog.appendStringWithSpace(buffer, mvlog.getBufferPool());
                CSSBAlterMViewLog.appendNewLine(buffer, prettyPrint, 1);
            }
            CSSBAlterMViewLog.appendStringWithSpace(buffer, ')');
        }
    }

    @Override
    public boolean canHandle(Object object) {
        return ((CompareObjectSelection)object).getObject() instanceof MaterializedViewLogOracle;
    }

    public static String getAddedLogColumns(MaterializedViewLogOracle smvl, MaterializedViewLogOracle tmvl, Map<String, EngPropertyHolder> map) {
        String res = "";
        EngPropertyHolder ph = map.get(MViewLogComparator.COLUMNS);
        if (ph != null && ph.isSelected()) {
            List<String> slist = smvl.getSortedColumnNamesList();
            List<String> tlist = tmvl.getSortedColumnNamesList();
            if (slist.size() > tlist.size() && slist.removeAll(tlist)) {
                for (String s : slist) {
                    if (res.isEmpty()) {
                        res = smvl.getStorageDesign().getFormatedSimpleName(s);
                        continue;
                    }
                    res = res + ", " + smvl.getStorageDesign().getFormatedSimpleName(s);
                }
            }
        }
        return res;
    }

    public static String getAddedLogItems(MaterializedViewLogOracle smvl, MaterializedViewLogOracle tmvl, MViewLogComparator comp) {
        String columns;
        String res = "";
        Map<String, EngPropertyHolder> map = comp.getPropertiesMap();
        EngPropertyHolder ph = map.get(MViewLogComparator.RowIDLogged);
        if (ph != null && "YES".equalsIgnoreCase(ph.getLeftValue())) {
            res = res.isEmpty() ? "ROWID" : res + "," + "ROWID";
        }
        if ((ph = map.get(MViewLogComparator.PKLogged)) != null && "YES".equalsIgnoreCase(ph.getLeftValue())) {
            res = res.isEmpty() ? "PRIMARY KEY" : res + "," + "PRIMARY KEY";
        }
        if ((ph = map.get(MViewLogComparator.SequenceLogged)) != null && "YES".equalsIgnoreCase(ph.getLeftValue())) {
            res = res.isEmpty() ? "SEQUENCE" : res + "," + "SEQUENCE";
        }
        if ((ph = map.get(MViewLogComparator.OBJECT_ID_LOGGED)) != null && "YES".equalsIgnoreCase(ph.getLeftValue())) {
            res = res.isEmpty() ? "OBJECT ID" : res + "," + "OBJECT ID";
        }
        if (!(columns = CSSBAlterMViewLog.getAddedLogColumns(smvl, tmvl, map)).isEmpty()) {
            columns = "( " + columns + " )";
            res = res.isEmpty() ? columns : res + " " + columns;
        }
        if ((ph = map.get(MViewLogComparator.NewValues)) != null) {
            res = "YES".equalsIgnoreCase(ph.getLeftValue()) ? res + " " + "INCLUDING" + " " + "NEW" + " " + "VALUES" : res + " " + "EXCLUDING" + " " + "NEW" + " " + "VALUES";
        }
        return res;
    }
}

