/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.model.ModelIDObject;

public class SegmentNameManager {
    public static int seg_size = 70;
    private List maps = new ArrayList();
    public static String NAME_PREFIX = "seg_";

    public String getSegmentName(ModelIDObject object) {
        return this.getSegmentName(object.getObjectID());
    }

    public String getSegmentName(String id) {
        return NAME_PREFIX + this.getMapIndex(id);
    }

    private int getMapIndex(String id) {
        for (int i = 0; i < this.maps.size(); ++i) {
            Object obj;
            Map map = (Map)this.maps.get(i);
            if (map == null || (obj = map.get(id)) == null) continue;
            return i;
        }
        return this.addToMaps(id);
    }

    private int addToMaps(String id) {
        for (int i = 0; i < this.maps.size(); ++i) {
            Map map = (Map)this.maps.get(i);
            if (map == null || map.keySet().size() >= seg_size) continue;
            map.put(id, id);
            return i;
        }
        HashMap<String, String> map = new HashMap<String, String>(seg_size + 30);
        map.put(id, id);
        this.maps.add(map);
        return this.maps.indexOf(map);
    }

    public void add(String segment, String id) {
        int k = this.getSegmentIndex(segment);
        if (k >= this.maps.size()) {
            for (int i = this.maps.size(); i <= k; ++i) {
                this.maps.add(new HashMap());
            }
        }
        Map map = (Map)this.maps.get(k);
        map.put(id, id);
    }

    private int getSegmentIndex(String segment) {
        int k = segment.indexOf(NAME_PREFIX);
        if (k == 0) {
            int p = -1;
            try {
                p = Integer.valueOf(segment.substring(NAME_PREFIX.length()));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (p > -1) {
                return p;
            }
        }
        throw new RuntimeException("Error in segment name");
    }

    public void removeAll() {
        for (int i = 0; i < this.maps.size(); ++i) {
            Map map = (Map)this.maps.get(i);
            map.clear();
        }
    }

    public void removeID(String id) {
        for (int i = 0; i < this.maps.size(); ++i) {
            Object obj;
            Map map = (Map)this.maps.get(i);
            if (map == null || (obj = map.get(id)) == null) continue;
            map.remove(id);
        }
    }
}

