/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.oracle.v9i;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.oracle.DBMExtractionHandlerOracle;
import oracle.dbtools.crest.imports.metadata.oracle.v9i.MOHTypeIncompleteOraclev9i;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.datatype.NativeDBType;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.Method;
import oracle.dbtools.crest.model.design.datatypes.MethodParam;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.design.storage.oracle.MethodParamProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StructuredTypeProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StructuredTypeProxySetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.MethodProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.util.TimeLog;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.string.StringUtilities;
import oracle.dbtools.util.Closeables;

public class MOHTypeOraclev9i
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "OBJECT";
    private static final Logger LOGGER = new Logger(MOHTypeOraclev9i.class);
    protected boolean dbaUser;
    PreparedStatement attr_statemewnt = null;
    PreparedStatement met_statemewnt = null;
    PreparedStatement metp_statemewnt = null;
    PreparedStatement metb_statemewnt = null;

    public MOHTypeOraclev9i(AbstractDBMExtractionHandler dbmeHandler) {
        super(dbmeHandler);
        this.dbaUser = false;
    }

    public MOHTypeOraclev9i(AbstractDBMExtractionHandler dbmeHandler, boolean dbaUser) {
        super(dbmeHandler);
        this.dbaUser = dbaUser;
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        TimeLog.log("Type begin");
        this.attr_statemewnt = null;
        this.met_statemewnt = null;
        this.metp_statemewnt = null;
        this.metb_statemewnt = null;
        PreparedStatement type_statement = null;
        try {
            StorageDesignOracle storage = (StorageDesignOracle)this.getStorageDesign();
            MOHTypeIncompleteOraclev9i typeInc = ((DBMExtractionHandlerOracle)this.getDbmeHandler()).getMOHTypeIncompleteOraclev9i();
            for (DBObject dbo : typeInc.getAllTypes()) {
                if (!OBJECT_TYPE.equals(dbo.getType())) continue;
                String name = dbo.getName();
                String owner = dbo.getSchema();
                StructuredTypeProxyOracle proxy = ((StructuredTypeProxySetOracle)storage.getStructuredTypeProxySet()).getByLongName(name, owner);
                if (proxy == null) continue;
                StructuredType type = proxy.getStructuredType();
                if (type_statement == null) {
                    StringBuffer buffer = new StringBuffer();
                    buffer.append("SELECT").append(' ');
                    buffer.append("SUPERTYPE_OWNER").append(',');
                    buffer.append("SUPERTYPE_NAME").append(',');
                    buffer.append("FINAL").append(',');
                    buffer.append("INSTANTIABLE").append(',');
                    buffer.append("ATTRIBUTES").append(',');
                    buffer.append("METHODS").append(' ');
                    buffer.append("FROM").append(' ').append(this.dbaUser ? "dba_types" : "all_types").append(' ');
                    buffer.append("WHERE").append(' ').append("TYPE_NAME").append('=').append('?');
                    buffer.append("AND").append(' ').append("OWNER").append('=').append('?');
                    String sql = buffer.toString();
                    type_statement = sqlConnection.prepareStatement(sql);
                }
                ResultSet rs = null;
                try {
                    type_statement.setString(1, name);
                    type_statement.setString(2, owner);
                    rs = type_statement.executeQuery();
                    if (rs != null && rs.next()) {
                        StructuredTypeProxyOracle superTypeProxy;
                        String superTypeOwner = rs.getString("SUPERTYPE_OWNER");
                        String superTypeName = rs.getString("SUPERTYPE_NAME");
                        String isFinal = rs.getString("FINAL");
                        String instantiable = rs.getString("INSTANTIABLE");
                        int localAttributes = rs.getInt("ATTRIBUTES");
                        int localMethods = rs.getInt("METHODS");
                        type.setFinal(isFinal.equalsIgnoreCase("YES"));
                        type.setInstantiable(instantiable.equalsIgnoreCase("YES"));
                        if (superTypeName != null && (superTypeProxy = ((StructuredTypeProxySetOracle)storage.getStructuredTypeProxySet()).getByLongName(superTypeName, superTypeOwner)) != null) {
                            type.setParentType(superTypeProxy.getStructuredType(), false);
                        }
                        if (localAttributes > 0) {
                            this.initAttributes(sqlConnection, type, proxy);
                        }
                        if (localMethods > 0) {
                            this.initMethods(sqlConnection, type, proxy);
                            if (type.getMethods().length > 0) {
                                this.initMehodBody(sqlConnection, type, proxy);
                            }
                        }
                        this.stampModelObject((ModelObject)proxy, owner, name);
                    }
                    Closeables.close((Object)rs);
                }
                catch (Exception e) {
                    LOGGER.error("MOHTypeOraclev9i.generate():", e);
                }
                finally {
                    Closeables.close(rs);
                }
            }
        }
        catch (Throwable throwable) {
            Closeables.close((Object[])new PreparedStatement[]{this.attr_statemewnt, this.met_statemewnt, this.metp_statemewnt, this.metb_statemewnt, type_statement});
            throw throwable;
        }
        Closeables.close((Object[])new PreparedStatement[]{this.attr_statemewnt, this.met_statemewnt, this.metp_statemewnt, this.metb_statemewnt, type_statement});
        TimeLog.log("Type end");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initAttributes(Connection sqlConnection, StructuredType type, StructuredTypeProxyOracle proxy) throws Exception {
        if (proxy.getOwner() != null) {
            String username = proxy.getOwner().getName();
            if (this.attr_statemewnt == null) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("SELECT").append(' ').append("ATTR_NAME").append(',');
                buffer.append("ATTR_TYPE_MOD").append(',');
                buffer.append("ATTR_TYPE_OWNER").append(',');
                buffer.append("ATTR_TYPE_NAME").append(',');
                buffer.append("LENGTH").append(',');
                buffer.append("PRECISION").append(',');
                buffer.append("SCALE").append(' ');
                buffer.append("FROM").append(' ').append(this.dbaUser ? "dba_type_attrs" : "all_type_attrs").append(' ');
                buffer.append("WHERE").append(' ').append("OWNER").append('=').append('?').append(' ');
                buffer.append("AND").append(' ').append("TYPE_NAME").append('=').append('?').append(' ');
                buffer.append("AND").append(' ').append("INHERITED").append('=');
                buffer.append('\'').append("NO").append('\'').append(' ');
                buffer.append("ORDER BY").append(' ').append("ATTR_NO");
                String sql = buffer.toString();
                this.attr_statemewnt = sqlConnection.prepareStatement(sql);
            }
            ResultSet rs = null;
            try {
                this.attr_statemewnt.setString(1, username);
                this.attr_statemewnt.setString(2, proxy.getName());
                rs = this.attr_statemewnt.executeQuery();
                if (rs != null) {
                    while (rs.next()) {
                        String attrName = rs.getString("ATTR_NAME");
                        String mode = rs.getString("ATTR_TYPE_MOD");
                        String typeOwner = rs.getString("ATTR_TYPE_OWNER");
                        String typeName = rs.getString("ATTR_TYPE_NAME");
                        String length = rs.getString("LENGTH");
                        int prec = rs.getInt("PRECISION");
                        int scale = rs.getInt("SCALE");
                        TypeElement element = new TypeElement(type.getDesignPart(), type);
                        element.setName(attrName);
                        if (!attrName.equals(attrName.toUpperCase())) {
                            element.setNameHasQuotes(true);
                        }
                        element.setDesign(type.getDesign());
                        type.add(element);
                        boolean typeFound = false;
                        if (typeOwner != null) {
                            StructuredType st = (StructuredType)element.getDesign().getDataTypesDesign().getStructuredTypeSet().getByName(typeName);
                            if (st != null) {
                                if ("REF".equalsIgnoreCase(mode)) {
                                    element.setType(st);
                                    element.setReference(true);
                                    typeFound = true;
                                } else if (!typeName.equalsIgnoreCase("XMLTYPE")) {
                                    element.setType(st);
                                    typeFound = true;
                                }
                            } else {
                                CollectionType ct = (CollectionType)element.getDesign().getDataTypesDesign().getCollectionTypeSet().getByName(typeName);
                                if (ct != null) {
                                    element.setType(ct);
                                    typeFound = true;
                                }
                            }
                        }
                        if (typeFound) {
                            element.updateReference();
                            continue;
                        }
                        String usedDatatype = StandardDatatypeNames.getUsedDatatypeName(typeName);
                        LogicalDatatype logicalDT = MappingDatatypeNameLogicalDataType.getLogicalDatatype(this.getStorageDesign().getRDBMSType(), usedDatatype);
                        element.setType(logicalDT);
                        if (usedDatatype.startsWith("TIMESTAMP")) {
                            element.setPrecision(scale);
                            continue;
                        }
                        element.setSize(length);
                        element.setScale(scale);
                        element.setPrecision(prec);
                    }
                    rs.close();
                }
                Closeables.close((Object)rs);
            }
            catch (Exception e) {
                LOGGER.error("MOHTypeOraclev9i.initAttributes():", e);
            }
            finally {
                Closeables.close(rs);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initMethods(Connection sqlConnection, StructuredType type, StructuredTypeProxyOracle proxy) throws Exception {
        if (proxy.getOwner() != null) {
            String username = proxy.getOwner().getName();
            if (this.met_statemewnt == null) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("SELECT").append(' ');
                if (this.getStorageDesign() instanceof StorageDesignOraclev9i) {
                    buffer.append("DISTINCT").append(' ');
                }
                buffer.append("a.").append("METHOD_NAME").append(',');
                buffer.append("FINAL").append(',');
                buffer.append("INSTANTIABLE").append(',');
                buffer.append("OVERRIDING").append(',');
                buffer.append("a.").append("METHOD_NO").append(',');
                buffer.append("RESULT_TYPE_NAME").append(',');
                buffer.append("RESULT_TYPE_MOD").append(',');
                buffer.append("RESULT_TYPE_OWNER").append(' ');
                buffer.append("FROM").append(' ').append(this.dbaUser ? "dba_type_methods" : "all_type_methods").append(' ').append("a").append(',');
                buffer.append(this.dbaUser ? "dba_method_results" : "all_method_results").append(' ').append("b").append(' ');
                buffer.append("WHERE").append(' ').append("a.").append("OWNER").append('=').append('?').append(' ');
                buffer.append("AND").append(' ').append("a.").append("TYPE_NAME").append('=').append('?').append(' ');
                buffer.append("AND").append(' ').append("INHERITED").append('=');
                buffer.append('\'').append("NO").append('\'').append(' ');
                buffer.append("AND").append(' ');
                buffer.append("a.").append("OWNER").append('=').append("b.").append("OWNER").append(' ').append("(+)").append(' ');
                buffer.append("AND").append(' ');
                buffer.append("a.").append("TYPE_NAME").append('=').append("b.").append("TYPE_NAME").append(' ').append("(+)").append(' ');
                buffer.append("AND").append(' ');
                buffer.append("a.").append("METHOD_NO").append('=').append("b.").append("METHOD_NO").append(' ').append("(+)").append(' ');
                buffer.append("ORDER BY").append(' ').append("METHOD_NO");
                String sql = buffer.toString();
                this.met_statemewnt = sqlConnection.prepareStatement(sql);
            }
            ResultSet rs = null;
            try {
                this.met_statemewnt.setString(1, username);
                this.met_statemewnt.setString(2, proxy.getName());
                rs = this.met_statemewnt.executeQuery();
                if (rs != null) {
                    RDBMSType rdbmsType = this.getStorageDesign().getRDBMSType();
                    while (rs.next()) {
                        String name = rs.getString("METHOD_NAME");
                        String isFinal = rs.getString("FINAL");
                        String instantiable = rs.getString("INSTANTIABLE");
                        String overriding = rs.getString("OVERRIDING");
                        int number = rs.getInt("METHOD_NO");
                        String resultTypeName = rs.getString("RESULT_TYPE_NAME");
                        String resultTypeMod = rs.getString("RESULT_TYPE_MOD");
                        String dt_owner = rs.getString("RESULT_TYPE_OWNER");
                        Method m = new Method(type.getDesignPart(), type);
                        m.setName(name);
                        m.setDesign(type.getDesign());
                        m.setNumber(number);
                        type.addMethod(m);
                        MethodProxyOraclev9i methodProxy = (MethodProxyOraclev9i)this.getStorageDesign().getProxy(m);
                        if (methodProxy != null) {
                            if (isFinal.equalsIgnoreCase("YES")) {
                                methodProxy.setIsFinal("YES");
                            }
                            if (instantiable.equalsIgnoreCase("NO")) {
                                methodProxy.setInstantiable("NO");
                            }
                            if (overriding.equalsIgnoreCase("YES")) {
                                methodProxy.setOverriding("YES");
                            }
                        }
                        if (name.equals(type.getName())) {
                            m.setConstructor(true);
                        }
                        this.initMethodParams(sqlConnection, m, type, username);
                        if (resultTypeName == null) continue;
                        MethodParam param = new MethodParam(m.getDesignPart());
                        param.setName(name);
                        param.setDesign(m.getDesign());
                        m.setReturnValue(param);
                        boolean typeFound = false;
                        if (dt_owner != null) {
                            StructuredType st = (StructuredType)param.getDesign().getDataTypesDesign().getStructuredTypeSet().getByName(resultTypeName);
                            if (st != null) {
                                if ("REF".equalsIgnoreCase(resultTypeMod)) {
                                    param.setType(st);
                                    param.setReference(true);
                                    typeFound = true;
                                } else if (!resultTypeName.equalsIgnoreCase("XMLTYPE")) {
                                    param.setType(st);
                                    typeFound = true;
                                }
                            } else {
                                CollectionType ct = (CollectionType)param.getDesign().getDataTypesDesign().getCollectionTypeSet().getByName(resultTypeName);
                                if (ct != null) {
                                    param.setType(ct);
                                    typeFound = true;
                                }
                            }
                        }
                        if (typeFound) continue;
                        String usedDatatype = StandardDatatypeNames.getUsedDatatypeName(resultTypeName);
                        LogicalDatatype logDatatype = MappingDatatypeNameLogicalDataType.getLogicalDatatype(rdbmsType, usedDatatype);
                        NativeDBType nt = null;
                        if (logDatatype == null) {
                            nt = StandardDatatypeNames.getNativeDBType(rdbmsType, usedDatatype);
                            if (nt == null && dt_owner != null) {
                                nt = StandardDatatypeNames.getNativeDBType(rdbmsType, dt_owner + "." + usedDatatype);
                            }
                            if (nt != null) {
                                logDatatype = nt.getLogicalDatatype();
                            }
                        }
                        param.setType(logDatatype);
                    }
                    rs.close();
                }
                Closeables.close((Object)rs);
            }
            catch (Exception e) {
                LOGGER.error("MOHTypeOraclev9i.initMethods():", e);
            }
            finally {
                Closeables.close(rs);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initMehodBody(Connection sqlConnection, StructuredType type, StructuredTypeProxyOracle proxy) throws Exception {
        if (proxy.getOwner() != null) {
            String username = proxy.getOwner().getName();
            if (this.metb_statemewnt == null) {
                StringBuffer buffer = new StringBuffer();
                buffer.append("SELECT").append(' ').append("line").append(',');
                buffer.append("TEXT").append(' ');
                buffer.append("FROM").append(' ').append(this.dbaUser ? "dba_source" : "all_source").append(' ');
                buffer.append("WHERE").append(' ').append("OWNER").append('=').append('?').append(' ');
                buffer.append("AND").append(' ').append("NAME").append('=').append('?').append(' ');
                buffer.append("AND").append(' ').append("TYPE").append('=').append("'TYPE BODY'").append(' ');
                buffer.append("ORDER BY").append(' ').append("NAME").append(',').append("line");
                String sql = buffer.toString();
                this.metb_statemewnt = sqlConnection.prepareStatement(sql);
            }
            ResultSet rs = null;
            try {
                String methodBody;
                int k;
                String methodString;
                this.metb_statemewnt.setString(1, username);
                this.metb_statemewnt.setString(2, type.getName());
                rs = this.metb_statemewnt.executeQuery();
                StringBuffer methodBuffer = new StringBuffer();
                if (rs != null) {
                    while (rs.next()) {
                        methodBuffer.append(rs.getString(2));
                    }
                    rs.close();
                }
                if ((methodString = (k = StringUtilities.indexOf(methodBody = methodBuffer.toString(), type.getName())) > -1 ? methodBody.substring(k + type.getName().length()) : Token.getStringAfterToken(methodBody, type.getLongName())).length() > 0 && methodString.charAt(0) == '\"') {
                    methodString = methodString.substring(1);
                }
                if (Token.startsWithString2(methodString = Token.trimLeft(methodString), "AS") || Token.startsWithString2(methodString, "IS")) {
                    methodString = methodString.substring(2);
                    methodString = Token.trimLeft(methodString);
                }
                methodBody = "";
                String[] match = new String[]{"OVERRIDING", "FINAL", "INSTANTIABLE", "MEMBER", "STATIC", "CONSTRUCTOR", "MAP", "ORDER"};
                while (Token.hasToken(methodString, "MEMBER") || Token.hasToken(methodString, "STATIC") || Token.hasToken(methodString, "PROCEDURE") || Token.hasToken(methodString, "FUNCTION")) {
                    String methodBodyUC;
                    String name;
                    String spacedName;
                    while (methodString.startsWith("--")) {
                        int endComment = methodString.indexOf("\n");
                        if (endComment < 0) {
                            methodString = "";
                            continue;
                        }
                        methodString = methodString.substring(endComment + 1);
                        methodString = Token.trimLeft(methodString);
                    }
                    String currentString = methodString;
                    boolean overriding = false;
                    boolean final_fl = false;
                    boolean instantable = true;
                    boolean static_fl = false;
                    boolean constructor = false;
                    String mapOrderType = null;
                    boolean hasInherClause = true;
                    while (hasInherClause) {
                        String currentStringUC;
                        boolean notst = false;
                        if (currentString.toUpperCase(Locale.ROOT).startsWith("NOT")) {
                            currentString = Token.cutFirstToken2(currentString);
                            notst = true;
                        }
                        if ((currentStringUC = currentString.toUpperCase(Locale.ROOT)).startsWith("OVERRIDING")) {
                            currentString = Token.cutFirstToken2(currentString);
                            overriding = !notst;
                            continue;
                        }
                        if (currentStringUC.startsWith("FINAL")) {
                            currentString = Token.cutFirstToken2(currentString);
                            final_fl = !notst;
                            continue;
                        }
                        if (currentStringUC.startsWith("INSTANTIABLE")) {
                            currentString = Token.cutFirstToken2(currentString);
                            instantable = !notst;
                            continue;
                        }
                        hasInherClause = false;
                    }
                    if (currentString.toUpperCase(Locale.ROOT).startsWith("STATIC")) {
                        currentString = Token.cutFirstToken2(currentString);
                        static_fl = true;
                    } else {
                        if (currentString.toUpperCase(Locale.ROOT).startsWith("MAP")) {
                            mapOrderType = "MAP";
                            currentString = Token.cutFirstToken2(currentString);
                        } else if (currentString.toUpperCase(Locale.ROOT).startsWith("ORDER")) {
                            mapOrderType = "ORDER";
                            currentString = Token.cutFirstToken2(currentString);
                        }
                        if (currentString.toUpperCase(Locale.ROOT).startsWith("MEMBER")) {
                            currentString = Token.cutFirstToken2(currentString);
                        }
                    }
                    if (currentString.toUpperCase(Locale.ROOT).startsWith("CONSTRUCTOR")) {
                        currentString = Token.cutFirstToken2(currentString);
                        constructor = true;
                    }
                    if (!(spacedName = (name = Token.getFirstName(currentString = Token.cutFirstToken2(currentString), '\"', '\"')).replaceAll("[\t\n\f\r\u000b]+", " ")).equals(name)) {
                        name = Token.getFirstToken(spacedName);
                    }
                    if ((currentString = Token.getStringAfter(currentString, name)).startsWith("\"")) {
                        currentString = currentString.substring(1).trim();
                    }
                    int methodBodyLength = -1;
                    int startIndex = 0;
                    while (methodBodyLength < 0) {
                        String stringToCheck = currentString.substring(startIndex);
                        int lengthBeforeTrim = stringToCheck.length();
                        stringToCheck = Token.trimLeft(stringToCheck);
                        startIndex = startIndex + lengthBeforeTrim - stringToCheck.length();
                        int commentStart = stringToCheck.indexOf("--");
                        if (commentStart >= 0) {
                            stringToCheck = stringToCheck.substring(0, commentStart);
                        }
                        String stringBeforeMatch = Token.getStringToFirstMatch2(stringToCheck, match);
                        if (commentStart >= 0 && stringBeforeMatch.length() == stringToCheck.length()) {
                            int commentEnd = currentString.indexOf("\n", startIndex + commentStart);
                            if (commentEnd >= 0) {
                                startIndex = commentEnd + 1;
                                continue;
                            }
                            methodBodyLength = currentString.length();
                            continue;
                        }
                        methodBodyLength = startIndex + stringBeforeMatch.length();
                    }
                    if (methodBodyLength == 0) {
                        methodBody = currentString;
                    } else {
                        methodBody = currentString.substring(0, methodBodyLength);
                        if (methodBodyLength == currentString.length() && (k = methodBody.lastIndexOf(";")) > 0 && (k = StringUtilities.lastIndexOf(methodBody = methodBody.substring(0, k), "END")) > 0) {
                            methodBody = Token.trimRight(methodBody.substring(0, k));
                        }
                    }
                    methodString = currentString.substring(methodBody.length());
                    methodString = Token.trimLeft(methodString);
                    ArrayList parameterNames = new ArrayList();
                    ArrayList parameterDatatypes = new ArrayList();
                    ArrayList parameterDefaults = new ArrayList();
                    List nocopyList = this.getMethodParams(methodBody, parameterNames, parameterDatatypes, parameterDefaults);
                    MethodProxyOraclev9i methodProxy = (MethodProxyOraclev9i)this.getStorageDesign().getMethodProxySet().getMethodByNameAndParams(proxy, name, parameterNames, parameterDatatypes);
                    if (methodProxy == null) continue;
                    Method method = methodProxy.getMethod();
                    if (static_fl) {
                        methodProxy.setIsStatic("YES");
                    }
                    if (constructor) {
                        methodProxy.setConstructor("YES");
                        if (nocopyList != null && nocopyList.contains("SELF")) {
                            methodProxy.setCopySelf("NO");
                        }
                    }
                    if (final_fl) {
                        methodProxy.setIsFinal("YES");
                    }
                    if (overriding) {
                        methodProxy.setOverriding("YES");
                    }
                    if (!instantable) {
                        methodProxy.setInstantiable("NO");
                    }
                    if (mapOrderType != null) {
                        proxy.setMapOrderFunction(methodProxy);
                        proxy.setMapOrderType(mapOrderType);
                    }
                    if (nocopyList != null) {
                        for (MethodParamProxyOracle param : methodProxy.getParams()) {
                            if (!nocopyList.contains(param.getName().toUpperCase(Locale.ROOT))) continue;
                            param.setCopyArgument("NO");
                        }
                    }
                    block10: for (int i = 0; i < parameterDefaults.size(); ++i) {
                        String defaultValue = (String)parameterDefaults.get(i);
                        if (defaultValue.length() <= 0) continue;
                        String paramName = (String)parameterNames.get(i);
                        for (MethodParam param : method.getParameters()) {
                            if (!param.getName().equalsIgnoreCase(paramName)) continue;
                            param.setDefaultValue(defaultValue);
                            continue block10;
                        }
                    }
                    if (methodBody.startsWith("(")) {
                        String methodParams = Token.getValBetweenBrackets(methodBody, 1);
                        methodBody = methodBody.substring(methodParams.length() + 2);
                        methodBody = Token.trimLeft(methodBody);
                    }
                    if (methodBody.toUpperCase(Locale.ROOT).startsWith("RETURN ")) {
                        String methodBodyUC2 = (methodBody = Token.cutFirstToken2(methodBody)).toUpperCase(Locale.ROOT);
                        if (methodBodyUC2.startsWith("SELF AS RESULT")) {
                            methodBody = methodBody.substring(14);
                        } else if (methodBodyUC2.startsWith("INTERVAL DAY TO SECOND") || methodBodyUC2.startsWith("INTERVAL YEAR TO MONTH")) {
                            methodBody = methodBody.substring(22);
                        } else if (methodBodyUC2.startsWith("TIMESTAMP WITH TIME ZONE")) {
                            methodBody = methodBody.substring(24);
                        } else if (methodBodyUC2.startsWith("TIMESTAMP WITH LOCAL TIME ZONE")) {
                            methodBody = methodBody.substring(30);
                        } else {
                            int newLinePos;
                            int datatypeLength;
                            String firstToken = Token.getFirstToken(methodBody);
                            if (firstToken.equalsIgnoreCase("REF")) {
                                methodBody = Token.trimLeft(methodBody.substring(3));
                            }
                            if ((datatypeLength = methodBody.indexOf(" ")) < 0) {
                                datatypeLength = methodBody.length();
                            }
                            if ((newLinePos = methodBody.substring(0, datatypeLength).indexOf("\n")) >= 0) {
                                datatypeLength = newLinePos;
                            }
                            methodBody = methodBody.substring(datatypeLength);
                        }
                        methodBody = Token.trimLeft(methodBody);
                    }
                    if ((methodBodyUC = methodBody.toUpperCase(Locale.ROOT)).startsWith("IS\n") || methodBodyUC.startsWith("AS\n")) {
                        methodBody = methodBody.substring(3);
                    } else if (methodBodyUC.startsWith("IS") || methodBodyUC.startsWith("AS")) {
                        methodBody = Token.cutFirstToken2(methodBody);
                    }
                    method.setBody(methodBody);
                }
            }
            catch (Exception e) {
                try {
                    LOGGER.error("Error importing method body for Type " + type.getName() + " :", e);
                }
                catch (Throwable throwable) {
                    Closeables.close(rs);
                    throw throwable;
                }
                Closeables.close((Object)rs);
            }
            Closeables.close((Object)rs);
        }
    }

    private List getMethodParams(String methodBody, List paramNames, List paramDatatypes, List paramDefaults) {
        String methodParams;
        ArrayList<String> nocopyList = null;
        String bodyString = methodBody;
        if (bodyString.startsWith("(") && !(methodParams = Token.getValBetweenBrackets(bodyString, 1).trim()).equals("")) {
            StringTokenizer tokens = new StringTokenizer(methodParams, ",");
            String token = "";
            while (tokens.hasMoreTokens()) {
                String dataType;
                String paramName;
                token = tokens.nextToken().trim();
                String paramType = Token.getStringAfter(token, paramName = Token.getFirstName(token, '\"', '\"'));
                if (paramType.startsWith("\" ")) {
                    paramType = paramType.substring(2).trim();
                }
                if (Token.getFirstToken(paramType).equalsIgnoreCase("IN")) {
                    paramType = Token.cutTokenFromFront(paramType, "IN");
                }
                if (Token.getFirstToken(paramType).equalsIgnoreCase("OUT")) {
                    paramType = Token.cutTokenFromFront(paramType, "OUT");
                }
                if (Token.getFirstToken(paramType).equalsIgnoreCase("NOCOPY")) {
                    if (nocopyList == null) {
                        nocopyList = new ArrayList<String>();
                    }
                    nocopyList.add(paramName.toUpperCase(Locale.ROOT));
                    paramType = Token.cutTokenFromFront(paramType, "NOCOPY");
                }
                if (paramName.equalsIgnoreCase("SELF")) continue;
                boolean isRef = false;
                String paramTypeUC = paramType.toUpperCase(Locale.ROOT);
                if (paramTypeUC.startsWith("INTERVAL DAY TO SECOND")) {
                    dataType = "INTERVAL DAY TO SECOND";
                } else if (paramTypeUC.startsWith("INTERVAL YEAR TO MONTH")) {
                    dataType = "INTERVAL YEAR TO MONTH";
                } else if (paramTypeUC.startsWith("TIMESTAMP WITH TIME ZONE")) {
                    dataType = "TIMESTAMP WITH TIME ZONE";
                } else if (paramTypeUC.startsWith("TIMESTAMP WITH LOCAL TIME ZONE")) {
                    dataType = "TIMESTAMP WITH LOCAL TIME ZONE";
                } else {
                    dataType = Token.getFirstName(paramType, '\"', '\"');
                    if (dataType.equalsIgnoreCase("REF")) {
                        isRef = true;
                        paramType = paramType.substring(3);
                        dataType = Token.getFirstName(paramType, '\"', '\"');
                    }
                }
                String afterDatatype = Token.getStringAfter(paramType, dataType);
                String defaultValue = Token.getStringAfter(afterDatatype, "DEFAULT");
                if (isRef) {
                    dataType = "REF " + dataType;
                }
                paramNames.add(paramName);
                paramDatatypes.add(dataType);
                paramDefaults.add(defaultValue);
            }
        }
        return nocopyList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initMethodParams(Connection sqlConnection, Method m, StructuredType type, String username) throws Exception {
        if (this.metp_statemewnt == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ').append("PARAM_NAME").append(',');
            buffer.append("PARAM_MODE").append(',');
            buffer.append("PARAM_TYPE_MOD").append(',');
            buffer.append("PARAM_TYPE_NAME").append(',');
            buffer.append("PARAM_TYPE_OWNER").append(' ');
            buffer.append("FROM").append(' ').append(this.dbaUser ? "dba_method_params" : "all_method_params").append(' ');
            buffer.append("WHERE").append(' ').append("OWNER").append('=').append('?').append(' ');
            buffer.append("AND").append(' ').append("TYPE_NAME").append('=').append('?').append(' ');
            buffer.append("AND").append(' ').append("PARAM_NAME").append("<>").append("'SELF'").append(' ');
            buffer.append("AND").append(' ').append("METHOD_NAME").append('=').append('?').append(' ');
            buffer.append("AND").append(' ').append("METHOD_NO").append('=').append('?').append(' ');
            buffer.append("ORDER BY").append(' ').append("PARAM_NO");
            String sql = buffer.toString();
            this.metp_statemewnt = sqlConnection.prepareStatement(sql);
        }
        ResultSet rs = null;
        try {
            this.metp_statemewnt.setString(1, username);
            this.metp_statemewnt.setString(2, type.getName());
            this.metp_statemewnt.setString(3, m.getName());
            this.metp_statemewnt.setInt(4, m.getNumber());
            rs = this.metp_statemewnt.executeQuery();
            RDBMSType dbtype = this.getStorageDesign().getRDBMSType();
            if (rs != null) {
                while (rs.next()) {
                    StorageDesignOracle storage;
                    MethodParamProxyOracle proxy;
                    String name = rs.getString("PARAM_NAME");
                    String mode = rs.getString("PARAM_MODE");
                    String paramMode = rs.getString("PARAM_TYPE_MOD");
                    String typeName = rs.getString("PARAM_TYPE_NAME");
                    String dt_owner = rs.getString("PARAM_TYPE_OWNER");
                    MethodParam param = new MethodParam(m.getDesignPart());
                    param.setName(name);
                    param.setDesign(m.getDesign());
                    m.addParameter(param);
                    boolean typeFound = false;
                    if (dt_owner != null) {
                        StructuredType st = (StructuredType)param.getDesign().getDataTypesDesign().getStructuredTypeSet().getByName(typeName);
                        if (st != null) {
                            if ("REF".equalsIgnoreCase(paramMode)) {
                                param.setType(st);
                                param.setReference(true);
                                typeFound = true;
                            } else if (!typeName.equalsIgnoreCase("XMLTYPE")) {
                                param.setType(st);
                                typeFound = true;
                            }
                        } else {
                            CollectionType ct = (CollectionType)param.getDesign().getDataTypesDesign().getCollectionTypeSet().getByName(typeName);
                            if (ct != null) {
                                param.setType(ct);
                                typeFound = true;
                            }
                        }
                    }
                    if (!typeFound) {
                        String usedDatatype = StandardDatatypeNames.getUsedDatatypeName(typeName);
                        LogicalDatatype logDatatype = MappingDatatypeNameLogicalDataType.getLogicalDatatype(dbtype, usedDatatype);
                        NativeDBType nt = null;
                        if (logDatatype == null) {
                            nt = StandardDatatypeNames.getNativeDBType(dbtype, usedDatatype);
                            if (nt == null && dt_owner != null) {
                                nt = StandardDatatypeNames.getNativeDBType(dbtype, dt_owner + "." + usedDatatype);
                            }
                            if (nt != null) {
                                logDatatype = nt.getLogicalDatatype();
                            }
                        }
                        param.setType(logDatatype);
                    }
                    if ((proxy = (MethodParamProxyOracle)(storage = (StorageDesignOracle)this.getStorageDesign()).getMethodParamProxySet().getProxy(param.getObjectID())) == null) continue;
                    proxy.setDirectionType(mode);
                }
                rs.close();
            }
            Closeables.close((Object)rs);
        }
        catch (Exception e) {
            LOGGER.error("MOHTypeOraclev9i.initMethodParams():", e);
        }
        finally {
            Closeables.close(rs);
        }
    }
}

