/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.oracle;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.storage.oracle.ColumnProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.DimensionAttributeOracle;
import oracle.dbtools.crest.model.design.storage.oracle.DimensionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.HierarchyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.LevelOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableProxySetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.DimensionOraclev10g;
import oracle.dbtools.crest.util.TimeLog;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.util.Closeables;

public class MOHDimensionOracle
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "DIMENSION";
    private static final Logger LOGGER = new Logger(MOHDimensionOracle.class);
    protected boolean dbaUser;
    PreparedStatement levKey_statement = null;
    PreparedStatement attr_statement = null;
    PreparedStatement hier_statement = null;
    PreparedStatement child_statement = null;
    PreparedStatement jkey_statement = null;
    PreparedStatement lev_statement = null;

    public MOHDimensionOracle(AbstractDBMExtractionHandler dbmeHandler) {
        super(dbmeHandler);
        this.dbaUser = false;
    }

    public MOHDimensionOracle(AbstractDBMExtractionHandler dbmeHandler, boolean dbaUser) {
        super(dbmeHandler);
        this.dbaUser = dbaUser;
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        TimeLog.log("Dimensions begin");
        this.levKey_statement = null;
        this.attr_statement = null;
        this.hier_statement = null;
        this.child_statement = null;
        this.jkey_statement = null;
        this.lev_statement = null;
        StorageDesignOracle storage = (StorageDesignOracle)this.getStorageDesign();
        try {
            for (int i = 0; i < selectedObjects.size(); ++i) {
                UserOracle user;
                DBObject dbo = (DBObject)selectedObjects.get(i);
                if (!OBJECT_TYPE.equalsIgnoreCase(dbo.getType())) continue;
                String name = dbo.getName();
                String username = dbo.getSchema();
                DimensionOracle dim = storage.getDimensionSet().createDimension();
                dim.setName(name);
                if (!name.equals(name.toUpperCase())) {
                    dim.setNameHasQuotes(true);
                }
                if ((user = (UserOracle)storage.getUserSet().getByName(username)) == null) {
                    user = storage.getUserSet().createUser();
                    user.setName(username);
                    this.stampModelObject((ModelObject)user, "", username);
                }
                dim.setUser(user);
                this.initLevels(sqlConnection, dim, user);
                this.initHierarchies(sqlConnection, dim, user);
                this.stampModelObject(dim, dbo);
                importLog.incrementImportedStatements();
                this.addToHandledObjects(dbo);
            }
            storage.getDimensionAttributeSet().sort();
            storage.getLevelSet().sort();
        }
        catch (Throwable throwable) {
            Closeables.close((Object[])new PreparedStatement[]{this.lev_statement, this.levKey_statement, this.attr_statement, this.hier_statement, this.child_statement, this.jkey_statement});
            throw throwable;
        }
        Closeables.close((Object[])new PreparedStatement[]{this.lev_statement, this.levKey_statement, this.attr_statement, this.hier_statement, this.child_statement, this.jkey_statement});
        TimeLog.log("Dimensions end");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initHierarchies(Connection sqlConnection, DimensionOracle dim, UserOracle user) throws Exception {
        if (this.hier_statement == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ').append("HIERARCHY_NAME").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append(this.dbaUser ? "dba_dim_hierarchies" : "all_dim_hierarchies").append(' ');
            buffer.append("WHERE").append(' ').append("OWNER").append('=').append('?').append(' ');
            buffer.append("AND").append(' ').append("DIMENSION_NAME").append('=').append('?');
            String sql = buffer.toString();
            this.hier_statement = sqlConnection.prepareStatement(sql);
        }
        ResultSet rs = null;
        try {
            this.hier_statement.setString(1, user.getName());
            this.hier_statement.setString(2, dim.getName());
            rs = this.hier_statement.executeQuery();
            if (rs != null) {
                while (rs.next()) {
                    String name = rs.getString(1);
                    StorageDesignOracle storage = (StorageDesignOracle)this.getStorageDesign();
                    HierarchyOracle hier = storage.getHierarchySet().createHierarchy();
                    hier.setName(name);
                    if (!name.equals(name.toUpperCase())) {
                        hier.setNameHasQuotes(true);
                    }
                    hier.setDimension(dim);
                    this.stampModelObject((ModelObject)hier, user.getName(), dim.getName() + '.' + name);
                    this.initChildOfLevels(sqlConnection, dim, hier, user);
                }
                rs.close();
            }
            Closeables.close((Object)rs);
        }
        catch (Exception e) {
            LOGGER.error("MOHDimensionOracle.initHierarchies():", e);
        }
        finally {
            Closeables.close(rs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initChildOfLevels(Connection sqlConnection, DimensionOracle dim, HierarchyOracle hier, UserOracle user) throws Exception {
        if (this.child_statement == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ').append("CHILD_LEVEL_NAME").append(',');
            buffer.append("JOIN_KEY_ID").append(',');
            buffer.append("PARENT_LEVEL_NAME").append(' ');
            buffer.append("FROM").append(' ').append(this.dbaUser ? "dba_dim_child_of" : "all_dim_child_of").append(' ');
            buffer.append("WHERE").append(' ').append("OWNER").append('=').append('?').append(' ');
            buffer.append("AND").append(' ').append("DIMENSION_NAME").append('=').append('?').append(' ');
            buffer.append("AND").append(' ').append("HIERARCHY_NAME").append('=').append('?').append(' ');
            buffer.append("ORDER BY").append(' ').append("POSITION");
            String sql = buffer.toString();
            this.child_statement = sqlConnection.prepareStatement(sql);
        }
        ResultSet rs = null;
        try {
            this.child_statement.setString(1, user.getName());
            this.child_statement.setString(2, dim.getName());
            this.child_statement.setString(3, hier.getName());
            rs = this.child_statement.executeQuery();
            if (rs != null) {
                LevelOracle parentLevel;
                String parent = null;
                boolean useID = true;
                while (rs.next()) {
                    String child = rs.getString(1);
                    int joinId = rs.getInt(2);
                    parent = rs.getString(3);
                    LevelOracle level = dim.getLevelByName(child);
                    TableProxyOracle childTable = null;
                    if (level != null) {
                        childTable = (TableProxyOracle)level.getLevelTable();
                        if (childTable != null) {
                            hier.setLevels(level.getObjectID());
                        } else {
                            hier.setLevels(level.getName());
                            useID = false;
                        }
                    }
                    if (joinId == 0 || level == null) continue;
                    if (childTable != null) {
                        this.initJoinKey(sqlConnection, dim, hier, user, childTable);
                        continue;
                    }
                    this.initJoinKey(sqlConnection, dim, hier, user, childTable);
                }
                if (parent != null && (parentLevel = dim.getLevelByName(parent)) != null) {
                    if (useID) {
                        hier.setLevels(parentLevel.getObjectID());
                    } else {
                        hier.setLevels(parentLevel.getName());
                    }
                }
                rs.close();
            }
            Closeables.close((Object)rs);
        }
        catch (Exception e) {
            LOGGER.error("MOHDimensionOracle.initChildOfLevels():", e);
        }
        finally {
            Closeables.close(rs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initJoinKey(Connection sqlConnection, DimensionOracle dim, HierarchyOracle hier, UserOracle user, TableProxyOracle childTable) throws Exception {
        if (this.jkey_statement == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ').append("LEVEL_NAME").append(' ').append("PARENT_LEVEL_NAME").append(',');
            buffer.append("CHILD_JOIN_COLUMN").append(' ');
            buffer.append("FROM").append(' ').append(this.dbaUser ? "dba_dim_join_key" : "all_dim_join_key").append(' ');
            buffer.append("WHERE").append(' ').append("OWNER").append('=').append('?').append(' ');
            buffer.append("AND").append(' ').append("DIMENSION_NAME").append('=').append('?').append(' ');
            buffer.append("AND").append(' ').append("HIERARCHY_NAME").append('=').append('?').append(' ');
            buffer.append("ORDER BY").append(' ').append("KEY_POSITION");
            String sql = buffer.toString();
            this.jkey_statement = sqlConnection.prepareStatement(sql);
        }
        ResultSet rs = null;
        try {
            this.jkey_statement.setString(1, user.getName());
            this.jkey_statement.setString(2, dim.getName());
            this.jkey_statement.setString(3, hier.getName());
            rs = this.jkey_statement.executeQuery();
            if (rs != null) {
                while (rs.next()) {
                    String parentLevelName = rs.getString(1);
                    String colName = rs.getString(2);
                    if (childTable != null) {
                        ColumnProxyOracle col = (ColumnProxyOracle)childTable.getColumnProxyByName(colName);
                        if (col == null) continue;
                        StringBuffer join = new StringBuffer("JOIN KEY ");
                        join.append(col.getLongName());
                        join.append(" REFERENCES ");
                        join.append(parentLevelName);
                        hier.setJoins(join.toString());
                        continue;
                    }
                    StringBuffer join = new StringBuffer("JOIN KEY ");
                    join.append(colName);
                    join.append(" REFERENCES ");
                    join.append(parentLevelName);
                    hier.setJoins(join.toString());
                }
                rs.close();
            }
            Closeables.close((Object)rs);
        }
        catch (Exception e) {
            LOGGER.error("MOHDimensionOracle.initJoinKey():", e);
        }
        finally {
            Closeables.close(rs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initLevels(Connection sqlConnection, DimensionOracle dim, UserOracle user) throws Exception {
        if (this.lev_statement == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ').append("LEVEL_NAME").append(',');
            buffer.append("DETAILOBJ_OWNER").append(',');
            buffer.append("DETAILOBJ_NAME").append(' ');
            buffer.append("FROM").append(' ').append(this.dbaUser ? "dba_dim_levels" : "all_dim_levels").append(' ');
            buffer.append("WHERE").append(' ').append("OWNER").append('=').append('?').append(' ');
            buffer.append("AND").append(' ').append("DIMENSION_NAME").append('=').append('?');
            String sql = buffer.toString();
            this.lev_statement = sqlConnection.prepareStatement(sql);
        }
        ResultSet rs = null;
        try {
            this.lev_statement.setString(1, user.getName());
            this.lev_statement.setString(2, dim.getName());
            rs = this.lev_statement.executeQuery();
            if (rs != null) {
                while (rs.next()) {
                    String name = rs.getString(1);
                    String tableUser = rs.getString(2);
                    String tableName = rs.getString(3);
                    StorageDesignOracle storage = (StorageDesignOracle)this.getStorageDesign();
                    LevelOracle level = storage.getLevelSet().createLevel();
                    level.setName(name);
                    if (!name.equals(name.toUpperCase())) {
                        level.setNameHasQuotes(true);
                    }
                    level.setDimension(dim);
                    this.stampModelObject((ModelObject)level, user.getName(), dim.getName() + '.' + name);
                    TableProxyOracle table = ((TableProxySetOracle)storage.getTableProxySet()).getByLongName(tableName, tableUser);
                    if (table != null) {
                        level.setLevelTable(table);
                        this.initLevelKeys(sqlConnection, level, dim, table);
                        this.initAttributes(sqlConnection, level, dim, table);
                        continue;
                    }
                    level.setTableName(tableName);
                    level.setTableOwner(tableUser);
                    this.initLevelKeys(sqlConnection, level, dim, table);
                    this.initAttributes(sqlConnection, level, dim, table);
                }
                rs.close();
            }
            Closeables.close((Object)rs);
        }
        catch (Exception e) {
            LOGGER.error("MOHDimensionOracle.initLevels():", e);
        }
        finally {
            Closeables.close(rs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initAttributes(Connection sqlConnection, LevelOracle level, DimensionOracle dim, TableProxyOracle table) throws Exception {
        boolean oracle10gUpwards = dim instanceof DimensionOraclev10g;
        if (this.attr_statement == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            if (oracle10gUpwards) {
                buffer.append("ATTRIBUTE_NAME").append(',');
            }
            buffer.append("COLUMN_NAME").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append(this.dbaUser ? "dba_dim_attributes" : "all_dim_attributes").append(' ');
            buffer.append("WHERE").append(' ').append("OWNER").append('=').append('?').append(' ');
            buffer.append("AND").append(' ').append("DIMENSION_NAME").append('=').append('?').append(' ');
            buffer.append("AND").append(' ').append("LEVEL_NAME").append('=').append('?');
            String sql = buffer.toString();
            this.attr_statement = sqlConnection.prepareStatement(sql);
        }
        ResultSet rs = null;
        try {
            this.attr_statement.setString(1, dim.getUser().getName());
            this.attr_statement.setString(2, dim.getName());
            this.attr_statement.setString(3, level.getName());
            rs = this.attr_statement.executeQuery();
            StorageDesignOracle storage = level.getStorageDesignOracle();
            DimensionAttributeOracle attr = storage.getDimensionAttributeSet().createDimensionAttribute();
            attr.setLevel(level);
            if (rs != null) {
                while (rs.next()) {
                    if (oracle10gUpwards) {
                        String attrName = rs.getString("ATTRIBUTE_NAME");
                        attr.setName(attrName);
                        if (!attrName.equals(attrName.toUpperCase())) {
                            attr.setNameHasQuotes(true);
                        }
                    }
                    String cname = rs.getString("COLUMN_NAME");
                    if (table != null) {
                        ColumnProxyOracle col = (ColumnProxyOracle)table.getColumnProxyByName(cname);
                        if (col == null) continue;
                        attr.setColumns(col.getObjectID());
                        continue;
                    }
                    attr.setColumns(cname);
                }
                rs.close();
            }
            Closeables.close((Object)rs);
        }
        catch (Exception e) {
            LOGGER.error("MOHDimensionOracle.initAttributes():", e);
        }
        finally {
            Closeables.close(rs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initLevelKeys(Connection sqlConnection, LevelOracle level, DimensionOracle dim, TableProxyOracle table) throws Exception {
        if (this.levKey_statement == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ').append("b.").append("COLUMN_NAME").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append(this.dbaUser ? "dba_dim_levels" : "all_dim_levels").append(' ').append("a").append(',');
            buffer.append(this.dbaUser ? "dba_dim_level_key" : "all_dim_level_key").append(' ').append("b").append(' ');
            buffer.append("WHERE").append(' ').append("a.").append("OWNER").append('=').append('?').append(' ');
            buffer.append("AND").append(' ').append("a.").append("DIMENSION_NAME").append('=').append('?').append(' ');
            buffer.append("AND").append(' ').append("a.").append("LEVEL_NAME").append('=').append('?').append(' ');
            buffer.append("AND").append(' ').append("a.").append("OWNER").append('=').append("b.").append("OWNER").append(' ');
            buffer.append("AND").append(' ').append("a.").append("DIMENSION_NAME").append('=').append("b.").append("DIMENSION_NAME").append(' ');
            buffer.append("AND").append(' ').append("a.").append("LEVEL_NAME").append('=').append("b.").append("LEVEL_NAME").append(' ');
            buffer.append("ORDER BY").append(' ').append("b.").append("KEY_POSITION");
            String sql = buffer.toString();
            this.levKey_statement = sqlConnection.prepareStatement(sql);
        }
        ResultSet rs = null;
        try {
            this.levKey_statement.setString(1, dim.getUser().getName());
            this.levKey_statement.setString(2, dim.getName());
            this.levKey_statement.setString(3, level.getName());
            rs = this.levKey_statement.executeQuery();
            if (rs != null) {
                while (rs.next()) {
                    String cname = rs.getString(1);
                    if (table != null) {
                        ColumnProxyOracle col = (ColumnProxyOracle)table.getColumnProxyByName(cname);
                        if (col == null) continue;
                        level.setColumns(col.getObjectID());
                        continue;
                    }
                    if (dim.getDesign().getSettings().isIncludeSchemaInDDL()) {
                        level.setColumns(level.getTableOwner() + "." + level.getTableName() + "." + cname);
                        continue;
                    }
                    level.setColumns(level.getTableName() + "." + cname);
                }
                rs.close();
            }
            Closeables.close((Object)rs);
        }
        catch (Exception e) {
            LOGGER.error("MOHDimensionOracle.initLevelKeys():", e);
        }
        finally {
            Closeables.close(rs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List extract(Connection sqlConnection, List schemas) throws Exception {
        TimeLog.log("Extract Dimensions begin");
        statement = null;
        list = new ArrayList<DBObject>();
        try {
            for (DBObject dboNext : schemas) {
                if (!dboNext.isSelected()) continue;
                schemaName = dboNext.getName();
                if (statement == null) {
                    filterCondition = this.getFilterConditionOracle("DIMENSION_NAME");
                    buffer = new StringBuffer();
                    buffer.append("SELECT").append(' ').append("DIMENSION_NAME").append(' ');
                    buffer.append("FROM").append(' ').append(this.dbaUser != false ? "dba_dimensions" : "all_dimensions").append(' ');
                    buffer.append("WHERE").append(' ').append("OWNER").append('=').append('?').append(' ');
                    if (filterCondition != null) {
                        buffer.append("AND").append(' ').append(filterCondition).append(' ');
                    }
                    sql = buffer.toString();
                    statement = sqlConnection.prepareStatement(sql);
                }
                rs = null;
                try {
                    statement.setString(1, dboNext.getName());
                    rs = statement.executeQuery();
                    if (rs != null) {
                        while (rs.next()) {
                            dimName = rs.getString(1);
                            dboDim = new DBObject(AbstractDBMExtractionHandler.isAllSelected(), dimName, "DIMENSION", schemaName);
                            list.add(dboDim);
                        }
                        rs.close();
                    }
                    ** GOTO lbl43
                }
                catch (Exception e) {
                    try {
                        MOHDimensionOracle.LOGGER.error("MOHDimensionOracle.extract():", e);
                    }
                    catch (Throwable var11_12) {
                        Closeables.close(rs);
                        throw var11_12;
                    }
lbl43:
                    // 1 sources

                    Closeables.close((Object)rs);
                    continue;
                    Closeables.close((Object)rs);
                }
            }
        }
        finally {
            Closeables.close(statement);
        }
        TimeLog.log("Extract Dimensions end");
        return list;
    }
}

