/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata.oracle;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.List;
import oracle.dbtools.crest.imports.MappingDatatypeNameLogicalDataType;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.AbstractMOHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.oracle.DBMExtractionHandlerOracle;
import oracle.dbtools.crest.imports.metadata.oracle.v9i.MOHTypeIncompleteOraclev9i;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.datatype.NativeDBType;
import oracle.dbtools.crest.model.datatype.StandardDatatypeNames;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.design.storage.oracle.CollectionTypeProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.util.TimeLog;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.util.Closeables;

public class MOHCollectionTypeOracle
extends AbstractMOHandler {
    public static final String OBJECT_TYPE = "COLLECTION";
    private static final Logger LOGGER = new Logger(MOHCollectionTypeOracle.class);
    protected boolean dbaUser;
    PreparedStatement statement = null;

    public MOHCollectionTypeOracle(AbstractDBMExtractionHandler dbmeHandler) {
        super(dbmeHandler);
        this.dbaUser = false;
    }

    public MOHCollectionTypeOracle(AbstractDBMExtractionHandler dbmeHandler, boolean dbaUser) {
        super(dbmeHandler);
        this.dbaUser = dbaUser;
    }

    @Override
    public String getType() {
        return OBJECT_TYPE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void generate(Connection sqlConnection, List selectedObjects, ImportLogger importLog) throws Exception {
        TimeLog.log("Type Collection begin");
        this.statement = null;
        try {
            StorageDesignOracle storage = (StorageDesignOracle)this.getStorageDesign();
            MOHTypeIncompleteOraclev9i typeInc = ((DBMExtractionHandlerOracle)this.getDbmeHandler()).getMOHTypeIncompleteOraclev9i();
            for (DBObject dbo : typeInc.getAllTypes()) {
                if (!dbo.getType().equals(OBJECT_TYPE)) continue;
                String name = dbo.getName();
                String owner = dbo.getSchema();
                CollectionTypeProxyOracle proxy = (CollectionTypeProxyOracle)storage.getCollectionTypeProxySet().getByOwnerAndName(owner, name);
                if (proxy == null) continue;
                CollectionType type = proxy.getCollectionType();
                this.initProperties(sqlConnection, type, proxy);
                this.stampModelObject((ModelObject)proxy, proxy.getOwner().getName(), type.getName());
            }
        }
        finally {
            Closeables.close((Object)this.statement);
        }
        TimeLog.log("Type Collection end");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initProperties(Connection sqlConnection, CollectionType type, CollectionTypeProxyOracle proxy) throws Exception {
        if (this.statement == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("SELECT").append(' ');
            buffer.append("COLL_TYPE").append(',');
            buffer.append("UPPER_BOUND").append(',');
            buffer.append("ELEM_TYPE_MOD").append(',');
            buffer.append("ELEM_TYPE_OWNER").append(',');
            buffer.append("ELEM_TYPE_NAME").append(',');
            buffer.append("LENGTH").append(',');
            buffer.append("PRECISION").append(',');
            buffer.append("SCALE").append(' ');
            buffer.append("FROM").append(' ');
            buffer.append(this.dbaUser ? "dba_coll_types" : "all_coll_types").append(' ');
            buffer.append("WHERE").append(' ');
            buffer.append("OWNER").append('=').append('?').append(' ');
            buffer.append("AND").append(' ');
            buffer.append("TYPE_NAME").append('=').append('?');
            String sql = buffer.toString();
            this.statement = sqlConnection.prepareStatement(sql);
        }
        ResultSet rs = null;
        try {
            this.statement.setString(1, proxy.getOwner().getName());
            this.statement.setString(2, type.getName());
            rs = this.statement.executeQuery();
            RDBMSType dbtype = this.getStorageDesign().getRDBMSType();
            if (rs != null) {
                while (rs.next()) {
                    String collType = rs.getString("COLL_TYPE");
                    String elementTypeName = rs.getString("ELEM_TYPE_NAME");
                    String elementTypeMod = rs.getString("ELEM_TYPE_MOD");
                    String maxElem = rs.getString("UPPER_BOUND");
                    String dt_owner = rs.getString("ELEM_TYPE_OWNER");
                    String lenght = rs.getString("LENGTH");
                    int prec = rs.getInt("PRECISION");
                    int scale = rs.getInt("SCALE");
                    if (collType.equalsIgnoreCase("TABLE")) {
                        type.setCollectionType();
                    } else {
                        type.setArrayType();
                        type.setMaxElement(Integer.parseInt(maxElem));
                    }
                    TypeElement element = this.initElementType(type, elementTypeName);
                    type.setElementType(element);
                    String nativeType = elementTypeName;
                    boolean typeFound = false;
                    if (dt_owner != null) {
                        StructuredType st;
                        if (elementTypeName.equals("XMLTYPE")) {
                            if ("REF".equalsIgnoreCase(elementTypeMod)) {
                                nativeType = "REF XMLTYPE";
                            }
                        } else {
                            if (!elementTypeName.equals(elementTypeName.toUpperCase())) {
                                nativeType = "\"" + elementTypeName + "\"";
                            }
                            nativeType = dt_owner + '.' + nativeType;
                            if ("REF".equalsIgnoreCase(elementTypeMod)) {
                                nativeType = "REF " + nativeType;
                            }
                        }
                        if ((st = (StructuredType)type.getDesign().getDataTypesDesign().getStructuredTypeSet().getByName(elementTypeName)) != null) {
                            if ("REF".equalsIgnoreCase(elementTypeMod)) {
                                element.setType(st);
                                element.setReference(true);
                                typeFound = true;
                            } else if (!elementTypeName.equalsIgnoreCase("XMLTYPE")) {
                                element.setType(st);
                                typeFound = true;
                            }
                        } else {
                            CollectionType ct = (CollectionType)type.getDesign().getDataTypesDesign().getCollectionTypeSet().getByName(elementTypeName);
                            if (ct != null) {
                                element.setType(ct);
                                typeFound = true;
                            }
                        }
                    }
                    element.setNativeDataType(nativeType);
                    if (typeFound) continue;
                    String usedDatatype = StandardDatatypeNames.getUsedDatatypeName(elementTypeName);
                    LogicalDatatype logDatatype = MappingDatatypeNameLogicalDataType.getLogicalDatatype(this.getStorageDesign().getRDBMSType(), usedDatatype);
                    NativeDBType nt = null;
                    if (logDatatype == null) {
                        nt = StandardDatatypeNames.getNativeDBType(dbtype, usedDatatype);
                        if (nt == null && dt_owner != null) {
                            nt = StandardDatatypeNames.getNativeDBType(dbtype, dt_owner + "." + usedDatatype);
                        }
                        if (nt != null) {
                            logDatatype = nt.getLogicalDatatype();
                        }
                    }
                    element.setType(logDatatype);
                    element.setSize(lenght);
                    element.setScale(scale);
                    element.setPrecision(prec);
                }
                rs.close();
            }
            Closeables.close((Object)rs);
        }
        catch (Exception e) {
            LOGGER.error("MOHCollectionTypeOracle.initProperties():", e);
        }
        finally {
            Closeables.close(rs);
        }
    }

    private TypeElement initElementType(CollectionType type, String elementTypeName) {
        TypeElement element = new TypeElement(type.getDesignPart(), null);
        element.setDesign(type.getDesign());
        element.setParent(type);
        return element;
    }
}

