/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.imports.metadata;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.List;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.DBMOConstants;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.imports.metadata.ImportDBShowEntry;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.util.logging.ImportLogger;
import oracle.dbtools.crest.util.logging.Logger;

public abstract class AbstractMOHandler
implements DBMOConstants {
    protected static final String SCHEMA_PROPERTY = "schema";
    protected AbstractDBMExtractionHandler dbmeHandler;
    protected List<DBObject> handledObjects = new ArrayList<DBObject>();
    private boolean supportInformation_Schema = false;
    protected int countOfProcessedObjedcts = 0;

    public AbstractMOHandler(AbstractDBMExtractionHandler dbmeHandler) {
        this.dbmeHandler = dbmeHandler;
    }

    public abstract String getType();

    public abstract void generate(Connection var1, List var2, ImportLogger var3) throws Exception;

    public List extract(Connection sqlConnection, List schemas) throws Exception {
        return new ArrayList();
    }

    protected ImportDBShowEntry getShowEntry() {
        List showList = this.getDbmeHandler().getShowList();
        if (showList != null) {
            for (ImportDBShowEntry showEntry : showList) {
                if (!this.getType().equals(showEntry.getHandlerType())) continue;
                return showEntry;
            }
        }
        return null;
    }

    protected boolean showObjects() {
        ImportDBShowEntry showEntry = this.getShowEntry();
        if (showEntry != null) {
            return showEntry.isShow();
        }
        return true;
    }

    protected String getFilterConditionOracle(String nameColumn) {
        String entryFilter;
        ImportDBShowEntry showEntry = this.getShowEntry();
        if (showEntry != null && (entryFilter = showEntry.getFilter()) != null && !(entryFilter = entryFilter.trim()).isEmpty()) {
            boolean addEscapeChar = false;
            if (entryFilter.indexOf(95) > -1) {
                addEscapeChar = true;
                entryFilter = entryFilter.replaceAll("_", "@_");
            }
            StringBuffer buffer = new StringBuffer();
            buffer.append(nameColumn).append(" LIKE '%");
            buffer.append(entryFilter).append("%' ");
            if (addEscapeChar) {
                buffer.append("ESCAPE '@' ");
            }
            return buffer.toString();
        }
        return null;
    }

    public Design getDesign() {
        return this.dbmeHandler.getDesign();
    }

    public StorageDesign getStorageDesign() {
        return this.getDesign().getRelationalDesign().getStorageDesign();
    }

    public RelationalDesign getRelationalDesign() {
        return this.getDesign().getRelationalDesign();
    }

    public static String getSQLDataType(short type) {
        switch (type) {
            case -5: {
                return "BIGINT";
            }
            case -2: {
                return "BINARY";
            }
            case -7: {
                return "BIT";
            }
            case 2004: {
                return "BLOB";
            }
            case 16: {
                return "BOOLEAN";
            }
            case 1: {
                return "CHAR";
            }
            case -8: {
                return "CHAR";
            }
            case 2005: {
                return "CLOB";
            }
            case 70: {
                return "DATALINK";
            }
            case 91: {
                return "DATE";
            }
            case 3: {
                return "DECIMAL";
            }
            case 2001: {
                return "DISTINCT";
            }
            case 8: {
                return "DOUBLE";
            }
            case 6: {
                return "FLOAT";
            }
            case 4: {
                return "INTEGER";
            }
            case -4: {
                return "IMAGE";
            }
            case -1: {
                return "LONG alphabetic";
            }
            case 2: {
                return "NUMERIC";
            }
            case 7: {
                return "REAL";
            }
            case 5: {
                return "SMALLINT";
            }
            case 2002: {
                return "STRUCT";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -6: {
                return "TINYINT";
            }
            case -3: {
                return "VARBINARY";
            }
            case 12: {
                return "VARCHAR";
            }
            case -9: {
                return "VARCHAR";
            }
        }
        return null;
    }

    public String getColumn(ResultSet resultSet, String column) {
        String result = null;
        if (resultSet != null) {
            try {
                result = resultSet.getString(column);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public boolean getColumn(ResultSet resultSet, String column, boolean defaultValue) {
        boolean result = defaultValue;
        if (resultSet != null) {
            try {
                result = resultSet.getBoolean(column);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    public int getColumn(ResultSet resultSet, String column, int defaultValue) {
        int result = defaultValue;
        if (resultSet != null) {
            try {
                result = resultSet.getInt(column);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result;
    }

    protected void dumpResultSet(ResultSet rs) {
        try {
            while (rs.next()) {
                ResultSetMetaData rsmd = rs.getMetaData();
                for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
                }
            }
        }
        catch (Exception e) {
            Logger.error(e);
        }
    }

    protected void dumpBuffer(StringBuffer buffer) {
    }

    public AbstractDBMExtractionHandler getDbmeHandler() {
        return this.dbmeHandler;
    }

    protected void addToHandledObjects(DBObject dbo) {
        this.handledObjects.add(dbo);
    }

    public List<DBObject> getHandledObjects() {
        return this.handledObjects;
    }

    public void clearHandledObjects(List selectedObjects) {
        selectedObjects.removeAll(this.handledObjects);
    }

    public void stampModelObject(ModelObject obj, DBObject dbo) {
        this.stampModelObject(obj, dbo.getSchema(), dbo.getName());
    }

    public void stampModelObject(ModelObject obj, StorageObject stoObj, String objectName) {
        if (stoObj != null && stoObj.getSchemaObject() != null) {
            String schemaName = stoObj.getSchemaObject().getName();
            this.stampModelObject(obj, schemaName, objectName);
        }
    }

    public void stampModelObject(ModelObject obj, RelationalObjectProxy proxy, String objectName) {
        String schemaName = proxy.getObject().getSchema();
        if (proxy.getSchemaObject() != null) {
            schemaName = proxy.getSchemaObject().getName();
        }
        this.stampModelObject(obj, schemaName, objectName);
    }

    public void stampModelObject(ModelObject obj, String schemaName, String objectName) {
        obj.setSourceObjSchema(schemaName != null ? schemaName : "");
        obj.setSourceObjName(objectName);
    }

    public void reset() {
        this.handledObjects.clear();
    }

    public void postGenerateProcessing(Connection sqlConnection) {
    }

    protected DBObject findObject(List<DBObject> dbObjs, String type, String name) {
        DBObject val = null;
        if (dbObjs != null && type != null && name != null) {
            for (DBObject dbObj : dbObjs) {
                if (!dbObj.getType().equals(type) || !dbObj.getName().equals(name)) continue;
                val = dbObj;
                break;
            }
        }
        return val;
    }

    public boolean isSupportInformation_Schema() {
        return this.supportInformation_Schema;
    }

    public void setSupportInformation_Schema(boolean supportInformation_Schema) {
        this.supportInformation_Schema = supportInformation_Schema;
    }

    public void preGenerateProcessing(Connection sqlConnection, List<DBObject> selectedObject) {
    }

    public int getCountOfObjectsToProcess(List selected) {
        int res = 0;
        for (DBObject dbo : selected) {
            if (!this.getType().equalsIgnoreCase(dbo.getType())) continue;
            ++res;
        }
        return res;
    }

    public int getCountOfProcessedObjedcts() {
        return this.countOfProcessedObjedcts;
    }

    public void setCountOfProcessedObjedcts(int countOfProcessedObjedcts) {
        this.countOfProcessedObjedcts = countOfProcessedObjedcts;
    }
}

