/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.exports.ddl.oracle.v10g;

import oracle.dbtools.crest.exports.ddl.oracle.AbstractSSBOracle;
import oracle.dbtools.crest.imports.Token;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.datatypes.CollectionType;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.oracle.CollectionTypeProxyOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsOracle;
import oracle.dbtools.crest.model.design.storage.oracle.PermissionsSetOracle;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.CollectionTypeProxyOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.util.string.StringUtilities;

public class SSBCollectionTypeOraclev10g
extends AbstractSSBOracle {
    private StorageDesign storageDesign;

    @Override
    public void doAppend(StringBuffer oldbuffer, Object object, boolean prettyPrint) {
        if (object instanceof CollectionType) {
            CollectionType type = (CollectionType)object;
            SSBCollectionTypeOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
            this.appendComment(oldbuffer, type);
        } else if (object instanceof CollectionTypeProxyOraclev10g) {
            CollectionTypeProxyOraclev10g typeProxy = (CollectionTypeProxyOraclev10g)object;
            this.storageDesign = typeProxy.getStorageDesign();
            if (!typeProxy.getCollectionType().isPredefined()) {
                SSBCollectionTypeOraclev10g.appendNewLine(oldbuffer, prettyPrint, 0);
                this.appendComment(oldbuffer, typeProxy);
                this.appendFullDefinition(oldbuffer, typeProxy, prettyPrint);
                this.appendPermissions(oldbuffer, typeProxy);
                this.incrementCreateCollectionType();
            }
        }
    }

    private void appendFullDefinition(StringBuffer oldbuffer, CollectionTypeProxyOraclev10g typeProxy, boolean prettyPrint) {
        String ownerName;
        StringBuffer buffer = new StringBuffer();
        String advancedComment = "";
        this.appendPrompt(buffer, typeProxy, "TYPE");
        SSBCollectionTypeOraclev10g.appendNewLine(buffer, prettyPrint, 0);
        SSBCollectionTypeOraclev10g.appendStringWithSpace(buffer, "CREATE");
        SSBCollectionTypeOraclev10g.appendStringWithSpace(buffer, "OR");
        SSBCollectionTypeOraclev10g.appendStringWithSpace(buffer, "REPLACE");
        SSBCollectionTypeOraclev10g.appendStringWithSpace(buffer, "TYPE");
        UserOracle owner = typeProxy.getOwner();
        if (owner != null && !(ownerName = owner.getName()).equalsIgnoreCase("MDSYS") && !ownerName.equalsIgnoreCase("SYS") && this.storageDesign.getDesign().getSettings().isIncludeSchemaInDDL()) {
            SSBCollectionTypeOraclev10g.appendString(buffer, this.storageDesign.getFormatedName(owner));
            SSBCollectionTypeOraclev10g.appendString(buffer, '.');
        }
        SSBCollectionTypeOraclev10g.appendStringWithSpace(buffer, this.storageDesign.getFormatedName(typeProxy));
        advancedComment = buffer.toString();
        if (typeProxy.getForceReplace().equalsIgnoreCase("YES") && this.storageDesign instanceof StorageDesignOraclev11g) {
            SSBCollectionTypeOraclev10g.appendStringWithSpace(buffer, "FORCE");
        }
        SSBCollectionTypeOraclev10g.appendNewLine(buffer, prettyPrint, 1);
        if (!"".equalsIgnoreCase(typeProxy.getGlobalOid().trim())) {
            SSBCollectionTypeOraclev10g.appendStringWithSpace(buffer, "OID");
            if (Token.hasString(typeProxy.getGlobalOid(), "'")) {
                SSBCollectionTypeOraclev10g.appendStringWithSpace(buffer, typeProxy.getGlobalOid());
            } else {
                SSBCollectionTypeOraclev10g.appendString(buffer, '\'');
                SSBCollectionTypeOraclev10g.appendString(buffer, typeProxy.getGlobalOid());
                SSBCollectionTypeOraclev10g.appendStringWithSpace(buffer, '\'');
            }
        }
        SSBCollectionTypeOraclev10g.appendStringWithSpace(buffer, "IS");
        if (typeProxy.isArrayType(typeProxy.getType())) {
            SSBCollectionTypeOraclev10g.appendStringWithSpace(buffer, "VARRAY");
            SSBCollectionTypeOraclev10g.appendStringWithSpace(buffer, '(');
            SSBCollectionTypeOraclev10g.appendStringWithSpace(buffer, typeProxy.getMaxElement());
            SSBCollectionTypeOraclev10g.appendStringWithSpace(buffer, ')');
        } else {
            SSBCollectionTypeOraclev10g.appendStringWithSpace(buffer, "TABLE");
        }
        SSBCollectionTypeOraclev10g.appendStringWithSpace(buffer, "OF");
        String datatype = null;
        TypeElement typeElement = ((CollectionType)typeProxy.getObject()).getElementType();
        DesignObject elemDataType = typeElement.getType();
        if (elemDataType instanceof StructuredType || elemDataType instanceof CollectionType) {
            RelationalObjectProxy proxy = this.storageDesign.getProxy(elemDataType);
            datatype = proxy != null ? this.storageDesign.getFormatedLongNameDDL(proxy) : this.storageDesign.getFormatedName(elemDataType);
            if (typeElement.isReference() && elemDataType instanceof StructuredType) {
                datatype = "REF " + datatype;
            }
        } else {
            datatype = typeElement.getDataType(this.storageDesign.getRDBMSType().getName());
        }
        if (datatype.equalsIgnoreCase("unknown")) {
            String nativeDataType = typeElement.getNativeDataType();
            if (!typeElement.getDesign().getSettings().isIncludeSchemaInDDL()) {
                int ind;
                boolean isRef = nativeDataType.startsWith("REF ");
                if (isRef) {
                    nativeDataType = nativeDataType.substring(4);
                }
                if ((ind = nativeDataType.indexOf(46)) > -1) {
                    nativeDataType = nativeDataType.substring(ind + 1);
                }
                if (isRef) {
                    nativeDataType = "REF " + nativeDataType;
                }
            }
            datatype = nativeDataType;
        }
        SSBCollectionTypeOraclev10g.appendStringWithSpace(buffer, datatype);
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
        SSBCollectionTypeOraclev10g.appendNewLine(buffer, prettyPrint, 0);
        this.appendLineFinisherWithSlash(buffer, prettyPrint);
        SSBCollectionTypeOraclev10g.appendNewLine(buffer, prettyPrint, 0);
        this.appendToBuffer(oldbuffer, buffer, advancedComment);
    }

    @Override
    public boolean canHandle(Object object) {
        if (object instanceof CollectionTypeProxyOraclev10g && ((CollectionTypeProxyOraclev10g)object).isMarkedGenerate()) {
            return true;
        }
        return object instanceof CollectionType && ((CollectionType)object).isMarkedGenerate();
    }

    protected void appendPermissions(StringBuffer oldBuffer, CollectionTypeProxyOracle collectionTypeProxyOracle) {
        StorageDesignOracle storageDesignOracle = (StorageDesignOracle)collectionTypeProxyOracle.getStorageDesign();
        StringBuffer buffer = new StringBuffer();
        PermissionsSetOracle permissionsSet = storageDesignOracle.getPermissionsSet();
        for (PermissionsOracle permissions : permissionsSet) {
            if (!collectionTypeProxyOracle.equals(permissions.getCollectionTypeOracle()) || permissions.getUser() == null && permissions.getRole() == null) continue;
            if (StringUtilities.isNotEmpty(permissions.getPrivileges())) {
                this.appendPrivileges(oldBuffer, buffer, permissions, collectionTypeProxyOracle, storageDesignOracle, false);
            }
            if (!StringUtilities.isNotEmpty(permissions.getPrivilegesWithGrantOption())) continue;
            this.appendPrivileges(oldBuffer, buffer, permissions, collectionTypeProxyOracle, storageDesignOracle, true);
        }
    }

    private void appendPrivileges(StringBuffer oldBuffer, StringBuffer buffer, PermissionsOracle permissions, CollectionTypeProxyOracle collectionTypeProxyOracle, StorageDesignOracle storageDesignOracle, boolean withGrantOption) {
        buffer.append(NEWLINE);
        this.appendComment(buffer, permissions);
        SSBCollectionTypeOraclev10g.appendStringWithSpace(buffer, "GRANT");
        if (withGrantOption) {
            buffer.append(permissions.getPrivilegesWithGrantOption());
        } else {
            buffer.append(permissions.getPrivileges());
        }
        this.appendObject(buffer, collectionTypeProxyOracle, storageDesignOracle);
        this.appendTo(buffer, permissions, storageDesignOracle);
        if (withGrantOption) {
            this.appendGrantOption(buffer, permissions);
        }
        String advancedComment = buffer.toString();
        buffer.append(NEWLINE);
        buffer.append(';');
        buffer.append(NEWLINE);
        this.appendToBuffer(oldBuffer, buffer, advancedComment);
    }

    private void appendObject(StringBuffer buffer, CollectionTypeProxyOracle collectionTypeProxyOracle, StorageDesign storageDesign) {
        buffer.append(NEWLINE);
        SSBCollectionTypeOraclev10g.appendStringWithSpace(buffer, "ON");
        SSBCollectionTypeOraclev10g.appendStringWithSpace(buffer, storageDesign.getFormatedLongNameDDL(collectionTypeProxyOracle));
    }

    private void appendGrantOption(StringBuffer buffer, PermissionsOracle permissions) {
        if (permissions.getRole() == null) {
            SSBCollectionTypeOraclev10g.appendStringWithSpace(buffer, "WITH GRANT OPTION");
        }
    }
}

