/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.SocketException;
import java.util.Properties;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import javax.net.ssl.SSLContext;
import oracle.jdbc.OracleHostnameResolver;
import oracle.jdbc.driver.DMSFactory;
import oracle.jdbc.internal.CompletionStageUtil;
import oracle.jdbc.logging.annotations.Blind;
import oracle.jdbc.logging.annotations.DisableTrace;
import oracle.jdbc.logging.annotations.PropertiesBlinder;
import oracle.net.jdbc.nl.NLException;
import oracle.net.jdbc.nl.NVFactory;
import oracle.net.jdbc.nl.NVNavigator;
import oracle.net.jdbc.nl.NVPair;
import oracle.net.ns.NetException;
import oracle.net.nt.AsyncOutboundTimeoutHandler;
import oracle.net.nt.MQLNTAdapter;
import oracle.net.nt.NTAdapter;
import oracle.net.nt.SdpNTAdapter;
import oracle.net.nt.TcpNTAdapter;
import oracle.net.nt.TcpsNTAdapter;

public class ConnOption {
    public NTAdapter nt;
    public String protocol;
    public String host;
    public int port;
    public String addr;
    public String sid;
    public String service_name;
    public String instance_name;
    public int delayBetweenRetry;
    public int tdu;
    public int sdu;
    public StringBuilder conn_data = new StringBuilder(200);
    public String sslServerCertDN;
    public String walletDirectory;
    public String origSSLServerCertDN;
    public String origServiceName;
    public String origSid;
    public boolean done;
    public int connectTimeout;
    public int transportConnectTimeout;

    private NTAdapter getNT(@Blind(value=PropertiesBlinder.class) Properties properties, SSLContext sSLContext, OracleHostnameResolver oracleHostnameResolver) throws NetException {
        block7: {
            try {
                if (this.protocol.equalsIgnoreCase("tcp")) {
                    this.nt = new TcpNTAdapter(this.addr, properties, oracleHostnameResolver);
                    this.origServiceName = this.service_name;
                    this.origSid = this.sid;
                    break block7;
                }
                if (this.protocol.equalsIgnoreCase("tcps") || this.protocol.equalsIgnoreCase("wss")) {
                    this.nt = new TcpsNTAdapter(this.addr, properties, sSLContext, oracleHostnameResolver);
                    this.origSSLServerCertDN = this.sslServerCertDN;
                    this.origServiceName = this.service_name;
                    this.origSid = this.sid;
                    String[] stringArray = new String[]{this.origSSLServerCertDN, this.origServiceName, this.origSid};
                    this.nt.setOption(108, stringArray);
                    break block7;
                }
                if (this.protocol.equalsIgnoreCase("sdp")) {
                    this.nt = new SdpNTAdapter(this.addr, properties);
                    this.origServiceName = this.service_name;
                    this.origSid = this.sid;
                    break block7;
                }
                if (this.protocol.equalsIgnoreCase("exadirect") || this.protocol.equalsIgnoreCase("msgqlt")) {
                    this.nt = new MQLNTAdapter(this.addr, properties);
                    this.origServiceName = this.service_name;
                    this.origSid = this.sid;
                    break block7;
                }
                throw new NetException(21, "protocol: " + this.protocol);
            }
            catch (NLException nLException) {
                throw new NetException(501);
            }
            catch (Exception exception) {
                throw (NetException)new NetException(21).initCause(exception);
            }
        }
        return this.nt;
    }

    public void connect(@Blind(value=PropertiesBlinder.class) Properties properties, DMSFactory.DMSNoun dMSNoun) throws IOException, InterruptedIOException {
        this.connect(properties, dMSNoun, null, null);
    }

    public void connect(@Blind(value=PropertiesBlinder.class) Properties properties, DMSFactory.DMSNoun dMSNoun, SSLContext sSLContext, OracleHostnameResolver oracleHostnameResolver) throws IOException, InterruptedIOException {
        try {
            this.populateProtocol();
            if (this.protocol == null) {
                throw new NetException(501);
            }
        }
        catch (NLException nLException) {
            throw new NetException(501);
        }
        if (this.nt == null || !this.nt.hasMoreInetAddresses()) {
            this.nt = this.getNT(properties, sSLContext, oracleHostnameResolver);
        }
        this.nt.connect(dMSNoun);
    }

    final CompletionStage<Void> connectAsync(Properties properties, DMSFactory.DMSNoun dMSNoun, SSLContext sSLContext, OracleHostnameResolver oracleHostnameResolver, AsyncOutboundTimeoutHandler asyncOutboundTimeoutHandler, Executor executor) {
        try {
            this.populateProtocol();
            if (this.protocol == null) {
                return CompletionStageUtil.failedStage(new NetException(501));
            }
        }
        catch (NLException nLException) {
            return CompletionStageUtil.failedStage(new NetException(501));
        }
        try {
            if (this.nt == null || !this.nt.hasMoreInetAddresses()) {
                this.nt = this.getNT(properties, sSLContext, oracleHostnameResolver);
            }
            return this.nt.connectAsync(dMSNoun, asyncOutboundTimeoutHandler, executor);
        }
        catch (IOException iOException) {
            return CompletionStageUtil.failedStage(iOException);
        }
    }

    private void populateProtocol() throws NLException {
        NVPair nVPair = null;
        NVNavigator nVNavigator = new NVNavigator();
        NVPair nVPair2 = new NVFactory().createNVPair(this.addr);
        nVPair = nVNavigator.findNVPair(nVPair2, "PROTOCOL");
        if (nVPair == null) {
            throw new NLException("NoNVPair-04614", "PROTOCOL");
        }
        this.protocol = nVPair.getAtom();
    }

    public void restoreFromOrigCoption(ConnOption connOption) throws IOException {
        this.origSSLServerCertDN = connOption.origSSLServerCertDN;
        this.origServiceName = connOption.origServiceName;
        this.origSid = connOption.origSid;
        this.conn_data = connOption.conn_data;
        if (this.protocol.equalsIgnoreCase("tcps")) {
            String[] stringArray = new String[]{this.origSSLServerCertDN, this.origServiceName, this.origSid};
            this.nt.setOption(108, stringArray);
        }
    }

    @DisableTrace
    public String toString() {
        return "host=" + this.host + ", port=" + this.port + ", sid=" + this.sid + ", protocol=" + this.protocol + ", service_name=" + this.service_name + "\naddr=" + this.addr + "\nconn_data=" + this.conn_data + "\nsslServerCertDN=" + this.sslServerCertDN + ", origSSLServerCertDN=" + this.origSSLServerCertDN + ", origServiceName=" + this.origServiceName + ", origSid=" + this.origSid + ", done=" + this.done;
    }

    boolean isConnectionSocketKeepAlive() throws SocketException {
        return this.nt.isConnectionSocketKeepAlive();
    }
}

