/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plugin.api.types;

import java.util.Set;
import oracle.dbtools.plugin.api.types.TypeQualifier;
import oracle.dbtools.plugin.api.types.TypeReflection;

public interface TypeLocator {
    default public <T> TypeReflection<T> forType(Class<T> type) throws IllegalArgumentException {
        TypeReflection<T> untyped;
        Set<TypeReflection<T>> matches = this.selectType(TypeQualifier.type(type));
        if (matches == null || matches.isEmpty()) {
            throw new IllegalArgumentException(type.getCanonicalName());
        }
        TypeReflection<T> typed = untyped = matches.iterator().next();
        return typed;
    }

    default public <T> TypeReflection<T> get(Class<T> type) throws IllegalArgumentException {
        return this.forType(type);
    }

    public <T> Set<TypeReflection<? extends T>> selectType(TypeQualifier<T> var1);
}

