/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plugin.api.conf;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import oracle.dbtools.plugin.api.conf.ConfigurationStatus;
import oracle.dbtools.plugin.api.conf.TimeDuration;
import oracle.dbtools.plugin.api.di.Instances;
import oracle.dbtools.plugin.api.i18n.Translatable;
import oracle.dbtools.plugin.api.i18n.annotations.TranslatableText;
import oracle.dbtools.plugin.api.types.TypeReflections;

public final class ConfigurationSetting {
    private final Object defaultValue;
    private final Translatable description;
    private final boolean global;
    private final boolean override;
    private final boolean secure;
    private final ConfigurationStatus status;
    private final Class<?> type;

    private ConfigurationSetting(boolean global, boolean secure, Class<?> type, Object defaultValue, Translatable description, ConfigurationStatus status, boolean override) {
        this.global = global;
        this.secure = secure;
        this.type = type;
        this.defaultValue = defaultValue;
        this.description = description;
        this.status = status;
        this.override = override;
    }

    public Object defaultValue() {
        return this.defaultValue;
    }

    public Translatable description() {
        return this.description;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ConfigurationSetting other = (ConfigurationSetting)obj;
        return Objects.equals(this.defaultValue, other.defaultValue) && this.global == other.global && this.secure == other.secure && Objects.equals(this.type, other.type);
    }

    public int hashCode() {
        return Objects.hash(this.defaultValue, this.global, this.secure, this.type);
    }

    public boolean canOverride() {
        return this.override;
    }

    public boolean isGlobal() {
        return this.global;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public Builder modify() {
        return ConfigurationSetting.setting().global(this.global).secure(this.secure).type(this.type).defaultValue(this.defaultValue).description(this.description).status(this.status);
    }

    public ConfigurationStatus status() {
        return this.status;
    }

    public String toString() {
        StringBuilder builder2 = new StringBuilder();
        builder2.append("ConfigurationSetting [global=");
        builder2.append(this.global);
        builder2.append(", secure=");
        builder2.append(this.secure);
        builder2.append(", type=");
        builder2.append(this.type);
        builder2.append(", defaultValue=");
        builder2.append(this.defaultValue);
        builder2.append(", status=");
        builder2.append((Object)this.status);
        builder2.append("]");
        return builder2.toString();
    }

    public Class<?> type() {
        return this.type;
    }

    public static boolean isConfigurationType(Class<?> type) {
        return String.class == type || Boolean.TYPE == type || Boolean.class == type || Integer.TYPE == type || Integer.class == type || Long.TYPE == type || Long.class == type || Enum.class.isAssignableFrom(type);
    }

    public static Builder setting() {
        return new Builder();
    }

    public static ConfigurationSetting setting(boolean defaultValue) {
        return ConfigurationSetting.setting(defaultValue, null);
    }

    public static ConfigurationSetting setting(boolean defaultValue, Translatable description) {
        return new ConfigurationSetting(false, false, Boolean.class, defaultValue, description, ConfigurationStatus.DOCUMENTED, false);
    }

    public static <T extends Enum<T>> ConfigurationSetting setting(Class<T> type, T defaultValue) {
        return ConfigurationSetting.setting(type, defaultValue, null);
    }

    public static <T extends Enum<T>> ConfigurationSetting setting(Class<T> type, T defaultValue, Translatable description) {
        return new ConfigurationSetting(false, false, type, defaultValue, description, ConfigurationStatus.DOCUMENTED, false);
    }

    public static ConfigurationSetting setting(int defaultValue) {
        return ConfigurationSetting.setting(defaultValue, null);
    }

    public static ConfigurationSetting setting(int defaultValue, Translatable description) {
        return new ConfigurationSetting(false, false, Integer.class, defaultValue, description, ConfigurationStatus.DOCUMENTED, false);
    }

    public static ConfigurationSetting setting(long defaultValue) {
        return ConfigurationSetting.setting(defaultValue, null);
    }

    public static ConfigurationSetting setting(long defaultValue, Translatable description) {
        return new ConfigurationSetting(false, false, Long.class, defaultValue, description, ConfigurationStatus.DOCUMENTED, false);
    }

    public static ConfigurationSetting setting(String defaultValue) {
        return ConfigurationSetting.setting(defaultValue, null);
    }

    public static ConfigurationSetting setting(String defaultValue, Translatable description) {
        return new ConfigurationSetting(false, false, String.class, defaultValue, description, ConfigurationStatus.DOCUMENTED, false);
    }

    public static ConfigurationSetting setting(TimeDuration defaultValue) {
        return ConfigurationSetting.setting(defaultValue, null);
    }

    public static ConfigurationSetting setting(TimeDuration defaultValue, Translatable description) {
        return new ConfigurationSetting(false, false, TimeDuration.class, defaultValue, description, ConfigurationStatus.DOCUMENTED, false);
    }

    public static Map<String, ConfigurationSetting> settings(Class<?> type) {
        LinkedHashMap<String, ConfigurationSetting> settings = new LinkedHashMap<String, ConfigurationSetting>();
        List<Instances.QualifiedInstance<ConfigurationSetting>> configurationSettings = TypeReflections.builder().add(type).build().singletons().qualifiedInstances(ConfigurationSetting.class);
        for (Instances.QualifiedInstance qualifiedInstance : configurationSettings) {
            String name = qualifiedInstance.qualifier().name();
            ConfigurationSetting setting = (ConfigurationSetting)qualifiedInstance.get();
            settings.put(name, setting);
        }
        return settings;
    }

    public static class Builder {
        private Object defaultValue = null;
        private Translatable description;
        private boolean global = false;
        private boolean override = false;
        private boolean secure = false;
        private ConfigurationStatus status = ConfigurationStatus.DOCUMENTED;
        private Class<?> type = String.class;

        public ConfigurationSetting build() {
            return new ConfigurationSetting(this.global, this.secure, this.type, this.defaultValue, this.description, this.status, this.override);
        }

        public Builder defaultValue(Object defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public Builder description(Translatable description) {
            this.description = description;
            return this;
        }

        public Builder global(boolean global) {
            this.global = global;
            return this;
        }

        public Builder override(boolean override) {
            this.override = override;
            return this;
        }

        public Builder secure(boolean secure) {
            this.secure = secure;
            return this;
        }

        public Builder status(ConfigurationStatus status) {
            this.status = status;
            return this;
        }

        public Builder type(Class<?> type) {
            this.type = type;
            return this;
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    @Deprecated
    public static @interface Description {
        public TranslatableText[] examples() default {};

        public TranslatableText value();
    }
}

