/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plugin.api.types;

import jakarta.inject.Provider;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Objects;
import oracle.dbtools.plugin.api.di.annotations.Optional;
import oracle.dbtools.plugin.api.types.Primitive;
import oracle.dbtools.plugin.api.types.TypeQualifier;

public class TypeDependency {
    private final transient int hashCode;
    private final Kind kind;
    private final TypeQualifier<?> qualifier;

    private TypeDependency(Kind kind, TypeQualifier<?> qualifier) {
        this.kind = kind;
        this.qualifier = qualifier;
        this.hashCode = Objects.hash(new Object[]{kind, qualifier});
    }

    public String description() {
        StringBuilder b = new StringBuilder();
        b.append(" requires ");
        TypeQualifier<?> constraint = this.qualifier();
        b.append(constraint);
        return b.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TypeDependency)) {
            return false;
        }
        TypeDependency other = (TypeDependency)obj;
        return this.kind == other.kind && Objects.equals(this.qualifier, other.qualifier);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean isEmpty() {
        return this.qualifier.isEmpty();
    }

    public boolean isRequired() {
        return Kind.OPTIONAL != this.kind;
    }

    public Kind kind() {
        return this.kind;
    }

    public TypeQualifier<?> qualifier() {
        return this.qualifier;
    }

    public String selector() {
        StringBuilder b = new StringBuilder();
        switch (this.kind()) {
            case MULTIPLE: 
            case PROVIDER: {
                b.append("select");
                break;
            }
            case OPTIONAL: {
                b.append("optional");
                break;
            }
            default: {
                switch (Primitive.valueOf(this.type())) {
                    case REFERENCE: {
                        b.append("required");
                        break;
                    }
                    case BOOLEAN: {
                        b.append("booleanValue");
                        break;
                    }
                    case BYTE: {
                        b.append("byteValue");
                        break;
                    }
                    case CHAR: {
                        b.append("charValue");
                        break;
                    }
                    case DOUBLE: {
                        b.append("doubleValue");
                        break;
                    }
                    case FLOAT: {
                        b.append("floatValue");
                        break;
                    }
                    case INT: {
                        b.append("intValue");
                        break;
                    }
                    case LONG: {
                        b.append("longValue");
                        break;
                    }
                    case SHORT: {
                        b.append("shortValue");
                    }
                }
                b.append("(");
                b.append(this.qualifier().declaration());
                b.append(")");
            }
        }
        return b.toString();
    }

    public String toString() {
        String pkg;
        StringBuilder b = new StringBuilder();
        TypeQualifier<?> qualifier = this.qualifier();
        if (!qualifier.isEmpty()) {
            b.append(qualifier);
            b.append(' ');
        }
        if (Kind.PROVIDER == this.kind()) {
            b.append("Provider<");
        } else if (Kind.MULTIPLE == this.kind()) {
            b.append("Iterable<");
        } else if (Kind.OPTIONAL == this.kind()) {
            b.append("@Optional ");
        }
        String name = this.qualifier().type().getCanonicalName();
        Package thePackage = this.qualifier().type().getPackage();
        if (thePackage != null && !(pkg = thePackage.getName()).isEmpty() && !pkg.startsWith("java")) {
            name = name.substring(pkg.length() + 1);
        }
        b.append(name);
        if (Kind.PROVIDER == this.kind() || Kind.MULTIPLE == this.kind()) {
            b.append(">");
        }
        return b.toString();
    }

    public Class<?> type() {
        return this.qualifier.type();
    }

    public static TypeDependency from(Kind kind, TypeQualifier<?> service) {
        return new TypeDependency(kind, service);
    }

    static TypeDependency from(Parameter parameter) {
        Class parameterType = parameter.getType();
        Kind kind = Kind.REQUIRED;
        kind = Iterable.class == parameterType ? Kind.MULTIPLE : (Provider.class == parameterType ? Kind.PROVIDER : (parameter.getAnnotation(Optional.class) == null ? Kind.REQUIRED : Kind.OPTIONAL));
        Type genericType = TypeDependency.genericType(parameter);
        Class type = genericType == null ? parameterType : (Class)genericType;
        TypeQualifier qualifier = TypeQualifier.from(type, parameter.getAnnotations());
        return new TypeDependency(kind, qualifier);
    }

    private static Type genericType(Parameter parameter) {
        Type parameterType = parameter.getParameterizedType();
        if (parameterType != null && parameterType instanceof ParameterizedType) {
            Type typeParameter = ((ParameterizedType)parameterType).getActualTypeArguments()[0];
            return typeParameter;
        }
        return null;
    }

    public static enum Kind {
        MULTIPLE,
        OPTIONAL,
        PROVIDER,
        REQUIRED;


        boolean isOptional() {
            return MULTIPLE == this || OPTIONAL == this;
        }
    }
}

