/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plugin.api.errors;

import java.util.Objects;
import oracle.dbtools.plugin.api.i18n.Translatable;

public final class ProductErrorMessage {
    private final Translatable action;
    private final Translatable cause;
    private final Identifier id;
    private final Translatable message;

    private ProductErrorMessage(Identifier id, Translatable message, Translatable cause, Translatable action) {
        this.id = id;
        this.message = message;
        this.cause = cause;
        this.action = action;
    }

    public Translatable action() {
        return this.action;
    }

    public Translatable cause() {
        return this.cause;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ProductErrorMessage other = (ProductErrorMessage)obj;
        return Objects.equals(this.action, other.action) && Objects.equals(this.cause, other.cause) && Objects.equals(this.id, other.id) && Objects.equals(this.message, other.message);
    }

    public Identifier id() {
        return this.id;
    }

    public int hashCode() {
        return Objects.hash(this.action, this.cause, this.id, this.message);
    }

    public Translatable message() {
        return this.message;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append(this.id);
        b.append(": ");
        b.append(this.message);
        b.append(" Cause: ");
        b.append(this.cause);
        b.append(" Action: ");
        b.append(this.action);
        return b.toString();
    }

    public static class Identifier
    implements Comparable<Identifier> {
        private final int code;
        private final String prefix;

        private Identifier(CharSequence prefix, int code) {
            this.prefix = prefix.toString();
            this.code = code;
        }

        public ProductErrorMessage errorMessage(Translatable message, Translatable cause, Translatable action) {
            return new ProductErrorMessage(this, message, cause, action);
        }

        public static Identifier of(CharSequence prefix, int code) {
            if (code < 0 || code > 99999) {
                throw new IllegalArgumentException();
            }
            Objects.requireNonNull(prefix);
            return new Identifier(prefix, code);
        }

        @Override
        public int compareTo(Identifier o) {
            int diff = this.prefix.compareTo(o.prefix);
            if (diff == 0) {
                diff = this.code - o.code;
            }
            return diff;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Identifier other = (Identifier)obj;
            return this.code == other.code && Objects.equals(this.prefix, other.prefix);
        }

        public int hashCode() {
            return Objects.hash(this.code, this.prefix);
        }

        public String toString() {
            StringBuilder b = new StringBuilder(this.prefix.length() + 6);
            b.append(this.prefix);
            b.append('-');
            b.append(String.format("%05d", this.code));
            return b.toString();
        }
    }
}

