/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plugin.api.conf;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalUnit;
import java.time.temporal.UnsupportedTemporalTypeException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class TimeDuration
implements Comparable<TimeDuration>,
TemporalAmount {
    private final long duration;
    private final TimeUnit unit;
    private static final TimeDuration DISABLED = new TimeDuration(-1L, TimeUnit.SECONDS);

    public TimeDuration(long duration, TimeUnit unit) {
        this.unit = duration < 0L ? TimeUnit.SECONDS : unit;
        this.duration = duration < 0L ? -1L : duration;
    }

    @Override
    public int compareTo(TimeDuration o) {
        long other = this.unit.convert(o.duration(), o.unit());
        if (this.duration < other) {
            return -1;
        }
        if (this.duration == other) {
            return 0;
        }
        return 1;
    }

    public long convertTo(TimeUnit timeUnit) {
        return timeUnit.convert(this.duration, this.unit);
    }

    public boolean enabled() {
        return this.duration >= 0L;
    }

    public long duration() {
        return this.duration;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimeDuration other = (TimeDuration)obj;
        long otherDuration = this.unit.convert(other.duration(), other.unit());
        return this.duration == otherDuration;
    }

    public boolean exceeded(long start, long end) {
        if (this.duration < 0L) {
            return false;
        }
        long expectedEnd = start + TimeUnit.MILLISECONDS.convert(this.duration, this.unit);
        return end > expectedEnd;
    }

    public boolean exceeded(Instant start, Instant end) {
        if (this.duration < 0L) {
            return false;
        }
        Instant expectedEnd = start.plusMillis(this.unit.toMillis(this.duration));
        return end.compareTo(expectedEnd) > 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.duration ^ this.duration >>> 32);
        result = 31 * result + (this.unit == null ? 0 : this.unit.hashCode());
        return result;
    }

    public long toMillis() {
        return this.unit.toMillis(this.duration);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(Long.toString(this.duration));
        switch (this.unit) {
            case DAYS: {
                builder.append('d');
                break;
            }
            case HOURS: {
                builder.append('h');
                break;
            }
            case MINUTES: {
                builder.append('m');
                break;
            }
            case SECONDS: {
                builder.append('s');
                break;
            }
            case MILLISECONDS: {
                builder.append("ms");
                break;
            }
            case MICROSECONDS: {
                builder.append("us");
                break;
            }
            case NANOSECONDS: {
                builder.append("ns");
            }
        }
        return builder.toString();
    }

    public TimeUnit unit() {
        return this.unit;
    }

    public static TimeDuration disabled() {
        return DISABLED;
    }

    public static TimeDuration parse(String text) {
        long duration;
        TimeUnit unit = TimeUnit.SECONDS;
        if (text.length() == 0) {
            throw new IllegalArgumentException(text);
        }
        int end = text.length();
        if (text.length() > 1) {
            --end;
            char[] suffix = text.substring(text.length() - 2, text.length()).toCharArray();
            char lastChar = suffix[1];
            char secondLastChar = suffix[0];
            block0 : switch (lastChar) {
                case 'd': {
                    unit = TimeUnit.DAYS;
                    break;
                }
                case 'h': {
                    unit = TimeUnit.HOURS;
                    break;
                }
                case 'm': {
                    unit = TimeUnit.MINUTES;
                    break;
                }
                case 's': {
                    switch (secondLastChar) {
                        case 'm': {
                            unit = TimeUnit.MILLISECONDS;
                            --end;
                            break block0;
                        }
                        case 'u': {
                            unit = TimeUnit.MICROSECONDS;
                            --end;
                            break block0;
                        }
                        case 'n': {
                            unit = TimeUnit.NANOSECONDS;
                            --end;
                            break block0;
                        }
                    }
                    unit = TimeUnit.SECONDS;
                    break;
                }
                default: {
                    end = text.length();
                    unit = TimeUnit.SECONDS;
                }
            }
        }
        if ((duration = Long.parseLong(text.substring(0, end))) < 0L) {
            return DISABLED;
        }
        return new TimeDuration(duration, unit);
    }

    private static final ChronoUnit toChronoUnit(TimeUnit unit) {
        switch (unit) {
            case NANOSECONDS: {
                return ChronoUnit.NANOS;
            }
            case MICROSECONDS: {
                return ChronoUnit.MICROS;
            }
            case MILLISECONDS: {
                return ChronoUnit.MILLIS;
            }
            case SECONDS: {
                return ChronoUnit.SECONDS;
            }
            case MINUTES: {
                return ChronoUnit.MINUTES;
            }
            case HOURS: {
                return ChronoUnit.HOURS;
            }
            case DAYS: {
                return ChronoUnit.DAYS;
            }
        }
        throw new AssertionError();
    }

    @Override
    public long get(TemporalUnit unit) {
        if (unit == TimeDuration.toChronoUnit(this.unit)) {
            return this.duration;
        }
        throw new UnsupportedTemporalTypeException("Unsupported unit: " + unit);
    }

    @Override
    public List<TemporalUnit> getUnits() {
        return Arrays.asList(TimeDuration.toChronoUnit(this.unit));
    }

    @Override
    public Temporal addTo(Temporal temporal) {
        if (this.duration > 0L) {
            Temporal modified = temporal.plus(this.duration, TimeDuration.toChronoUnit(this.unit));
            return modified;
        }
        return temporal;
    }

    @Override
    public Temporal subtractFrom(Temporal temporal) {
        if (this.duration > 0L) {
            Temporal modified = temporal.minus(this.duration, TimeDuration.toChronoUnit(this.unit));
            return modified;
        }
        return temporal;
    }
}

