/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plugin.api.types;

import jakarta.inject.Qualifier;
import jakarta.inject.Scope;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class AnnotationSet
implements Iterable<Annotation> {
    private final Map<Class<?>, Annotation> annotations;
    private final int hashCode;
    private final transient Set<Annotation> qualifiers;
    private final transient Annotation scope;
    private final transient AnnotatedElement element;

    private AnnotationSet(AnnotatedElement element, Map<Class<?>, Annotation> annotations, Set<Annotation> qualifiers, Annotation scope) {
        this.element = element;
        this.annotations = annotations;
        this.qualifiers = qualifiers;
        this.scope = scope;
        this.hashCode = Objects.hash(annotations);
    }

    public AnnotatedElement element() {
        return this.element;
    }

    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this.getAnnotation(annotationClass) != null;
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        Annotation unchecked;
        Annotation downcast = unchecked = this.annotations.get(annotationClass);
        return (T)downcast;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AnnotationSet)) {
            return false;
        }
        AnnotationSet other = (AnnotationSet)obj;
        return Objects.equals(this.annotations, other.annotations);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean isEmpty() {
        return this.annotations.isEmpty();
    }

    @Override
    public Iterator<Annotation> iterator() {
        return this.annotations.values().iterator();
    }

    public Set<Annotation> qualifiers() {
        return this.qualifiers;
    }

    public Annotation scope() {
        return this.scope;
    }

    public int size() {
        return this.annotations.size();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AnnotationSet [annotations=");
        builder.append(this.annotations);
        builder.append("]");
        return builder.toString();
    }

    public static AnnotationSet from(AnnotatedElement element) {
        LinkedHashMap<Class<? extends Annotation>, Annotation> annotations = new LinkedHashMap<Class<? extends Annotation>, Annotation>();
        LinkedHashSet<Annotation> qualifiers = new LinkedHashSet<Annotation>();
        Annotation scope = null;
        for (Annotation annotation : element.getAnnotations()) {
            Class<? extends Annotation> annotationType = annotation.annotationType();
            annotations.put(annotationType, annotation);
            if (AnnotationSet.isQualifier(annotation)) {
                qualifiers.add(annotation);
            }
            if (!AnnotationSet.isScope(annotation)) continue;
            scope = annotation;
        }
        return new AnnotationSet(element, Collections.unmodifiableMap(annotations), Collections.unmodifiableSet(qualifiers), scope);
    }

    private static boolean isQualifier(Annotation annotation) {
        Qualifier qualifier = annotation.annotationType().getAnnotation(Qualifier.class);
        return qualifier != null;
    }

    private static boolean isScope(Annotation annotation) {
        Scope scope = annotation.annotationType().getAnnotation(Scope.class);
        return scope != null;
    }
}

