/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plugin.apt;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.Elements;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import oracle.dbtools.plugin.apt.InstantiableTypes;

@SupportedAnnotationTypes(value={"oracle.dbtools.plugin.api.di.annotations.Provides"})
public class AnnotationProcessor
extends AbstractProcessor {
    private final InstantiableTypes instantiables;
    private final Descriptor providers = new Descriptor("META-INF/oracle.dbtools.plugin.api.di.providers");
    public static final String SERVICE_PATH = "META-INF/oracle.dbtools.plugin.api.di.providers";
    static final String PROVIDES_ANNOTATION = "oracle.dbtools.plugin.api.di.annotations.Provides";

    public AnnotationProcessor() {
        this.instantiables = new InstantiableTypes();
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Filer filer = this.processingEnv.getFiler();
        Messager messager = this.processingEnv.getMessager();
        if (roundEnv.processingOver()) {
            this.providers.write(filer);
            for (String type : this.providers) {
                messager.printMessage(Diagnostic.Kind.NOTE, "Discovered type annotated with @Provides: " + type);
            }
        } else {
            this.processProviders(roundEnv, messager, filer);
        }
        return true;
    }

    private void processInstanceProvider(Messager messager, Elements elements, Element element) {
        boolean isFinalStaticField;
        VariableElement field = (VariableElement)VariableElement.class.cast(element);
        Set<Modifier> modifiers = field.getModifiers();
        TypeElement parent = (TypeElement)TypeElement.class.cast(field.getEnclosingElement());
        String parentTypeName = elements.getBinaryName(parent).toString();
        String fieldName = parentTypeName + "." + field.getSimpleName();
        boolean bl = isFinalStaticField = modifiers.contains((Object)Modifier.FINAL) && modifiers.contains((Object)Modifier.STATIC);
        if (isFinalStaticField) {
            this.providers.add(parentTypeName);
        } else {
            messager.printMessage(Diagnostic.Kind.ERROR, "The following field must be final and static when annotated with @Provides " + fieldName);
        }
    }

    private void processProviders(RoundEnvironment roundEnv, Messager messager, Filer filer) {
        this.providers.read(filer);
        Elements elements = this.processingEnv.getElementUtils();
        TypeElement provides = this.processingEnv.getElementUtils().getTypeElement(PROVIDES_ANNOTATION);
        for (Element element : roundEnv.getElementsAnnotatedWith(provides)) {
            switch (element.getKind()) {
                case CLASS: {
                    this.processServiceProvider(filer, messager, elements, element);
                    break;
                }
                case FIELD: {
                    this.processInstanceProvider(messager, elements, element);
                }
            }
        }
    }

    private void processServiceProvider(Filer filer, Messager messager, Elements elements, Element element) {
        TypeElement type = (TypeElement)TypeElement.class.cast(element);
        boolean instantiable = this.instantiables.isInstantiable(type);
        String name = elements.getBinaryName(type).toString();
        if (instantiable || !this.instantiables.isConcreteType(type)) {
            this.providers.add(name);
        }
    }

    private static class Descriptor
    implements Iterable<String> {
        private final Set<String> elements = new ConcurrentSkipListSet<String>();
        private final String path;

        Descriptor(String path) {
            this.path = path;
        }

        @Override
        public Iterator<String> iterator() {
            return this.elements.iterator();
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Descriptor [path=");
            builder.append(this.path);
            builder.append(", elements=");
            builder.append(this.elements);
            builder.append("]");
            return builder.toString();
        }

        void add(String element) {
            this.elements.add(element);
        }

        void read(Filer filer) {
            try {
                FileObject file = filer.getResource(StandardLocation.CLASS_OUTPUT, "", this.path);
                try (BufferedReader r = new BufferedReader(new InputStreamReader(file.openInputStream(), "UTF-8"));){
                    String line;
                    while ((line = r.readLine()) != null) {
                        this.elements.add(line);
                    }
                }
                catch (IOException iOException) {}
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        void write(Filer filer) {
            if (this.elements.isEmpty()) {
                return;
            }
            try {
                FileObject file = filer.createResource(StandardLocation.CLASS_OUTPUT, "", this.path, new Element[0]);
                try (Writer w = file.openWriter();){
                    for (String element : this.elements) {
                        w.write(element);
                        w.write("\n");
                    }
                    w.flush();
                }
                catch (IOException exceptionForWriter) {
                    throw new RuntimeException(exceptionForWriter);
                }
            }
            catch (IOException exceptionForFileObject) {
                throw new RuntimeException(exceptionForFileObject);
            }
        }
    }
}

