/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plugin.api.types;

import jakarta.inject.Qualifier;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import oracle.dbtools.plugin.api.di.annotations.Provides;
import oracle.dbtools.plugin.api.types.AnnotationSet;
import oracle.dbtools.plugin.api.types.TypeQualifier;

public class ProvidedClassifier {
    private static final ProvidedClassifier INSTANCE = new ProvidedClassifier();

    private ProvidedClassifier() {
    }

    public Set<TypeQualifier<?>> provides(AnnotatedElement element) {
        if (element instanceof Class) {
            return this.provides((Class)element);
        }
        if (element instanceof Field) {
            return this.provides((Field)element);
        }
        return Collections.emptySet();
    }

    public Set<TypeQualifier<?>> provides(AnnotationSet annotations) {
        Set<Annotation> qualifiers = annotations.qualifiers();
        Set<Class<?>> types = this.inferredTypes(annotations);
        Set<TypeQualifier<?>> inferred = this.typeQualifiers(qualifiers, types);
        Provides provides = annotations.getAnnotation(Provides.class);
        return this.provides(provides, inferred, qualifiers);
    }

    public Set<TypeQualifier<?>> provides(Class<?> type) {
        List<Annotation> qualifiers = this.qualifiers(type);
        Set<Class<?>> types = this.inferredTypes(type);
        Set<TypeQualifier<?>> inferred = this.typeQualifiers(qualifiers, types);
        Provides provides = type.getAnnotation(Provides.class);
        return this.provides(provides, inferred, qualifiers);
    }

    public Set<TypeQualifier<?>> provides(Field field) throws IllegalArgumentException {
        int modifier = field.getModifiers();
        if (Modifier.isStatic(modifier) && Modifier.isFinal(modifier)) {
            List<Annotation> qualifiers = this.qualifiers(field);
            Set<Class<?>> types = this.inferredTypes(field);
            Set<TypeQualifier<?>> inferred = this.typeQualifiers(qualifiers, types);
            Provides provides = field.getAnnotation(Provides.class);
            if (provides != null || this.isQualified(field)) {
                return this.provides(provides, inferred, qualifiers);
            }
            return Collections.emptySet();
        }
        throw new IllegalArgumentException(field.toGenericString());
    }

    private Set<Class<?>> inferredTypes(AnnotationSet annotations) {
        AnnotatedElement element = annotations.element();
        if (element instanceof Class) {
            return this.inferredTypes((Class)element);
        }
        if (element instanceof Field) {
            return this.inferredTypes((Field)element);
        }
        throw new IllegalArgumentException(element.toString());
    }

    private Set<Class<?>> inferredTypes(Class<?> type) {
        int modifiers;
        Class<?> superType;
        Set<Object> provides = Collections.emptySet();
        provides = ProvidedClassifier.asSet(type.getInterfaces());
        if (provides.isEmpty() && (superType = type.getSuperclass()) != null && !Object.class.equals(superType) && Modifier.isAbstract(modifiers = superType.getModifiers())) {
            provides = ProvidedClassifier.asSet(superType);
        }
        if (provides.isEmpty()) {
            provides = ProvidedClassifier.asSet(type);
        }
        return provides;
    }

    private Set<Class<?>> inferredTypes(Field field) {
        return ProvidedClassifier.asSet(field.getType());
    }

    private boolean isQualified(Field field) {
        for (Annotation annotation : field.getAnnotations()) {
            if (!this.isQualifier(annotation)) continue;
            return true;
        }
        return false;
    }

    private boolean isQualifier(Annotation annotation) {
        Qualifier qualifier = annotation.annotationType().getAnnotation(Qualifier.class);
        return qualifier != null;
    }

    private Set<TypeQualifier<?>> provides(Provides descriptor, Set<TypeQualifier<?>> inferred, Iterable<Annotation> qualifiers) {
        if (descriptor == null || descriptor.value().length == 0) {
            return inferred;
        }
        return this.typeQualifiers(qualifiers, Arrays.asList(descriptor.value()));
    }

    private List<Annotation> qualifiers(AnnotatedElement element) {
        ArrayList<Annotation> qualifiers = new ArrayList<Annotation>();
        Annotation[] annotations = element.getAnnotations();
        if (annotations != null) {
            for (Annotation annotation : annotations) {
                if (!this.isQualifier(annotation)) continue;
                qualifiers.add(annotation);
            }
        }
        return qualifiers;
    }

    private Set<TypeQualifier<?>> typeQualifiers(Iterable<Annotation> qualifiers, Iterable<Class<?>> types) {
        LinkedHashSet typeQualifiers = new LinkedHashSet();
        for (Class<?> type : types) {
            TypeQualifier<?> typeQualifier = TypeQualifier.from(type, qualifiers);
            typeQualifiers.add(typeQualifier);
        }
        return typeQualifiers;
    }

    public static ProvidedClassifier instance() {
        return INSTANCE;
    }

    @SafeVarargs
    private static Set<Class<?>> asSet(Class<?> ... items) {
        return new LinkedHashSet(Arrays.asList(items));
    }
}

