/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plugin.api.types;

import oracle.dbtools.plugin.api.types.PrimitiveWrapper;

public enum Primitive {
    BOOLEAN(Boolean.TYPE, Boolean.class),
    BYTE(Byte.TYPE, Byte.class),
    CHAR(Character.TYPE, Character.class),
    DOUBLE(Double.TYPE, Double.class),
    FLOAT(Float.TYPE, Float.class),
    INT(Integer.TYPE, Integer.class),
    LONG(Long.TYPE, Long.class),
    REFERENCE(Object.class, Object.class),
    SHORT(Short.TYPE, Short.class);

    private final Class<?> type;
    private final Class<?> wrapper;

    private Primitive(Class<?> type, Class<?> wrapper) {
        this.type = type;
        this.wrapper = wrapper;
    }

    public PrimitiveWrapper wrapper() {
        return PrimitiveWrapper.valueOf(this.wrapper);
    }

    public boolean booleanValue(Object value) {
        return (Boolean)Boolean.class.cast(value);
    }

    public byte byteValue(Object value) {
        return (Byte)Byte.class.cast(value);
    }

    public char charValue(Object value) {
        return ((Character)Character.class.cast(value)).charValue();
    }

    public double doubleValue(Object value) {
        return (Double)Double.class.cast(value);
    }

    public float floatValue(Object value) {
        return ((Float)Float.class.cast(value)).floatValue();
    }

    public int intValue(Object value) {
        return (Integer)Integer.class.cast(value);
    }

    public final boolean isPrimitive() {
        return REFERENCE != this;
    }

    public long longValue(Object value) {
        return (Long)Long.class.cast(value);
    }

    public short shortValue(Object value) {
        return (Short)Short.class.cast(value);
    }

    public Class<?> wrapperType() {
        return this.wrapper;
    }

    public Class<?> type() {
        return this.type;
    }

    public static Primitive valueOf(Class<?> type) {
        if (Boolean.TYPE == type) {
            return BOOLEAN;
        }
        if (Byte.TYPE == type) {
            return BYTE;
        }
        if (Character.TYPE == type) {
            return CHAR;
        }
        if (Double.TYPE == type) {
            return DOUBLE;
        }
        if (Float.TYPE == type) {
            return FLOAT;
        }
        if (Integer.TYPE == type) {
            return INT;
        }
        if (Long.TYPE == type) {
            return LONG;
        }
        if (Short.TYPE == type) {
            return SHORT;
        }
        return REFERENCE;
    }
}

