/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plugin.api.di;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import oracle.dbtools.plugin.api.di.InstanceProvider;
import oracle.dbtools.plugin.api.types.TypeDependencyNotAvailableException;
import oracle.dbtools.plugin.api.types.TypeQualifier;

public class ResolvedInstances<T>
implements InstanceProvider<T> {
    private final List<Throwable> errors;
    private final List<T> matches;
    private final TypeQualifier<T> qualifier;

    private ResolvedInstances(TypeQualifier<T> qualifier, Collection<Throwable> errors, Iterable<T> matches) {
        this.qualifier = qualifier;
        this.errors = errors.isEmpty() ? Collections.emptyList() : new ArrayList<Throwable>(errors);
        this.matches = new ArrayList<T>();
        for (T match : matches) {
            this.matches.add(match);
        }
    }

    @Override
    public T get() {
        if (this.isUnsatisfied()) {
            if (this.errors.isEmpty()) {
                throw TypeDependencyNotAvailableException.from(this.qualifier);
            }
            throw TypeDependencyNotAvailableException.from(this.qualifier, this.errors.get(0));
        }
        return this.matches.get(0);
    }

    @Override
    public boolean hasMultiple() {
        return this.matches.size() > 1;
    }

    @Override
    public boolean isUnsatisfied() {
        return this.matches.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return this.matches.iterator();
    }

    @Override
    public TypeQualifier<T> qualifier() {
        return this.qualifier;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.matches);
        return builder.toString();
    }

    void add(T instance) {
        this.matches.add(instance);
    }

    @SafeVarargs
    public static <T> ResolvedInstances<T> matches(InstanceProvider<T> firstMatch, InstanceProvider<T> ... subsequentMatches) {
        TypeQualifier<T> qualifier = firstMatch.qualifier();
        Iterable<T> allMatches = ResolvedInstances.sequence(firstMatch, Arrays.asList(subsequentMatches));
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        if (firstMatch instanceof ResolvedInstances) {
            errors.addAll(((ResolvedInstances)firstMatch).errors);
        }
        for (InstanceProvider<T> match : subsequentMatches) {
            if (!(match instanceof ResolvedInstances)) continue;
            errors.addAll(((ResolvedInstances)match).errors);
        }
        return ResolvedInstances.matches(qualifier, errors, allMatches);
    }

    public static <T> ResolvedInstances<T> matches(TypeQualifier<T> qualifier, Collection<Throwable> errors, Iterable<T> matches) {
        return new ResolvedInstances<T>(qualifier, errors, matches);
    }

    static <T> ResolvedInstances<T> empty(TypeQualifier<T> service) {
        return new ResolvedInstances<T>(service, Collections.emptyList(), Collections.emptyList());
    }

    private static <T> Iterable<T> sequence(Iterable<T> first, Iterable<Iterable<T>> subsequent) {
        Iterator<Iterable<T>> iter = subsequent.iterator();
        Stream stream = StreamSupport.stream(first.spliterator(), false);
        while (iter.hasNext()) {
            Iterable<T> iterable = iter.next();
            Stream<T> next = StreamSupport.stream(iterable.spliterator(), false);
            stream = Stream.concat(stream, next);
        }
        List results = stream.collect(Collectors.toList());
        return results;
    }
}

