/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plugin.api.di;

import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import oracle.dbtools.plugin.api.di.DependencyInjectionModule;

public class ModuleDependencies {
    private final Set<Class<? extends DependencyInjectionModule>> dependencies;

    private ModuleDependencies(Set<Class<? extends DependencyInjectionModule>> dependencies) {
        this.dependencies = Collections.unmodifiableSet(new LinkedHashSet<Class<? extends DependencyInjectionModule>>(dependencies));
    }

    public Set<Class<? extends DependencyInjectionModule>> dependencies() {
        return this.dependencies;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModuleDependencies)) {
            return false;
        }
        ModuleDependencies other = (ModuleDependencies)obj;
        return Objects.equals(this.dependencies, other.dependencies);
    }

    public int hashCode() {
        return Objects.hash(this.dependencies);
    }

    public String toString() {
        StringBuilder builder2 = new StringBuilder();
        builder2.append("ModuleDependencies [dependencies=");
        builder2.append(this.dependencies);
        builder2.append("]");
        return builder2.toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Set<Class<? extends DependencyInjectionModule>> dependencies = new LinkedHashSet<Class<? extends DependencyInjectionModule>>();

        private Builder() {
        }

        public Builder add(Class<? extends DependencyInjectionModule> module) {
            this.dependencies.add(module);
            return this;
        }

        public Builder add(Class<? extends DependencyInjectionModule> ... modules) {
            return this.add(Arrays.asList(modules));
        }

        public Builder add(Iterable<Class<? extends DependencyInjectionModule>> modules) {
            for (Class<? extends DependencyInjectionModule> module : modules) {
                this.add(module);
            }
            return this;
        }

        public ModuleDependencies build() {
            return null;
        }
    }
}

