/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plugin.api.types;

import java.util.Comparator;
import oracle.dbtools.plugin.api.di.Annotations;
import oracle.dbtools.plugin.api.di.annotations.Priority;
import oracle.dbtools.plugin.api.types.TypeReflection;

final class TypePriorityComparator
implements Comparator<TypeReflection<?>> {
    private static final Priority DEFAULT_PRIORITY = Annotations.instance().literal(Priority.class);
    private static final TypePriorityComparator INSTANCE = new TypePriorityComparator();

    private TypePriorityComparator() {
    }

    @Override
    public int compare(TypeReflection<?> o1, TypeReflection<?> o2) {
        Priority p1 = this.priority(o1);
        Priority p2 = this.priority(o2);
        int comparison = Integer.compare(p1.ring(), p2.ring());
        if (comparison == 0) {
            comparison = Integer.compare(p2.value(), p1.value());
        }
        if (comparison == 0) {
            comparison = o1.compareTo(o2);
        }
        return comparison;
    }

    public static TypePriorityComparator instance() {
        return INSTANCE;
    }

    private Priority priority(TypeReflection<?> type) {
        Priority priority = type.getAnnotation(Priority.class);
        if (priority == null) {
            priority = DEFAULT_PRIORITY;
        }
        return priority;
    }
}

