/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.ords.metrics;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.ConfigFileAuthenticationDetailsProvider;
import com.oracle.bmc.auth.InstancePrincipalsAuthenticationDetailsProvider;
import com.oracle.bmc.monitoring.MonitoringClient;
import com.oracle.bmc.monitoring.model.Datapoint;
import com.oracle.bmc.monitoring.model.MetricDataDetails;
import com.oracle.bmc.monitoring.model.PostMetricDataDetails;
import com.oracle.bmc.monitoring.model.PostMetricDataResponseDetails;
import com.oracle.bmc.monitoring.requests.PostMetricDataRequest;
import com.oracle.bmc.monitoring.responses.PostMetricDataResponse;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import oracle.dbtools.ords.metrics.InstanceInfo;
import oracle.dbtools.ords.metrics.InstanceMetadata;
import oracle.dbtools.ords.metrics.MetricDataCount;
import oracle.dbtools.ords.metrics.MetricTransmitter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OCIMetricTransmitter
implements MetricTransmitter {
    private static final Logger log = LoggerFactory.getLogger(OCIMetricTransmitter.class);
    static final String DIMENSION_TENANT = "tenant";
    static final String DIMENSION_HOST = "host";
    static final String DIMENSION_AD = "availabilityDomain";
    static final String DIMENSION_FD = "faultDomain";
    static final int POST_STREAM_MAX = 50;
    private final MonitoringClient monitoringClient;
    private final String compartment;
    private final String namespace;
    private final String resource;
    private final boolean hasTenant;
    private final Map<String, String> dimensions = new HashMap<String, String>();
    private long failCount;

    public OCIMetricTransmitter(String compartment, String namespace, String resource, String host, String profile, boolean t2) throws IOException {
        this.monitoringClient = ((MonitoringClient.Builder)MonitoringClient.builder().configuration(ClientConfiguration.builder().retryConfiguration(RetryConfiguration.SDK_DEFAULT_RETRY_CONFIGURATION).build())).build((AbstractAuthenticationDetailsProvider)(profile != null ? new ConfigFileAuthenticationDetailsProvider(profile) : InstancePrincipalsAuthenticationDetailsProvider.builder().build()));
        this.monitoringClient.setEndpoint(this.monitoringClient.getEndpoint().replace("telemetry", "telemetry-ingestion"));
        InstanceInfo instanceInfo = t2 ? InstanceMetadata.collect() : null;
        this.compartment = t2 ? this.getT2CompartmentId(instanceInfo) : compartment;
        this.namespace = namespace;
        this.resource = resource;
        this.hasTenant = t2;
        this.dimensions.put(DIMENSION_HOST, host);
        if (t2) {
            this.dimensions.put(DIMENSION_AD, instanceInfo.ociAdName);
            this.dimensions.put(DIMENSION_FD, this.getFaultDomainId(instanceInfo));
        }
    }

    public long getFailCount() {
        return this.failCount;
    }

    @Override
    public void send(List<MetricDataCount> data) {
        if (data.isEmpty()) {
            return;
        }
        List<MetricDataDetails> details = data.stream().collect(Collectors.groupingBy(TenantName::new)).entrySet().stream().map(entry -> MetricDataDetails.builder().compartmentId(this.compartment).namespace(this.namespace).resourceGroup(this.resource).name(((TenantName)entry.getKey()).name).datapoints(((List)entry.getValue()).stream().map(dp -> Datapoint.builder().timestamp(new Date(dp.getTimestamp())).count(Integer.valueOf(dp.getCount())).value(Double.valueOf(dp.getValue())).build()).collect(Collectors.toList())).dimensions(this.getDimensions(((TenantName)entry.getKey()).tenant)).build()).collect(Collectors.toList());
        if (details.size() <= 50) {
            this.post(details);
        } else {
            for (int i = 0; i < details.size(); i += 50) {
                this.post(details.subList(i, Math.min(i + 50, details.size())));
            }
        }
    }

    @Override
    public void send(MetricDataCount data) {
        List<MetricDataDetails> details = Collections.singletonList(MetricDataDetails.builder().compartmentId(this.compartment).namespace(this.namespace).resourceGroup(this.resource).name(data.getName()).datapoints(Collections.singletonList(Datapoint.builder().timestamp(new Date(data.getTimestamp())).count(Integer.valueOf(data.getCount())).value(Double.valueOf(data.getValue())).build())).dimensions(this.getDimensions(data.getTenant())).build());
        this.post(details);
    }

    private void post(List<MetricDataDetails> details) {
        PostMetricDataResponse response;
        PostMetricDataRequest request = PostMetricDataRequest.builder().postMetricDataDetails(PostMetricDataDetails.builder().metricData(details).build()).build();
        log.debug("Request: {}", (Object)request.toString());
        try {
            response = this.monitoringClient.postMetricData(request);
        }
        catch (Exception e) {
            log.error("Cannot post metrics: {}", (Object)e.toString());
            details.forEach(rec -> log.error("Failed: {}", (Object)rec.toString()));
            this.failCount += (long)details.size();
            return;
        }
        PostMetricDataResponseDetails responseDetails = response.getPostMetricDataResponseDetails();
        if (responseDetails.getFailedMetricsCount() > 0) {
            this.failCount += (long)responseDetails.getFailedMetricsCount().intValue();
            responseDetails.getFailedMetrics().forEach(rec -> log.error("Post metric failed: {}", (Object)rec.toString()));
        }
        log.debug("Response [opc-request-id: {}]: {}", (Object)response.getOpcRequestId(), (Object)response.getPostMetricDataResponseDetails());
    }

    private Map<String, String> getDimensions(String tenant) {
        if (this.hasTenant && tenant != null) {
            HashMap<String, String> tenantDimensions = new HashMap<String, String>(this.dimensions);
            tenantDimensions.put(DIMENSION_TENANT, tenant);
            return tenantDimensions;
        }
        return this.dimensions;
    }

    public void close() {
        this.monitoringClient.close();
    }

    private String getT2CompartmentId(InstanceInfo instance) {
        String region = instance.region;
        String realm = instance.regionInfo.realmKey;
        if (region.equals("r1") || region.equals("sea") || region.equalsIgnoreCase("us-seattle-1")) {
            return "ocid1.compartment.region1..aaaaaaaasfm6ym4xn4o7bk27vwt6mswiibyqwqxo654hkf4l27whzlhcbvka";
        }
        return switch (realm) {
            case "oc1" -> "ocid1.compartment.oc1..aaaaaaaagixeyxsjv643gwx5vf6dkuwmvvf4dlf7k6sobwzbjrtce4lvndwq";
            case "oc2" -> "ocid1.compartment.oc2..aaaaaaaaxdh2pzeumdaqc4oukomeqzqnuwvdgyqg524k536ifbhiicmdt6aa";
            case "oc3" -> "ocid1.compartment.oc3..aaaaaaaapa74z64fu5zpjwntqbmfp6mh7vgeboswqd4wo6prnkgancwpkaoq";
            case "oc4" -> "ocid1.compartment.oc4..aaaaaaaazhf44ssrbzgrz4plybe2q6mzsdyafjb3bwc67jgkimhaldwurpva";
            default -> String.format("ocid1.compartment.%s..aaaaaaaawratuwq6uxcid7nnfe64rk7l5yr4zrnlkgy7ufw733ft2njfsjda", realm);
        };
    }

    private String getFaultDomainId(InstanceInfo instance) {
        return instance.faultDomain.startsWith("FAULT-DOMAIN-") ? instance.faultDomain.substring(13) : "";
    }

    static class TenantName {
        final String tenant;
        final String name;

        TenantName(MetricDataCount m) {
            this.tenant = m.getTenant();
            this.name = m.getName();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TenantName that = (TenantName)o;
            return Objects.equals(this.tenant, that.tenant) && Objects.equals(this.name, that.name);
        }

        public int hashCode() {
            return Objects.hash(this.tenant, this.name);
        }
    }
}

