/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.ords.metrics;

import oracle.dbtools.ords.metrics.AccessLogRecord;
import oracle.dbtools.ords.metrics.MetricBuffer;
import oracle.dbtools.ords.metrics.MetricData;
import oracle.dbtools.ords.metrics.MetricDataCount;
import oracle.dbtools.ords.metrics.MetricTransmitter;
import oracle.dbtools.ords.metrics.StatusCodeList;

public class MetricReporter {
    static final String HTTP_STATUS_PREFIX = "HttpStatus";
    private static final int DEFAULT_BUFFER_SIZE = 8192;
    private final MetricTransmitter transmitter;
    private final String prefix;
    private final StatusCodeList includeCodes;
    private final boolean respTime;
    private final MetricBuffer buf;

    public MetricReporter(MetricTransmitter transmitter, String prefix, StatusCodeList codes, boolean respTime) {
        this.transmitter = transmitter;
        this.prefix = prefix == null ? "" : prefix;
        this.includeCodes = codes;
        this.respTime = respTime;
        this.buf = new MetricBuffer(8192, transmitter::send);
    }

    MetricReporter(MetricTransmitter transmitter, String prefix) {
        this(transmitter, prefix, new StatusCodeList(), false);
    }

    public void emit(AccessLogRecord record) {
        int statusCode = record.statusCode();
        if (!this.includeCodes.contain(statusCode)) {
            return;
        }
        String name = String.format("%s%s%d", this.prefix, HTTP_STATUS_PREFIX, statusCode);
        this.buf.add(new MetricData(record.tenantId(), name, this.respTime ? (double)record.responseTime() : 1.0, record.timestamp()));
    }

    public void emit(String key) {
        String name = this.prefix.isEmpty() ? key : String.format("%s%s", this.prefix, key);
        this.transmitter.send(new MetricDataCount(new MetricData(null, name, 1.0, System.currentTimeMillis()), 1));
    }

    public void flush(long timestamp) {
        this.buf.flush(timestamp);
    }

    public void flush() {
        this.buf.flush();
    }
}

