/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.ords.metrics;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import oracle.dbtools.ords.metrics.InstanceInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceMetadata {
    private static final Logger log = LoggerFactory.getLogger(InstanceMetadata.class);
    private static final String DEFAULT_ENDPOINT = "http://169.254.169.254/opc/v2/instance/";
    private static final ObjectMapper MAPPER = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);

    public static InstanceInfo collect() throws IOException {
        return InstanceMetadata.collect(DEFAULT_ENDPOINT);
    }

    public static InstanceInfo collect(String endpoint) throws IOException {
        InstanceInfo instanceInfo;
        block8: {
            HttpURLConnection connection = (HttpURLConnection)new URL(endpoint).openConnection();
            connection.setRequestMethod("GET");
            connection.setRequestProperty("Authorization", "Bearer Oracle");
            InputStream inputStream = connection.getInputStream();
            try {
                byte[] responseBytes = inputStream.readAllBytes();
                String resp = new String(responseBytes, StandardCharsets.UTF_8);
                instanceInfo = (InstanceInfo)MAPPER.readValue(resp, InstanceInfo.class);
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    log.info("Cannot get Instance Metadata: {}", (Object)e.toString());
                    throw e;
                }
            }
            inputStream.close();
        }
        return instanceInfo;
    }
}

