/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.ords.metrics;

import oracle.dbtools.ords.metrics.MetricReporter;
import oracle.dbtools.ords.metrics.OrdsMetrics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Heartbeat
extends Thread {
    private static final Logger log = LoggerFactory.getLogger(Heartbeat.class);
    private static final String HEARTBEAT_METRIC_NAME = "Heartbeat";
    private final MetricReporter reporter;
    private final int interval;

    Heartbeat(MetricReporter reporter, int interval) {
        this.reporter = reporter;
        this.interval = interval;
    }

    @Override
    public void run() {
        while (!OrdsMetrics.shuttingDown.get()) {
            try {
                this.reporter.emit(HEARTBEAT_METRIC_NAME);
            }
            catch (Exception e) {
                log.warn("Cannot send heartbeat: {}", (Object)e.getMessage());
            }
            this.nap();
        }
        log.info("Heartbeat thread exiting");
    }

    private void nap() {
        try {
            Thread.sleep(this.interval);
        }
        catch (InterruptedException e) {
            log.info("Heartbeat interrupted");
        }
    }
}

