/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.monitoring.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.monitoring.model.Alarm;
import com.oracle.bmc.monitoring.model.AlarmOverride;
import com.oracle.bmc.monitoring.model.Suppression;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class AlarmSummary
extends ExplicitlySetBmcModel {
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="metricCompartmentId")
    private final String metricCompartmentId;
    @JsonProperty(value="namespace")
    private final String namespace;
    @JsonProperty(value="query")
    private final String query;
    @JsonProperty(value="severity")
    private final Severity severity;
    @JsonProperty(value="destinations")
    private final List<String> destinations;
    @JsonProperty(value="suppression")
    private final Suppression suppression;
    @JsonProperty(value="isEnabled")
    private final Boolean isEnabled;
    @JsonProperty(value="isNotificationsPerMetricDimensionEnabled")
    private final Boolean isNotificationsPerMetricDimensionEnabled;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="lifecycleState")
    private final Alarm.LifecycleState lifecycleState;
    @JsonProperty(value="overrides")
    private final List<AlarmOverride> overrides;
    @JsonProperty(value="ruleName")
    private final String ruleName;
    @JsonProperty(value="notificationVersion")
    private final String notificationVersion;
    @JsonProperty(value="notificationTitle")
    private final String notificationTitle;
    @JsonProperty(value="evaluationSlackDuration")
    private final String evaluationSlackDuration;
    @JsonProperty(value="alarmSummary")
    private final String alarmSummary;
    @JsonProperty(value="resourceGroup")
    private final String resourceGroup;

    @Deprecated
    @ConstructorProperties(value={"id", "displayName", "compartmentId", "metricCompartmentId", "namespace", "query", "severity", "destinations", "suppression", "isEnabled", "isNotificationsPerMetricDimensionEnabled", "freeformTags", "definedTags", "lifecycleState", "overrides", "ruleName", "notificationVersion", "notificationTitle", "evaluationSlackDuration", "alarmSummary", "resourceGroup"})
    public AlarmSummary(String id, String displayName, String compartmentId, String metricCompartmentId, String namespace, String query, Severity severity, List<String> destinations, Suppression suppression, Boolean isEnabled, Boolean isNotificationsPerMetricDimensionEnabled, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, Alarm.LifecycleState lifecycleState, List<AlarmOverride> overrides, String ruleName, String notificationVersion, String notificationTitle, String evaluationSlackDuration, String alarmSummary, String resourceGroup) {
        this.id = id;
        this.displayName = displayName;
        this.compartmentId = compartmentId;
        this.metricCompartmentId = metricCompartmentId;
        this.namespace = namespace;
        this.query = query;
        this.severity = severity;
        this.destinations = destinations;
        this.suppression = suppression;
        this.isEnabled = isEnabled;
        this.isNotificationsPerMetricDimensionEnabled = isNotificationsPerMetricDimensionEnabled;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
        this.lifecycleState = lifecycleState;
        this.overrides = overrides;
        this.ruleName = ruleName;
        this.notificationVersion = notificationVersion;
        this.notificationTitle = notificationTitle;
        this.evaluationSlackDuration = evaluationSlackDuration;
        this.alarmSummary = alarmSummary;
        this.resourceGroup = resourceGroup;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getId() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getMetricCompartmentId() {
        return this.metricCompartmentId;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getQuery() {
        return this.query;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public List<String> getDestinations() {
        return this.destinations;
    }

    public Suppression getSuppression() {
        return this.suppression;
    }

    public Boolean getIsEnabled() {
        return this.isEnabled;
    }

    public Boolean getIsNotificationsPerMetricDimensionEnabled() {
        return this.isNotificationsPerMetricDimensionEnabled;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public Alarm.LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public List<AlarmOverride> getOverrides() {
        return this.overrides;
    }

    public String getRuleName() {
        return this.ruleName;
    }

    public String getNotificationVersion() {
        return this.notificationVersion;
    }

    public String getNotificationTitle() {
        return this.notificationTitle;
    }

    public String getEvaluationSlackDuration() {
        return this.evaluationSlackDuration;
    }

    public String getAlarmSummary() {
        return this.alarmSummary;
    }

    public String getResourceGroup() {
        return this.resourceGroup;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AlarmSummary(");
        sb.append("super=").append(super.toString());
        sb.append("id=").append(String.valueOf(this.id));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", metricCompartmentId=").append(String.valueOf(this.metricCompartmentId));
        sb.append(", namespace=").append(String.valueOf(this.namespace));
        sb.append(", query=").append(String.valueOf(this.query));
        sb.append(", severity=").append(String.valueOf((Object)this.severity));
        sb.append(", destinations=").append(String.valueOf(this.destinations));
        sb.append(", suppression=").append(String.valueOf((Object)this.suppression));
        sb.append(", isEnabled=").append(String.valueOf(this.isEnabled));
        sb.append(", isNotificationsPerMetricDimensionEnabled=").append(String.valueOf(this.isNotificationsPerMetricDimensionEnabled));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", overrides=").append(String.valueOf(this.overrides));
        sb.append(", ruleName=").append(String.valueOf(this.ruleName));
        sb.append(", notificationVersion=").append(String.valueOf(this.notificationVersion));
        sb.append(", notificationTitle=").append(String.valueOf(this.notificationTitle));
        sb.append(", evaluationSlackDuration=").append(String.valueOf(this.evaluationSlackDuration));
        sb.append(", alarmSummary=").append(String.valueOf(this.alarmSummary));
        sb.append(", resourceGroup=").append(String.valueOf(this.resourceGroup));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AlarmSummary)) {
            return false;
        }
        AlarmSummary other = (AlarmSummary)((Object)o);
        return Objects.equals(this.id, other.id) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.metricCompartmentId, other.metricCompartmentId) && Objects.equals(this.namespace, other.namespace) && Objects.equals(this.query, other.query) && Objects.equals((Object)this.severity, (Object)other.severity) && Objects.equals(this.destinations, other.destinations) && Objects.equals((Object)this.suppression, (Object)other.suppression) && Objects.equals(this.isEnabled, other.isEnabled) && Objects.equals(this.isNotificationsPerMetricDimensionEnabled, other.isNotificationsPerMetricDimensionEnabled) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.overrides, other.overrides) && Objects.equals(this.ruleName, other.ruleName) && Objects.equals(this.notificationVersion, other.notificationVersion) && Objects.equals(this.notificationTitle, other.notificationTitle) && Objects.equals(this.evaluationSlackDuration, other.evaluationSlackDuration) && Objects.equals(this.alarmSummary, other.alarmSummary) && Objects.equals(this.resourceGroup, other.resourceGroup) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.metricCompartmentId == null ? 43 : this.metricCompartmentId.hashCode());
        result = result * 59 + (this.namespace == null ? 43 : this.namespace.hashCode());
        result = result * 59 + (this.query == null ? 43 : this.query.hashCode());
        result = result * 59 + (this.severity == null ? 43 : this.severity.hashCode());
        result = result * 59 + (this.destinations == null ? 43 : this.destinations.hashCode());
        result = result * 59 + (this.suppression == null ? 43 : this.suppression.hashCode());
        result = result * 59 + (this.isEnabled == null ? 43 : this.isEnabled.hashCode());
        result = result * 59 + (this.isNotificationsPerMetricDimensionEnabled == null ? 43 : this.isNotificationsPerMetricDimensionEnabled.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.overrides == null ? 43 : this.overrides.hashCode());
        result = result * 59 + (this.ruleName == null ? 43 : this.ruleName.hashCode());
        result = result * 59 + (this.notificationVersion == null ? 43 : this.notificationVersion.hashCode());
        result = result * 59 + (this.notificationTitle == null ? 43 : this.notificationTitle.hashCode());
        result = result * 59 + (this.evaluationSlackDuration == null ? 43 : this.evaluationSlackDuration.hashCode());
        result = result * 59 + (this.alarmSummary == null ? 43 : this.alarmSummary.hashCode());
        result = result * 59 + (this.resourceGroup == null ? 43 : this.resourceGroup.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Severity implements BmcEnum
    {
        Critical("CRITICAL"),
        Error("ERROR"),
        Warning("WARNING"),
        Info("INFO"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Severity> map;

        private Severity(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Severity create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Severity', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Severity.class);
            map = new HashMap<String, Severity>();
            for (Severity v : Severity.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="metricCompartmentId")
        private String metricCompartmentId;
        @JsonProperty(value="namespace")
        private String namespace;
        @JsonProperty(value="query")
        private String query;
        @JsonProperty(value="severity")
        private Severity severity;
        @JsonProperty(value="destinations")
        private List<String> destinations;
        @JsonProperty(value="suppression")
        private Suppression suppression;
        @JsonProperty(value="isEnabled")
        private Boolean isEnabled;
        @JsonProperty(value="isNotificationsPerMetricDimensionEnabled")
        private Boolean isNotificationsPerMetricDimensionEnabled;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="lifecycleState")
        private Alarm.LifecycleState lifecycleState;
        @JsonProperty(value="overrides")
        private List<AlarmOverride> overrides;
        @JsonProperty(value="ruleName")
        private String ruleName;
        @JsonProperty(value="notificationVersion")
        private String notificationVersion;
        @JsonProperty(value="notificationTitle")
        private String notificationTitle;
        @JsonProperty(value="evaluationSlackDuration")
        private String evaluationSlackDuration;
        @JsonProperty(value="alarmSummary")
        private String alarmSummary;
        @JsonProperty(value="resourceGroup")
        private String resourceGroup;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder metricCompartmentId(String metricCompartmentId) {
            this.metricCompartmentId = metricCompartmentId;
            this.__explicitlySet__.add("metricCompartmentId");
            return this;
        }

        public Builder namespace(String namespace) {
            this.namespace = namespace;
            this.__explicitlySet__.add("namespace");
            return this;
        }

        public Builder query(String query) {
            this.query = query;
            this.__explicitlySet__.add("query");
            return this;
        }

        public Builder severity(Severity severity) {
            this.severity = severity;
            this.__explicitlySet__.add("severity");
            return this;
        }

        public Builder destinations(List<String> destinations) {
            this.destinations = destinations;
            this.__explicitlySet__.add("destinations");
            return this;
        }

        public Builder suppression(Suppression suppression) {
            this.suppression = suppression;
            this.__explicitlySet__.add("suppression");
            return this;
        }

        public Builder isEnabled(Boolean isEnabled) {
            this.isEnabled = isEnabled;
            this.__explicitlySet__.add("isEnabled");
            return this;
        }

        public Builder isNotificationsPerMetricDimensionEnabled(Boolean isNotificationsPerMetricDimensionEnabled) {
            this.isNotificationsPerMetricDimensionEnabled = isNotificationsPerMetricDimensionEnabled;
            this.__explicitlySet__.add("isNotificationsPerMetricDimensionEnabled");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder lifecycleState(Alarm.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder overrides(List<AlarmOverride> overrides) {
            this.overrides = overrides;
            this.__explicitlySet__.add("overrides");
            return this;
        }

        public Builder ruleName(String ruleName) {
            this.ruleName = ruleName;
            this.__explicitlySet__.add("ruleName");
            return this;
        }

        public Builder notificationVersion(String notificationVersion) {
            this.notificationVersion = notificationVersion;
            this.__explicitlySet__.add("notificationVersion");
            return this;
        }

        public Builder notificationTitle(String notificationTitle) {
            this.notificationTitle = notificationTitle;
            this.__explicitlySet__.add("notificationTitle");
            return this;
        }

        public Builder evaluationSlackDuration(String evaluationSlackDuration) {
            this.evaluationSlackDuration = evaluationSlackDuration;
            this.__explicitlySet__.add("evaluationSlackDuration");
            return this;
        }

        public Builder alarmSummary(String alarmSummary) {
            this.alarmSummary = alarmSummary;
            this.__explicitlySet__.add("alarmSummary");
            return this;
        }

        public Builder resourceGroup(String resourceGroup) {
            this.resourceGroup = resourceGroup;
            this.__explicitlySet__.add("resourceGroup");
            return this;
        }

        public AlarmSummary build() {
            AlarmSummary model = new AlarmSummary(this.id, this.displayName, this.compartmentId, this.metricCompartmentId, this.namespace, this.query, this.severity, this.destinations, this.suppression, this.isEnabled, this.isNotificationsPerMetricDimensionEnabled, this.freeformTags, this.definedTags, this.lifecycleState, this.overrides, this.ruleName, this.notificationVersion, this.notificationTitle, this.evaluationSlackDuration, this.alarmSummary, this.resourceGroup);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AlarmSummary model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("metricCompartmentId")) {
                this.metricCompartmentId(model.getMetricCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("namespace")) {
                this.namespace(model.getNamespace());
            }
            if (model.wasPropertyExplicitlySet("query")) {
                this.query(model.getQuery());
            }
            if (model.wasPropertyExplicitlySet("severity")) {
                this.severity(model.getSeverity());
            }
            if (model.wasPropertyExplicitlySet("destinations")) {
                this.destinations(model.getDestinations());
            }
            if (model.wasPropertyExplicitlySet("suppression")) {
                this.suppression(model.getSuppression());
            }
            if (model.wasPropertyExplicitlySet("isEnabled")) {
                this.isEnabled(model.getIsEnabled());
            }
            if (model.wasPropertyExplicitlySet("isNotificationsPerMetricDimensionEnabled")) {
                this.isNotificationsPerMetricDimensionEnabled(model.getIsNotificationsPerMetricDimensionEnabled());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("overrides")) {
                this.overrides(model.getOverrides());
            }
            if (model.wasPropertyExplicitlySet("ruleName")) {
                this.ruleName(model.getRuleName());
            }
            if (model.wasPropertyExplicitlySet("notificationVersion")) {
                this.notificationVersion(model.getNotificationVersion());
            }
            if (model.wasPropertyExplicitlySet("notificationTitle")) {
                this.notificationTitle(model.getNotificationTitle());
            }
            if (model.wasPropertyExplicitlySet("evaluationSlackDuration")) {
                this.evaluationSlackDuration(model.getEvaluationSlackDuration());
            }
            if (model.wasPropertyExplicitlySet("alarmSummary")) {
                this.alarmSummary(model.getAlarmSummary());
            }
            if (model.wasPropertyExplicitlySet("resourceGroup")) {
                this.resourceGroup(model.getResourceGroup());
            }
            return this;
        }
    }
}

