/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.monitoring;

import com.oracle.bmc.monitoring.Monitoring;
import com.oracle.bmc.monitoring.model.Alarm;
import com.oracle.bmc.monitoring.model.AlarmSuppression;
import com.oracle.bmc.monitoring.requests.GetAlarmRequest;
import com.oracle.bmc.monitoring.requests.GetAlarmSuppressionRequest;
import com.oracle.bmc.monitoring.responses.GetAlarmResponse;
import com.oracle.bmc.monitoring.responses.GetAlarmSuppressionResponse;
import com.oracle.bmc.util.internal.Validate;
import com.oracle.bmc.waiter.BmcGenericWaiter;
import com.oracle.bmc.waiter.DelayStrategy;
import com.oracle.bmc.waiter.TerminationStrategy;
import com.oracle.bmc.waiter.Waiter;
import com.oracle.bmc.waiter.Waiters;
import com.oracle.bmc.waiter.internal.SimpleWaiterImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import java.util.function.Predicate;

public class MonitoringWaiters {
    private final ExecutorService executorService;
    private final Monitoring client;

    public MonitoringWaiters(ExecutorService executorService, Monitoring client) {
        this.executorService = executorService;
        this.client = client;
    }

    public Waiter<GetAlarmRequest, GetAlarmResponse> forAlarm(GetAlarmRequest request, Alarm.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forAlarm(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetAlarmRequest, GetAlarmResponse> forAlarm(GetAlarmRequest request, Alarm.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forAlarm(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetAlarmRequest, GetAlarmResponse> forAlarm(GetAlarmRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, Alarm.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forAlarm(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetAlarmRequest, GetAlarmResponse> forAlarm(BmcGenericWaiter waiter, GetAlarmRequest request, Alarm.LifecycleState ... targetStates) {
        final HashSet<Alarm.LifecycleState> targetStatesSet = new HashSet<Alarm.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetAlarmRequest, GetAlarmResponse>(){

            @Override
            public GetAlarmResponse apply(GetAlarmRequest request) {
                return MonitoringWaiters.this.client.getAlarm(request);
            }
        }, (Predicate)new Predicate<GetAlarmResponse>(){

            @Override
            public boolean test(GetAlarmResponse response) {
                return targetStatesSet.contains((Object)response.getAlarm().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)Alarm.LifecycleState.Deleted)), (Object)request);
    }

    public Waiter<GetAlarmSuppressionRequest, GetAlarmSuppressionResponse> forAlarmSuppression(GetAlarmSuppressionRequest request, AlarmSuppression.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one targetState must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null targetState values are not permitted", (Object[])new Object[0]);
        return this.forAlarmSuppression(Waiters.DEFAULT_POLLING_WAITER, request, targetStates);
    }

    public Waiter<GetAlarmSuppressionRequest, GetAlarmSuppressionResponse> forAlarmSuppression(GetAlarmSuppressionRequest request, AlarmSuppression.LifecycleState targetState, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy) {
        Validate.notNull((Object)((Object)targetState), (String)"The targetState cannot be null", (Object[])new Object[0]);
        return this.forAlarmSuppression(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetState);
    }

    public Waiter<GetAlarmSuppressionRequest, GetAlarmSuppressionResponse> forAlarmSuppression(GetAlarmSuppressionRequest request, TerminationStrategy terminationStrategy, DelayStrategy delayStrategy, AlarmSuppression.LifecycleState ... targetStates) {
        Validate.notEmpty((Object[])targetStates, (String)"At least one target state must be provided", (Object[])new Object[0]);
        Validate.noNullElements((Object[])targetStates, (String)"Null target states are not permitted", (Object[])new Object[0]);
        return this.forAlarmSuppression(Waiters.newWaiter((TerminationStrategy)terminationStrategy, (DelayStrategy)delayStrategy), request, targetStates);
    }

    private Waiter<GetAlarmSuppressionRequest, GetAlarmSuppressionResponse> forAlarmSuppression(BmcGenericWaiter waiter, GetAlarmSuppressionRequest request, AlarmSuppression.LifecycleState ... targetStates) {
        final HashSet<AlarmSuppression.LifecycleState> targetStatesSet = new HashSet<AlarmSuppression.LifecycleState>(Arrays.asList(targetStates));
        return new SimpleWaiterImpl(this.executorService, waiter.toCallable(() -> request, (Function)new Function<GetAlarmSuppressionRequest, GetAlarmSuppressionResponse>(){

            @Override
            public GetAlarmSuppressionResponse apply(GetAlarmSuppressionRequest request) {
                return MonitoringWaiters.this.client.getAlarmSuppression(request);
            }
        }, (Predicate)new Predicate<GetAlarmSuppressionResponse>(){

            @Override
            public boolean test(GetAlarmSuppressionResponse response) {
                return targetStatesSet.contains((Object)response.getAlarmSuppression().getLifecycleState());
            }
        }, targetStatesSet.contains((Object)AlarmSuppression.LifecycleState.Deleted)), (Object)request);
    }
}

