/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.monitoring.requests;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.monitoring.model.AlarmSuppression;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class ListAlarmSuppressionsRequest
extends BmcRequest<Void> {
    private String opcRequestId;
    private String alarmId;
    private String displayName;
    private AlarmSuppression.LifecycleState lifecycleState;
    private AlarmSuppression.Level level;
    private String compartmentId;
    private Boolean compartmentIdInSubtree;
    private TargetType targetType;
    private Boolean isAllSuppressions;
    private SortBy sortBy;
    private SortOrder sortOrder;
    private String page;
    private Integer limit;

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public String getAlarmId() {
        return this.alarmId;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public AlarmSuppression.LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public AlarmSuppression.Level getLevel() {
        return this.level;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Boolean getCompartmentIdInSubtree() {
        return this.compartmentIdInSubtree;
    }

    public TargetType getTargetType() {
        return this.targetType;
    }

    public Boolean getIsAllSuppressions() {
        return this.isAllSuppressions;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public SortOrder getSortOrder() {
        return this.sortOrder;
    }

    public String getPage() {
        return this.page;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public Builder toBuilder() {
        return new Builder().opcRequestId(this.opcRequestId).alarmId(this.alarmId).displayName(this.displayName).lifecycleState(this.lifecycleState).level(this.level).compartmentId(this.compartmentId).compartmentIdInSubtree(this.compartmentIdInSubtree).targetType(this.targetType).isAllSuppressions(this.isAllSuppressions).sortBy(this.sortBy).sortOrder(this.sortOrder).page(this.page).limit(this.limit);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(",alarmId=").append(String.valueOf(this.alarmId));
        sb.append(",displayName=").append(String.valueOf(this.displayName));
        sb.append(",lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(",level=").append(String.valueOf((Object)this.level));
        sb.append(",compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(",compartmentIdInSubtree=").append(String.valueOf(this.compartmentIdInSubtree));
        sb.append(",targetType=").append(String.valueOf((Object)this.targetType));
        sb.append(",isAllSuppressions=").append(String.valueOf(this.isAllSuppressions));
        sb.append(",sortBy=").append(String.valueOf((Object)this.sortBy));
        sb.append(",sortOrder=").append(String.valueOf((Object)this.sortOrder));
        sb.append(",page=").append(String.valueOf(this.page));
        sb.append(",limit=").append(String.valueOf(this.limit));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ListAlarmSuppressionsRequest)) {
            return false;
        }
        ListAlarmSuppressionsRequest other = (ListAlarmSuppressionsRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.opcRequestId, other.opcRequestId) && Objects.equals(this.alarmId, other.alarmId) && Objects.equals(this.displayName, other.displayName) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals((Object)this.level, (Object)other.level) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.compartmentIdInSubtree, other.compartmentIdInSubtree) && Objects.equals((Object)this.targetType, (Object)other.targetType) && Objects.equals(this.isAllSuppressions, other.isAllSuppressions) && Objects.equals((Object)this.sortBy, (Object)other.sortBy) && Objects.equals((Object)this.sortOrder, (Object)other.sortOrder) && Objects.equals(this.page, other.page) && Objects.equals(this.limit, other.limit);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        result = result * 59 + (this.alarmId == null ? 43 : this.alarmId.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.level == null ? 43 : this.level.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.compartmentIdInSubtree == null ? 43 : this.compartmentIdInSubtree.hashCode());
        result = result * 59 + (this.targetType == null ? 43 : this.targetType.hashCode());
        result = result * 59 + (this.isAllSuppressions == null ? 43 : this.isAllSuppressions.hashCode());
        result = result * 59 + (this.sortBy == null ? 43 : this.sortBy.hashCode());
        result = result * 59 + (this.sortOrder == null ? 43 : this.sortOrder.hashCode());
        result = result * 59 + (this.page == null ? 43 : this.page.hashCode());
        result = result * 59 + (this.limit == null ? 43 : this.limit.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<ListAlarmSuppressionsRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String opcRequestId = null;
        private String alarmId = null;
        private String displayName = null;
        private AlarmSuppression.LifecycleState lifecycleState = null;
        private AlarmSuppression.Level level = null;
        private String compartmentId = null;
        private Boolean compartmentIdInSubtree = null;
        private TargetType targetType = null;
        private Boolean isAllSuppressions = null;
        private SortBy sortBy = null;
        private SortOrder sortOrder = null;
        private String page = null;
        private Integer limit = null;

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder alarmId(String alarmId) {
            this.alarmId = alarmId;
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder lifecycleState(AlarmSuppression.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            return this;
        }

        public Builder level(AlarmSuppression.Level level) {
            this.level = level;
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            return this;
        }

        public Builder compartmentIdInSubtree(Boolean compartmentIdInSubtree) {
            this.compartmentIdInSubtree = compartmentIdInSubtree;
            return this;
        }

        public Builder targetType(TargetType targetType) {
            this.targetType = targetType;
            return this;
        }

        public Builder isAllSuppressions(Boolean isAllSuppressions) {
            this.isAllSuppressions = isAllSuppressions;
            return this;
        }

        public Builder sortBy(SortBy sortBy) {
            this.sortBy = sortBy;
            return this;
        }

        public Builder sortOrder(SortOrder sortOrder) {
            this.sortOrder = sortOrder;
            return this;
        }

        public Builder page(String page) {
            this.page = page;
            return this;
        }

        public Builder limit(Integer limit) {
            this.limit = limit;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(ListAlarmSuppressionsRequest o) {
            this.opcRequestId(o.getOpcRequestId());
            this.alarmId(o.getAlarmId());
            this.displayName(o.getDisplayName());
            this.lifecycleState(o.getLifecycleState());
            this.level(o.getLevel());
            this.compartmentId(o.getCompartmentId());
            this.compartmentIdInSubtree(o.getCompartmentIdInSubtree());
            this.targetType(o.getTargetType());
            this.isAllSuppressions(o.getIsAllSuppressions());
            this.sortBy(o.getSortBy());
            this.sortOrder(o.getSortOrder());
            this.page(o.getPage());
            this.limit(o.getLimit());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public ListAlarmSuppressionsRequest build() {
            ListAlarmSuppressionsRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public ListAlarmSuppressionsRequest buildWithoutInvocationCallback() {
            ListAlarmSuppressionsRequest request = new ListAlarmSuppressionsRequest();
            request.opcRequestId = this.opcRequestId;
            request.alarmId = this.alarmId;
            request.displayName = this.displayName;
            request.lifecycleState = this.lifecycleState;
            request.level = this.level;
            request.compartmentId = this.compartmentId;
            request.compartmentIdInSubtree = this.compartmentIdInSubtree;
            request.targetType = this.targetType;
            request.isAllSuppressions = this.isAllSuppressions;
            request.sortBy = this.sortBy;
            request.sortOrder = this.sortOrder;
            request.page = this.page;
            request.limit = this.limit;
            return request;
        }
    }

    public static enum SortOrder implements BmcEnum
    {
        Asc("ASC"),
        Desc("DESC");

        private final String value;
        private static Map<String, SortOrder> map;

        private SortOrder(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortOrder create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortOrder: " + key);
        }

        static {
            map = new HashMap<String, SortOrder>();
            for (SortOrder v : SortOrder.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum SortBy implements BmcEnum
    {
        DisplayName("displayName"),
        TimeCreated("timeCreated"),
        TimeSuppressFrom("timeSuppressFrom");

        private final String value;
        private static Map<String, SortBy> map;

        private SortBy(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static SortBy create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid SortBy: " + key);
        }

        static {
            map = new HashMap<String, SortBy>();
            for (SortBy v : SortBy.values()) {
                map.put(v.getValue(), v);
            }
        }
    }

    public static enum TargetType implements BmcEnum
    {
        Alarm("ALARM"),
        Compartment("COMPARTMENT");

        private final String value;
        private static Map<String, TargetType> map;

        private TargetType(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static TargetType create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            throw new IllegalArgumentException("Invalid TargetType: " + key);
        }

        static {
            map = new HashMap<String, TargetType>();
            for (TargetType v : TargetType.values()) {
                map.put(v.getValue(), v);
            }
        }
    }
}

