/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.monitoring.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class GetAlarmSuppressionRequest
extends BmcRequest<Void> {
    private String alarmSuppressionId;
    private String opcRequestId;

    public String getAlarmSuppressionId() {
        return this.alarmSuppressionId;
    }

    public String getOpcRequestId() {
        return this.opcRequestId;
    }

    public Builder toBuilder() {
        return new Builder().alarmSuppressionId(this.alarmSuppressionId).opcRequestId(this.opcRequestId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",alarmSuppressionId=").append(String.valueOf(this.alarmSuppressionId));
        sb.append(",opcRequestId=").append(String.valueOf(this.opcRequestId));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GetAlarmSuppressionRequest)) {
            return false;
        }
        GetAlarmSuppressionRequest other = (GetAlarmSuppressionRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.alarmSuppressionId, other.alarmSuppressionId) && Objects.equals(this.opcRequestId, other.opcRequestId);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.alarmSuppressionId == null ? 43 : this.alarmSuppressionId.hashCode());
        result = result * 59 + (this.opcRequestId == null ? 43 : this.opcRequestId.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<GetAlarmSuppressionRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String alarmSuppressionId = null;
        private String opcRequestId = null;

        public Builder alarmSuppressionId(String alarmSuppressionId) {
            this.alarmSuppressionId = alarmSuppressionId;
            return this;
        }

        public Builder opcRequestId(String opcRequestId) {
            this.opcRequestId = opcRequestId;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(GetAlarmSuppressionRequest o) {
            this.alarmSuppressionId(o.getAlarmSuppressionId());
            this.opcRequestId(o.getOpcRequestId());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public GetAlarmSuppressionRequest build() {
            GetAlarmSuppressionRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public GetAlarmSuppressionRequest buildWithoutInvocationCallback() {
            GetAlarmSuppressionRequest request = new GetAlarmSuppressionRequest();
            request.alarmSuppressionId = this.alarmSuppressionId;
            request.opcRequestId = this.opcRequestId;
            return request;
        }
    }
}

