/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.monitoring.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.monitoring.model.AlarmSuppressionTarget;
import com.oracle.bmc.monitoring.model.SuppressionCondition;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class AlarmSuppressionHistoryItem
extends ExplicitlySetBmcModel {
    @JsonProperty(value="suppressionId")
    private final String suppressionId;
    @JsonProperty(value="alarmSuppressionTarget")
    private final AlarmSuppressionTarget alarmSuppressionTarget;
    @JsonProperty(value="level")
    private final Level level;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="description")
    private final String description;
    @JsonProperty(value="dimensions")
    private final Map<String, String> dimensions;
    @JsonProperty(value="timeEffectiveFrom")
    private final Date timeEffectiveFrom;
    @JsonProperty(value="timeEffectiveUntil")
    private final Date timeEffectiveUntil;
    @JsonProperty(value="suppressionConditions")
    private final List<SuppressionCondition> suppressionConditions;

    @Deprecated
    @ConstructorProperties(value={"suppressionId", "alarmSuppressionTarget", "level", "displayName", "description", "dimensions", "timeEffectiveFrom", "timeEffectiveUntil", "suppressionConditions"})
    public AlarmSuppressionHistoryItem(String suppressionId, AlarmSuppressionTarget alarmSuppressionTarget, Level level, String displayName, String description, Map<String, String> dimensions, Date timeEffectiveFrom, Date timeEffectiveUntil, List<SuppressionCondition> suppressionConditions) {
        this.suppressionId = suppressionId;
        this.alarmSuppressionTarget = alarmSuppressionTarget;
        this.level = level;
        this.displayName = displayName;
        this.description = description;
        this.dimensions = dimensions;
        this.timeEffectiveFrom = timeEffectiveFrom;
        this.timeEffectiveUntil = timeEffectiveUntil;
        this.suppressionConditions = suppressionConditions;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getSuppressionId() {
        return this.suppressionId;
    }

    public AlarmSuppressionTarget getAlarmSuppressionTarget() {
        return this.alarmSuppressionTarget;
    }

    public Level getLevel() {
        return this.level;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public Map<String, String> getDimensions() {
        return this.dimensions;
    }

    public Date getTimeEffectiveFrom() {
        return this.timeEffectiveFrom;
    }

    public Date getTimeEffectiveUntil() {
        return this.timeEffectiveUntil;
    }

    public List<SuppressionCondition> getSuppressionConditions() {
        return this.suppressionConditions;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AlarmSuppressionHistoryItem(");
        sb.append("super=").append(super.toString());
        sb.append("suppressionId=").append(String.valueOf(this.suppressionId));
        sb.append(", alarmSuppressionTarget=").append(String.valueOf((Object)this.alarmSuppressionTarget));
        sb.append(", level=").append(String.valueOf((Object)this.level));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", description=").append(String.valueOf(this.description));
        sb.append(", dimensions=").append(String.valueOf(this.dimensions));
        sb.append(", timeEffectiveFrom=").append(String.valueOf(this.timeEffectiveFrom));
        sb.append(", timeEffectiveUntil=").append(String.valueOf(this.timeEffectiveUntil));
        sb.append(", suppressionConditions=").append(String.valueOf(this.suppressionConditions));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AlarmSuppressionHistoryItem)) {
            return false;
        }
        AlarmSuppressionHistoryItem other = (AlarmSuppressionHistoryItem)((Object)o);
        return Objects.equals(this.suppressionId, other.suppressionId) && Objects.equals((Object)this.alarmSuppressionTarget, (Object)other.alarmSuppressionTarget) && Objects.equals((Object)this.level, (Object)other.level) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.description, other.description) && Objects.equals(this.dimensions, other.dimensions) && Objects.equals(this.timeEffectiveFrom, other.timeEffectiveFrom) && Objects.equals(this.timeEffectiveUntil, other.timeEffectiveUntil) && Objects.equals(this.suppressionConditions, other.suppressionConditions) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.suppressionId == null ? 43 : this.suppressionId.hashCode());
        result = result * 59 + (this.alarmSuppressionTarget == null ? 43 : this.alarmSuppressionTarget.hashCode());
        result = result * 59 + (this.level == null ? 43 : this.level.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.description == null ? 43 : this.description.hashCode());
        result = result * 59 + (this.dimensions == null ? 43 : this.dimensions.hashCode());
        result = result * 59 + (this.timeEffectiveFrom == null ? 43 : this.timeEffectiveFrom.hashCode());
        result = result * 59 + (this.timeEffectiveUntil == null ? 43 : this.timeEffectiveUntil.hashCode());
        result = result * 59 + (this.suppressionConditions == null ? 43 : this.suppressionConditions.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Level implements BmcEnum
    {
        Alarm("ALARM"),
        Dimension("DIMENSION"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Level> map;

        private Level(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Level create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Level', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Level.class);
            map = new HashMap<String, Level>();
            for (Level v : Level.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="suppressionId")
        private String suppressionId;
        @JsonProperty(value="alarmSuppressionTarget")
        private AlarmSuppressionTarget alarmSuppressionTarget;
        @JsonProperty(value="level")
        private Level level;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="dimensions")
        private Map<String, String> dimensions;
        @JsonProperty(value="timeEffectiveFrom")
        private Date timeEffectiveFrom;
        @JsonProperty(value="timeEffectiveUntil")
        private Date timeEffectiveUntil;
        @JsonProperty(value="suppressionConditions")
        private List<SuppressionCondition> suppressionConditions;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder suppressionId(String suppressionId) {
            this.suppressionId = suppressionId;
            this.__explicitlySet__.add("suppressionId");
            return this;
        }

        public Builder alarmSuppressionTarget(AlarmSuppressionTarget alarmSuppressionTarget) {
            this.alarmSuppressionTarget = alarmSuppressionTarget;
            this.__explicitlySet__.add("alarmSuppressionTarget");
            return this;
        }

        public Builder level(Level level) {
            this.level = level;
            this.__explicitlySet__.add("level");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder dimensions(Map<String, String> dimensions) {
            this.dimensions = dimensions;
            this.__explicitlySet__.add("dimensions");
            return this;
        }

        public Builder timeEffectiveFrom(Date timeEffectiveFrom) {
            this.timeEffectiveFrom = timeEffectiveFrom;
            this.__explicitlySet__.add("timeEffectiveFrom");
            return this;
        }

        public Builder timeEffectiveUntil(Date timeEffectiveUntil) {
            this.timeEffectiveUntil = timeEffectiveUntil;
            this.__explicitlySet__.add("timeEffectiveUntil");
            return this;
        }

        public Builder suppressionConditions(List<SuppressionCondition> suppressionConditions) {
            this.suppressionConditions = suppressionConditions;
            this.__explicitlySet__.add("suppressionConditions");
            return this;
        }

        public AlarmSuppressionHistoryItem build() {
            AlarmSuppressionHistoryItem model = new AlarmSuppressionHistoryItem(this.suppressionId, this.alarmSuppressionTarget, this.level, this.displayName, this.description, this.dimensions, this.timeEffectiveFrom, this.timeEffectiveUntil, this.suppressionConditions);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AlarmSuppressionHistoryItem model) {
            if (model.wasPropertyExplicitlySet("suppressionId")) {
                this.suppressionId(model.getSuppressionId());
            }
            if (model.wasPropertyExplicitlySet("alarmSuppressionTarget")) {
                this.alarmSuppressionTarget(model.getAlarmSuppressionTarget());
            }
            if (model.wasPropertyExplicitlySet("level")) {
                this.level(model.getLevel());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("dimensions")) {
                this.dimensions(model.getDimensions());
            }
            if (model.wasPropertyExplicitlySet("timeEffectiveFrom")) {
                this.timeEffectiveFrom(model.getTimeEffectiveFrom());
            }
            if (model.wasPropertyExplicitlySet("timeEffectiveUntil")) {
                this.timeEffectiveUntil(model.getTimeEffectiveUntil());
            }
            if (model.wasPropertyExplicitlySet("suppressionConditions")) {
                this.suppressionConditions(model.getSuppressionConditions());
            }
            return this;
        }
    }
}

