/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.monitoring.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class AlarmDimensionStatesEntry
extends ExplicitlySetBmcModel {
    @JsonProperty(value="alarmSummary")
    private final String alarmSummary;
    @JsonProperty(value="dimensions")
    private final Map<String, String> dimensions;
    @JsonProperty(value="status")
    private final Status status;
    @JsonProperty(value="ruleName")
    private final String ruleName;
    @JsonProperty(value="timestamp")
    private final Date timestamp;

    @Deprecated
    @ConstructorProperties(value={"alarmSummary", "dimensions", "status", "ruleName", "timestamp"})
    public AlarmDimensionStatesEntry(String alarmSummary, Map<String, String> dimensions, Status status, String ruleName, Date timestamp) {
        this.alarmSummary = alarmSummary;
        this.dimensions = dimensions;
        this.status = status;
        this.ruleName = ruleName;
        this.timestamp = timestamp;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getAlarmSummary() {
        return this.alarmSummary;
    }

    public Map<String, String> getDimensions() {
        return this.dimensions;
    }

    public Status getStatus() {
        return this.status;
    }

    public String getRuleName() {
        return this.ruleName;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("AlarmDimensionStatesEntry(");
        sb.append("super=").append(super.toString());
        sb.append("alarmSummary=").append(String.valueOf(this.alarmSummary));
        sb.append(", dimensions=").append(String.valueOf(this.dimensions));
        sb.append(", status=").append(String.valueOf((Object)this.status));
        sb.append(", ruleName=").append(String.valueOf(this.ruleName));
        sb.append(", timestamp=").append(String.valueOf(this.timestamp));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AlarmDimensionStatesEntry)) {
            return false;
        }
        AlarmDimensionStatesEntry other = (AlarmDimensionStatesEntry)((Object)o);
        return Objects.equals(this.alarmSummary, other.alarmSummary) && Objects.equals(this.dimensions, other.dimensions) && Objects.equals((Object)this.status, (Object)other.status) && Objects.equals(this.ruleName, other.ruleName) && Objects.equals(this.timestamp, other.timestamp) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.alarmSummary == null ? 43 : this.alarmSummary.hashCode());
        result = result * 59 + (this.dimensions == null ? 43 : this.dimensions.hashCode());
        result = result * 59 + (this.status == null ? 43 : this.status.hashCode());
        result = result * 59 + (this.ruleName == null ? 43 : this.ruleName.hashCode());
        result = result * 59 + (this.timestamp == null ? 43 : this.timestamp.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum Status implements BmcEnum
    {
        Firing("FIRING"),
        Ok("OK"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, Status> map;

        private Status(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static Status create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'Status', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(Status.class);
            map = new HashMap<String, Status>();
            for (Status v : Status.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="alarmSummary")
        private String alarmSummary;
        @JsonProperty(value="dimensions")
        private Map<String, String> dimensions;
        @JsonProperty(value="status")
        private Status status;
        @JsonProperty(value="ruleName")
        private String ruleName;
        @JsonProperty(value="timestamp")
        private Date timestamp;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder alarmSummary(String alarmSummary) {
            this.alarmSummary = alarmSummary;
            this.__explicitlySet__.add("alarmSummary");
            return this;
        }

        public Builder dimensions(Map<String, String> dimensions) {
            this.dimensions = dimensions;
            this.__explicitlySet__.add("dimensions");
            return this;
        }

        public Builder status(Status status) {
            this.status = status;
            this.__explicitlySet__.add("status");
            return this;
        }

        public Builder ruleName(String ruleName) {
            this.ruleName = ruleName;
            this.__explicitlySet__.add("ruleName");
            return this;
        }

        public Builder timestamp(Date timestamp) {
            this.timestamp = timestamp;
            this.__explicitlySet__.add("timestamp");
            return this;
        }

        public AlarmDimensionStatesEntry build() {
            AlarmDimensionStatesEntry model = new AlarmDimensionStatesEntry(this.alarmSummary, this.dimensions, this.status, this.ruleName, this.timestamp);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(AlarmDimensionStatesEntry model) {
            if (model.wasPropertyExplicitlySet("alarmSummary")) {
                this.alarmSummary(model.getAlarmSummary());
            }
            if (model.wasPropertyExplicitlySet("dimensions")) {
                this.dimensions(model.getDimensions());
            }
            if (model.wasPropertyExplicitlySet("status")) {
                this.status(model.getStatus());
            }
            if (model.wasPropertyExplicitlySet("ruleName")) {
                this.ruleName(model.getRuleName());
            }
            if (model.wasPropertyExplicitlySet("timestamp")) {
                this.timestamp(model.getTimestamp());
            }
            return this;
        }
    }
}

