/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plugin.api.di;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.plugin.api.di.InstanceLocator;
import oracle.dbtools.plugin.api.di.InstanceProvider;
import oracle.dbtools.plugin.api.di.ResolvedInstances;
import oracle.dbtools.plugin.api.types.TypeQualifier;

class MapLocator
implements InstanceLocator {
    private final Map<TypeQualifier<?>, InstanceProvider<?>> instances;

    MapLocator(Map<TypeQualifier<?>, InstanceProvider<?>> instances) {
        this.instances = instances;
    }

    @Override
    public <T> InstanceProvider<T> select(TypeQualifier<T> qualifier) {
        TypeQualifier<?> normalized = qualifier.normalize();
        ArrayList result = new ArrayList();
        switch (qualifier.matchingMode()) {
            case PROVIDER: {
                InstanceProvider<?> unchecked = this.instances.get(normalized);
                if (unchecked == null) break;
                InstanceProvider<?> checked = unchecked;
                return checked;
            }
            default: {
                for (Map.Entry<TypeQualifier<?>, InstanceProvider<?>> entry : this.instances.entrySet()) {
                    TypeQualifier<?> candidate = entry.getKey();
                    if (!normalized.matches(candidate)) continue;
                    Iterable matching = entry.getValue();
                    Iterator iterator = matching.iterator();
                    while (iterator.hasNext()) {
                        Object match;
                        Object cast = match = iterator.next();
                        result.add(cast);
                    }
                }
            }
        }
        return ResolvedInstances.matches(qualifier, Collections.emptyList(), result);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("{\n");
        for (Map.Entry<TypeQualifier<?>, InstanceProvider<?>> entry : this.instances.entrySet()) {
            b.append(entry.getKey());
            b.append(": ");
            b.append(entry.getValue());
            b.append("\n");
        }
        b.append("}");
        return b.toString();
    }
}

