/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.ords.metrics;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatusCodeList {
    private static final Logger log = LoggerFactory.getLogger(StatusCodeList.class);
    private static final int MIN_CODE = 100;
    private static final int MAX_CODE = 599;
    private final boolean[] map;

    public StatusCodeList(String codeList) {
        this.map = StatusCodeList.getCodeList(codeList);
    }

    StatusCodeList() {
        this(String.format("%d-%d", 100, 599));
    }

    public boolean contain(int code) {
        return code >= 100 && code <= 599 && this.map[code];
    }

    private static boolean[] getCodeList(String codes) {
        boolean[] list = new boolean[600];
        for (String part : codes.split(",")) {
            try {
                if (part.contains("-")) {
                    String[] pair = part.split("-");
                    int start = Math.max(Integer.parseInt(pair[0].trim()), 100);
                    int end = Math.min(Integer.parseInt(pair[1].trim()), 599);
                    for (int i = start; i <= end; ++i) {
                        list[i] = true;
                    }
                    continue;
                }
                int code = Integer.parseInt(part.trim());
                if (code < 100 || code > 599) continue;
                list[code] = true;
            }
            catch (NumberFormatException e) {
                log.warn("Cannot parse HTTP status code: {}", (Object)part);
            }
        }
        return list;
    }
}

