/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.ords.metrics;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.channels.FileLock;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.atomic.AtomicBoolean;
import oracle.dbtools.ords.metrics.AccessLog;
import oracle.dbtools.ords.metrics.Config;
import oracle.dbtools.ords.metrics.Heartbeat;
import oracle.dbtools.ords.metrics.MetricReporter;
import oracle.dbtools.ords.metrics.OCIMetricTransmitter;
import oracle.dbtools.ords.metrics.StatusCodeList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrdsMetrics {
    private static final Logger log = LoggerFactory.getLogger(OrdsMetrics.class);
    private static final String ORDS_METRICS_STATE_FILE = ".ords-metric";
    private static final String ORDS_METRICS_CONF_FILE = "/etc/ords-metrics.conf";
    private static final String DEFAULT_LOG_DIR = "/var/log/ords/access";
    static final String DEFAULT_NAMESPACE = "dbtools_ords";
    static final String DEFAULT_RESOURCE_GROUP = "ords";
    private static final int DEFAULT_HEARTBEAT_INTERVAL = 60;
    private static final String DEFAULT_CODE_LIST = "100-599";
    private static final char OPT_LOGDIR = 'd';
    private static final char OPT_NAMESPACE = 'n';
    private static final char OPT_RESOURCE = 'r';
    private static final char OPT_COMPARTMENT = 'c';
    private static final char OPT_PROFILE = 'p';
    private static final char OPT_PROJECT = 'P';
    private static final char OPT_FLEET = 'F';
    private static final char OPT_START = 's';
    private static final char OPT_END = 'e';
    private static final char OPT_HEARTBEAT = 'b';
    private static final char OPT_HOSTNAME = 'H';
    private static final char OPT_VERBOSE = 'v';
    private static final char OPT_PREFIX = 'a';
    private static final char OPT_NOWAIT = 'q';
    private static final char OPT_INCLUDE = 'i';
    private static final char OPT_TIME = 't';
    private static long recordTime = 0L;
    static final AtomicBoolean shuttingDown = new AtomicBoolean(false);

    public static void main(String[] args) {
        long twoHoursAgo;
        Config opt = new Config("OrdsMetrics");
        opt.addOption('d', "logdir", "Log directory", true, DEFAULT_LOG_DIR, false);
        opt.addOption('n', "namespace", "OCI metrics namespace", true, DEFAULT_NAMESPACE, false);
        opt.addOption('r', "resource", "OCI metrics resource group", true, DEFAULT_RESOURCE_GROUP, false);
        opt.addOption('c', "compartment", "OCI metrics compartment", true);
        opt.addOption('p', "profile", "OCI profile", true);
        opt.addOption('P', "project", "OCI project", true, null, false, true);
        opt.addOption('F', "fleet", "OCI fleet", true, null, false, true);
        opt.addOption('a', "prefix", "Metrics name prefix", true);
        opt.addOption('s', "start", "Scan log files with start time", true, null, false, true);
        opt.addOption('e', "end", "Scan log files with end time", true, null, false, true);
        opt.addOption('b', "heartbeat", "Heartbeat interval in second, 0 to disable", true, String.valueOf(60), false);
        opt.addOption('H', "hostname", "Hostname (default is FQDN of the local host)", true);
        opt.addOption('i', "include", "A comma separated list of status code or range of code to include, eg 200,500-599", true, DEFAULT_CODE_LIST, false);
        opt.addOption('v', "verbose", "Verbose mode");
        opt.addOption('q', "nowait", "Exit after processing existing records");
        opt.addOption('t', "time", "Send response time metrics (in milliseconds)");
        try {
            if (Files.exists(Path.of(ORDS_METRICS_CONF_FILE, new String[0]), new LinkOption[0])) {
                opt.load(ORDS_METRICS_CONF_FILE);
            }
        }
        catch (IOException e) {
            log.warn("Cannot load {}: {}", (Object)ORDS_METRICS_CONF_FILE, (Object)e.getMessage());
        }
        try {
            opt.load(args);
        }
        catch (IllegalArgumentException e) {
            if (e.getMessage().contains("-h") || e.getMessage().contains("-?")) {
                System.out.println(opt.usage());
                System.exit(0);
            }
            System.err.println(e.getMessage());
            System.err.println(opt.usage());
            System.exit(2);
        }
        opt.logOptions();
        File logDir = Path.of(opt.getString('d'), new String[0]).toFile();
        String compartment = opt.getString('c');
        String project = opt.getString('P');
        String fleet = opt.getString('F');
        long startDate = opt.getDate('s', 0L);
        long endDate = opt.getDate('e', Long.MAX_VALUE);
        int heartbeatSec = opt.getInt('b', 60);
        boolean verbose = opt.getSwitch('v');
        Path stateFile = Path.of(logDir.getPath(), ORDS_METRICS_STATE_FILE);
        RandomAccessFile file = null;
        FileLock lock = null;
        try {
            Files.createDirectories(stateFile.getParent(), new FileAttribute[0]);
            file = new RandomAccessFile(stateFile.toFile(), "rw");
            lock = file.getChannel().tryLock();
            if (startDate == 0L && file.length() > 0L) {
                try {
                    startDate = recordTime = Long.parseLong(file.readLine());
                }
                catch (Exception e) {
                    log.warn("Cannot read timestamp from state file: {}", (Object)e.getMessage());
                }
            }
        }
        catch (FileNotFoundException e) {
            log.error("Cannot create state file under log directory {}: {}", (Object)logDir, (Object)e.getMessage());
            System.exit(3);
        }
        catch (Exception e) {
            log.error("Cannot lock state file: {}", (Object)e.getMessage());
            System.exit(4);
        }
        if (lock == null) {
            log.error("Another instance of ords-metrics is running. Existing.");
            System.exit(5);
        }
        if (startDate < (twoHoursAgo = System.currentTimeMillis() - 0x6DDD00L)) {
            startDate = twoHoursAgo;
        }
        String hostname = opt.getString('H', OrdsMetrics.getHostName());
        String namespace = opt.getString('n');
        String resource = opt.getString('r');
        boolean t2 = false;
        if (project != null && fleet != null) {
            namespace = project;
            resource = fleet;
            t2 = true;
        } else if (compartment == null) {
            System.err.println("-c compartment option is required on this host");
            System.exit(1);
        }
        OCIMetricTransmitter transmitter = null;
        try {
            transmitter = new OCIMetricTransmitter(compartment, namespace, resource, hostname, opt.getString('p'), t2);
        }
        catch (IOException e) {
            log.error("OCI metrics initialization failed: {}", (Object)e.getMessage());
            System.exit(2);
        }
        MetricReporter reporter = new MetricReporter(transmitter, opt.getString('a'), new StatusCodeList(opt.getString('i')), opt.getSwitch('t'));
        Thread mainThread = Thread.currentThread();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            log.info("shutting down");
            shuttingDown.set(true);
            try {
                mainThread.join();
            }
            catch (InterruptedException e) {
                log.warn("main thread join interrupted");
            }
        }));
        if (heartbeatSec != 0) {
            Heartbeat heartbeat = new Heartbeat(reporter, heartbeatSec * 1000);
            heartbeat.setDaemon(true);
            heartbeat.start();
        }
        log.info("start timestamp: {}", (Object)startDate);
        AccessLog accessLog = new AccessLog(reporter, logDir, startDate, endDate, verbose);
        long lastRecordTime = accessLog.scan();
        if (!opt.getSwitch('q')) {
            lastRecordTime = accessLog.tail();
        }
        reporter.flush();
        if (lastRecordTime > recordTime) {
            try {
                file.setLength(0L);
                file.writeBytes(String.valueOf(lastRecordTime));
                file.close();
            }
            catch (IOException e) {
                log.warn("Cannot write timestamp to state file");
            }
        }
        log.info("Ords metrics completed");
    }

    static String getHostName() {
        try {
            return InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }
}

