/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.ords.metrics;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Queue;
import java.util.function.Consumer;
import oracle.dbtools.ords.metrics.MetricData;
import oracle.dbtools.ords.metrics.MetricDataCount;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricBuffer {
    private static final Logger log = LoggerFactory.getLogger(MetricBuffer.class);
    private static final long FLUSH_THRESHOLD_MIN = 3000L;
    private final int capacity;
    private final Consumer<List<MetricDataCount>> cb;
    private final HashMap<MetricData, Integer> map = new HashMap();
    private final Queue<MetricData> queue = new ArrayDeque<MetricData>();

    MetricBuffer(int capacity, Consumer<List<MetricDataCount>> cb) {
        this.capacity = capacity;
        this.cb = cb;
    }

    void add(MetricData data) {
        log.debug("adding {}", (Object)data);
        if (!this.map.containsKey(data)) {
            this.queue.add(data);
        }
        this.map.compute(data, (k, v) -> v == null ? 1 : v + 1);
        if (this.queue.size() > this.capacity) {
            this.flush(System.currentTimeMillis() - 3000L);
        }
    }

    void flush(long timestamp) {
        MetricData data;
        ArrayList<MetricDataCount> list = new ArrayList<MetricDataCount>();
        while (!this.queue.isEmpty() && (data = this.queue.peek()) != null && data.timestamp() <= timestamp) {
            list.add(new MetricDataCount(data, this.map.get(data)));
            this.queue.remove();
        }
        this.cb.accept(list);
    }

    void flush() {
        ArrayList<MetricDataCount> list = new ArrayList<MetricDataCount>();
        while (!this.queue.isEmpty()) {
            MetricData data = this.queue.remove();
            list.add(new MetricDataCount(data, this.map.get(data)));
        }
        this.cb.accept(list);
    }
}

