/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.ords.metrics;

import java.io.FileInputStream;
import java.io.IOException;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Config {
    private static final Logger log = LoggerFactory.getLogger(Config.class);
    private final List<Option> options = new ArrayList<Option>();
    private final Map<Character, Option> index = new HashMap<Character, Option>();
    private final Map<String, Option> nameIndex = new HashMap<String, Option>();
    private final String program;

    public Config(String program) {
        this.program = program;
    }

    public void load(String filePath) throws IOException {
        Properties properties = new Properties();
        try (FileInputStream input = new FileInputStream(filePath);){
            properties.load(input);
        }
        this.load(properties);
    }

    public void load(Properties props) {
        props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(key, value) -> {
            Option opt = this.nameIndex.get(((String)key).toLowerCase());
            if (opt != null) {
                this.setOpt(opt, (String)value);
            } else {
                log.info("Ignoring unknown property {}", key);
            }
        }));
    }

    public void load(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            Option opt;
            String arg = args[i];
            if (arg.startsWith("--")) {
                opt = this.nameIndex.get(arg.substring(2).toLowerCase());
                if (opt == null) {
                    throw new IllegalArgumentException(arg);
                }
            } else if (arg.charAt(0) == '-' && arg.length() > 1) {
                char key = arg.charAt(1);
                opt = this.index.get(Character.valueOf(key));
                if (opt == null) {
                    throw new IllegalArgumentException(arg);
                }
                if (arg.length() > 2) {
                    if (!opt.hasArg) {
                        this.setSwitch(opt);
                        for (int j = 1; j < arg.length(); ++j) {
                            key = arg.charAt(j);
                            opt = this.index.get(Character.valueOf(key));
                            if (opt == null || opt.hasArg) {
                                throw new IllegalArgumentException(arg.substring(j));
                            }
                            this.setSwitch(opt);
                        }
                        continue;
                    }
                    this.setOpt(opt, arg.substring(2));
                    continue;
                }
            } else {
                throw new IllegalArgumentException(arg);
            }
            String optArg = null;
            if (opt.hasArg && i < args.length - 1) {
                optArg = args[++i];
            }
            this.setOpt(opt, optArg);
        }
        this.index.values().stream().filter(o -> o.required && o.value == null).findAny().ifPresent(o -> {
            throw new IllegalArgumentException(String.format("Missing required option: -%s", Character.valueOf(o.key)));
        });
    }

    private void setOpt(Option opt, String arg) {
        if (opt.hasArg) {
            if (arg == null) {
                throw new IllegalArgumentException(String.format("Missing required argument for option: -%c", Character.valueOf(opt.key)));
            }
            opt.value = arg;
        } else if (arg == null) {
            this.setSwitch(opt);
        } else {
            opt.value = arg;
        }
    }

    private void setSwitch(Option opt) {
        opt.value = "1";
    }

    public void addOption(char c, String name, String desc, boolean hasArg, String def, boolean required, boolean hidden) {
        Option option = new Option(c, name, desc, hasArg, def, required);
        if (!hidden) {
            this.options.add(option);
        }
        this.index.put(Character.valueOf(c), option);
        if (name != null) {
            this.nameIndex.put(name.toLowerCase(), option);
        }
    }

    public void addOption(char c, String name, String desc, boolean hasArg, String def, boolean required) {
        this.addOption(c, name, desc, hasArg, def, required, false);
    }

    public void addOption(char c, String name, String desc, boolean hasArg) {
        this.addOption(c, name, desc, hasArg, null, false, false);
    }

    public void addOption(char c, String name, String desc) {
        this.addOption(c, name, desc, false, null, false, false);
    }

    public String getString(char option) {
        Option opt = this.index.get(Character.valueOf(option));
        if (opt == null) {
            throw new NoSuchElementException(String.valueOf(option));
        }
        return opt.value;
    }

    public String getString(char option, String def) {
        String value = this.getString(option);
        return value == null ? def : value;
    }

    public long getDate(char option, long def) {
        try {
            String value = this.getString(option);
            return value == null ? def : Instant.parse(value).toEpochMilli();
        }
        catch (DateTimeParseException e) {
            throw new IllegalArgumentException(String.format("Invalid date argument for option %c", Character.valueOf(option)));
        }
    }

    public long getDate(char option) {
        return this.getDate(option, 0L);
    }

    public boolean getSwitch(char option) {
        String value = this.getString(option);
        return value != null && (value.equalsIgnoreCase("1") || value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes") || value.equalsIgnoreCase("on"));
    }

    public int getInt(char option, int def) {
        String value = this.getString(option);
        try {
            return value == null ? def : Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format("Option %c requires a numeric argument", Character.valueOf(option)));
        }
    }

    public boolean isSet(char option) {
        Option opt = this.index.get(Character.valueOf(option));
        return opt != null && opt.value != null;
    }

    public void logOptions() {
        this.index.values().stream().filter(o -> o.value != null).forEach(o -> log.info("{}: {}", (Object)o.name, (Object)o.value));
    }

    public String usage() {
        StringBuilder buf = new StringBuilder();
        buf.append("Usage: ");
        buf.append(this.program);
        for (Option option : this.options) {
            buf.append(' ');
            if (!option.required) {
                buf.append("[");
            }
            buf.append("-");
            buf.append(option.key);
            if (option.hasArg) {
                buf.append(' ');
                buf.append(option.name == null ? "arg" : option.name);
            }
            if (option.required) continue;
            buf.append("]");
        }
        for (Option opt : this.options) {
            Object[] objectArray = new Object[4];
            objectArray[0] = Character.valueOf(opt.key);
            objectArray[1] = opt.hasArg ? (opt.name == null ? "arg" : opt.name) : "";
            objectArray[2] = opt.desc;
            objectArray[3] = opt.def == null ? "" : String.format("(default is %s)", opt.def);
            buf.append(String.format("\n-%c %-12s %s %s", objectArray));
        }
        return buf.toString();
    }

    static class Option {
        final char key;
        final String name;
        final String desc;
        final boolean hasArg;
        final String def;
        final boolean required;
        String value;

        Option(char key, String name, String desc, boolean hasArg, String def, boolean required) {
            this.key = key;
            this.name = name;
            this.desc = desc;
            this.hasArg = hasArg;
            this.def = def;
            this.required = required;
            if (def != null) {
                this.value = def;
            }
        }
    }
}

