/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.ords.metrics;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public record AccessLogRecord(String clientIP, String user, long timestamp, String request, int statusCode, int responseSize, long responseTime, String tenantId, String requestId, String apexAppId) {
    private static final Logger log = LoggerFactory.getLogger(AccessLogRecord.class);
    private static final DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("dd/MMM/yyyy:HH:mm:ss Z");
    private static final Pattern pattern = Pattern.compile("(\\S+) (\\S+) \\[([^]]*)] \"(.+?)\" (\\d{3}) (\\d+|-) \"(.*?)\" \"(.*?)\" (\\d+) (\\S+) (\\S+)");
    private static final Pattern pattern24 = Pattern.compile("(\\S+) (\\S+) \\[([^]]*)] \"(.+?)\" (\\d{3}) (\\d+|-) \"(.*?)\" \"(.*?)\" (\\d+) (\\S+) (\\S+) (\\S+).*");
    private static final Pattern hostPattern = Pattern.compile("(\\w+)-\\S*\\.adb\\..*");
    private static final Pattern timestampPattern = Pattern.compile("(\\S+) (\\S+) \\[([^]]*)] .*");

    static AccessLogRecord getLogRecord(String logLine) {
        int version = 24;
        Matcher matcher = pattern24.matcher(logLine);
        if (!matcher.matches()) {
            version = 23;
            matcher = pattern.matcher(logLine);
        }
        if (matcher.matches()) {
            String clientIP = matcher.group(1);
            String user = matcher.group(2);
            String timestampStr = matcher.group(3);
            String request = matcher.group(4);
            int statusCode = Integer.parseInt(matcher.group(5));
            int responseSize = matcher.group(6).equals("-") ? 0 : Integer.parseInt(matcher.group(6));
            long responseTime = Long.parseLong(matcher.group(9));
            String host = matcher.group(10);
            Matcher hostMatcher = hostPattern.matcher(host);
            String tenantId = hostMatcher.matches() ? hostMatcher.group(1) : "-";
            long timestamp = Instant.from(dateFormatter.parse(timestampStr)).toEpochMilli();
            String requestId = matcher.group(11);
            String apexAppId = version == 24 ? matcher.group(12) : "-";
            return new AccessLogRecord(clientIP, user, timestamp, request, statusCode, responseSize, responseTime, tenantId, requestId, apexAppId);
        }
        log.warn("Invalid access log record format: {}", (Object)logLine);
        return null;
    }

    static long getTimestamp(String logLine) {
        Matcher matcher = timestampPattern.matcher(logLine);
        if (matcher.matches()) {
            String timestampStr = matcher.group(3);
            return Instant.from(dateFormatter.parse(timestampStr)).toEpochMilli();
        }
        log.warn("Invalid access log record timestamp format: {}", (Object)logLine);
        return 0L;
    }

    @Override
    public String toString() {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            return objectMapper.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            return String.format("Error converting object to JSON: %s; record timestamp: %d", e.getMessage(), this.timestamp);
        }
    }
}

