/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plugin.api.types;

import java.util.Objects;
import java.util.Set;
import oracle.dbtools.plugin.api.types.TypeQualifier;
import oracle.dbtools.plugin.api.types.TypeReflections;

class TypeSet {
    private final transient int hashCode;
    private final Set<Class<?>> ignored;
    private final Set<Class<?>> types = TypeReflections.identitySet();

    private TypeSet(Set<Class<?>> types, Set<Class<?>> ignored) {
        this.types.addAll(types);
        this.ignored = TypeReflections.identitySet();
        this.ignored.addAll(ignored);
        this.hashCode = Objects.hash(ignored, types);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TypeSet)) {
            return false;
        }
        TypeSet other = (TypeSet)obj;
        return this.hashCode == other.hashCode && Objects.equals(this.ignored, other.ignored) && Objects.equals(this.types, other.types);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        StringBuilder builder2 = new StringBuilder();
        builder2.append("TypeSet [ignored=");
        builder2.append(this.ignored);
        builder2.append(", types=");
        builder2.append(this.types);
        builder2.append("]");
        return builder2.toString();
    }

    Set<Class<?>> ignored() {
        return this.ignored;
    }

    boolean isEmpty() {
        return this.types.isEmpty() && this.ignored.isEmpty();
    }

    boolean isIgnored(TypeQualifier<?> service) {
        if (TypeQualifier.MatchingMode.EXACT_TYPE != service.matchingMode()) {
            return this.ignored.contains(service.type());
        }
        return false;
    }

    Builder modify() {
        return new Builder(this);
    }

    Set<Class<?>> types() {
        return this.types;
    }

    static Builder builder() {
        return new Builder(null);
    }

    static class Builder {
        private final TypeSet existing;
        private final Set<Class<?>> ignored;
        private boolean modified;
        private final Set<Class<?>> types;

        private Builder(TypeSet existing) {
            this.existing = existing;
            this.types = TypeReflections.identitySet();
            if (existing != null) {
                this.types.addAll(existing.types);
            }
            this.ignored = TypeReflections.identitySet();
            if (existing != null) {
                this.ignored.addAll(existing.ignored);
            }
            this.ignored.addAll(this.ignored);
        }

        TypeSet build() {
            if (this.existing == null || this.modified) {
                return new TypeSet(this.types, this.ignored);
            }
            return this.existing;
        }

        Builder clear() {
            if (!this.isEmpty()) {
                this.types.clear();
                this.ignored.clear();
                this.modified();
            }
            return this;
        }

        Builder ignore(Class<?> type) {
            if (this.ignored.add(type)) {
                this.modified();
            }
            return this;
        }

        Set<Class<?>> ignored() {
            return this.ignored;
        }

        boolean isEmpty() {
            return this.types.isEmpty() && this.ignored.isEmpty();
        }

        boolean add(Class<?> type) {
            if (this.types.add(type)) {
                this.modified();
                return true;
            }
            return false;
        }

        private void modified() {
            this.modified = true;
        }
    }
}

