/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plugin.api.types;

import java.util.Objects;
import oracle.dbtools.plugin.api.types.TypeDependency;
import oracle.dbtools.plugin.api.types.TypeQualifier;

public class TypeDependencyNotAvailableException
extends RuntimeException {
    private final TypeQualifier<?> qualifier;
    private static final long serialVersionUID = 1L;

    private TypeDependencyNotAvailableException(TypeQualifier<?> qualifier, String message) {
        super(message);
        this.qualifier = qualifier;
    }

    private TypeDependencyNotAvailableException(TypeQualifier<?> qualifier, String message, Throwable cause) {
        super(message, cause);
        this.qualifier = qualifier;
    }

    public TypeQualifier<?> qualifier() {
        return this.qualifier;
    }

    static TypeDependencyNotAvailableException from(Class<?> type, Throwable cause) {
        return TypeDependencyNotAvailableException.from(TypeQualifier.provides(type), cause);
    }

    static TypeDependencyNotAvailableException from(Class<?> type, TypeDependency dependency, Throwable cause) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(dependency);
        String message = "The type: " + type + " could not be instantiated due to missing dependency: " + dependency;
        return new TypeDependencyNotAvailableException(dependency.qualifier(), message);
    }

    public static TypeDependencyNotAvailableException from(TypeQualifier<?> type) {
        Objects.requireNonNull(type);
        String message = "The service: " + type + " is not available in the current scope";
        return new TypeDependencyNotAvailableException(type, message);
    }

    public static TypeDependencyNotAvailableException from(TypeQualifier<?> type, Throwable cause) {
        Objects.requireNonNull(type);
        Objects.requireNonNull(cause);
        TypeDependencyNotAvailableException existing = TypeDependencyNotAvailableException.checkForWrapping(type, cause);
        if (existing != null) {
            return existing;
        }
        String message = "The type: " + type + " could not be instantiated due to the following error: " + cause.getMessage();
        return new TypeDependencyNotAvailableException(type, message, cause);
    }

    private static final TypeDependencyNotAvailableException checkForWrapping(TypeQualifier<?> service, Throwable cause) {
        if (cause instanceof TypeDependencyNotAvailableException) {
            TypeDependencyNotAvailableException existing = (TypeDependencyNotAvailableException)cause;
            if (service.equals(existing.qualifier)) {
                return existing;
            }
        }
        return null;
    }
}

