/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plugin.api.types;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import oracle.dbtools.plugin.api.di.InstanceLocator;
import oracle.dbtools.plugin.api.di.Instances;
import oracle.dbtools.plugin.api.di.annotations.Provides;
import oracle.dbtools.plugin.api.types.AnnotationSet;
import oracle.dbtools.plugin.api.types.ProvidedClassifier;
import oracle.dbtools.plugin.api.types.TypeConstantField;
import oracle.dbtools.plugin.api.types.TypeDependencies;
import oracle.dbtools.plugin.api.types.TypeDependencyNotAvailableException;
import oracle.dbtools.plugin.api.types.TypeInstantiator;
import oracle.dbtools.plugin.api.types.TypeLocator;
import oracle.dbtools.plugin.api.types.TypePriorityComparator;
import oracle.dbtools.plugin.api.types.TypeProvider;
import oracle.dbtools.plugin.api.types.TypeQualifier;
import oracle.dbtools.plugin.api.types.TypeReflection;
import oracle.dbtools.plugin.api.types.TypeSet;

public class TypeReflections
implements TypeLocator,
Iterable<TypeReflection<?>> {
    private final transient Map<TypeQualifier<?>, Set<TypeReflection<?>>> byProvider;
    private final transient Map<Class<?>, TypeReflection<?>> byType;
    private final transient int hashCode;
    private final transient Map<Class<?>, TypeInstantiator<?>> instantiators;
    private final transient Instances singletons;
    private final TypeSet typeSet;
    private static final MethodHandles.Lookup LOOKUP = MethodHandles.lookup();

    private TypeReflections(TypeSet typeSet, Set<TypeReflection<?>> types, Map<Class<?>, TypeInstantiator<?>> instantiators, Instances singletons) {
        this.typeSet = typeSet;
        this.byType = TypeReflections.identityMap();
        this.byProvider = TypeReflections.equalityMap();
        this.singletons = singletons;
        for (TypeReflection<?> type : types) {
            this.byType.put(type.type(), type);
            if (!type.isConcrete()) continue;
            for (TypeQualifier<?> service : type.provides()) {
                Set<TypeReflection<Object>> providers = this.byProvider.get(service);
                if (providers == null) {
                    providers = TypeReflections.equalitySet();
                    this.byProvider.put(service, providers);
                }
                providers.add(type);
            }
        }
        this.instantiators = TypeReflections.identityMap();
        this.instantiators.putAll(instantiators);
        this.hashCode = Objects.hash(typeSet);
    }

    public boolean contains(Class<?> type) {
        return this.byType.containsKey(type);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TypeReflections)) {
            return false;
        }
        TypeReflections other = (TypeReflections)obj;
        return this.hashCode == other.hashCode && Objects.equals(this.typeSet, other.typeSet);
    }

    @Override
    public <T> TypeReflection<T> forType(Class<T> type) throws IllegalArgumentException {
        TypeReflection<?> untyped = this.byType.get(type);
        if (untyped == null) {
            throw new IllegalArgumentException(type.getCanonicalName());
        }
        TypeReflection<?> typed = untyped;
        return typed;
    }

    @Override
    public <T> TypeReflection<T> get(Class<T> type) throws IllegalArgumentException {
        return this.forType(type);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean isIgnored(TypeQualifier<?> service) {
        return this.typeSet.isIgnored(service);
    }

    @Override
    public Iterator<TypeReflection<?>> iterator() {
        return this.byType.values().iterator();
    }

    public Builder modify() {
        return new Builder(this);
    }

    @Override
    public <T> Set<TypeReflection<? extends T>> selectType(TypeQualifier<T> service) {
        TreeSet<TypeReflection<T>> result = new TreeSet<TypeReflection<T>>(TypePriorityComparator.instance());
        switch (service.matchingMode()) {
            case EXACT_TYPE: {
                TypeReflection<?> downcast = this.byType.get(service.type());
                if (downcast == null) break;
                result.add(downcast);
                break;
            }
            case PROVIDER: {
                Set<TypeReflection<?>> matches;
                if (this.isIgnored(service) || (matches = this.byProvider.get(service)) == null) break;
                Iterator<TypeReflection<?>> iterator = matches.iterator();
                while (iterator.hasNext()) {
                    TypeReflection<?> type;
                    TypeReflection<?> downcast2 = type = iterator.next();
                    result.add(downcast2);
                }
                break;
            }
            default: {
                if (this.isIgnored(service)) break;
                Set allMatches = this.byType.values().stream().filter(service::matches).collect(Collectors.toSet());
                Iterator iterator = allMatches.iterator();
                while (iterator.hasNext()) {
                    TypeReflection type;
                    TypeReflection downcast3 = type = (TypeReflection)iterator.next();
                    result.add(downcast3);
                }
                break block0;
            }
        }
        return result;
    }

    public Instances singletons() {
        return this.singletons;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TypeReflections [");
        b.append("types=");
        Iterator<TypeReflection<?>> iter = this.byType.values().iterator();
        while (iter.hasNext()) {
            TypeReflection<?> type = iter.next();
            b.append(type.type());
            if (!iter.hasNext()) continue;
            b.append(", ");
        }
        b.append(", singletons=");
        b.append(this.singletons);
        b.append("]");
        return b.toString();
    }

    public Set<Class<?>> types() {
        return this.typeSet.types();
    }

    public static Builder builder() {
        return new Builder(null);
    }

    public static MethodHandles.Lookup lookup() {
        return LOOKUP;
    }

    static <K, V> Map<K, V> equalityMap() {
        return new LinkedHashMap();
    }

    static <T> Set<T> equalitySet() {
        return new LinkedHashSet();
    }

    static <K, V> Map<K, V> identityMap() {
        return new IdentityHashMap();
    }

    static <T> Set<T> identitySet() {
        Map map = TypeReflections.identityMap();
        return Collections.newSetFromMap(map);
    }

    static final class ReflectiveInstantiator<T>
    extends TypeInstantiator<T> {
        private final TypeDependencies<T> dependencies;

        private ReflectiveInstantiator(Class<T> type, TypeDependencies<T> dependencies) {
            super(type, false);
            this.dependencies = dependencies;
        }

        @Override
        public T load(InstanceLocator locator) throws TypeDependencyNotAvailableException {
            return this.dependencies.newInstance(locator);
        }
    }

    public static class Builder {
        private final Map<Class<?>, TypeReflection<?>> byType;
        private final TypeReflections existing;
        private final Map<Class<?>, TypeInstantiator<?>> instantiators;
        private boolean modified = false;
        private final Instances.Builder singletons;
        private final Set<TypeReflection<?>> types;
        private final TypeSet.Builder typeSet;
        private static final ProvidedClassifier CLASSIFIER = ProvidedClassifier.instance();

        Builder(TypeReflections existing) {
            this.typeSet = existing == null ? TypeSet.builder() : existing.typeSet.modify();
            this.types = TypeReflections.equalitySet();
            this.byType = TypeReflections.equalityMap();
            this.instantiators = TypeReflections.identityMap();
            this.existing = existing;
            Instances.Builder builder = this.singletons = existing == null ? Instances.builder() : existing.singletons.modify();
            if (existing != null) {
                for (TypeReflection<?> typeReflection : existing.byType.values()) {
                    this.add(typeReflection);
                }
                this.instantiators.putAll(existing.instantiators);
            }
        }

        public Builder add(Class<?> type) {
            this.register(type);
            return this;
        }

        public Builder add(Class<?> ... types) {
            return this.add(Arrays.asList(types));
        }

        public Builder add(Iterable<Class<?>> types) {
            types.forEach(t -> this.add((Class<?>)t));
            return this;
        }

        public Builder add(TypeReflections existing) {
            existing.typeSet.ignored().forEach(ignored -> this.ignore((Class<?>)ignored));
            existing.typeSet.types().forEach(type -> this.add((Class<?>)type));
            return this;
        }

        public TypeReflections build() {
            if (this.existing == null || this.modified) {
                TypeSet typeSet = this.typeSet.build();
                Instances singletons = this.singletons.build();
                return new TypeReflections(typeSet, this.types, this.instantiators, singletons);
            }
            return this.existing;
        }

        public Builder clear() {
            if (!this.isEmpty()) {
                this.typeSet.clear();
                this.types.clear();
                this.singletons.clear();
                this.modified();
            }
            return this;
        }

        public Builder ignore(Class<?> serviceType) {
            this.typeSet.ignore(serviceType);
            return this;
        }

        public boolean isEmpty() {
            return this.typeSet.isEmpty();
        }

        private void register(Class<?> type) {
            if (this.typeSet.add(type)) {
                TypeReflection<?> typeReflection = this.forType(type);
                if (typeReflection.isConcrete()) {
                    this.add(typeReflection);
                } else {
                    this.addSingletons(typeReflection);
                }
            }
        }

        public Builder remove(Class<?> type) {
            TypeReflection<?> typeReflection = this.byType.get(type);
            if (type != null) {
                this.types.remove(typeReflection);
                this.modified();
            }
            return this;
        }

        private void add(TypeReflection<?> typeReflection) {
            if (this.types.add(typeReflection)) {
                TypeInstantiator<Object> maybeInstantiator;
                if (typeReflection.isConcrete() && (maybeInstantiator = this.checkIsTypeInstantiator(typeReflection)) != null) {
                    this.cacheInstantiator(maybeInstantiator);
                }
                this.byType.put(typeReflection.type(), typeReflection);
                this.modified();
            }
        }

        private void addSingletons(TypeReflection<?> typeReflection) {
            for (TypeConstantField<?> field : typeReflection.constantFields()) {
                Object instance = field.get();
                if (instance == null) continue;
                Iterator<TypeQualifier<?>> iterator = field.provides().iterator();
                while (iterator.hasNext()) {
                    TypeQualifier<?> qualifier;
                    TypeQualifier<?> upcast = qualifier = iterator.next();
                    this.singletons.add(upcast, instance);
                    TypeInstantiator<Object> maybeInstantiator = this.checkIsSingletonInstantiator(instance, qualifier);
                    if (maybeInstantiator == null) continue;
                    this.cacheInstantiator(maybeInstantiator);
                }
            }
        }

        private void cacheInstantiator(TypeInstantiator<Object> maybeInstantiator) {
            TypeInstantiator<Object> instantiator = maybeInstantiator;
            Class<Object> instantiatedType = instantiator.type();
            this.instantiators.put(instantiatedType, instantiator);
            TypeReflection<?> cached = this.byType.get(instantiatedType);
            TypeReflection<?> target = cached == null ? this.forType(instantiatedType) : cached;
            TypeReflection<Object> withCustomInstantiator = target.useInstantiator(instantiator);
            this.remove(instantiatedType).add(withCustomInstantiator);
        }

        private TypeInstantiator<Object> checkIsSingletonInstantiator(Object instance, TypeQualifier<?> qualifier) {
            boolean isInstantiator = TypeInstantiator.class.isAssignableFrom(qualifier.type());
            if (isInstantiator) {
                TypeInstantiator instantiator = (TypeInstantiator)instance;
                return instantiator;
            }
            return null;
        }

        private TypeInstantiator<Object> checkIsTypeInstantiator(TypeReflection<?> typeReflection) {
            boolean isInstantiator = TypeInstantiator.class.isAssignableFrom(typeReflection.type());
            if (isInstantiator) {
                TypeProvider<?> factory = typeReflection.using(InstanceLocator.empty());
                TypeInstantiator instance = (TypeInstantiator)factory.get();
                return instance;
            }
            return null;
        }

        private List<TypeConstantField<?>> constantFields(Class<?> type) {
            ArrayList constantFields = new ArrayList();
            for (Field field : type.getDeclaredFields()) {
                AnnotationSet annotations;
                int modifiers = field.getModifiers();
                if (!Modifier.isFinal(modifiers) || !Modifier.isStatic(modifiers) || !this.isQualified(annotations = AnnotationSet.from(field))) continue;
                Set<TypeQualifier<?>> provides = CLASSIFIER.provides(annotations);
                Class<?> upcast = field.getType();
                Object instance = this.instance(field);
                TypeConstantField<Object> constantField = new TypeConstantField<Object>(upcast, instance, provides);
                constantFields.add(constantField);
            }
            return constantFields;
        }

        private TypeReflection<?> forType(Class<?> type) {
            TypeReflection<?> typeReflection = this.load(type);
            return typeReflection;
        }

        private Object instance(Field field) {
            field.setAccessible(true);
            try {
                MethodHandle mh = LOOKUP.unreflectGetter(field);
                Object instance = mh.invokeWithArguments(new Object[0]);
                return instance;
            }
            catch (Throwable e) {
                throw new IllegalStateException(e);
            }
        }

        private boolean isQualified(AnnotationSet annotations) {
            return annotations.getAnnotation(Provides.class) != null || !annotations.qualifiers().isEmpty();
        }

        private <T> TypeReflection<T> load(Class<T> type) {
            AnnotationSet annotations = AnnotationSet.from(type);
            TypeDependencies<T> dependencies = TypeDependencies.forType(type);
            Set<TypeQualifier<?>> provides = this.providers(annotations);
            List<TypeConstantField<?>> constantFields = this.constantFields(type);
            ReflectiveInstantiator<T> instantiator = new ReflectiveInstantiator<T>(type, dependencies);
            return new TypeReflection<T>(dependencies, instantiator, provides, constantFields, annotations);
        }

        private Builder modified() {
            this.modified = true;
            return this;
        }

        private Set<TypeQualifier<?>> providers(AnnotationSet annotations) {
            Set<TypeQualifier<?>> provides = CLASSIFIER.provides(annotations);
            return provides;
        }
    }
}

