/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plugin.api.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLTransientConnectionException;
import java.util.Iterator;
import java.util.function.Function;
import oracle.dbtools.plugin.api.jdbc.SchemaNotAvailableException;

public interface JDBCDataSource
extends Iterable<String>,
Function<String, Connection> {
    @Override
    default public Connection apply(String schema) throws IllegalArgumentException, IllegalStateException, RuntimeException {
        try {
            return this.connection(schema);
        }
        catch (SQLException e) {
            throw JDBCDataSource.wrap(e);
        }
    }

    public Connection connection(String var1) throws SchemaNotAvailableException, SQLException;

    public boolean authenticate(String var1, char[] var2);

    @Override
    default public Iterator<String> iterator() {
        try {
            return this.schemas().iterator();
        }
        catch (SQLException e) {
            throw JDBCDataSource.wrap(e);
        }
    }

    public Iterable<String> schemas() throws SQLException;

    public static RuntimeException wrap(SQLException e) {
        if (e instanceof SQLTransientConnectionException) {
            String sqlState;
            switch (sqlState = e.getSQLState()) {
                case "08003": {
                    return new IllegalArgumentException(e);
                }
                case "08004": {
                    return new IllegalStateException(e);
                }
            }
            return new RuntimeException(e);
        }
        return new RuntimeException(e);
    }
}

