/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plugin.api.di;

import jakarta.inject.Provider;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import oracle.dbtools.plugin.api.di.DeferredInstanceProvider;
import oracle.dbtools.plugin.api.di.DeferredInstanceProviderCycleException;
import oracle.dbtools.plugin.api.di.InstanceLocator;
import oracle.dbtools.plugin.api.di.InstanceProvider;
import oracle.dbtools.plugin.api.di.MapLocator;
import oracle.dbtools.plugin.api.di.ResolvedInstances;
import oracle.dbtools.plugin.api.types.Primitive;
import oracle.dbtools.plugin.api.types.PrimitiveWrapper;
import oracle.dbtools.plugin.api.types.TypeQualifier;

public class Instances
implements InstanceLocator {
    private final transient MapLocator delegate;
    private final Map<TypeQualifier<?>, InstanceProvider<?>> instances;
    private static final Instances EMPTY = Instances.builder().build();

    private Instances(Map<TypeQualifier<?>, InstanceProvider<?>> instances) {
        this.instances = instances;
        this.delegate = new MapLocator(instances);
    }

    public Set<Map.Entry<TypeQualifier<?>, InstanceProvider<?>>> entries() {
        return Collections.unmodifiableMap(this.instances).entrySet();
    }

    public boolean isEmpty() {
        return this.instances.isEmpty();
    }

    public Builder modify() {
        Builder modified = new Builder();
        for (Map.Entry<TypeQualifier<?>, InstanceProvider<?>> entry : this.instances.entrySet()) {
            TypeQualifier<?> qualifier;
            TypeQualifier<?> upcast = qualifier = entry.getKey();
            InstanceProvider<?> instances = entry.getValue();
            for (Object instance : instances) {
                modified.add(upcast, instance);
            }
        }
        return modified;
    }

    public <T> List<QualifiedInstance<T>> qualifiedInstances(Class<T> type) {
        ArrayList<QualifiedInstance<T>> matches = new ArrayList<QualifiedInstance<T>>();
        for (Map.Entry<TypeQualifier<?>, InstanceProvider<?>> entry : this.instances.entrySet()) {
            TypeQualifier<?> candidate = entry.getKey();
            if (type != candidate.type()) continue;
            Iterable matching = entry.getValue();
            Iterator iterator = matching.iterator();
            while (iterator.hasNext()) {
                Object match;
                Object cast = match = iterator.next();
                TypeQualifier<?> downcast = candidate;
                QualifiedInstance qualified = new QualifiedInstance(downcast, cast);
                matches.add(qualified);
            }
        }
        return matches;
    }

    @Override
    public <T> InstanceProvider<T> select(TypeQualifier<T> service) {
        return this.delegate.select(service);
    }

    public String toString() {
        return this.delegate.toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    static Instances empty() {
        return EMPTY;
    }

    public static class QualifiedInstance<T>
    implements Provider<T>,
    Supplier<T> {
        private final T instance;
        private final TypeQualifier<T> qualifier;

        private QualifiedInstance(TypeQualifier<T> qualifier, T instance) {
            this.qualifier = qualifier;
            this.instance = instance;
        }

        @Override
        public T get() {
            return this.instance;
        }

        public TypeQualifier<T> qualifier() {
            return this.qualifier;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("QualifiedInstance [qualifier=");
            builder.append(this.qualifier);
            builder.append(", instance=");
            builder.append(this.instance);
            builder.append("]");
            return builder.toString();
        }
    }

    public static class Builder
    implements InstanceLocator {
        private final MapLocator delegate;
        private final Map<TypeQualifier<?>, InstanceProvider<?>> instances = new LinkedHashMap();

        private Builder() {
            this.delegate = new MapLocator(this.instances);
        }

        public <T> Builder add(Class<T> service, T instance) {
            return this.add(TypeQualifier.provides(service), instance);
        }

        public <T> Builder add(TypeQualifier<T> service, T instance) {
            Objects.requireNonNull(service);
            if (instance != null) {
                TypeQualifier<?> normalized = service.normalize();
                InstanceProvider<Object> instances = this.getInstances(normalized);
                if (instances instanceof ResolvedInstances) {
                    ResolvedInstances existing = (ResolvedInstances)instances;
                    existing.add(instance);
                } else {
                    this.remove(service).add(service, instance);
                }
            }
            return this;
        }

        public Instances build() {
            Instances instances = new Instances(this.instances);
            return instances;
        }

        public Builder clear() {
            this.instances.clear();
            return this;
        }

        public Builder merge(Instances other, boolean overwrite) {
            for (Map.Entry<TypeQualifier<?>, InstanceProvider<?>> entry : other.instances.entrySet()) {
                TypeQualifier<?> service = entry.getKey();
                InstanceProvider<?> instances = entry.getValue();
                if (overwrite) {
                    this.instances.put(service, instances);
                    continue;
                }
                this.instances.putIfAbsent(service, instances);
            }
            return this;
        }

        public Builder remove(Class<?> type) {
            return this.remove(TypeQualifier.provides(type));
        }

        public <T> Builder remove(TypeQualifier<T> service) {
            this.instances.remove(service);
            Class<T> type = service.type();
            Primitive primitive = Primitive.valueOf(type);
            if (primitive.isPrimitive()) {
                TypeQualifier<?> boxed = service.withType(primitive.wrapperType());
                this.instances.remove(boxed);
            } else {
                PrimitiveWrapper wrapper = PrimitiveWrapper.valueOf(type);
                if (wrapper.isWrapper()) {
                    TypeQualifier<?> unboxed = service.withType(wrapper.primitive().type());
                    this.instances.remove(unboxed);
                }
            }
            return this;
        }

        @Override
        public <T> InstanceProvider<T> select(TypeQualifier<T> service) {
            return this.delegate.select(service);
        }

        public <T> Builder set(Class<T> service, T instance) {
            return this.set(TypeQualifier.provides(service), instance);
        }

        public Builder set(TypeQualifier<?> service, InstanceProvider<?> provider) {
            if (provider instanceof DeferredInstanceProvider && this == ((DeferredInstanceProvider)provider).locator()) {
                throw new DeferredInstanceProviderCycleException((DeferredInstanceProvider)provider);
            }
            this.remove(service);
            this.instances.put(service, provider);
            return this;
        }

        public <T> Builder set(TypeQualifier<T> qualifier, T instance) {
            if (instance == null) {
                return this.remove(qualifier);
            }
            return this.remove(qualifier).add(qualifier, instance);
        }

        public String toString() {
            return this.delegate.toString();
        }

        private InstanceProvider<Object> getInstances(TypeQualifier<?> qualifier) {
            InstanceProvider<Object> existing = this.instances.get(qualifier);
            if (existing == null) {
                ResolvedInstances<Object> empty = ResolvedInstances.empty(qualifier);
                this.instances.put(qualifier, empty);
                ResolvedInstances<Object> upcast = empty;
                return upcast;
            }
            return existing;
        }
    }
}

