/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plugin.api.types;

import java.lang.annotation.Annotation;
import java.util.Arrays;
import oracle.dbtools.plugin.api.types.Primitive;
import oracle.dbtools.plugin.api.types.TypeQualifierImpl;
import oracle.dbtools.plugin.api.types.TypeReflection;

public interface TypeQualifier<T> {
    public String declaration();

    public boolean equals(Object var1);

    public int hashCode();

    public boolean isEmpty();

    public boolean matches(TypeQualifier<?> var1);

    public boolean matches(TypeReflection<?> var1);

    public MatchingMode matchingMode();

    public String name();

    public <E> TypeQualifier<E> withType(Class<E> var1);

    public String toString();

    public Class<T> type();

    public static <T> TypeQualifier<T> any(Class<T> type) {
        return TypeQualifierImpl.any(type);
    }

    @Deprecated
    public static <T> TypeQualifier<T> from(Class<T> type, Annotation ... qualifiers) {
        return TypeQualifier.from(type, Arrays.asList(qualifiers));
    }

    @Deprecated
    public static <T> TypeQualifier<T> from(Class<T> type, Iterable<? extends Annotation> qualifiers) {
        return TypeQualifierImpl.from(type, qualifiers);
    }

    public static <T> TypeQualifier<T> named(Class<T> type, String name) {
        return TypeQualifierImpl.named(type, name);
    }

    public static <T> TypeQualifier<T> provides(Class<T> type) {
        return TypeQualifierImpl.provides(type);
    }

    public static <T> TypeQualifier<T> type(Class<T> type) {
        return TypeQualifierImpl.type(type);
    }

    default public TypeQualifier<?> normalize() {
        Class<T> type = this.type();
        Primitive primitive = Primitive.valueOf(type);
        TypeQualifier<?> normalized = primitive.isPrimitive() ? this.withType(primitive.wrapperType()) : this;
        return normalized;
    }

    public static enum MatchingMode {
        ANY_PROVIDER,
        EXACT_TYPE,
        PROVIDER;

    }

    public static interface Builder<T> {
        default public Builder<T> any(Class<?> service) {
            return this.matchingMode(MatchingMode.ANY_PROVIDER);
        }

        public TypeQualifier<T> build();

        default public Builder<T> exactType() {
            return this.matchingMode(MatchingMode.EXACT_TYPE);
        }

        public boolean isEmpty();

        public Builder<T> matchingMode(MatchingMode var1);

        public Builder<T> named(String var1);

        public Builder<T> provides(Class<T> var1);

        @Deprecated
        public Builder<T> qualifiers(Annotation ... var1);
    }
}

