/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.plugin.api.types;

import oracle.dbtools.plugin.api.types.Primitive;

public enum PrimitiveWrapper {
    BOOLEAN(Boolean.class, Boolean.TYPE),
    BYTE(Byte.class, Byte.TYPE),
    CHARACTER(Character.class, Character.TYPE),
    DOUBLE(Double.class, Double.TYPE),
    FLOAT(Float.class, Float.TYPE),
    INTEGER(Integer.class, Integer.TYPE),
    LONG(Long.class, Long.TYPE),
    PRIMITIVE(Void.class, null),
    REFERENCE(Object.class, Object.class),
    SHORT(Short.class, Short.TYPE);

    private final Class<?> primitive;
    private Class<?> type;

    private PrimitiveWrapper(Class<?> type, Class<?> primitive) {
        this.primitive = primitive;
        this.type = type;
    }

    public Class<?> type() {
        return this.type;
    }

    public Primitive primitive() {
        return Primitive.valueOf(this.primitive);
    }

    public boolean isWrapper() {
        return REFERENCE != this && PRIMITIVE != this;
    }

    public static PrimitiveWrapper valueOf(Class<?> type) {
        if (type.isPrimitive()) {
            return PRIMITIVE;
        }
        if (Boolean.class == type) {
            return BOOLEAN;
        }
        if (Byte.class == type) {
            return BYTE;
        }
        if (Character.class == type) {
            return CHARACTER;
        }
        if (Double.class == type) {
            return DOUBLE;
        }
        if (Float.class == type) {
            return FLOAT;
        }
        if (Integer.class == type) {
            return INTEGER;
        }
        if (Long.class == type) {
            return LONG;
        }
        if (Short.TYPE == type) {
            return SHORT;
        }
        return REFERENCE;
    }
}

